nimbix-run.py
===============================

This readme file contains these sections:

1. OVERVIEW
2. SOFTWARE TOOLS AND SYSTEM REQUIREMENTS
3. INSTALLATION AND OPERATING INSTRUCTIONS
4. LAUNCHING APPLICATIONS BEHIND A PROXY
5. SUPPORT
6. LICENSE
7. Acknowledgements
8. REVISION HISTORY

## 1. OVERVIEW
A script to run applications on FPGA boards hosted by Nimbix from an external network.
This program will execute the following steps

1. Upload the content of the current directory to nimbix
2. Run the application based on the arguments provided to the script
3. Copy the results back to the current working directory


## 2. SOFTWARE TOOLS AND SYSTEM REQUIREMENTS
* Python 2.7.5
* lftp

## 3. INSTALLATION AND OPERATING INSTRUCTIONS
Make sure you have "lftp" installed. If you don't, you can install it by "sudo
yum install lftp -y" in RedHAT/CentOS.

Make sure you have "sftp" installed. If not, you can install it the same way.

If you are using the script behind a proxy, like Xilinx internal network, you
need to follow the instruction on how to create "~.ssh/config".


- Add the script to the environment PATH
```
export PATH=<repo location>/utility/nimbix:$PATH
```

In order to run the application, the following information is required

Nimbix user name
Nimbix API key - this is the encrypted key generated by Nimbix per user

### Obtaining the Nimbix API key
1. Log into the Nimbix cloud at [xilinx-cloud.jarvice.com](http://xilinx-cloud.jarvice.com)
2. Click on your username and select settings
3. Copy the API key to a file

### Setting up the local environment for running jobs on Nimbix

 - Set the environment each time
```
$ export NIMBIX_USER=<username>
$ export NIMBIX_APIKEY=<apikey>
```

Or

- Setup the environment once
```
$ cat <<EOF > ~/.nimbix_creds.json
{
  "username": "<username>",
  "api-key": "<apikey>"
}
EOF
```

### Run an application on Nimbix
```
$ nimbix-run.py <prog> <args>
```

- < prog > is the name of the application to be executed
- < args >  are the command line arguments required by the application


## 4. LAUNCHING APPLICATIONS BEHIND A PROXY
In cases where the system launching applications to Nimbix is located behind a proxy, the following settings are needed

Using Proxy for SSH
```
$ cat <<EOF >> ~/.ssh/config
Host drop.jarvice.com
   ProxyCommand <path to local proxy service software>
   proxy 80 %h %p
   TCPKeepAlive yes
   ServerAliveInterval 30
EOF
```
Using Proxy for everything else
```
$ export http_proxy=http://proxy:8080
$ export https_proxy=https://proxy:8080
$ export ftp_proxy=ftp://proxy:8080
$ export all_proxy=proxy:8080
```

## 5. OTHER INFORMATION

For more information check here:
[SDAccel User Guides]

## 6. SUPPORT
For questions and to get help on this project or your own projects, visit the [SDAccel Forums][].

## 7. License
The source for this project is licensed under the [3-Clause BSD License][]

## 8. Acknowledgements
The utility is written by developers at [Xilinx](http://www.xilinx.com/)

## 10. REVISION HISTORY

Date    | Readme Version | Revision Description
--------|----------------|-------------------------
JAN2016 |      1.0       | Initial Xilinx release
MAR2016 |      2.0       | Bug fix: Create /data/automated_test if it does not exist
MAY2016 |      3.0       | Update to Nimbix Jarvice 2.0 infrastructure

[3-Clause BSD License]: LICENSE.md
[SDAccel Forums]: https://forums.xilinx.com/t5/SDAccel/bd-p/SDx
[SDAccel User Guides]: http://www.xilinx.com/support/documentation-navigation/development-tools/software-development/sdaccel.html?resultsTablePreSelect=documenttype:SeeAll#documentation
[Nimbix Getting Started Guide]: http://www.xilinx.com/member/sdaccel_ea_40hr/Getting_Started_with_SDAccel_on_Nimbix_cloud.pdf
[Walkthrough Video]: http://bcove.me/6pp0o482
