/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.internal.config.SystemPropertiesConfigurationModel;
import org.glassfish.jersey.internal.util.PropertiesClass;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.spi.WebServer;

public final class JerseySeBootstrapConfiguration
implements SeBootstrap.Configuration {
    private static final Logger LOGGER = Logger.getLogger(JerseySeBootstrapConfiguration.class.getName());
    protected static final Random RANDOM = new Random();
    private final SeBootstrap.Configuration configuration;

    private JerseySeBootstrapConfiguration(SeBootstrap.Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Object property(String name) {
        return this.configuration.property(name);
    }

    public URI uri(boolean resolveDefaultPort) {
        String protocol = this.configuration.protocol();
        String host = this.configuration.host();
        int port = resolveDefaultPort ? this.resolvePort() : this.configuration.port();
        String rootPath = this.configuration.rootPath();
        URI uri = UriBuilder.newInstance().scheme(protocol.toLowerCase()).host(host).port(port).path(rootPath).build(new Object[0]);
        return uri;
    }

    private int resolvePort() {
        int configPort = this.configuration.port();
        int basePort = this.allowPrivilegedPorts() ? 0 : 8000;
        return switch (configPort) {
            case -1 -> basePort + (this.isHttps() ? 443 : 80);
            case 0 -> this._resolvePort(basePort == 0);
            default -> configPort;
        };
    }

    private int _resolvePort(boolean allowPrivilegedPort) {
        int initialOffset;
        int basePort;
        int lower = basePort = allowPrivilegedPort ? 0 : 1024;
        int range = 65535;
        int offset = initialOffset = RANDOM.nextInt(65535 - lower);
        while (true) {
            int port = lower + offset;
            try {
                ServerSocket socket = new ServerSocket(port);
                socket.close();
                return port;
            }
            catch (IOException iOException) {
                if ((offset = (offset + 1) % 65535) != initialOffset) continue;
                throw new IllegalArgumentException(LocalizationMessages.COULD_NOT_BIND_TO_ANY_PORT());
            }
            break;
        }
    }

    @Override
    public SSLContext sslContext() {
        SSLContext sslContext = this.configuration.sslContext();
        return this.isHttps() ? sslContext : null;
    }

    public boolean isHttps() {
        return "HTTPS".equalsIgnoreCase(this.configuration.protocol());
    }

    public boolean autoStart() {
        boolean autoStart = Optional.ofNullable((Boolean)this.configuration.property("jersey.config.server.bootstrap.webserver.autostart")).orElse(Boolean.TRUE);
        return autoStart;
    }

    public boolean allowPrivilegedPorts() {
        return Optional.ofNullable((Boolean)this.configuration.property("jersey.config.server.bootstrap.webserver.allow.privileged.ports")).orElse(Boolean.FALSE);
    }

    public static JerseySeBootstrapConfiguration from(SeBootstrap.Configuration configuration) {
        return JerseySeBootstrapConfiguration.class.isInstance(configuration) ? (JerseySeBootstrapConfiguration)configuration : new JerseySeBootstrapConfiguration(configuration);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements SeBootstrap.Configuration.Builder {
        private static final Map<String, Class<?>> PROPERTY_TYPES = new HashMap();
        private final Map<String, Object> properties = new HashMap<String, Object>();

        private Builder() {
            this.properties.put("jakarta.ws.rs.SeBootstrap.Protocol", "HTTP");
            this.properties.put("jakarta.ws.rs.SeBootstrap.Host", "localhost");
            this.properties.put("jakarta.ws.rs.SeBootstrap.Port", -1);
            this.properties.put("jakarta.ws.rs.SeBootstrap.RootPath", "/");
            this.properties.put("jersey.config.server.bootstrap.webserver.class", WebServer.class);
            try {
                this.properties.put("jakarta.ws.rs.SeBootstrap.SSLContext", SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            this.properties.put("jakarta.ws.rs.SeBootstrap.SSLClientAuthentication", (Object)SeBootstrap.Configuration.SSLClientAuthentication.NONE);
            this.properties.put("jersey.config.server.bootstrap.webserver.autostart", Boolean.TRUE);
            this.properties.put("jersey.config.server.bootstrap.webserver.allow.privileged.ports", Boolean.FALSE);
            SystemPropertiesConfigurationModel propertiesConfigurationModel = new SystemPropertiesConfigurationModel(Collections.singletonList(Properties.class.getName()));
            this.from((T name, U aClass) -> String.class.equals(aClass) || Integer.class.equals(aClass) || Boolean.class.equals(aClass) ? propertiesConfigurationModel.getOptionalProperty((String)name, aClass) : Optional.empty());
        }

        @Override
        public JerseySeBootstrapConfiguration build() {
            return JerseySeBootstrapConfiguration.from(this.properties::get);
        }

        @Override
        public Builder property(String name, Object value) {
            this.properties.put(name, value);
            return this;
        }

        public Builder webServerClass(Class<? extends WebServer> webServerClass) {
            return this.property("jersey.config.server.bootstrap.webserver.class", webServerClass);
        }

        public Builder autoStart(Boolean autostart) {
            return this.property("jersey.config.server.bootstrap.webserver.autostart", autostart);
        }

        @Override
        public <T> Builder from(BiFunction<String, Class<T>, Optional<T>> configProvider) {
            PROPERTY_TYPES.forEach((propertyName, propertyType) -> ((Optional)configProvider.apply((String)propertyName, (Class)propertyType)).ifPresent(propertyValue -> this.properties.put((String)propertyName, propertyValue)));
            return this;
        }

        @Override
        public Builder from(Object externalConfig) {
            if (SeBootstrap.Configuration.class.isInstance(externalConfig)) {
                SeBootstrap.Configuration other = (SeBootstrap.Configuration)externalConfig;
                this.from((T name, U clazz) -> {
                    Object property = other.property((String)name);
                    if (property != null) {
                        if (clazz.equals(property.getClass())) {
                            return Optional.of(property);
                        }
                        LOGGER.warning(LocalizationMessages.IGNORE_SEBOOTSTRAP_CONFIGURATION_PROPERTY(name, clazz));
                    }
                    return Optional.empty();
                });
            }
            return this;
        }

        static {
            PROPERTY_TYPES.put("jakarta.ws.rs.SeBootstrap.Protocol", String.class);
            PROPERTY_TYPES.put("jakarta.ws.rs.SeBootstrap.Host", String.class);
            PROPERTY_TYPES.put("jakarta.ws.rs.SeBootstrap.Port", Integer.class);
            PROPERTY_TYPES.put("jakarta.ws.rs.SeBootstrap.RootPath", String.class);
            PROPERTY_TYPES.put("jakarta.ws.rs.SeBootstrap.SSLContext", SSLContext.class);
            PROPERTY_TYPES.put("jakarta.ws.rs.SeBootstrap.SSLClientAuthentication", SeBootstrap.Configuration.SSLClientAuthentication.class);
            PROPERTY_TYPES.put("jersey.config.server.bootstrap.webserver.allow.privileged.ports", Boolean.class);
            PROPERTY_TYPES.put("jersey.config.server.bootstrap.webserver.autostart", Boolean.class);
            PROPERTY_TYPES.put("jersey.config.server.bootstrap.webserver.class", Class.class);
        }
    }

    @PropertiesClass
    private static class Properties {
        public static final String SE_BOOTSTRAP_CONFIGURATION_PROTOCOL = "jakarta.ws.rs.SeBootstrap.Protocol";
        public static final String SE_BOOTSTRAP_CONFIGURATION_HOST = "jakarta.ws.rs.SeBootstrap.Host";
        public static final String SE_BOOTSTRAP_CONFIGURATION_PORT = "jakarta.ws.rs.SeBootstrap.Port";
        public static final String SE_BOOTSTRAP_CONFIGURATION_ROOT_PATH = "jakarta.ws.rs.SeBootstrap.RootPath";
        public static final String WEBSERVER_ALLOW_PRIVILEGED_PORTS = "jersey.config.server.bootstrap.webserver.allow.privileged.ports";
        public static final String WEBSERVER_AUTO_START = "jersey.config.server.bootstrap.webserver.autostart";

        private Properties() {
        }
    }
}

