/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.innate;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Feature;
import java.net.Proxy;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.innate.ClientProxy;
import org.glassfish.jersey.client.innate.http.SSLParamConfigurator;
import org.glassfish.jersey.internal.PropertiesResolver;
import org.glassfish.jersey.internal.util.collection.Ref;

public class ConnectorConfiguration<E extends ConnectorConfiguration<E>> {
    protected final NullableRef<Integer> connectTimeout = NullableRef.empty();
    protected final NullableRef<Boolean> expect100Continue = NullableRef.empty();
    protected final NullableRef<Long> expect100continueThreshold = NullableRef.empty();
    protected final NullableRef<Boolean> followRedirects = NullableRef.empty();
    protected final NullableRef<String> prefix = NullableRef.empty();
    protected final NullableRef<Object> proxyUri = NullableRef.empty();
    protected final NullableRef<String> proxyUserName = NullableRef.empty();
    protected final NullableRef<String> proxyPassword = NullableRef.empty();
    protected final NullableRef<Integer> readTimeout = NullableRef.empty();
    protected final NullableRef<RequestEntityProcessing> requestEntityProcessing = NullableRef.empty();
    protected final NullableRef<String> sniHostname = NullableRef.empty();
    protected final NullableRef<Supplier<SSLContext>> sslContextSupplier = NullableRef.empty();
    protected final NullableRef<Integer> threadPoolSize = NullableRef.empty();

    protected ConnectorConfiguration() {
    }

    public E asyncThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize.set(threadPoolSize);
        return this.self();
    }

    public E connectTimeout(int millis) {
        this.connectTimeout.set(millis);
        return this.self();
    }

    public E expect100Continue(boolean enable) {
        this.expect100Continue.set(enable);
        return this.self();
    }

    public E expect100ContinueThreshold(long size) {
        this.expect100continueThreshold.set(size);
        return this.self();
    }

    public E followRedirects(boolean follow) {
        this.followRedirects.set(follow);
        return this.self();
    }

    public E prefix(String prefix) {
        this.prefix.set(Objects.requireNonNull(prefix));
        return this.self();
    }

    public E proxyPassword(String proxyPassword) {
        this.proxyPassword.set(proxyPassword);
        return this.self();
    }

    public E proxyUserName(String userName) {
        this.proxyUserName.set(userName);
        return this.self();
    }

    public E proxyUri(String proxyUri) {
        this.proxyUri.set(proxyUri);
        return this.self();
    }

    public E proxyUri(URI proxyUri) {
        this.proxyUri.set(proxyUri);
        return this.self();
    }

    public E proxy(Proxy proxy) {
        this.proxyUri.set(proxy);
        return this.self();
    }

    public E readTimeout(int millis) {
        this.readTimeout.set(millis);
        return this.self();
    }

    public E requestEntityProcessing(RequestEntityProcessing requestEntityProcessing) {
        this.requestEntityProcessing.set(requestEntityProcessing);
        return this.self();
    }

    public E sniHostName(String sniHostname) {
        this.sniHostname.set(sniHostname);
        return this.self();
    }

    public E sslContextSupplier(Supplier<SSLContext> sslContextSupplier) {
        this.sslContextSupplier.set(sslContextSupplier);
        return this.self();
    }

    protected E self() {
        return (E)this;
    }

    protected static class NullableRef<T>
    implements Ref<T> {
        private boolean empty = true;
        private T ref = null;

        private NullableRef() {
        }

        public static <T> NullableRef<T> empty() {
            return new NullableRef<T>();
        }

        public static <T> NullableRef<T> of(T value) {
            NullableRef<T> ref = new NullableRef<T>();
            ref.set(value);
            return ref;
        }

        @Override
        public void set(T value) {
            this.empty = false;
            this.ref = value;
        }

        public void setNonEmpty(NullableRef<T> other) {
            other.ifPresent(this::set);
        }

        @Override
        public T get() {
            return this.ref;
        }

        public void iff(Predicate<T> predicate, Runnable action) {
            if (predicate.test(this.ref)) {
                action.run();
            }
        }

        public void ifEmptySet(T value) {
            if (this.empty) {
                this.set(value);
            }
        }

        public void ifPresent(Consumer<? super T> action) {
            if (!this.empty) {
                action.accept(this.ref);
            }
        }

        public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
            if (!this.empty) {
                action.accept(this.ref);
            } else {
                emptyAction.run();
            }
        }

        public T ifPresentOrElse(T other) {
            return this.empty ? other : this.ref;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public boolean isPresent() {
            return !this.empty;
        }

        public int hashCode() {
            return Objects.hash(this.ref, this.empty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NullableRef)) {
                return false;
            }
            NullableRef that = (NullableRef)o;
            return Objects.equals(this.empty, that.empty) && Objects.equals(this.ref, that.ref);
        }

        public String toString() {
            return this.empty ? "<empty>" : (this.ref == null ? "<null>" : this.ref.toString());
        }
    }

    protected static class PrefixedConfiguration
    implements Configuration {
        private final String prefix;
        private final Configuration inner;

        private PrefixedConfiguration(String prefix, Configuration inner) {
            this.prefix = prefix;
            this.inner = inner;
        }

        @Override
        public RuntimeType getRuntimeType() {
            return this.inner.getRuntimeType();
        }

        @Override
        public Map<String, Object> getProperties() {
            return new PrefixedMap<Object>(this.prefix, this.inner.getProperties());
        }

        @Override
        public Object getProperty(String name) {
            return this.inner.getProperty(this.prefix + name);
        }

        @Override
        public Collection<String> getPropertyNames() {
            return this.inner.getPropertyNames();
        }

        @Override
        public boolean isEnabled(Feature feature) {
            return this.inner.isEnabled(feature);
        }

        @Override
        public boolean isEnabled(Class<? extends Feature> featureClass) {
            return this.inner.isEnabled(featureClass);
        }

        @Override
        public boolean isRegistered(Object component) {
            return this.inner.isRegistered(component);
        }

        @Override
        public boolean isRegistered(Class<?> componentClass) {
            return this.inner.isRegistered(componentClass);
        }

        @Override
        public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
            return this.inner.getContracts(componentClass);
        }

        @Override
        public Set<Class<?>> getClasses() {
            return this.inner.getClasses();
        }

        @Override
        public Set<Object> getInstances() {
            return this.inner.getInstances();
        }
    }

    private static class PrefixedPropertiesResolver
    implements PropertiesResolver {
        private final String prefix;
        private final PropertiesResolver resolver;

        private PrefixedPropertiesResolver(String prefix, PropertiesResolver resolver) {
            this.prefix = prefix;
            this.resolver = resolver;
        }

        @Override
        public <T> T resolveProperty(String name, Class<T> type) {
            return (T)this.resolver.resolveProperty(this.prefix + name, type);
        }

        @Override
        public <T> T resolveProperty(String name, T defaultValue) {
            return this.resolver.resolveProperty(this.prefix + name, defaultValue);
        }
    }

    private static class PrefixedMap<V>
    implements Map<String, V> {
        private final Map<String, V> inner;
        private final String prefix;

        private PrefixedMap(String prefix, Map<String, V> inner) {
            this.inner = inner;
            this.prefix = prefix;
        }

        @Override
        public int size() {
            return this.inner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.inner.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.inner.containsKey(this.prefix + key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.inner.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.inner.get(this.prefix + key);
        }

        @Override
        public V put(String key, V value) {
            return this.inner.put(key, value);
        }

        @Override
        public V remove(Object key) {
            return this.inner.remove(this.prefix + key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends V> m4) {
            this.inner.putAll(m4);
        }

        @Override
        public void clear() {
            this.inner.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.inner.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.inner.values();
        }

        @Override
        public Set<Map.Entry<String, V>> entrySet() {
            return this.inner.entrySet();
        }
    }

    protected static interface Read<CC extends ConnectorConfiguration<CC>>
    extends SSLParamConfigurator.SSLParamConfiguratorConfiguration {
        default public <X extends ConnectorConfiguration<?>> void setNonEmpty(X other) {
            ((ConnectorConfiguration)this.me()).connectTimeout.setNonEmpty(other.connectTimeout);
            ((ConnectorConfiguration)this.me()).expect100Continue.setNonEmpty(other.expect100Continue);
            ((ConnectorConfiguration)this.me()).expect100continueThreshold.setNonEmpty(other.expect100continueThreshold);
            ((ConnectorConfiguration)this.me()).followRedirects.setNonEmpty(other.followRedirects);
            ((ConnectorConfiguration)this.me()).prefix.setNonEmpty(other.prefix);
            ((ConnectorConfiguration)this.me()).proxyUri.setNonEmpty(other.proxyUri);
            ((ConnectorConfiguration)this.me()).proxyUserName.setNonEmpty(other.proxyUserName);
            ((ConnectorConfiguration)this.me()).proxyPassword.setNonEmpty(other.proxyPassword);
            ((ConnectorConfiguration)this.me()).readTimeout.setNonEmpty(other.readTimeout);
            ((ConnectorConfiguration)this.me()).requestEntityProcessing.setNonEmpty(other.requestEntityProcessing);
            ((ConnectorConfiguration)this.me()).sniHostname.setNonEmpty(other.sniHostname);
            ((ConnectorConfiguration)this.me()).sslContextSupplier.setNonEmpty(other.sslContextSupplier);
            ((ConnectorConfiguration)this.me()).threadPoolSize.setNonEmpty(other.threadPoolSize);
        }

        default public Integer asyncThreadPoolSize() {
            return ((ConnectorConfiguration)this.me()).threadPoolSize.get();
        }

        default public int connectTimeout(ClientRequest request) {
            ((ConnectorConfiguration)this.me()).connectTimeout.set(request.resolveProperty(this.prefixed("jersey.config.client.connectTimeout"), ((ConnectorConfiguration)this.me()).connectTimeout.get()));
            return ((ConnectorConfiguration)this.me()).connectTimeout.get();
        }

        default public int connectTimeout() {
            return ((ConnectorConfiguration)this.me()).connectTimeout.get();
        }

        default public CC init() {
            ((ConnectorConfiguration)((ConnectorConfiguration)((ConnectorConfiguration)((ConnectorConfiguration)((ConnectorConfiguration)this.me()).connectTimeout(0)).expect100ContinueThreshold(ClientProperties.DEFAULT_EXPECT_100_CONTINUE_THRESHOLD_SIZE)).followRedirects(Boolean.TRUE)).prefix("")).readTimeout(0);
            return this.me();
        }

        default public CC copy() {
            CC config = this.instance();
            ((Read)config).init();
            ((Read)config).setNonEmpty((ConnectorConfiguration)this.me());
            return config;
        }

        default public CC copyFromClient(Configuration configuration) {
            CC clientConfiguration = this.copy();
            Map<String, Object> properties = configuration.getProperties();
            Object configProp = properties.get(((Read)clientConfiguration).prefixed("jersey.config.client.ConnectorConfiguration"));
            if (configProp != null) {
                ConnectorConfiguration clientCfg = (ConnectorConfiguration)configProp;
                if (((ConnectorConfiguration)this.me()).prefix.equals(clientCfg.prefix) || clientCfg.prefix.get() == null) {
                    ((Read)clientConfiguration).setNonEmpty(clientCfg);
                }
            } else {
                configProp = properties.get("jersey.config.client.ConnectorConfiguration");
                if (configProp != null && ((ConnectorConfiguration)this.me()).prefix.equals(((ConnectorConfiguration)configProp).prefix)) {
                    ((Read)clientConfiguration).setNonEmpty((ConnectorConfiguration)configProp);
                }
            }
            return clientConfiguration;
        }

        default public CC copyFromRequest(ClientRequest request) {
            CC requestConfiguration = this.copy();
            Object configProp = request.getProperty(this.prefixed("jersey.config.client.ConnectorConfiguration"));
            if (configProp != null) {
                ConnectorConfiguration requestCfg = (ConnectorConfiguration)configProp;
                if (((ConnectorConfiguration)this.me()).prefix.equals(requestCfg.prefix) || requestCfg.prefix.get() == null) {
                    ((Read)requestConfiguration).setNonEmpty(requestCfg);
                }
            } else {
                configProp = request.getProperty("jersey.config.client.ConnectorConfiguration");
                if (configProp != null && ((ConnectorConfiguration)this.me()).prefix.equals(((ConnectorConfiguration)configProp).prefix)) {
                    ((Read)requestConfiguration).setNonEmpty((ConnectorConfiguration)configProp);
                }
            }
            return requestConfiguration;
        }

        @Override
        default public String getSniHostNameProperty(Configuration configuration) {
            Object property = configuration.getProperty(this.prefixed("jersey.config.client.snihostname"));
            if (property == null) {
                property = configuration.getProperty(this.prefixed("jersey.config.client.snihostname".toLowerCase(Locale.ROOT)));
            }
            return property == null ? ((ConnectorConfiguration)this.me()).sniHostname.get() : (String)property;
        }

        default public Boolean expect100Continue(ClientRequest request) {
            Boolean expectContinueActivated = (Boolean)((Object)request.resolveProperty(this.prefixed("jersey.config.client.request.expect.100.continue.processing"), Boolean.class));
            if (expectContinueActivated != null) {
                ((ConnectorConfiguration)this.me()).expect100Continue.set(expectContinueActivated);
            }
            return ((ConnectorConfiguration)this.me()).expect100Continue.get();
        }

        default public long expect100ContinueThreshold(ClientRequest request) {
            ((ConnectorConfiguration)this.me()).expect100continueThreshold.set(request.resolveProperty(this.prefixed("jersey.config.client.request.expect.100.continue.threshold.size"), ((ConnectorConfiguration)this.me()).expect100continueThreshold.get()));
            return ((ConnectorConfiguration)this.me()).expect100continueThreshold.get();
        }

        default public boolean followRedirects(ClientRequest request) {
            ((ConnectorConfiguration)this.me()).followRedirects.set(request.resolveProperty(this.prefixed("jersey.config.client.followRedirects"), ((ConnectorConfiguration)this.me()).followRedirects.get()));
            return ((ConnectorConfiguration)this.me()).followRedirects.get();
        }

        default public boolean followRedirects() {
            return ((ConnectorConfiguration)this.me()).followRedirects.get();
        }

        default public Configuration prefixedConfiguration(Configuration configuration) {
            return ((ConnectorConfiguration)this.me()).prefix.get().isEmpty() ? configuration : new PrefixedConfiguration(((ConnectorConfiguration)this.me()).prefix.get(), configuration);
        }

        default public Optional<ClientProxy> proxy(ClientRequest request, URI requestUri) {
            Optional<ClientProxy> proxy = ClientProxy.proxyFromRequest(((ConnectorConfiguration)this.me()).prefix.get().isEmpty() ? request : new PrefixedPropertiesResolver(((ConnectorConfiguration)this.me()).prefix.get(), request));
            if (!proxy.isPresent() && ((ConnectorConfiguration)this.me()).proxyUri.isPresent()) {
                Map<String, Object> properties = ((ConnectorConfiguration)this.me()).prefix.get().isEmpty() ? new HashMap() : new PrefixedMap(((ConnectorConfiguration)this.me()).prefix.get(), new HashMap());
                properties.put(((ConnectorConfiguration)this.me()).prefix.get() + "jersey.config.client.proxy.uri", ((ConnectorConfiguration)this.me()).proxyUri.get());
                properties.put(((ConnectorConfiguration)this.me()).prefix.get() + "jersey.config.client.proxy.username", ((ConnectorConfiguration)this.me()).proxyUserName.get());
                properties.put(((ConnectorConfiguration)this.me()).prefix.get() + "jersey.config.client.proxy.password", ((ConnectorConfiguration)this.me()).proxyPassword.get());
                request.getPropertyNames().forEach(k -> properties.put((String)k, request.getProperty((String)k)));
                proxy = ClientProxy.proxyFromProperties(properties);
            }
            if (!proxy.isPresent()) {
                proxy = ClientProxy.proxyFromUri(requestUri);
            }
            return proxy;
        }

        default public CC readTimeout(ClientRequest request) {
            ((ConnectorConfiguration)this.me()).readTimeout.set(request.resolveProperty(this.prefixed("jersey.config.client.readTimeout"), ((ConnectorConfiguration)this.me()).readTimeout.get()));
            return this.me();
        }

        default public int readTimeout() {
            return ((ConnectorConfiguration)this.me()).readTimeout.get();
        }

        default public RequestEntityProcessing requestEntityProcessing(ClientRequest request) {
            RequestEntityProcessing entityProcessing = (RequestEntityProcessing)((Object)request.resolveProperty(this.prefixed("jersey.config.client.request.entity.processing"), RequestEntityProcessing.class));
            if (entityProcessing == null) {
                entityProcessing = ((ConnectorConfiguration)this.me()).requestEntityProcessing.get();
            }
            return entityProcessing;
        }

        @Override
        default public String resolveSniHostNameProperty(PropertiesResolver resolver) {
            String property = (String)((Object)resolver.resolveProperty(this.prefixed("jersey.config.client.snihostname"), String.class));
            if (property == null) {
                property = (String)((Object)resolver.resolveProperty(this.prefixed("jersey.config.client.snihostname".toLowerCase(Locale.ROOT)), String.class));
            }
            return property == null ? ((ConnectorConfiguration)this.me()).sniHostname.get() : property;
        }

        default public SSLContext sslContext(Client client, ClientRequest request) {
            Supplier<SSLContext> supplier = (Supplier<SSLContext>)((Object)request.resolveProperty(this.prefixed("jersey.config.client.ssl.context.supplier"), Supplier.class));
            if (supplier == null) {
                supplier = ((ConnectorConfiguration)this.me()).sslContextSupplier.get();
            }
            return supplier == null ? client.getSslContext() : (SSLContext)supplier.get();
        }

        default public String prefixed(String propertyName) {
            return ((ConnectorConfiguration)this.me()).prefix.get() + propertyName;
        }

        public CC instance();

        public CC me();
    }
}

