/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;

public class Fields
implements Iterable<Field> {
    public static final Fields EMPTY = new Fields(Collections.emptyMap());
    private final Map<String, Field> fields;

    public Fields() {
        this(false);
    }

    public Fields(boolean caseSensitive) {
        this(caseSensitive ? new LinkedHashMap() : new TreeMap(String::compareToIgnoreCase));
    }

    public Fields(MultiMap<String> params) {
        this(Fields.multiMapToMapOfFields(params));
    }

    public Fields(Map<String, Field> fields) {
        this.fields = fields;
    }

    public Fields(Fields fields) {
        if (fields.fields instanceof TreeMap) {
            this.fields = new TreeMap<String, Field>(String::compareToIgnoreCase);
            this.fields.putAll(fields.fields);
        } else if (fields.fields instanceof LinkedHashMap) {
            this.fields = new LinkedHashMap<String, Field>(fields.fields);
        } else if (Collections.unmodifiableMap(fields.fields) == fields.fields) {
            this.fields = fields.fields;
        } else {
            throw new IllegalStateException("unknown case sensitivity");
        }
    }

    public Fields asImmutable() {
        Map<String, Field> unmodifiable = Collections.unmodifiableMap(this.fields);
        return unmodifiable == this.fields ? this : new Fields(unmodifiable);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Fields) {
            Fields that = (Fields)obj;
            if (this.getSize() != that.getSize()) {
                return false;
            }
            if (!this.fields.getClass().equals(that.fields.getClass())) {
                return false;
            }
            for (Map.Entry<String, Field> entry : this.fields.entrySet()) {
                String name = entry.getKey();
                Field value = entry.getValue();
                if (value.equals(that.get(name))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public Set<String> getNames() {
        return this.fields.keySet();
    }

    public Stream<Field> stream() {
        return this.fields.values().stream();
    }

    public Field get(String name) {
        return this.fields.get(name);
    }

    public String getValue(String name) {
        Field field = this.get(name);
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public List<String> getValues(String name) {
        Field field = this.get(name);
        if (field == null) {
            return null;
        }
        return field.getValues();
    }

    public List<String> getValuesOrEmpty(String name) {
        Field field = this.get(name);
        if (field == null) {
            return Collections.emptyList();
        }
        return field.getValues();
    }

    public void put(String name, String value) {
        Field field = new Field(name, StringUtil.nonNull(value));
        this.fields.put(name, field);
    }

    public void put(Field field) {
        if (field != null) {
            String s2 = field.getName();
            this.fields.put(s2, field);
        }
    }

    public void add(String name, String value) {
        this.fields.compute(name, (k, f) -> {
            if (f == null) {
                return new Field(name, StringUtil.nonNull(value));
            }
            return new Field(f.getName(), f.getValues(), StringUtil.nonNull(value));
        });
    }

    public void add(String name, String ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (values.length == 1) {
            this.add(name, values[0]);
        } else {
            this.fields.compute(name, (k, f) -> {
                if (f == null) {
                    return new Field(name, StringUtil.toListNonNull(values));
                }
                return new Field(f.getName(), f.getValues(), StringUtil.toListNonNull(values));
            });
        }
    }

    public void add(Field field) {
        String key = field.getName();
        this.fields.compute(key, (k, f) -> {
            if (f == null) {
                return field;
            }
            return new Field(f.getName(), f.getValues(), field.getValues());
        });
    }

    public void addAll(Fields fields) {
        for (Field field : fields) {
            this.add(field);
        }
    }

    public Field remove(String name) {
        return this.fields.remove(name);
    }

    public void clear() {
        this.fields.clear();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public int getSize() {
        return this.fields.size();
    }

    @Override
    public Iterator<Field> iterator() {
        return this.fields.values().iterator();
    }

    public Map<String, String[]> toStringArrayMap() {
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>(){

            @Override
            public String toString() {
                return TypeUtil.toString(this);
            }
        };
        this.fields.forEach((? super K k, ? super V f) -> result.put(f.getName(), f.getValues().toArray(new String[0])));
        return result;
    }

    public MultiMap<String> toMultiMap() {
        MultiMap<String> multiMap = new MultiMap<String>();
        this.fields.forEach((? super K k, ? super V f) -> multiMap.addValues((String)k, f.getValues()));
        return multiMap;
    }

    public String toString() {
        return this.fields.values().stream().map(Field::toString).collect(Collectors.joining(",", "[", "]"));
    }

    public static Fields combine(Fields a, Fields b) {
        if (b == null || b.isEmpty()) {
            return a == null ? EMPTY : a;
        }
        if (a == null || a.isEmpty()) {
            return b;
        }
        Fields fields = new Fields(a.fields instanceof LinkedHashMap);
        fields.addAll(a);
        fields.addAll(b);
        return fields;
    }

    private static Map<String, Field> multiMapToMapOfFields(MultiMap<String> params) {
        if (params.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        for (Map.Entry entry : params.entrySet()) {
            fields.put((String)entry.getKey(), new Field((String)entry.getKey(), (List)entry.getValue()));
        }
        return fields;
    }

    public static class Field {
        private final String name;
        private final List<String> values;

        public Field(String name, String value) {
            this(name, List.of(value));
        }

        public Field(String name, List<String> values) {
            this.name = name;
            this.values = List.copyOf(values);
        }

        private Field(String name, List<String> values, String extraValue) {
            this(name, Field.append(values, extraValue));
        }

        private Field(String name, List<String> values, List<String> moreValues) {
            this(name, Field.append(values, moreValues));
        }

        private static List<String> append(List<String> values, String extraValue) {
            return switch (values.size()) {
                case 0 -> List.of(extraValue);
                case 1 -> List.of(values.get(0), extraValue);
                case 2 -> List.of(values.get(0), values.get(1), extraValue);
                case 3 -> List.of(values.get(0), values.get(1), values.get(2), extraValue);
                case 4 -> List.of(values.get(0), values.get(1), values.get(2), values.get(3), extraValue);
                case 5 -> List.of(values.get(0), values.get(1), values.get(2), values.get(3), values.get(4), extraValue);
                default -> {
                    ArrayList<String> list = new ArrayList<String>(values.size() + 1);
                    list.addAll(values);
                    list.add(extraValue);
                    yield list;
                }
            };
        }

        private static List<String> append(List<String> values, List<String> moreValues) {
            if (moreValues == null || moreValues.isEmpty()) {
                return values;
            }
            if (moreValues.size() == 1) {
                return Field.append(values, moreValues.get(0));
            }
            return switch (values.size()) {
                case 0 -> moreValues;
                case 1 -> {
                    switch (moreValues.size()) {
                        case 2: {
                            yield List.of(values.get(0), moreValues.get(0), moreValues.get(1));
                        }
                        case 3: {
                            yield List.of(values.get(0), moreValues.get(0), moreValues.get(1), moreValues.get(2));
                        }
                        case 4: {
                            yield List.of(values.get(0), moreValues.get(0), moreValues.get(1), moreValues.get(2), moreValues.get(3));
                        }
                        case 5: {
                            yield List.of(values.get(0), moreValues.get(0), moreValues.get(1), moreValues.get(2), moreValues.get(3), moreValues.get(4));
                        }
                    }
                    ArrayList<String> list = new ArrayList<String>(moreValues.size() + 1);
                    list.add(values.get(0));
                    list.addAll(moreValues);
                    yield list;
                }
                default -> {
                    ArrayList<String> list = new ArrayList<String>(values.size() + moreValues.size());
                    list.addAll(values);
                    list.addAll(moreValues);
                    yield list;
                }
            };
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Field that = (Field)obj;
            return this.name.equals(that.name) && this.values.equals(that.values);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.values);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.values.get(0);
        }

        public Integer getValueAsInt() {
            String value = this.getValue();
            return value == null ? null : Integer.valueOf(Integer.parseInt(value));
        }

        public List<String> getValues() {
            return this.values;
        }

        public boolean hasMultipleValues() {
            return this.values.size() > 1;
        }

        public String toString() {
            return String.format("%s=%s", this.name, this.values);
        }
    }
}

