/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.Dumpable;

public interface Attributes {
    public static final Attributes NULL = new Attributes(){

        @Override
        public Object removeAttribute(String name) {
            return null;
        }

        @Override
        public Object setAttribute(String name, Object attribute) {
            return null;
        }

        @Override
        public Object getAttribute(String name) {
            return null;
        }

        @Override
        public Set<String> getAttributeNameSet() {
            return Collections.emptySet();
        }

        @Override
        public void clearAttributes() {
        }

        @Override
        public Map<String, Object> asAttributeMap() {
            return Collections.emptyMap();
        }

        @Override
        public int hashCode() {
            return Attributes.hashCode(this);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Attributes && Attributes.equals(this, o);
        }
    };

    public Object removeAttribute(String var1);

    public Object setAttribute(String var1, Object var2);

    public Object getAttribute(String var1);

    public Set<String> getAttributeNameSet();

    default public Map<String, Object> asAttributeMap() {
        return new AbstractMap<String, Object>(){
            private final Set<String> _attributeNameSet;
            private final AbstractSet<Map.Entry<String, Object>> _entrySet;
            {
                this._attributeNameSet = Attributes.this.getAttributeNameSet();
                this._entrySet = new AbstractSet<Map.Entry<String, Object>>(){

                    @Override
                    public Iterator<Map.Entry<String, Object>> iterator() {
                        final Iterator<String> names = _attributeNameSet.iterator();
                        return new Iterator<Map.Entry<String, Object>>(this){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public boolean hasNext() {
                                return names.hasNext();
                            }

                            @Override
                            public Map.Entry<String, Object> next() {
                                String name = (String)names.next();
                                return new AbstractMap.SimpleEntry<String, Object>(name, this.this$2.Attributes.this.getAttribute(name));
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return _attributeNameSet.size();
                    }
                };
            }

            @Override
            public int size() {
                return this._attributeNameSet.size();
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return this._entrySet;
            }
        };
    }

    default public void clearAttributes() {
        for (String name : this.getAttributeNameSet()) {
            this.removeAttribute(name);
        }
    }

    public int hashCode();

    public boolean equals(Object var1);

    public static Attributes unwrap(Attributes attributes) {
        while (attributes instanceof Wrapper) {
            attributes = ((Wrapper)attributes).getWrapped();
        }
        return attributes;
    }

    public static int hashCode(Attributes attributes) {
        int hash = 0;
        for (String name : attributes.getAttributeNameSet()) {
            hash = hash * 31 + Objects.hash(name, attributes.getAttribute(name));
        }
        return hash;
    }

    public static boolean equals(Attributes attributes, Object o) {
        if (o instanceof Attributes) {
            Set<String> theirs;
            Attributes a = (Attributes)o;
            Set<String> ours = attributes.getAttributeNameSet();
            if (!ours.equals(theirs = a.getAttributeNameSet())) {
                return false;
            }
            for (String s2 : ours) {
                if (Objects.equals(attributes.getAttribute(s2), a.getAttribute(s2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static <T extends Wrapper> T unwrap(Attributes attributes, Class<T> target) {
        while (true) {
            if (target.isAssignableFrom(attributes.getClass())) {
                return (T)((Wrapper)attributes);
            }
            if (!(attributes instanceof Wrapper)) break;
            Wrapper wrapper = (Wrapper)attributes;
            attributes = wrapper.getWrapped();
        }
        return null;
    }

    public static class Wrapper
    implements Attributes {
        private final Attributes _wrapped;

        public Wrapper(Attributes wrapped) {
            this._wrapped = Objects.requireNonNull(wrapped);
        }

        public Attributes getWrapped() {
            return this._wrapped;
        }

        @Override
        public Object removeAttribute(String name) {
            return this.getWrapped().removeAttribute(name);
        }

        @Override
        public Object setAttribute(String name, Object attribute) {
            return this.getWrapped().setAttribute(name, attribute);
        }

        @Override
        public Object getAttribute(String name) {
            return this.getWrapped().getAttribute(name);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            return this.getWrapped().getAttributeNameSet();
        }

        @Override
        public void clearAttributes() {
            this.getWrapped().clearAttributes();
        }

        @Override
        public int hashCode() {
            return Attributes.hashCode(this);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Attributes && Attributes.equals(this, o);
        }
    }

    public static abstract class Synthetic
    extends Wrapper {
        protected static final Object REMOVED = new Object(){

            public String toString() {
                return "REMOVED";
            }
        };
        private final AtomicReference<Map<String, Object>> _layer = new AtomicReference();

        protected Synthetic(Attributes base) {
            super(base);
        }

        protected abstract Object getSyntheticAttribute(String var1);

        protected abstract Set<String> getSyntheticNameSet();

        @Override
        public Object getAttribute(String name) {
            Object s2;
            Map<String, Object> layer = this._layer.get();
            if (layer != null) {
                Object l = layer.get(name);
                if (l == REMOVED) {
                    return null;
                }
                if (l != null) {
                    return l;
                }
            }
            if ((s2 = this.getSyntheticAttribute(name)) == REMOVED) {
                return null;
            }
            if (s2 != null) {
                return s2;
            }
            return super.getAttribute(name);
        }

        @Override
        public Object setAttribute(String name, Object value) {
            if (value == null) {
                return this.removeAttribute(name);
            }
            if (this.getSyntheticNameSet().contains(name)) {
                Map<String, Object> layer = this._layer.updateAndGet(m4 -> m4 == null ? new HashMap() : m4);
                Object old = layer.put(name, value);
                return old == REMOVED ? null : (old != null ? old : this.getSyntheticAttribute(name));
            }
            return super.setAttribute(name, value);
        }

        @Override
        public Object removeAttribute(String name) {
            if (this.getSyntheticNameSet().contains(name)) {
                Map<String, Object> layer = this._layer.updateAndGet(m4 -> m4 == null ? new HashMap() : m4);
                Object old = layer.put(name, REMOVED);
                return old == REMOVED ? null : (old != null ? old : this.getSyntheticAttribute(name));
            }
            return super.removeAttribute(name);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            HashSet<String> names = new HashSet<String>(super.getAttributeNameSet());
            Map<String, Object> layer = this._layer.get();
            if (layer == null) {
                for (String s2 : this.getSyntheticNameSet()) {
                    if (this.getSyntheticAttribute(s2) == null) continue;
                    names.add(s2);
                }
            } else {
                for (String s3 : this.getSyntheticNameSet()) {
                    Object l = layer.get(s3);
                    if (l == REMOVED) {
                        names.remove(s3);
                        continue;
                    }
                    if (l != null) {
                        names.add(s3);
                        continue;
                    }
                    Object v = this.getSyntheticAttribute(s3);
                    if (v == null || v == REMOVED) continue;
                    names.add(s3);
                }
            }
            return Collections.unmodifiableSet(names);
        }

        @Override
        public void clearAttributes() {
            super.clearAttributes();
            Map<String, Object> layer = this._layer.updateAndGet(m4 -> m4 == null ? new HashMap() : m4);
            for (String s2 : this.getSyntheticNameSet()) {
                layer.put(s2, REMOVED);
            }
        }
    }

    public static class Layer
    extends Wrapper {
        private static final Object REMOVED = new Object(){

            public String toString() {
                return "REMOVED";
            }
        };
        private final Attributes _layer;

        public Layer(Attributes persistent) {
            this(persistent, new Mapped());
        }

        public Layer(Attributes persistent, Attributes layer) {
            super(persistent);
            this._layer = layer;
        }

        public Attributes getPersistentAttributes() {
            return this.getWrapped();
        }

        public void clearLayerAttributes() {
            this._layer.clearAttributes();
        }

        @Override
        public Object removeAttribute(String name) {
            Object oldValue;
            Object persistentValue = super.getAttribute(name);
            Object object = oldValue = persistentValue == null ? this._layer.removeAttribute(name) : this._layer.setAttribute(name, REMOVED);
            return oldValue == REMOVED ? null : (oldValue == null ? persistentValue : oldValue);
        }

        @Override
        public Object setAttribute(String name, Object attribute) {
            if (attribute == null) {
                return this.removeAttribute(name);
            }
            Object v = this._layer.setAttribute(name, attribute);
            return v == REMOVED ? null : v;
        }

        @Override
        public Object getAttribute(String name) {
            Object v = this._layer.getAttribute(name);
            if (v != null) {
                return v == REMOVED ? null : v;
            }
            return super.getAttribute(name);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            HashSet<String> names = new HashSet<String>(super.getAttributeNameSet());
            for (String name : this._layer.getAttributeNameSet()) {
                if (this._layer.getAttribute(name) == REMOVED) {
                    names.remove(name);
                    continue;
                }
                names.add(name);
            }
            return Collections.unmodifiableSet(names);
        }

        @Override
        public void clearAttributes() {
            this._layer.clearAttributes();
            for (String name : super.getAttributeNameSet()) {
                this._layer.setAttribute(name, REMOVED);
            }
        }
    }

    public static class Lazy
    implements Attributes,
    Dumpable {
        private final AtomicReference<ConcurrentMap<String, Object>> _map = new AtomicReference();

        private ConcurrentMap<String, Object> map() {
            return this._map.get();
        }

        private ConcurrentMap<String, Object> ensureMap() {
            ConcurrentMap<String, Object> map;
            do {
                if ((map = this.map()) == null) continue;
                return map;
            } while (!this._map.compareAndSet(null, map = new ConcurrentHashMap<String, Object>()));
            return map;
        }

        @Override
        public Map<String, Object> asAttributeMap() {
            return this.ensureMap();
        }

        @Override
        public Object removeAttribute(String name) {
            ConcurrentMap<String, Object> map = this.map();
            return map == null ? null : map.remove(name);
        }

        @Override
        public Object setAttribute(String name, Object attribute) {
            if (attribute == null) {
                return this.removeAttribute(name);
            }
            return this.ensureMap().put(name, attribute);
        }

        @Override
        public Object getAttribute(String name) {
            ConcurrentMap<String, Object> map = this.map();
            return map == null ? null : map.get(name);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            return Collections.unmodifiableSet(this.keySet());
        }

        @Override
        public void clearAttributes() {
            ConcurrentMap<String, Object> map = this.map();
            if (map != null) {
                map.clear();
            }
        }

        public int size() {
            ConcurrentMap<String, Object> map = this.map();
            return map == null ? 0 : map.size();
        }

        public String toString() {
            ConcurrentMap<String, Object> map = this.map();
            return map == null ? "{}" : map.toString();
        }

        private Set<String> keySet() {
            ConcurrentMap<String, Object> map = this.map();
            return map == null ? Collections.emptySet() : map.keySet();
        }

        public void addAll(Attributes attributes) {
            for (String name : attributes.getAttributeNameSet()) {
                this.setAttribute(name, attributes.getAttribute(name));
            }
        }

        @Override
        public String dump() {
            return Dumpable.dump(this);
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            Dumpable.dumpObjects(out, indent, String.format("%s@%x", TypeUtil.toShortName(this.getClass()), this.hashCode()), this.map());
        }

        @Override
        public int hashCode() {
            return Attributes.hashCode(this);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Attributes && Attributes.equals(this, o);
        }
    }

    public static class Mapped
    implements Attributes {
        private final Map<String, Object> _map;
        private final Set<String> _names;

        public Mapped() {
            this(new ConcurrentHashMap<String, Object>());
        }

        public Mapped(Map<String, Object> map) {
            this._map = Objects.requireNonNull(map);
            this._names = Collections.unmodifiableSet(this._map.keySet());
        }

        public Mapped(Mapped attributes) {
            this(new ConcurrentHashMap<String, Object>(attributes._map));
        }

        @Override
        public Map<String, Object> asAttributeMap() {
            return this._map;
        }

        @Override
        public Object removeAttribute(String name) {
            return this._map.remove(name);
        }

        @Override
        public Object setAttribute(String name, Object attribute) {
            if (attribute == null) {
                return this._map.remove(name);
            }
            return this._map.put(name, attribute);
        }

        @Override
        public Object getAttribute(String name) {
            return this._map.get(name);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            return this._names;
        }

        @Override
        public void clearAttributes() {
            this._map.clear();
        }

        public int size() {
            return this._map.size();
        }

        public String toString() {
            return this._map.toString();
        }

        public void addAll(Attributes attributes) {
            for (String name : attributes.getAttributeNameSet()) {
                this.setAttribute(name, attributes.getAttribute(name));
            }
        }

        @Override
        public int hashCode() {
            return Attributes.hashCode(this);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Attributes && Attributes.equals(this, o);
        }
    }
}

