/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.CompletableTask;
import org.eclipse.jetty.util.thread.Invocable;

@Deprecated(forRemoval=true, since="12.1.0")
public class ChunkAccumulator {
    private static final ByteBufferPool NON_POOLING = ByteBufferPool.NON_POOLING;
    private final List<Content.Chunk> _chunks = new ArrayList<Content.Chunk>();
    private int _length;

    public boolean add(Content.Chunk chunk) {
        if (chunk.hasRemaining()) {
            this._length = Math.addExact(this._length, chunk.remaining());
            if (chunk.canRetain()) {
                chunk.retain();
                return this._chunks.add(chunk);
            }
            return this._chunks.add(Content.Chunk.from(BufferUtil.copy(chunk.getByteBuffer()), chunk.isLast()));
        }
        if (Content.Chunk.isFailure(chunk)) {
            throw new IllegalArgumentException("chunk is failure");
        }
        return false;
    }

    public int length() {
        return this._length;
    }

    public byte[] take() {
        if (this._length == 0) {
            return BufferUtil.EMPTY_BYTES;
        }
        byte[] bytes = new byte[this._length];
        int offset = 0;
        for (Content.Chunk chunk : this._chunks) {
            offset += chunk.get(bytes, offset, chunk.remaining());
            chunk.release();
        }
        assert (offset == this._length);
        this._chunks.clear();
        this._length = 0;
        return bytes;
    }

    public RetainableByteBuffer take(ByteBufferPool pool, boolean direct) {
        Content.Chunk chunk;
        ByteBuffer byteBuffer;
        if (this._length == 0) {
            return RetainableByteBuffer.EMPTY;
        }
        if (this._chunks.size() == 1 && direct == (byteBuffer = (chunk = this._chunks.get(0)).getByteBuffer()).isDirect()) {
            this._chunks.clear();
            this._length = 0;
            return RetainableByteBuffer.wrap(byteBuffer, chunk);
        }
        RetainableByteBuffer.Mutable buffer = Objects.requireNonNullElse(pool, NON_POOLING).acquire(this._length, direct);
        int offset = 0;
        for (Content.Chunk chunk2 : this._chunks) {
            offset += chunk2.remaining();
            BufferUtil.append(buffer.getByteBuffer(), chunk2.getByteBuffer());
            chunk2.release();
        }
        assert (offset == this._length);
        this._chunks.clear();
        this._length = 0;
        return buffer;
    }

    public void close() {
        this._chunks.forEach(Retainable::release);
        this._chunks.clear();
        this._length = 0;
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public CompletableFuture<byte[]> readAll(Content.Source source) {
        return this.readAll(source, -1);
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public CompletableFuture<byte[]> readAll(Content.Source source, int maxSize) {
        AccumulatorTask<byte[]> task = new AccumulatorTask<byte[]>(source, maxSize){

            @Override
            protected byte[] take(ChunkAccumulator accumulator) {
                return accumulator.take();
            }
        };
        return task.start();
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    public CompletableFuture<RetainableByteBuffer> readAll(Content.Source source, final ByteBufferPool pool, final boolean direct, int maxSize) {
        AccumulatorTask<RetainableByteBuffer> task = new AccumulatorTask<RetainableByteBuffer>(this, source, maxSize){
            final /* synthetic */ ChunkAccumulator this$0;
            {
                this.this$0 = this$0;
                super(source, maxLength);
            }

            @Override
            protected RetainableByteBuffer take(ChunkAccumulator accumulator) {
                return accumulator.take(pool, direct);
            }
        };
        return task.start();
    }

    @Deprecated(forRemoval=true, since="12.0.15")
    private static abstract class AccumulatorTask<T>
    extends CompletableTask<T>
    implements Invocable {
        private final Content.Source _source;
        private final ChunkAccumulator _accumulator = new ChunkAccumulator();
        private final int _maxLength;

        private AccumulatorTask(Content.Source source, int maxLength) {
            this._source = source;
            this._maxLength = maxLength;
        }

        @Override
        public void run() {
            block6: {
                Content.Chunk chunk;
                do {
                    if ((chunk = this._source.read()) == null) {
                        this._source.demand(this);
                        break block6;
                    }
                    if (Content.Chunk.isFailure(chunk)) {
                        this.completeExceptionally(chunk.getFailure());
                        if (chunk.isLast()) break block6;
                        this._source.fail(chunk.getFailure());
                        break block6;
                    }
                    try {
                        this._accumulator.add(chunk);
                        if (this._maxLength > 0 && this._accumulator._length > this._maxLength) {
                            throw new IOException("accumulation too large");
                        }
                    }
                    catch (Throwable t2) {
                        chunk.release();
                        this._accumulator.close();
                        this._source.fail(t2);
                        this.completeExceptionally(t2);
                        break block6;
                    }
                    chunk.release();
                } while (!chunk.isLast());
                this.complete(this.take(this._accumulator));
            }
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }

        protected abstract T take(ChunkAccumulator var1);
    }
}

