/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.content;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.http.content.CachingHttpContentFactory;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.thread.Scheduler;

public class ValidatingCachingHttpContentFactory
extends CachingHttpContentFactory
implements Runnable {
    private final Scheduler _scheduler;
    private final long _sweepDelay;
    private final long _validationTime;
    private final long _maxCacheIdleTime;

    public ValidatingCachingHttpContentFactory(@Name(value="authority") HttpContent.Factory authority, @Name(value="validationPeriod") long validationPeriod, @Name(value="bufferPool") ByteBufferPool.Sized bufferPool) {
        this(authority, validationPeriod, bufferPool, null, -1L, -1L);
    }

    public ValidatingCachingHttpContentFactory(@Name(value="authority") HttpContent.Factory authority, @Name(value="validationPeriod") long validationPeriod, @Name(value="byteBufferPool") ByteBufferPool.Sized bufferPool, @Name(value="scheduler") Scheduler scheduler, @Name(value="sweepPeriod") long sweepPeriod, @Name(value="idleTimeout") long idleTimeout) {
        super(authority, bufferPool);
        this._validationTime = validationPeriod;
        this._scheduler = scheduler;
        this._sweepDelay = sweepPeriod;
        this._maxCacheIdleTime = idleTimeout;
        if (scheduler != null && sweepPeriod > 0L) {
            this.schedule();
        }
    }

    @Override
    protected boolean isCacheable(HttpContent httpContent) {
        if (httpContent == null) {
            return this._validationTime != 0L;
        }
        return super.isCacheable(httpContent);
    }

    private void schedule() {
        this._scheduler.schedule(this, this._sweepDelay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ConcurrentMap<String, CachingHttpContentFactory.CachingHttpContent> cache = this.getCache();
            for (Map.Entry entry : cache.entrySet()) {
                CachingHttpContentFactory.CachingHttpContent value = (CachingHttpContentFactory.CachingHttpContent)entry.getValue();
                if (this._maxCacheIdleTime > 0L && NanoTime.since(value.getLastAccessedNanos()) > TimeUnit.MILLISECONDS.toNanos(this._maxCacheIdleTime)) {
                    this.removeFromCache(value);
                    continue;
                }
                if (value.isValid()) continue;
                this.removeFromCache(value);
            }
        }
        finally {
            this.schedule();
        }
    }

    @Override
    protected CachingHttpContentFactory.CachingHttpContent newCachedContent(String p, HttpContent httpContent) {
        return new ValidatingCachedContent(p, httpContent, this._validationTime);
    }

    @Override
    protected CachingHttpContentFactory.CachingHttpContent newNotFoundContent(String p) {
        return new ValidatingNotFoundContent(p, this._validationTime);
    }

    protected class ValidatingCachedContent
    extends CachingHttpContentFactory.CachedHttpContent {
        private final long _validationTime;
        private final AtomicLong _lastValidated;

        public ValidatingCachedContent(String key, HttpContent httpContent, long validationTime) {
            super(key, httpContent);
            this._lastValidated = new AtomicLong();
            this._lastValidated.set(NanoTime.now());
            this._validationTime = validationTime;
        }

        @Override
        public boolean isValid() {
            long now;
            if (this._validationTime < 0L) {
                return true;
            }
            if (this._validationTime > 0L && this._lastValidated.updateAndGet(arg_0 -> this.lambda$isValid$0(now = NanoTime.now(), arg_0)) != now) {
                return true;
            }
            return Objects.equals(this.getLastModifiedInstant(), this.getWrapped().getLastModifiedInstant());
        }

        private /* synthetic */ long lambda$isValid$0(long now, long lastChecked) {
            return NanoTime.elapsed(lastChecked, now) > TimeUnit.MILLISECONDS.toNanos(this._validationTime) ? now : lastChecked;
        }
    }

    protected static class ValidatingNotFoundContent
    extends CachingHttpContentFactory.NotFoundHttpContent {
        private final long _validationTime;
        private final AtomicLong _lastValidated = new AtomicLong();

        public ValidatingNotFoundContent(String key, long validationTime) {
            super(key);
            this._validationTime = validationTime;
            this._lastValidated.set(NanoTime.now());
        }

        @Override
        public boolean isValid() {
            if (this._validationTime < 0L) {
                return true;
            }
            if (this._validationTime > 0L) {
                return NanoTime.since(this._lastValidated.get()) < TimeUnit.MILLISECONDS.toNanos(this._validationTime);
            }
            return false;
        }
    }
}

