/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.storage.v1beta2.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.ReadSession;
import com.google.cloud.bigquery.storage.v1beta2.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1beta2.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1beta2.stub.BigQueryReadStub;
import com.google.cloud.bigquery.storage.v1beta2.stub.BigQueryReadStubSettings;
import com.google.cloud.bigquery.storage.v1beta2.stub.GrpcBigQueryReadCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcBigQueryReadStub
extends BigQueryReadStub {
    private static final MethodDescriptor<CreateReadSessionRequest, ReadSession> createReadSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1beta2.BigQueryRead/CreateReadSession").setRequestMarshaller(ProtoUtils.marshaller(CreateReadSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ReadSession.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ReadRowsRequest, ReadRowsResponse> readRowsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.cloud.bigquery.storage.v1beta2.BigQueryRead/ReadRows").setRequestMarshaller(ProtoUtils.marshaller(ReadRowsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ReadRowsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.bigquery.storage.v1beta2.BigQueryRead/SplitReadStream").setRequestMarshaller(ProtoUtils.marshaller(SplitReadStreamRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(SplitReadStreamResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateReadSessionRequest, ReadSession> createReadSessionCallable;
    private final ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable;
    private final UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBigQueryReadStub create(BigQueryReadStubSettings settings) throws IOException {
        return new GrpcBigQueryReadStub(settings, ClientContext.create(settings));
    }

    public static final GrpcBigQueryReadStub create(ClientContext clientContext) throws IOException {
        return new GrpcBigQueryReadStub(BigQueryReadStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBigQueryReadStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBigQueryReadStub(BigQueryReadStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBigQueryReadStub(BigQueryReadStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBigQueryReadCallableFactory());
    }

    protected GrpcBigQueryReadStub(BigQueryReadStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create(clientContext, callableFactory);
        GrpcCallSettings<CreateReadSessionRequest, ReadSession> createReadSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createReadSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("read_session.table", String.valueOf(request.getReadSession().getTable()));
            return builder.build();
        }).build();
        GrpcCallSettings<ReadRowsRequest, ReadRowsResponse> readRowsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readRowsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("read_stream", String.valueOf(request.getReadStream()));
            return builder.build();
        }).build();
        GrpcCallSettings<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(splitReadStreamMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createReadSessionCallable = callableFactory.createUnaryCallable(createReadSessionTransportSettings, settings.createReadSessionSettings(), clientContext);
        this.readRowsCallable = callableFactory.createServerStreamingCallable(readRowsTransportSettings, settings.readRowsSettings(), clientContext);
        this.splitReadStreamCallable = callableFactory.createUnaryCallable(splitReadStreamTransportSettings, settings.splitReadStreamSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateReadSessionRequest, ReadSession> createReadSessionCallable() {
        return this.createReadSessionCallable;
    }

    @Override
    public ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable() {
        return this.readRowsCallable;
    }

    @Override
    public UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamCallable() {
        return this.splitReadStreamCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    @Override
    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

