/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageSettings;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.cloud.bigquery.storage.v1beta1.stub.EnhancedBigQueryStorageStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class BigQueryStorageClient
implements BackgroundResource {
    private final BigQueryStorageSettings settings;
    private final EnhancedBigQueryStorageStub stub;

    public static final BigQueryStorageClient create() throws IOException {
        return BigQueryStorageClient.create(BigQueryStorageSettings.newBuilder().build());
    }

    public static final BigQueryStorageClient create(BigQueryStorageSettings settings) throws IOException {
        return new BigQueryStorageClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BigQueryStorageClient create(EnhancedBigQueryStorageStub stub) {
        return new BigQueryStorageClient(stub);
    }

    protected BigQueryStorageClient(BigQueryStorageSettings settings) throws IOException {
        this.settings = settings;
        this.stub = EnhancedBigQueryStorageStub.create(settings.getTypedStubSettings(), settings.getReadRowsRetryAttemptListener());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BigQueryStorageClient(EnhancedBigQueryStorageStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BigQueryStorageSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EnhancedBigQueryStorageStub getStub() {
        return this.stub;
    }

    public final Storage.ReadSession createReadSession(TableReferenceProto.TableReference tableReference, String parent, int requestedStreams) {
        Storage.CreateReadSessionRequest request = Storage.CreateReadSessionRequest.newBuilder().setTableReference(tableReference).setParent(parent).setRequestedStreams(requestedStreams).build();
        return this.createReadSession(request);
    }

    public final Storage.ReadSession createReadSession(Storage.CreateReadSessionRequest request) {
        return this.createReadSessionCallable().call(request);
    }

    public final UnaryCallable<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionCallable() {
        return this.stub.createReadSessionCallable();
    }

    public final ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsCallable() {
        return this.stub.readRowsCallable();
    }

    public final Storage.BatchCreateReadSessionStreamsResponse batchCreateReadSessionStreams(Storage.ReadSession session, int requestedStreams) {
        Storage.BatchCreateReadSessionStreamsRequest request = Storage.BatchCreateReadSessionStreamsRequest.newBuilder().setSession(session).setRequestedStreams(requestedStreams).build();
        return this.batchCreateReadSessionStreams(request);
    }

    public final Storage.BatchCreateReadSessionStreamsResponse batchCreateReadSessionStreams(Storage.BatchCreateReadSessionStreamsRequest request) {
        return this.batchCreateReadSessionStreamsCallable().call(request);
    }

    public final UnaryCallable<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsCallable() {
        return this.stub.batchCreateReadSessionStreamsCallable();
    }

    public final void finalizeStream(Storage.Stream stream) {
        Storage.FinalizeStreamRequest request = Storage.FinalizeStreamRequest.newBuilder().setStream(stream).build();
        this.finalizeStream(request);
    }

    public final void finalizeStream(Storage.FinalizeStreamRequest request) {
        this.finalizeStreamCallable().call(request);
    }

    public final UnaryCallable<Storage.FinalizeStreamRequest, Empty> finalizeStreamCallable() {
        return this.stub.finalizeStreamCallable();
    }

    public final Storage.SplitReadStreamResponse splitReadStream(Storage.Stream originalStream) {
        Storage.SplitReadStreamRequest request = Storage.SplitReadStreamRequest.newBuilder().setOriginalStream(originalStream).build();
        return this.splitReadStream(request);
    }

    public final Storage.SplitReadStreamResponse splitReadStream(Storage.SplitReadStreamRequest request) {
        return this.splitReadStreamCallable().call(request);
    }

    public final UnaryCallable<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamCallable() {
        return this.stub.splitReadStreamCallable();
    }

    @Override
    public final void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

