/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Strings;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.DatastoreBackupOptions;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class WriteChannelConfiguration
implements LoadConfiguration,
Serializable {
    private static final long serialVersionUID = 470267591917413578L;
    private final TableId destinationTable;
    private final JobInfo.CreateDisposition createDisposition;
    private final JobInfo.WriteDisposition writeDisposition;
    private final FormatOptions formatOptions;
    private final String nullMarker;
    private final Integer maxBadRecords;
    private final Schema schema;
    private final Boolean ignoreUnknownValues;
    private final List<JobInfo.SchemaUpdateOption> schemaUpdateOptions;
    private final Boolean autodetect;
    private final EncryptionConfiguration destinationEncryptionConfiguration;
    private final TimePartitioning timePartitioning;
    private final Clustering clustering;
    private final Boolean useAvroLogicalTypes;
    private final Map<String, String> labels;
    private List<String> decimalTargetTypes;
    private final List<ConnectionProperty> connectionProperties;
    private final Boolean createSession;

    protected WriteChannelConfiguration(Builder builder) {
        this.destinationTable = Preconditions.checkNotNull(builder.destinationTable);
        this.createDisposition = builder.createDisposition;
        this.writeDisposition = builder.writeDisposition;
        this.formatOptions = builder.formatOptions;
        this.nullMarker = builder.nullMarker;
        this.maxBadRecords = builder.maxBadRecords;
        this.schema = builder.schema;
        this.ignoreUnknownValues = builder.ignoreUnknownValues;
        this.schemaUpdateOptions = builder.schemaUpdateOptions;
        this.autodetect = builder.autodetect;
        this.destinationEncryptionConfiguration = builder.destinationEncryptionConfiguration;
        this.timePartitioning = builder.timePartitioning;
        this.clustering = builder.clustering;
        this.useAvroLogicalTypes = builder.useAvroLogicalTypes;
        this.labels = builder.labels;
        this.decimalTargetTypes = builder.decimalTargetTypes;
        this.connectionProperties = builder.connectionProperties;
        this.createSession = builder.createSession;
    }

    @Override
    public TableId getDestinationTable() {
        return this.destinationTable;
    }

    @Override
    public EncryptionConfiguration getDestinationEncryptionConfiguration() {
        return this.destinationEncryptionConfiguration;
    }

    @Override
    public JobInfo.CreateDisposition getCreateDisposition() {
        return this.createDisposition;
    }

    @Override
    public JobInfo.WriteDisposition getWriteDisposition() {
        return this.writeDisposition;
    }

    @Override
    public String getNullMarker() {
        return this.nullMarker;
    }

    @Override
    public CsvOptions getCsvOptions() {
        return this.formatOptions instanceof CsvOptions ? (CsvOptions)this.formatOptions : null;
    }

    @Override
    public Integer getMaxBadRecords() {
        return this.maxBadRecords;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getFormat() {
        return this.formatOptions != null ? this.formatOptions.getType() : null;
    }

    @Override
    public Boolean ignoreUnknownValues() {
        return this.ignoreUnknownValues;
    }

    @Override
    public DatastoreBackupOptions getDatastoreBackupOptions() {
        return this.formatOptions instanceof DatastoreBackupOptions ? (DatastoreBackupOptions)this.formatOptions : null;
    }

    @Override
    public List<JobInfo.SchemaUpdateOption> getSchemaUpdateOptions() {
        return this.schemaUpdateOptions;
    }

    @Override
    public Boolean getAutodetect() {
        return this.autodetect;
    }

    @Override
    public TimePartitioning getTimePartitioning() {
        return this.timePartitioning;
    }

    @Override
    public Clustering getClustering() {
        return this.clustering;
    }

    @Override
    public Boolean getUseAvroLogicalTypes() {
        return this.useAvroLogicalTypes;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public List<String> getDecimalTargetTypes() {
        return this.decimalTargetTypes;
    }

    public List<ConnectionProperty> getConnectionProperties() {
        return this.connectionProperties;
    }

    public Boolean getCreateSession() {
        return this.createSession;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper(this).add("destinationTable", this.destinationTable).add("destinationEncryptionConfiguration", this.destinationEncryptionConfiguration).add("createDisposition", (Object)this.createDisposition).add("writeDisposition", (Object)this.writeDisposition).add("formatOptions", this.formatOptions).add("nullMarker", this.nullMarker).add("maxBadRecords", this.maxBadRecords).add("schema", this.schema).add("ignoreUnknownValue", this.ignoreUnknownValues).add("schemaUpdateOptions", this.schemaUpdateOptions).add("autodetect", this.autodetect).add("timePartitioning", this.timePartitioning).add("clustering", this.clustering).add("useAvroLogicalTypes", this.useAvroLogicalTypes).add("labels", this.labels).add("decimalTargetTypes", this.decimalTargetTypes).add("connectionProperties", this.connectionProperties).add("createSession", this.createSession);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof WriteChannelConfiguration && Objects.equals(this.toPb(), ((WriteChannelConfiguration)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.destinationTable, this.createDisposition, this.writeDisposition, this.formatOptions, this.nullMarker, this.maxBadRecords, this.schema, this.ignoreUnknownValues, this.schemaUpdateOptions, this.autodetect, this.timePartitioning, this.clustering, this.useAvroLogicalTypes, this.labels, this.decimalTargetTypes, this.connectionProperties, this.createSession});
    }

    WriteChannelConfiguration setProjectId(String projectId) {
        if (Strings.isNullOrEmpty(this.getDestinationTable().getProject())) {
            return this.toBuilder().setDestinationTable(this.getDestinationTable().setProjectId(projectId)).build();
        }
        return this;
    }

    JobConfiguration toPb() {
        JobConfiguration jobConfiguration = new JobConfiguration();
        JobConfigurationLoad loadConfigurationPb = new JobConfigurationLoad();
        loadConfigurationPb.setDestinationTable(this.destinationTable.toPb());
        if (this.createDisposition != null) {
            loadConfigurationPb.setCreateDisposition(this.createDisposition.toString());
        }
        if (this.writeDisposition != null) {
            loadConfigurationPb.setWriteDisposition(this.writeDisposition.toString());
        }
        if (this.nullMarker != null) {
            loadConfigurationPb.setNullMarker(this.nullMarker);
        }
        if (this.getCsvOptions() != null) {
            CsvOptions csvOptions = this.getCsvOptions();
            loadConfigurationPb.setFieldDelimiter(csvOptions.getFieldDelimiter()).setAllowJaggedRows(csvOptions.allowJaggedRows()).setAllowQuotedNewlines(csvOptions.allowQuotedNewLines()).setEncoding(csvOptions.getEncoding()).setQuote(csvOptions.getQuote()).setPreserveAsciiControlCharacters(csvOptions.getPreserveAsciiControlCharacters());
            if (csvOptions.getSkipLeadingRows() != null) {
                loadConfigurationPb.setSkipLeadingRows(Ints.checkedCast(csvOptions.getSkipLeadingRows()));
            }
        }
        if (this.schema != null) {
            loadConfigurationPb.setSchema(this.schema.toPb());
        }
        if (this.formatOptions != null) {
            loadConfigurationPb.setSourceFormat(this.formatOptions.getType());
        }
        loadConfigurationPb.setMaxBadRecords(this.maxBadRecords);
        loadConfigurationPb.setIgnoreUnknownValues(this.ignoreUnknownValues);
        if (this.getDatastoreBackupOptions() != null) {
            DatastoreBackupOptions backupOptions = this.getDatastoreBackupOptions();
            loadConfigurationPb.setProjectionFields(backupOptions.getProjectionFields());
        }
        if (this.schemaUpdateOptions != null) {
            ImmutableList.Builder schemaUpdateOptionsBuilder = new ImmutableList.Builder();
            for (JobInfo.SchemaUpdateOption schemaUpdateOption : this.schemaUpdateOptions) {
                schemaUpdateOptionsBuilder.add(schemaUpdateOption.name());
            }
            loadConfigurationPb.setSchemaUpdateOptions((List<String>)((Object)schemaUpdateOptionsBuilder.build()));
        }
        loadConfigurationPb.setAutodetect(this.autodetect);
        if (this.destinationEncryptionConfiguration != null) {
            loadConfigurationPb.setDestinationEncryptionConfiguration(this.destinationEncryptionConfiguration.toPb());
        }
        if (this.timePartitioning != null) {
            loadConfigurationPb.setTimePartitioning(this.timePartitioning.toPb());
        }
        if (this.clustering != null) {
            loadConfigurationPb.setClustering(this.clustering.toPb());
        }
        loadConfigurationPb.setUseAvroLogicalTypes(this.useAvroLogicalTypes);
        if (this.labels != null) {
            jobConfiguration.setLabels(this.labels);
        }
        if (this.decimalTargetTypes != null) {
            loadConfigurationPb.setDecimalTargetTypes(this.decimalTargetTypes);
        }
        if (this.connectionProperties != null) {
            loadConfigurationPb.setConnectionProperties(Lists.transform(this.connectionProperties, ConnectionProperty.TO_PB_FUNCTION));
        }
        if (this.createSession != null) {
            loadConfigurationPb.setCreateSession(this.createSession);
        }
        jobConfiguration.setLoad(loadConfigurationPb);
        return jobConfiguration;
    }

    static WriteChannelConfiguration fromPb(JobConfiguration configurationPb) {
        return new Builder(configurationPb).build();
    }

    public static Builder newBuilder(TableId destinationTable) {
        return new Builder().setDestinationTable(destinationTable);
    }

    public static Builder newBuilder(TableId destinationTable, FormatOptions format) {
        return WriteChannelConfiguration.newBuilder(destinationTable).setFormatOptions(format);
    }

    public static WriteChannelConfiguration of(TableId destinationTable) {
        return WriteChannelConfiguration.newBuilder(destinationTable).build();
    }

    public static WriteChannelConfiguration of(TableId destinationTable, FormatOptions format) {
        return WriteChannelConfiguration.newBuilder(destinationTable).setFormatOptions(format).build();
    }

    public static final class Builder
    implements LoadConfiguration.Builder {
        private TableId destinationTable;
        private JobInfo.CreateDisposition createDisposition;
        private JobInfo.WriteDisposition writeDisposition;
        private FormatOptions formatOptions;
        private String nullMarker;
        private Integer maxBadRecords;
        private Schema schema;
        private Boolean ignoreUnknownValues;
        private List<JobInfo.SchemaUpdateOption> schemaUpdateOptions;
        private Boolean autodetect;
        private EncryptionConfiguration destinationEncryptionConfiguration;
        private TimePartitioning timePartitioning;
        private Clustering clustering;
        private Boolean useAvroLogicalTypes;
        private Map<String, String> labels;
        private List<String> decimalTargetTypes;
        private List<ConnectionProperty> connectionProperties;
        private Boolean createSession;

        private Builder() {
        }

        private Builder(WriteChannelConfiguration writeChannelConfiguration) {
            this.destinationTable = writeChannelConfiguration.destinationTable;
            this.createDisposition = writeChannelConfiguration.createDisposition;
            this.writeDisposition = writeChannelConfiguration.writeDisposition;
            this.formatOptions = writeChannelConfiguration.formatOptions;
            this.nullMarker = writeChannelConfiguration.nullMarker;
            this.maxBadRecords = writeChannelConfiguration.maxBadRecords;
            this.schema = writeChannelConfiguration.schema;
            this.ignoreUnknownValues = writeChannelConfiguration.ignoreUnknownValues;
            this.schemaUpdateOptions = writeChannelConfiguration.schemaUpdateOptions;
            this.autodetect = writeChannelConfiguration.autodetect;
            this.destinationEncryptionConfiguration = writeChannelConfiguration.destinationEncryptionConfiguration;
            this.timePartitioning = writeChannelConfiguration.timePartitioning;
            this.clustering = writeChannelConfiguration.clustering;
            this.useAvroLogicalTypes = writeChannelConfiguration.useAvroLogicalTypes;
            this.labels = writeChannelConfiguration.labels;
            this.decimalTargetTypes = writeChannelConfiguration.decimalTargetTypes;
            this.connectionProperties = writeChannelConfiguration.connectionProperties;
            this.createSession = writeChannelConfiguration.createSession;
        }

        private Builder(JobConfiguration configurationPb) {
            JobConfigurationLoad loadConfigurationPb = configurationPb.getLoad();
            this.destinationTable = TableId.fromPb(loadConfigurationPb.getDestinationTable());
            if (loadConfigurationPb.getCreateDisposition() != null) {
                this.createDisposition = JobInfo.CreateDisposition.valueOf(loadConfigurationPb.getCreateDisposition());
            }
            if (loadConfigurationPb.getWriteDisposition() != null) {
                this.writeDisposition = JobInfo.WriteDisposition.valueOf(loadConfigurationPb.getWriteDisposition());
            }
            if (loadConfigurationPb.getSourceFormat() != null) {
                this.formatOptions = FormatOptions.of(loadConfigurationPb.getSourceFormat());
            }
            if (loadConfigurationPb.getNullMarker() != null) {
                this.nullMarker = loadConfigurationPb.getNullMarker();
            }
            if (loadConfigurationPb.getAllowJaggedRows() != null || loadConfigurationPb.getAllowQuotedNewlines() != null || loadConfigurationPb.getEncoding() != null || loadConfigurationPb.getFieldDelimiter() != null || loadConfigurationPb.getQuote() != null || loadConfigurationPb.getSkipLeadingRows() != null) {
                CsvOptions.Builder builder = CsvOptions.newBuilder().setEncoding(loadConfigurationPb.getEncoding()).setFieldDelimiter(loadConfigurationPb.getFieldDelimiter()).setQuote(loadConfigurationPb.getQuote());
                if (loadConfigurationPb.getAllowJaggedRows() != null) {
                    builder.setAllowJaggedRows(loadConfigurationPb.getAllowJaggedRows());
                }
                if (loadConfigurationPb.getAllowQuotedNewlines() != null) {
                    builder.setAllowQuotedNewLines(loadConfigurationPb.getAllowQuotedNewlines());
                }
                if (loadConfigurationPb.getSkipLeadingRows() != null) {
                    builder.setSkipLeadingRows(loadConfigurationPb.getSkipLeadingRows().intValue());
                }
                this.formatOptions = builder.build();
            }
            this.maxBadRecords = loadConfigurationPb.getMaxBadRecords();
            if (loadConfigurationPb.getSchema() != null) {
                this.schema = Schema.fromPb(loadConfigurationPb.getSchema());
            }
            this.ignoreUnknownValues = loadConfigurationPb.getIgnoreUnknownValues();
            if (loadConfigurationPb.getProjectionFields() != null) {
                this.formatOptions = DatastoreBackupOptions.newBuilder().setProjectionFields(loadConfigurationPb.getProjectionFields()).build();
            }
            if (loadConfigurationPb.getSchemaUpdateOptions() != null) {
                ImmutableList.Builder schemaUpdateOptionsBuilder = new ImmutableList.Builder();
                for (String rawSchemaUpdateOption : loadConfigurationPb.getSchemaUpdateOptions()) {
                    schemaUpdateOptionsBuilder.add((Object)JobInfo.SchemaUpdateOption.valueOf(rawSchemaUpdateOption));
                }
                this.schemaUpdateOptions = schemaUpdateOptionsBuilder.build();
            }
            this.autodetect = loadConfigurationPb.getAutodetect();
            if (loadConfigurationPb.getDestinationEncryptionConfiguration() != null) {
                this.destinationEncryptionConfiguration = new EncryptionConfiguration.Builder(configurationPb.getLoad().getDestinationEncryptionConfiguration()).build();
            }
            if (loadConfigurationPb.getTimePartitioning() != null) {
                this.timePartitioning = TimePartitioning.fromPb(loadConfigurationPb.getTimePartitioning());
            }
            if (loadConfigurationPb.getClustering() != null) {
                this.clustering = Clustering.fromPb(loadConfigurationPb.getClustering());
            }
            this.useAvroLogicalTypes = loadConfigurationPb.getUseAvroLogicalTypes();
            if (configurationPb.getLabels() != null) {
                this.labels = configurationPb.getLabels();
            }
            if (loadConfigurationPb.getDecimalTargetTypes() != null) {
                this.decimalTargetTypes = loadConfigurationPb.getDecimalTargetTypes();
            }
            if (loadConfigurationPb.getConnectionProperties() != null) {
                this.connectionProperties = Lists.transform(loadConfigurationPb.getConnectionProperties(), ConnectionProperty.FROM_PB_FUNCTION);
            }
            this.createSession = loadConfigurationPb.getCreateSession();
        }

        @Override
        public Builder setDestinationTable(TableId destinationTable) {
            this.destinationTable = destinationTable;
            return this;
        }

        @Override
        public LoadConfiguration.Builder setDestinationEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.destinationEncryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public Builder setCreateDisposition(JobInfo.CreateDisposition createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        @Override
        public Builder setWriteDisposition(JobInfo.WriteDisposition writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        @Override
        public Builder setFormatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        @Override
        public Builder setNullMarker(String nullMarker) {
            this.nullMarker = nullMarker;
            return this;
        }

        @Override
        public Builder setMaxBadRecords(Integer maxBadRecords) {
            this.maxBadRecords = maxBadRecords;
            return this;
        }

        @Override
        public Builder setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public Builder setIgnoreUnknownValues(Boolean ignoreUnknownValues) {
            this.ignoreUnknownValues = ignoreUnknownValues;
            return this;
        }

        @Override
        public Builder setSchemaUpdateOptions(List<JobInfo.SchemaUpdateOption> schemaUpdateOptions) {
            this.schemaUpdateOptions = schemaUpdateOptions != null ? ImmutableList.copyOf(schemaUpdateOptions) : null;
            return this;
        }

        @Override
        public Builder setAutodetect(Boolean autodetect) {
            this.autodetect = autodetect;
            return this;
        }

        @Override
        public Builder setTimePartitioning(TimePartitioning timePartitioning) {
            this.timePartitioning = timePartitioning;
            return this;
        }

        @Override
        public Builder setClustering(Clustering clustering) {
            this.clustering = clustering;
            return this;
        }

        @Override
        public Builder setUseAvroLogicalTypes(Boolean useAvroLogicalTypes) {
            this.useAvroLogicalTypes = useAvroLogicalTypes;
            return this;
        }

        public Builder setLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        @Override
        public Builder setDecimalTargetTypes(List<String> decimalTargetTypes) {
            this.decimalTargetTypes = decimalTargetTypes;
            return this;
        }

        public Builder setConnectionProperties(List<ConnectionProperty> connectionProperties) {
            this.connectionProperties = ImmutableList.copyOf(connectionProperties);
            return this;
        }

        public Builder setCreateSession(Boolean createSession) {
            this.createSession = createSession;
            return this;
        }

        @Override
        public WriteChannelConfiguration build() {
            return new WriteChannelConfiguration(this);
        }
    }
}

