/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.FormatOptions;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class ParquetOptions
extends FormatOptions {
    private static final long serialVersionUID = 1993L;
    private final Boolean enableListInference;
    private final Boolean enumAsString;
    private final String mapTargetType;

    public Boolean getEnableListInference() {
        return this.enableListInference;
    }

    public Boolean getEnumAsString() {
        return this.enumAsString;
    }

    public String getMapTargetType() {
        return this.mapTargetType;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    ParquetOptions(Builder builder) {
        super("PARQUET");
        this.enableListInference = builder.enableListInference;
        this.enumAsString = builder.enumAsString;
        this.mapTargetType = builder.mapTargetType;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("enableListInference", this.enableListInference).add("enumAsString", this.enumAsString).add("mapTargetType", this.mapTargetType).toString();
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.enableListInference, this.enumAsString, this.mapTargetType);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(ParquetOptions.class)) {
            return false;
        }
        ParquetOptions other = (ParquetOptions)obj;
        return this.enableListInference == other.enableListInference && this.enumAsString == other.enumAsString && Objects.equals(this.mapTargetType, ((ParquetOptions)obj).getMapTargetType());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static ParquetOptions fromPb(com.google.api.services.bigquery.model.ParquetOptions parquetOptions) {
        Builder builder = ParquetOptions.newBuilder();
        if (parquetOptions.getEnableListInference() != null) {
            builder.setEnableListInference(parquetOptions.getEnableListInference());
        }
        if (parquetOptions.getEnumAsString() != null) {
            builder.setEnumAsString(parquetOptions.getEnumAsString());
        }
        if (parquetOptions.getMapTargetType() != null) {
            builder.setMapTargetType(parquetOptions.getMapTargetType());
        }
        return builder.build();
    }

    com.google.api.services.bigquery.model.ParquetOptions toPb() {
        com.google.api.services.bigquery.model.ParquetOptions parquetOptions = new com.google.api.services.bigquery.model.ParquetOptions();
        if (this.enableListInference != null) {
            parquetOptions.setEnableListInference(this.enableListInference);
        }
        if (this.enumAsString != null) {
            parquetOptions.setEnumAsString(this.enumAsString);
        }
        if (this.mapTargetType != null) {
            parquetOptions.setMapTargetType(this.mapTargetType);
        }
        return parquetOptions;
    }

    public static final class Builder {
        private Boolean enableListInference;
        private Boolean enumAsString;
        private String mapTargetType;

        private Builder() {
        }

        private Builder(ParquetOptions parquetOptions) {
            this.enableListInference = parquetOptions.enableListInference;
            this.enumAsString = parquetOptions.enumAsString;
            this.mapTargetType = parquetOptions.mapTargetType;
        }

        public Builder setEnableListInference(Boolean enableListInference) {
            this.enableListInference = enableListInference;
            return this;
        }

        public Builder setEnumAsString(Boolean enumAsString) {
            this.enumAsString = enumAsString;
            return this;
        }

        public Builder setMapTargetType(String mapTargetType) {
            this.mapTargetType = mapTargetType;
            return this;
        }

        public ParquetOptions build() {
            return new ParquetOptions(this);
        }
    }
}

