/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;

public final class HivePartitioningOptions {
    private final String mode;
    private final Boolean requirePartitionFilter;
    private final String sourceUriPrefix;
    private final List<String> fields;

    private HivePartitioningOptions(Builder builder) {
        this.mode = builder.mode;
        this.requirePartitionFilter = builder.requirePartitionFilter;
        this.sourceUriPrefix = builder.sourceUriPrefix;
        this.fields = builder.fields;
    }

    public String getMode() {
        return this.mode;
    }

    public Boolean getRequirePartitionFilter() {
        return this.requirePartitionFilter;
    }

    public String getSourceUriPrefix() {
        return this.sourceUriPrefix;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("mode", this.mode).add("requirePartitionFilter", this.requirePartitionFilter).add("sourceUriPrefix", this.sourceUriPrefix).toString();
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(HivePartitioningOptions.class) && Objects.equals(this.mode, ((HivePartitioningOptions)obj).getMode()) && Objects.equals(this.requirePartitionFilter, ((HivePartitioningOptions)obj).getRequirePartitionFilter()) && Objects.equals(this.sourceUriPrefix, ((HivePartitioningOptions)obj).getSourceUriPrefix()) && Objects.equals(this.fields, ((HivePartitioningOptions)obj).getFields());
    }

    public int hashCode() {
        return Objects.hash(this.mode, this.sourceUriPrefix, this.fields);
    }

    com.google.api.services.bigquery.model.HivePartitioningOptions toPb() {
        com.google.api.services.bigquery.model.HivePartitioningOptions options = new com.google.api.services.bigquery.model.HivePartitioningOptions();
        options.setMode(this.mode);
        options.setRequirePartitionFilter(this.requirePartitionFilter);
        options.setSourceUriPrefix(this.sourceUriPrefix);
        options.setFields(this.fields);
        return options;
    }

    static HivePartitioningOptions fromPb(com.google.api.services.bigquery.model.HivePartitioningOptions options) {
        Builder builder = HivePartitioningOptions.newBuilder();
        if (options.getMode() != null) {
            builder.setMode(options.getMode());
        }
        if (options.getRequirePartitionFilter() != null) {
            builder.setRequirePartitionFilter(options.getRequirePartitionFilter());
        }
        if (options.getSourceUriPrefix() != null) {
            builder.setSourceUriPrefix(options.getSourceUriPrefix());
        }
        if (options.getFields() != null) {
            builder.setFields(options.getFields());
        }
        return builder.build();
    }

    public static final class Builder {
        private String mode;
        private Boolean requirePartitionFilter;
        private String sourceUriPrefix;
        private List<String> fields;

        private Builder() {
        }

        private Builder(HivePartitioningOptions options) {
            this.mode = options.mode;
            this.requirePartitionFilter = options.requirePartitionFilter;
            this.sourceUriPrefix = options.sourceUriPrefix;
            this.fields = options.fields;
        }

        public Builder setMode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder setRequirePartitionFilter(Boolean requirePartitionFilter) {
            this.requirePartitionFilter = requirePartitionFilter;
            return this;
        }

        public Builder setSourceUriPrefix(String sourceUriPrefix) {
            this.sourceUriPrefix = sourceUriPrefix;
            return this;
        }

        public Builder setFields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public HivePartitioningOptions build() {
            return new HivePartitioningOptions(this);
        }
    }
}

