/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.FormatOptions;
import com.google.common.base.MoreObjects;
import java.nio.charset.Charset;
import java.util.Objects;

public final class CsvOptions
extends FormatOptions {
    private static final long serialVersionUID = 2193570529308612709L;
    private final Boolean allowJaggedRows;
    private final Boolean allowQuotedNewLines;
    private final String encoding;
    private final String fieldDelimiter;
    private final String nullMarker;
    private final String quote;
    private final Long skipLeadingRows;
    private final Boolean preserveAsciiControlCharacters;

    private CsvOptions(Builder builder) {
        super("CSV");
        this.allowJaggedRows = builder.allowJaggedRows;
        this.allowQuotedNewLines = builder.allowQuotedNewLines;
        this.encoding = builder.encoding;
        this.fieldDelimiter = builder.fieldDelimiter;
        this.nullMarker = builder.nullMarker;
        this.quote = builder.quote;
        this.skipLeadingRows = builder.skipLeadingRows;
        this.preserveAsciiControlCharacters = builder.preserveAsciiControlCharacters;
    }

    public Boolean allowJaggedRows() {
        return this.allowJaggedRows;
    }

    public Boolean allowQuotedNewLines() {
        return this.allowQuotedNewLines;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String getNullMarker() {
        return this.nullMarker;
    }

    public String getQuote() {
        return this.quote;
    }

    public Long getSkipLeadingRows() {
        return this.skipLeadingRows;
    }

    public Boolean getPreserveAsciiControlCharacters() {
        return this.preserveAsciiControlCharacters;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", this.getType()).add("allowJaggedRows", this.allowJaggedRows).add("allowQuotedNewLines", this.allowQuotedNewLines).add("encoding", this.encoding).add("fieldDelimiter", this.fieldDelimiter).add("nullMarker", this.nullMarker).add("quote", this.quote).add("skipLeadingRows", this.skipLeadingRows).add("preserveAsciiControlCharacters", this.preserveAsciiControlCharacters).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getType(), this.allowJaggedRows, this.allowQuotedNewLines, this.encoding, this.fieldDelimiter, this.nullMarker, this.quote, this.skipLeadingRows, this.preserveAsciiControlCharacters);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof CsvOptions && Objects.equals(this.toPb(), ((CsvOptions)obj).toPb());
    }

    com.google.api.services.bigquery.model.CsvOptions toPb() {
        com.google.api.services.bigquery.model.CsvOptions csvOptions = new com.google.api.services.bigquery.model.CsvOptions();
        csvOptions.setAllowJaggedRows(this.allowJaggedRows);
        csvOptions.setAllowQuotedNewlines(this.allowQuotedNewLines);
        csvOptions.setEncoding(this.encoding);
        csvOptions.setFieldDelimiter(this.fieldDelimiter);
        csvOptions.setNullMarker(this.nullMarker);
        csvOptions.setQuote(this.quote);
        csvOptions.setSkipLeadingRows(this.skipLeadingRows);
        csvOptions.setPreserveAsciiControlCharacters(this.preserveAsciiControlCharacters);
        return csvOptions;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static CsvOptions fromPb(com.google.api.services.bigquery.model.CsvOptions csvOptions) {
        Builder builder = CsvOptions.newBuilder();
        if (csvOptions.getAllowJaggedRows() != null) {
            builder.setAllowJaggedRows(csvOptions.getAllowJaggedRows());
        }
        if (csvOptions.getAllowQuotedNewlines() != null) {
            builder.setAllowQuotedNewLines(csvOptions.getAllowQuotedNewlines());
        }
        if (csvOptions.getEncoding() != null) {
            builder.setEncoding(csvOptions.getEncoding());
        }
        if (csvOptions.getFieldDelimiter() != null) {
            builder.setFieldDelimiter(csvOptions.getFieldDelimiter());
        }
        if (csvOptions.getNullMarker() != null) {
            builder.setNullMarker(csvOptions.getNullMarker());
        }
        if (csvOptions.getQuote() != null) {
            builder.setQuote(csvOptions.getQuote());
        }
        if (csvOptions.getSkipLeadingRows() != null) {
            builder.setSkipLeadingRows(csvOptions.getSkipLeadingRows());
        }
        if (csvOptions.getPreserveAsciiControlCharacters() != null) {
            builder.setPreserveAsciiControlCharacters(csvOptions.getPreserveAsciiControlCharacters());
        }
        return builder.build();
    }

    public static final class Builder {
        private Boolean allowJaggedRows;
        private Boolean allowQuotedNewLines;
        private String encoding;
        private String fieldDelimiter;
        private String nullMarker;
        private String quote;
        private Long skipLeadingRows;
        private Boolean preserveAsciiControlCharacters;

        private Builder() {
        }

        private Builder(CsvOptions csvOptions) {
            this.allowJaggedRows = csvOptions.allowJaggedRows;
            this.allowQuotedNewLines = csvOptions.allowQuotedNewLines;
            this.encoding = csvOptions.encoding;
            this.fieldDelimiter = csvOptions.fieldDelimiter;
            this.nullMarker = csvOptions.nullMarker;
            this.quote = csvOptions.quote;
            this.skipLeadingRows = csvOptions.skipLeadingRows;
            this.preserveAsciiControlCharacters = csvOptions.preserveAsciiControlCharacters;
        }

        public Builder setAllowJaggedRows(boolean allowJaggedRows) {
            this.allowJaggedRows = allowJaggedRows;
            return this;
        }

        public Builder setAllowQuotedNewLines(boolean allowQuotedNewLines) {
            this.allowQuotedNewLines = allowQuotedNewLines;
            return this;
        }

        public Builder setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setEncoding(Charset encoding) {
            this.encoding = encoding.name();
            return this;
        }

        public Builder setFieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public Builder setNullMarker(String nullMarker) {
            this.nullMarker = nullMarker;
            return this;
        }

        public Builder setQuote(String quote) {
            this.quote = quote;
            return this;
        }

        public Builder setSkipLeadingRows(long skipLeadingRows) {
            this.skipLeadingRows = skipLeadingRows;
            return this;
        }

        public Builder setPreserveAsciiControlCharacters(boolean preserveAsciiControlCharacters) {
            this.preserveAsciiControlCharacters = preserveAsciiControlCharacters;
            return this;
        }

        public CsvOptions build() {
            return new CsvOptions(this);
        }
    }
}

