/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.ResultRetryAlgorithmWithContext;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetryingContext;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.retrying.TimedRetryAlgorithmWithContext;
import com.google.cloud.bigquery.BigQueryRetryConfig;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.time.Duration;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class BigQueryRetryAlgorithm<ResponseT>
extends RetryAlgorithm<ResponseT> {
    private final BigQueryRetryConfig bigQueryRetryConfig;
    private final ResultRetryAlgorithm<ResponseT> resultAlgorithm;
    private final TimedRetryAlgorithm timedAlgorithm;
    private final ResultRetryAlgorithmWithContext<ResponseT> resultAlgorithmWithContext;
    private final TimedRetryAlgorithmWithContext timedAlgorithmWithContext;
    private static final Logger LOG = Logger.getLogger(BigQueryRetryAlgorithm.class.getName());
    private static final UUID RETRY_UUID = UUID.randomUUID();

    public BigQueryRetryAlgorithm(ResultRetryAlgorithm<ResponseT> resultAlgorithm, TimedRetryAlgorithm timedAlgorithm, BigQueryRetryConfig bigQueryRetryConfig) {
        super(resultAlgorithm, timedAlgorithm);
        this.bigQueryRetryConfig = Preconditions.checkNotNull(bigQueryRetryConfig);
        this.resultAlgorithm = Preconditions.checkNotNull(resultAlgorithm);
        this.timedAlgorithm = Preconditions.checkNotNull(timedAlgorithm);
        this.resultAlgorithmWithContext = null;
        this.timedAlgorithmWithContext = null;
    }

    @Override
    public boolean shouldRetry(RetryingContext context, Throwable previousThrowable, ResponseT previousResponse, TimedAttemptSettings nextAttemptSettings) throws CancellationException {
        boolean shouldRetry;
        int attemptCount = nextAttemptSettings == null ? 0 : nextAttemptSettings.getAttemptCount();
        Duration retryDelay = nextAttemptSettings == null ? Duration.ZERO : nextAttemptSettings.getRetryDelayDuration();
        String errorMessage = previousThrowable != null ? previousThrowable.getMessage() : "";
        boolean bl = shouldRetry = (this.shouldRetryBasedOnResult(context, previousThrowable, previousResponse) || this.shouldRetryBasedOnBigQueryRetryConfig(previousThrowable, this.bigQueryRetryConfig, previousResponse)) && this.shouldRetryBasedOnTiming(context, nextAttemptSettings);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Retrying with:\n{0}\n{1}\n{2}\n{3}\n{4}\n{5}", new Object[]{"BigQuery attemptCount: " + attemptCount, "BigQuery delay: " + retryDelay, "BigQuery retriableException: " + previousThrowable, "BigQuery shouldRetry: " + shouldRetry, "BigQuery previousThrowable.getMessage: " + errorMessage, "BigQuery retry identifier: " + RETRY_UUID});
        }
        return shouldRetry;
    }

    private boolean shouldRetryBasedOnBigQueryRetryConfig(Throwable previousThrowable, BigQueryRetryConfig bigQueryRetryConfig, ResponseT previousResponse) {
        String errorDesc = null;
        if (previousThrowable != null) {
            errorDesc = previousThrowable.getMessage();
        } else if (previousResponse != null) {
            errorDesc = this.getErrorDescFromResponse(previousResponse);
        }
        if (errorDesc != null) {
            errorDesc = errorDesc.toLowerCase();
            Iterator retriableMessages = bigQueryRetryConfig.getRetriableErrorMessages().iterator();
            while (retriableMessages.hasNext()) {
                if (!errorDesc.contains(((String)retriableMessages.next()).toLowerCase())) continue;
                return true;
            }
            Iterator retriableRegExes = bigQueryRetryConfig.getRetriableRegExes().iterator();
            while (retriableRegExes.hasNext()) {
                if (!BigQueryRetryAlgorithm.matchRegEx((String)retriableRegExes.next(), errorDesc)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matchRegEx(String retriableRegEx, String errorDesc) {
        return Pattern.matches(retriableRegEx.toLowerCase(), errorDesc.toLowerCase());
    }

    boolean shouldRetryBasedOnResult(RetryingContext context, Throwable previousThrowable, ResponseT previousResponse) {
        if (this.resultAlgorithmWithContext != null && context != null) {
            return this.resultAlgorithmWithContext.shouldRetry(context, previousThrowable, previousResponse);
        }
        return this.getResultAlgorithm().shouldRetry(previousThrowable, previousResponse);
    }

    private boolean shouldRetryBasedOnTiming(RetryingContext context, TimedAttemptSettings nextAttemptSettings) {
        if (nextAttemptSettings == null) {
            return false;
        }
        if (this.timedAlgorithmWithContext != null && context != null) {
            return this.timedAlgorithmWithContext.shouldRetry(context, nextAttemptSettings);
        }
        return this.getTimedAlgorithm().shouldRetry(nextAttemptSettings);
    }

    @Override
    public TimedAttemptSettings createNextAttempt(RetryingContext context, Throwable previousThrowable, ResponseT previousResponse, TimedAttemptSettings previousSettings) {
        if (!this.shouldRetryBasedOnResult(context, previousThrowable, previousResponse) && !this.shouldRetryBasedOnBigQueryRetryConfig(previousThrowable, this.bigQueryRetryConfig, previousResponse)) {
            return null;
        }
        TimedAttemptSettings newSettings = this.createNextAttemptBasedOnResult(context, previousThrowable, previousResponse, previousSettings);
        if (newSettings == null) {
            newSettings = this.createNextAttemptBasedOnTiming(context, previousSettings);
        }
        return newSettings;
    }

    private TimedAttemptSettings createNextAttemptBasedOnResult(RetryingContext context, Throwable previousThrowable, ResponseT previousResponse, TimedAttemptSettings previousSettings) {
        if (this.resultAlgorithmWithContext != null && context != null) {
            return this.resultAlgorithmWithContext.createNextAttempt(context, previousThrowable, previousResponse, previousSettings);
        }
        return this.getResultAlgorithm().createNextAttempt(previousThrowable, previousResponse, previousSettings);
    }

    private TimedAttemptSettings createNextAttemptBasedOnTiming(RetryingContext context, TimedAttemptSettings previousSettings) {
        if (this.timedAlgorithmWithContext != null && context != null) {
            return this.timedAlgorithmWithContext.createNextAttempt(context, previousSettings);
        }
        return this.getTimedAlgorithm().createNextAttempt(previousSettings);
    }

    private String getErrorDescFromResponse(ResponseT previousResponse) {
        try {
            JsonObject responseJson = JsonParser.parseString(previousResponse.toString()).getAsJsonObject();
            if (responseJson.has("status") && responseJson.getAsJsonObject("status").has("errorResult")) {
                return responseJson.getAsJsonObject("status").getAsJsonObject("errorResult").get("message").toString();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

