/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.ApiFunction;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetAccessEntry;
import com.google.cloud.StringEnumType;
import com.google.cloud.StringEnumValue;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.TableId;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public final class Acl
implements Serializable {
    private static final long serialVersionUID = 8357269726277191556L;
    private final Entity entity;
    private final Role role;
    private final Expr condition;

    private Acl(Entity entity, Role role) {
        this(entity, role, null);
    }

    private Acl(Entity entity, Role role, Expr condition) {
        this.entity = Preconditions.checkNotNull(entity);
        this.role = role;
        this.condition = condition;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Role getRole() {
        return this.role;
    }

    public Expr getCondition() {
        return this.condition;
    }

    public static Acl of(Entity entity, Role role) {
        return new Acl(entity, role);
    }

    public static Acl of(Entity entity, Role role, Expr condition) {
        return new Acl(entity, role, condition);
    }

    public static Acl of(DatasetAclEntity datasetAclEntity) {
        return new Acl(datasetAclEntity, null);
    }

    public static Acl of(View view) {
        return new Acl(view, null);
    }

    public static Acl of(Routine routine) {
        return new Acl(routine, null);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.role, this.condition);
    }

    public String toString() {
        return this.toPb().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Acl other = (Acl)obj;
        return Objects.equals(this.entity, other.entity) && Objects.equals(this.role, other.role) && Objects.equals(this.condition, other.condition);
    }

    Dataset.Access toPb() {
        Dataset.Access accessPb = this.entity.toPb();
        if (this.role != null) {
            accessPb.setRole(this.role.name());
        }
        if (this.condition != null) {
            accessPb.setCondition(this.condition.toPb());
        }
        return accessPb;
    }

    static Acl fromPb(Dataset.Access access) {
        return Acl.of(Entity.fromPb(access), access.getRole() != null ? Role.valueOf(access.getRole()) : null, access.getCondition() != null ? Expr.fromPb(access.getCondition()) : null);
    }

    public static abstract class Entity
    implements Serializable {
        private static final long serialVersionUID = 8111776788607959944L;
        private final Type type;

        Entity(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        abstract Dataset.Access toPb();

        static Entity fromPb(Dataset.Access access) {
            if (access.getDataset() != null) {
                return new DatasetAclEntity(DatasetId.fromPb(access.getDataset().getDataset()), access.getDataset().getTargetTypes());
            }
            if (access.getDomain() != null) {
                return new Domain(access.getDomain());
            }
            if (access.getGroupByEmail() != null) {
                return new Group(access.getGroupByEmail());
            }
            if (access.getSpecialGroup() != null) {
                return new Group(access.getSpecialGroup());
            }
            if (access.getUserByEmail() != null) {
                return new User(access.getUserByEmail());
            }
            if (access.getView() != null) {
                return new View(TableId.fromPb(access.getView()));
            }
            if (access.getIamMember() != null) {
                return new IamMember(access.getIamMember());
            }
            if (access.getRoutine() != null) {
                return new Routine(RoutineId.fromPb(access.getRoutine()));
            }
            throw new BigQueryException(0, "Unrecognized access configuration");
        }

        public static enum Type {
            DOMAIN,
            GROUP,
            USER,
            VIEW,
            IAM_MEMBER,
            ROUTINE,
            DATASET;

        }
    }

    public static final class Role
    extends StringEnumValue {
        private static final long serialVersionUID = -1992679397135956912L;
        private static final ApiFunction<String, Role> CONSTRUCTOR = new ApiFunction<String, Role>(){

            @Override
            public Role apply(String constant) {
                return new Role(constant);
            }
        };
        private static final StringEnumType<Role> type = new StringEnumType<Role>(Role.class, CONSTRUCTOR);
        public static final Role READER = type.createAndRegister("READER");
        public static final Role WRITER = type.createAndRegister("WRITER");
        public static final Role OWNER = type.createAndRegister("OWNER");

        private Role(String constant) {
            super(constant);
        }

        public static Role valueOfStrict(String constant) {
            return type.valueOfStrict(constant);
        }

        public static Role valueOf(String constant) {
            return type.valueOf(constant);
        }

        public static Role[] values() {
            return type.values();
        }
    }

    public static final class Expr
    implements Serializable {
        private final String expression;
        private final String title;
        private final String description;
        private final String location;
        private static final long serialVersionUID = 7358264726377291156L;

        public Expr(Builder builder) {
            this.expression = builder.expression;
            this.title = builder.title;
            this.description = builder.description;
            this.location = builder.location;
        }

        public Expr(String expression, String title, String description, String location) {
            this.expression = expression;
            this.title = title;
            this.description = description;
            this.location = location;
        }

        com.google.api.services.bigquery.model.Expr toPb() {
            com.google.api.services.bigquery.model.Expr bqExpr = new com.google.api.services.bigquery.model.Expr();
            bqExpr.setExpression(this.expression);
            bqExpr.setTitle(this.title);
            bqExpr.setDescription(this.description);
            bqExpr.setLocation(this.location);
            return bqExpr;
        }

        static Expr fromPb(com.google.api.services.bigquery.model.Expr bqExpr) {
            return new Builder(bqExpr).build();
        }

        public Builder toBuilder() {
            return new Builder(this);
        }

        public int hashCode() {
            return Objects.hash(this.expression, this.title, this.description, this.location);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Expr other = (Expr)obj;
            return Objects.equals(this.expression, other.expression) && Objects.equals(this.title, other.title) && Objects.equals(this.description, other.description) && Objects.equals(this.location, other.location);
        }

        public String toString() {
            return this.toPb().toString();
        }

        static final class Builder {
            private String expression;
            private String title;
            private String description;
            private String location;

            Builder() {
            }

            Builder(Expr expr) {
                this.expression = expr.expression;
                this.title = expr.title;
                this.description = expr.description;
                this.location = expr.location;
            }

            Builder(com.google.api.services.bigquery.model.Expr bqExpr) {
                this.expression = bqExpr.getExpression();
                if (bqExpr.getTitle() != null) {
                    this.title = bqExpr.getTitle();
                }
                if (bqExpr.getDescription() != null) {
                    this.description = bqExpr.getDescription();
                }
                if (bqExpr.getLocation() != null) {
                    this.location = bqExpr.getLocation();
                }
            }

            public Builder setExpression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder setTitle(String title) {
                this.title = title;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder setLocation(String location) {
                this.location = location;
                return this;
            }

            public Expr build() {
                return new Expr(this);
            }
        }
    }

    public static final class IamMember
    extends Entity {
        private static final long serialVersionUID = 3562909264454016939L;
        private final String iamMember;

        public IamMember(String iamMember) {
            super(Entity.Type.IAM_MEMBER);
            this.iamMember = iamMember;
        }

        public String getIamMember() {
            return this.iamMember;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IamMember iam = (IamMember)obj;
            return Objects.equals((Object)this.getType(), (Object)iam.getType()) && Objects.equals(this.iamMember, iam.iamMember);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.iamMember});
        }

        public String toString() {
            return this.toPb().toString();
        }

        @Override
        Dataset.Access toPb() {
            return new Dataset.Access().setIamMember(this.iamMember);
        }
    }

    public static final class Routine
    extends Entity {
        private static final long serialVersionUID = -8392885851733136262L;
        private final RoutineId id;

        public Routine(RoutineId id) {
            super(Entity.Type.ROUTINE);
            this.id = id;
        }

        public RoutineId getId() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Routine routine = (Routine)obj;
            return Objects.equals((Object)this.getType(), (Object)routine.getType()) && Objects.equals(this.id, routine.id);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.id});
        }

        public String toString() {
            return this.toPb().toString();
        }

        @Override
        Dataset.Access toPb() {
            return new Dataset.Access().setRoutine(this.id.toPb());
        }
    }

    public static final class View
    extends Entity {
        private static final long serialVersionUID = -6851072781269419383L;
        private final TableId id;

        public View(TableId id) {
            super(Entity.Type.VIEW);
            this.id = id;
        }

        public TableId getId() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            View view = (View)obj;
            return Objects.equals((Object)this.getType(), (Object)view.getType()) && Objects.equals(this.id, view.id);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.id});
        }

        public String toString() {
            return this.toPb().toString();
        }

        @Override
        Dataset.Access toPb() {
            return new Dataset.Access().setView(this.id.toPb());
        }
    }

    public static final class User
    extends Entity {
        private static final long serialVersionUID = -4942821351073996141L;
        private final String email;

        public User(String email) {
            super(Entity.Type.USER);
            this.email = email;
        }

        public String getEmail() {
            return this.email;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            User user = (User)obj;
            return Objects.equals((Object)this.getType(), (Object)user.getType()) && Objects.equals(this.email, user.email);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.email});
        }

        public String toString() {
            return this.toPb().toString();
        }

        @Override
        Dataset.Access toPb() {
            return new Dataset.Access().setUserByEmail(this.email);
        }
    }

    public static final class Group
    extends Entity {
        private static final String PROJECT_OWNERS = "projectOwners";
        private static final String PROJECT_READERS = "projectReaders";
        private static final String PROJECT_WRITERS = "projectWriters";
        private static final String ALL_AUTHENTICATED_USERS = "allAuthenticatedUsers";
        private static final long serialVersionUID = 5146829352398103029L;
        private final String identifier;

        public Group(String identifier) {
            super(Entity.Type.GROUP);
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Group group = (Group)obj;
            return Objects.equals((Object)this.getType(), (Object)group.getType()) && Objects.equals(this.identifier, group.identifier);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.identifier});
        }

        public String toString() {
            return this.toPb().toString();
        }

        @Override
        Dataset.Access toPb() {
            switch (this.identifier) {
                case "projectOwners": {
                    return new Dataset.Access().setSpecialGroup(PROJECT_OWNERS);
                }
                case "projectReaders": {
                    return new Dataset.Access().setSpecialGroup(PROJECT_READERS);
                }
                case "projectWriters": {
                    return new Dataset.Access().setSpecialGroup(PROJECT_WRITERS);
                }
                case "allAuthenticatedUsers": {
                    return new Dataset.Access().setSpecialGroup(ALL_AUTHENTICATED_USERS);
                }
            }
            return new Dataset.Access().setGroupByEmail(this.identifier);
        }

        public static Group ofProjectOwners() {
            return new Group(PROJECT_OWNERS);
        }

        public static Group ofProjectReaders() {
            return new Group(PROJECT_READERS);
        }

        public static Group ofProjectWriters() {
            return new Group(PROJECT_WRITERS);
        }

        public static Group ofAllAuthenticatedUsers() {
            return new Group(ALL_AUTHENTICATED_USERS);
        }
    }

    public static final class Domain
    extends Entity {
        private static final long serialVersionUID = -3033025857280447253L;
        private final String domain;

        public Domain(String domain) {
            super(Entity.Type.DOMAIN);
            this.domain = domain;
        }

        public String getDomain() {
            return this.domain;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Domain domainEntity = (Domain)obj;
            return Objects.equals((Object)this.getType(), (Object)domainEntity.getType()) && Objects.equals(this.domain, domainEntity.getDomain());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.domain});
        }

        public String toString() {
            return this.toPb().toString();
        }

        @Override
        Dataset.Access toPb() {
            return new Dataset.Access().setDomain(this.domain);
        }
    }

    public static final class DatasetAclEntity
    extends Entity {
        private static final long serialVersionUID = -8392885851733136526L;
        private final DatasetId id;
        private final List<String> targetTypes;

        public DatasetAclEntity(DatasetId id, List<String> targetTypes) {
            super(Entity.Type.DATASET);
            this.id = id;
            this.targetTypes = targetTypes;
        }

        public DatasetId getId() {
            return this.id;
        }

        public List<String> getTargetTypes() {
            return this.targetTypes;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DatasetAclEntity datasetAclEntity = (DatasetAclEntity)obj;
            return Objects.equals((Object)this.getType(), (Object)datasetAclEntity.getType()) && Objects.equals(this.id, datasetAclEntity.id) && Objects.equals(this.targetTypes, datasetAclEntity.targetTypes);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getType(), this.id});
        }

        public String toString() {
            return this.toPb().toString();
        }

        @Override
        Dataset.Access toPb() {
            return new Dataset.Access().setDataset(new DatasetAccessEntry().setDataset(this.id.toPb()).setTargetTypes(this.targetTypes));
        }
    }
}

