/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonToken;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StringUtils;
import com.google.api.client.util.Strings;
import java.io.IOException;

public class GoogleJsonResponseException
extends HttpResponseException {
    private static final long serialVersionUID = 409811126989994864L;
    private final transient GoogleJsonError details;

    public GoogleJsonResponseException(HttpResponseException.Builder builder, GoogleJsonError details) {
        super(builder);
        this.details = details;
    }

    public final GoogleJsonError getDetails() {
        return this.details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleJsonResponseException from(JsonFactory jsonFactory, HttpResponse response) {
        String detailString;
        GoogleJsonError details;
        HttpResponseException.Builder builder;
        block17: {
            builder = new HttpResponseException.Builder(response.getStatusCode(), response.getStatusMessage(), response.getHeaders());
            Preconditions.checkNotNull(jsonFactory);
            details = null;
            detailString = null;
            try {
                if (!response.isSuccessStatusCode() && HttpMediaType.equalsIgnoreParameters("application/json; charset=UTF-8", response.getContentType()) && response.getContent() != null) {
                    JsonParser parser = null;
                    try {
                        parser = jsonFactory.createJsonParser(response.getContent());
                        JsonToken currentToken = parser.getCurrentToken();
                        if (currentToken == null) {
                            currentToken = parser.nextToken();
                        }
                        if (currentToken != null) {
                            parser.skipToKey("error");
                            if (parser.getCurrentToken() == JsonToken.VALUE_STRING) {
                                detailString = parser.getText();
                            } else if (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                                details = parser.parseAndClose(GoogleJsonError.class);
                                detailString = details.toPrettyString();
                            }
                        }
                        break block17;
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                        break block17;
                    }
                    finally {
                        if (parser == null) {
                            response.ignore();
                        } else if (details == null) {
                            parser.close();
                        }
                    }
                }
                detailString = response.parseAsString();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        StringBuilder message = HttpResponseException.computeMessageBuffer(response);
        if (!Strings.isNullOrEmpty(detailString)) {
            message.append(StringUtils.LINE_SEPARATOR).append(detailString);
            builder.setContent(detailString);
        }
        builder.setMessage(message.toString());
        return new GoogleJsonResponseException(builder, details);
    }

    public static HttpResponse execute(JsonFactory jsonFactory, HttpRequest request) throws GoogleJsonResponseException, IOException {
        Preconditions.checkNotNull(jsonFactory);
        boolean originalThrowExceptionOnExecuteError = request.getThrowExceptionOnExecuteError();
        if (originalThrowExceptionOnExecuteError) {
            request.setThrowExceptionOnExecuteError(false);
        }
        HttpResponse response = request.execute();
        request.setThrowExceptionOnExecuteError(originalThrowExceptionOnExecuteError);
        if (!originalThrowExceptionOnExecuteError || response.isSuccessStatusCode()) {
            return response;
        }
        throw GoogleJsonResponseException.from(jsonFactory, response);
    }
}

