/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.settings;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class StatisticsSettings
implements Serializable {
    @SerializedName(value="start_time")
    public String startTime;
    @SerializedName(value="end_time")
    public String endTime;
    @SerializedName(value="sessions_total")
    public Integer sessionsTotal = 0;
    @SerializedName(value="jobs_started")
    public Integer jobsStarted = 0;
    @SerializedName(value="jobs_completed")
    public Integer jobsCompleted = 0;

    public StatisticsSettings() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
        this.startTime = formatter.format(Instant.now());
    }

    private void setEndTime() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
        this.endTime = formatter.format(Instant.now());
    }

    public void incrementSessionsTotal() {
        Integer n = this.sessionsTotal;
        this.sessionsTotal = this.sessionsTotal + 1;
        this.setEndTime();
    }

    public void incrementJobsStarted() {
        Integer n = this.jobsStarted;
        this.jobsStarted = this.jobsStarted + 1;
        this.setEndTime();
    }

    public void incrementJobsCompleted() {
        Integer n = this.jobsCompleted;
        this.jobsCompleted = this.jobsCompleted + 1;
        this.setEndTime();
    }
}

