/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.settings;

import app.freerouting.autoroute.AutorouteControl;
import app.freerouting.board.RoutingBoard;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.ReflectionUtil;
import app.freerouting.settings.RouterFanoutSettings;
import app.freerouting.settings.RouterOptimizerSettings;
import app.freerouting.settings.RouterScoringSettings;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.Random;

public class RouterSettings
implements Serializable {
    @SerializedName(value="enabled")
    public transient boolean enabled = true;
    @SerializedName(value="algorithm")
    public String algorithm = "freerouting-router";
    @SerializedName(value="job_timeout")
    public String jobTimeoutString = "12:00:00";
    @SerializedName(value="max_passes")
    public int maxPasses = 9999;
    public transient boolean[] isLayerActive;
    public transient boolean[] isPreferredDirectionHorizontalOnLayer;
    public transient boolean save_intermediate_stages;
    @SerializedName(value="ignore_net_classes")
    public transient String[] ignoreNetClasses = new String[0];
    @SerializedName(value="trace_pull_tight_accuracy")
    public int trace_pull_tight_accuracy = 500;
    @SerializedName(value="allowed_via_types")
    public boolean vias_allowed = true;
    @SerializedName(value="automatic_neckdown")
    public boolean automatic_neckdown = true;
    @SerializedName(value="fanout")
    public RouterFanoutSettings fanout = new RouterFanoutSettings();
    @SerializedName(value="optimizer")
    public RouterOptimizerSettings optimizer = new RouterOptimizerSettings();
    @SerializedName(value="scoring")
    public RouterScoringSettings scoring = new RouterScoringSettings();
    @SerializedName(value="max_threads")
    public int maxThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
    @SerializedName(value="random_seed")
    public transient Long random_seed = new Random().nextLong();
    private transient int start_pass_no = 1;
    private transient int stop_pass_no = 999;

    public RouterSettings() {
        this(0);
    }

    public RouterSettings(int p_layer_count) {
        this.setLayerCount(p_layer_count);
    }

    public RouterSettings(RoutingBoard p_board) {
        this(p_board.get_layer_count());
        double horizontal_width = p_board.bounding_box.width();
        double vertical_width = p_board.bounding_box.height();
        int layer_count = p_board.get_layer_count();
        double horizontal_add_costs_against_preferred_dir = 0.1 * (double)Math.round(10.0 * horizontal_width / vertical_width);
        double vertical_add_costs_against_preferred_dir = 0.1 * (double)Math.round(10.0 * vertical_width / horizontal_width);
        boolean curr_preferred_direction_is_horizontal = horizontal_width < vertical_width;
        for (int i = 0; i < layer_count; ++i) {
            this.isLayerActive[i] = p_board.layer_structure.arr[i].is_signal;
            if (p_board.layer_structure.arr[i].is_signal) {
                curr_preferred_direction_is_horizontal = !curr_preferred_direction_is_horizontal;
            }
            this.isPreferredDirectionHorizontalOnLayer[i] = curr_preferred_direction_is_horizontal;
            this.scoring.preferredDirectionTraceCost[i] = this.scoring.defaultPreferredDirectionTraceCost;
            this.scoring.undesiredDirectionTraceCost[i] = this.scoring.defaultUndesiredDirectionTraceCost;
            if (curr_preferred_direction_is_horizontal) {
                int n = i;
                this.scoring.undesiredDirectionTraceCost[n] = this.scoring.undesiredDirectionTraceCost[n] + horizontal_add_costs_against_preferred_dir;
                continue;
            }
            int n = i;
            this.scoring.undesiredDirectionTraceCost[n] = this.scoring.undesiredDirectionTraceCost[n] + vertical_add_costs_against_preferred_dir;
        }
        int signal_layer_count = p_board.layer_structure.signal_layer_count();
        if (signal_layer_count > 2) {
            double outer_add_costs = 0.2 * (double)signal_layer_count;
            this.scoring.preferredDirectionTraceCost[0] = this.scoring.preferredDirectionTraceCost[0] + outer_add_costs;
            int n = layer_count - 1;
            this.scoring.preferredDirectionTraceCost[n] = this.scoring.preferredDirectionTraceCost[n] + outer_add_costs;
            this.scoring.undesiredDirectionTraceCost[0] = this.scoring.undesiredDirectionTraceCost[0] + outer_add_costs;
            int n2 = layer_count - 1;
            this.scoring.undesiredDirectionTraceCost[n2] = this.scoring.undesiredDirectionTraceCost[n2] + outer_add_costs;
        }
    }

    public void setLayerCount(int layerCount) {
        this.isLayerActive = new boolean[layerCount];
        this.isPreferredDirectionHorizontalOnLayer = new boolean[layerCount];
        this.scoring.preferredDirectionTraceCost = new double[layerCount];
        this.scoring.undesiredDirectionTraceCost = new double[layerCount];
        for (int i = 0; i < layerCount; ++i) {
            this.isLayerActive[i] = true;
            this.isPreferredDirectionHorizontalOnLayer[i] = i % 2 == 1;
            this.scoring.preferredDirectionTraceCost[i] = this.scoring.defaultPreferredDirectionTraceCost;
            this.scoring.undesiredDirectionTraceCost[i] = this.scoring.defaultUndesiredDirectionTraceCost;
        }
    }

    public RouterSettings clone() {
        RouterSettings result = new RouterSettings(this.isLayerActive.length);
        result.algorithm = this.algorithm;
        result.jobTimeoutString = this.jobTimeoutString;
        result.isLayerActive = (boolean[])this.isLayerActive.clone();
        result.isPreferredDirectionHorizontalOnLayer = (boolean[])this.isPreferredDirectionHorizontalOnLayer.clone();
        result.scoring.preferredDirectionTraceCost = (double[])this.scoring.preferredDirectionTraceCost.clone();
        result.scoring.undesiredDirectionTraceCost = (double[])this.scoring.undesiredDirectionTraceCost.clone();
        result.scoring.defaultPreferredDirectionTraceCost = this.scoring.defaultPreferredDirectionTraceCost;
        result.scoring.defaultUndesiredDirectionTraceCost = this.scoring.defaultUndesiredDirectionTraceCost;
        result.maxPasses = this.maxPasses;
        result.optimizer.maxThreads = this.optimizer.maxThreads;
        result.optimizer.optimizationImprovementThreshold = this.optimizer.optimizationImprovementThreshold;
        result.optimizer.boardUpdateStrategy = this.optimizer.boardUpdateStrategy;
        result.optimizer.hybridRatio = this.optimizer.hybridRatio;
        result.optimizer.itemSelectionStrategy = this.optimizer.itemSelectionStrategy;
        result.ignoreNetClasses = (String[])this.ignoreNetClasses.clone();
        result.trace_pull_tight_accuracy = this.trace_pull_tight_accuracy;
        System.arraycopy(this.isLayerActive, 0, result.isLayerActive, 0, this.isLayerActive.length);
        System.arraycopy(this.isPreferredDirectionHorizontalOnLayer, 0, result.isPreferredDirectionHorizontalOnLayer, 0, this.isPreferredDirectionHorizontalOnLayer.length);
        System.arraycopy(this.scoring.preferredDirectionTraceCost, 0, result.scoring.preferredDirectionTraceCost, 0, this.scoring.preferredDirectionTraceCost.length);
        System.arraycopy(this.scoring.undesiredDirectionTraceCost, 0, result.scoring.undesiredDirectionTraceCost, 0, this.scoring.undesiredDirectionTraceCost.length);
        result.fanout.enabled = this.fanout.enabled;
        result.enabled = this.enabled;
        result.optimizer.enabled = this.optimizer.enabled;
        result.vias_allowed = this.vias_allowed;
        result.automatic_neckdown = this.automatic_neckdown;
        result.scoring.via_costs = this.scoring.via_costs;
        result.scoring.plane_via_costs = this.scoring.plane_via_costs;
        result.scoring.start_ripup_costs = this.scoring.start_ripup_costs;
        result.random_seed = this.random_seed;
        result.start_pass_no = this.start_pass_no;
        result.stop_pass_no = this.stop_pass_no;
        return result;
    }

    public int get_start_ripup_costs() {
        return this.scoring.start_ripup_costs;
    }

    public void set_start_ripup_costs(int p_value) {
        this.scoring.start_ripup_costs = Math.max(p_value, 1);
    }

    public int get_start_pass_no() {
        return this.start_pass_no;
    }

    public void set_start_pass_no(int p_value) {
        this.start_pass_no = Math.max(p_value, 1);
        this.start_pass_no = Math.min(this.start_pass_no, 99999);
    }

    public int get_stop_pass_no() {
        return this.stop_pass_no;
    }

    public void set_stop_pass_no(int p_value) {
        this.stop_pass_no = Math.max(p_value, this.start_pass_no);
        this.stop_pass_no = Math.min(this.stop_pass_no, 99999);
    }

    public void increment_pass_no() {
        ++this.start_pass_no;
    }

    public boolean getRunFanout() {
        return this.fanout.enabled;
    }

    public void setRunFanout(boolean p_value) {
        this.fanout.enabled = p_value;
    }

    public boolean getRunRouter() {
        return this.enabled;
    }

    public void setRunRouter(boolean p_value) {
        this.enabled = p_value;
    }

    public boolean getRunOptimizer() {
        return this.optimizer.enabled;
    }

    public void setRunOptimizer(boolean p_value) {
        this.optimizer.enabled = p_value;
    }

    public boolean get_vias_allowed() {
        return this.vias_allowed;
    }

    public void set_vias_allowed(boolean p_value) {
        this.vias_allowed = p_value;
    }

    public int get_via_costs() {
        return this.scoring.via_costs;
    }

    public void set_via_costs(int p_value) {
        this.scoring.via_costs = Math.max(p_value, 1);
    }

    public int get_plane_via_costs() {
        return this.scoring.plane_via_costs;
    }

    public void set_plane_via_costs(int p_value) {
        this.scoring.plane_via_costs = Math.max(p_value, 1);
    }

    public void set_layer_active(int p_layer, boolean p_value) {
        if (p_layer < 0 || p_layer >= this.isLayerActive.length) {
            FRLogger.warn("AutorouteSettings.set_layer_active: p_layer out of range");
            return;
        }
        this.isLayerActive[p_layer] = p_value;
    }

    public boolean get_layer_active(int p_layer) {
        if (p_layer < 0 || p_layer >= this.isLayerActive.length) {
            FRLogger.warn("AutorouteSettings.get_layer_active: p_layer out of range");
            return false;
        }
        return this.isLayerActive[p_layer];
    }

    public void set_preferred_direction_is_horizontal(int p_layer, boolean p_value) {
        if (p_layer < 0 || p_layer >= this.isLayerActive.length) {
            FRLogger.warn("AutorouteSettings.set_preferred_direction_is_horizontal: p_layer out of range");
            return;
        }
        this.isPreferredDirectionHorizontalOnLayer[p_layer] = p_value;
    }

    public boolean get_preferred_direction_is_horizontal(int p_layer) {
        if (p_layer < 0 || p_layer >= this.isLayerActive.length) {
            FRLogger.warn("AutorouteSettings.get_preferred_direction_is_horizontal: p_layer out of range");
            return false;
        }
        return this.isPreferredDirectionHorizontalOnLayer[p_layer];
    }

    public void set_preferred_direction_trace_costs(int p_layer, double p_value) {
        if (p_layer < 0 || p_layer >= this.isLayerActive.length) {
            FRLogger.warn("AutorouteSettings.set_preferred_direction_trace_costs: p_layer out of range");
            return;
        }
        this.scoring.preferredDirectionTraceCost[p_layer] = Math.max(p_value, 0.1);
    }

    public double get_preferred_direction_trace_costs(int p_layer) {
        if (p_layer < 0 || p_layer >= this.isLayerActive.length) {
            FRLogger.warn("AutorouteSettings.get_preferred_direction_trace_costs: p_layer out of range");
            return 0.0;
        }
        return this.scoring.preferredDirectionTraceCost[p_layer];
    }

    public double get_against_preferred_direction_trace_costs(int p_layer) {
        if (p_layer < 0 || p_layer >= this.isLayerActive.length) {
            FRLogger.warn("AutorouteSettings.get_against_preferred_direction_trace_costs: p_layer out of range");
            return 0.0;
        }
        return this.scoring.undesiredDirectionTraceCost[p_layer];
    }

    public double get_horizontal_trace_costs(int p_layer) {
        if (p_layer < 0 || p_layer >= this.isLayerActive.length) {
            FRLogger.warn("AutorouteSettings.get_preferred_direction_trace_costs: p_layer out of range");
            return 0.0;
        }
        double result = this.isPreferredDirectionHorizontalOnLayer[p_layer] ? this.scoring.preferredDirectionTraceCost[p_layer] : this.scoring.undesiredDirectionTraceCost[p_layer];
        return result;
    }

    public void set_against_preferred_direction_trace_costs(int p_layer, double p_value) {
        if (p_layer < 0 || p_layer >= this.isLayerActive.length) {
            FRLogger.warn("AutorouteSettings.set_against_preferred_direction_trace_costs: p_layer out of range");
            return;
        }
        this.scoring.undesiredDirectionTraceCost[p_layer] = Math.max(p_value, 0.1);
    }

    public double get_vertical_trace_costs(int p_layer) {
        if (p_layer < 0 || p_layer >= this.isLayerActive.length) {
            FRLogger.warn("AutorouteSettings.get_against_preferred_direction_trace_costs: p_layer out of range");
            return 0.0;
        }
        double result = this.isPreferredDirectionHorizontalOnLayer[p_layer] ? this.scoring.undesiredDirectionTraceCost[p_layer] : this.scoring.preferredDirectionTraceCost[p_layer];
        return result;
    }

    public AutorouteControl.ExpansionCostFactor[] get_trace_cost_arr() {
        AutorouteControl.ExpansionCostFactor[] result = new AutorouteControl.ExpansionCostFactor[this.scoring.preferredDirectionTraceCost.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new AutorouteControl.ExpansionCostFactor(this.get_horizontal_trace_costs(i), this.get_vertical_trace_costs(i));
        }
        return result;
    }

    public boolean get_automatic_neckdown() {
        return this.automatic_neckdown;
    }

    public void set_automatic_neckdown(boolean p_value) {
        this.automatic_neckdown = p_value;
    }

    public int applyNewValuesFrom(RouterSettings settings) {
        return ReflectionUtil.copyFields(settings, this);
    }
}

