/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.settings;

import app.freerouting.autoroute.BoardUpdateStrategy;
import app.freerouting.autoroute.ItemSelectionStrategy;
import app.freerouting.core.BoardFileDetails;
import app.freerouting.gui.FileFormat;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.ReflectionUtil;
import app.freerouting.management.TextManager;
import app.freerouting.management.gson.GsonProvider;
import app.freerouting.settings.ApiServerSettings;
import app.freerouting.settings.DesignRulesCheckerSettings;
import app.freerouting.settings.EnvironmentSettings;
import app.freerouting.settings.FeatureFlagsSettings;
import app.freerouting.settings.GuiSettings;
import app.freerouting.settings.RouterSettings;
import app.freerouting.settings.StatisticsSettings;
import app.freerouting.settings.UsageAndDiagnosticDataSettings;
import app.freerouting.settings.UserProfileSettings;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class GlobalSettings
implements Serializable {
    private static Path userDataPath = Path.of(System.getProperty("java.io.tmpdir"), "freerouting");
    private static Path configurationFilePath = userDataPath.resolve("freerouting.json");
    private static Boolean isUserDataPathLocked = false;
    public final transient EnvironmentSettings environmentSettings = new EnvironmentSettings();
    @SerializedName(value="profile")
    public final UserProfileSettings userProfileSettings = new UserProfileSettings();
    @SerializedName(value="gui")
    public final GuiSettings guiSettings = new GuiSettings();
    @SerializedName(value="router")
    public final RouterSettings routerSettings = new RouterSettings();
    @SerializedName(value="drc")
    public final DesignRulesCheckerSettings drcSettings = new DesignRulesCheckerSettings();
    @SerializedName(value="usage_and_diagnostic_data")
    public final UsageAndDiagnosticDataSettings usageAndDiagnosticData = new UsageAndDiagnosticDataSettings();
    @SerializedName(value="feature_flags")
    public final FeatureFlagsSettings featureFlags = new FeatureFlagsSettings();
    @SerializedName(value="api_server")
    public final ApiServerSettings apiServerSettings = new ApiServerSettings();
    @SerializedName(value="statistics")
    public final StatisticsSettings statistics = new StatisticsSettings();
    private final transient String[] supportedLanguages = new String[]{"en", "de", "zh", "zh_TW", "hi", "es", "it", "fr", "ar", "bn", "ru", "pt", "ja", "ko"};
    @SerializedName(value="version")
    public String version = "2.1.2-SNAPSHOT";
    public transient boolean show_help_option;
    public transient BoardFileDetails drc_report_file;
    @Deprecated
    public transient String design_input_filename;
    @Deprecated
    public transient String design_output_filename;
    @Deprecated
    public transient String design_rules_filename;
    public transient Locale currentLocale = Locale.getDefault();

    public GlobalSettings() {
        if (Arrays.stream(this.supportedLanguages).noneMatch(this.currentLocale.getLanguage()::equals)) {
            this.currentLocale = Locale.ENGLISH;
        }
    }

    public static void lockUserDataPath() {
        isUserDataPathLocked = true;
    }

    public static Path getUserDataPath() {
        return userDataPath;
    }

    public static void setUserDataPath(Path userDataPath) {
        if (!isUserDataPathLocked.booleanValue()) {
            GlobalSettings.userDataPath = userDataPath;
            configurationFilePath = userDataPath.resolve("freerouting.json");
            FRLogger.changeFileLogLocation(userDataPath);
        }
    }

    public static GlobalSettings load() throws IOException {
        GlobalSettings loadedSettings = null;
        try (BufferedReader reader = Files.newBufferedReader(configurationFilePath, StandardCharsets.UTF_8);){
            loadedSettings = GsonProvider.GSON.fromJson((Reader)reader, GlobalSettings.class);
        }
        GlobalSettings defaultSettings = new GlobalSettings();
        if (loadedSettings != null) {
            boolean isSaveNeeded = !loadedSettings.version.equals(defaultSettings.version);
            loadedSettings.version = null;
            ReflectionUtil.copyFields(defaultSettings, loadedSettings);
            if (isSaveNeeded) {
                GlobalSettings.saveAsJson(loadedSettings);
            }
        }
        return loadedSettings;
    }

    public static void saveAsJson(GlobalSettings globalSettings) throws IOException {
        Files.createDirectories(configurationFilePath.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(configurationFilePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            GsonProvider.GSON.toJson((Object)globalSettings, (Appendable)writer);
        }
    }

    public static Boolean setDefaultValue(String propertyName, String newValue) {
        try {
            GlobalSettings gs = GlobalSettings.load();
            gs.setValue(propertyName, newValue);
            GlobalSettings.saveAsJson(gs);
            return true;
        }
        catch (Exception e) {
            FRLogger.error("Failed to save property value for: " + propertyName, e);
            return false;
        }
    }

    public void applyEnvironmentVariables() {
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            if (!entry.getKey().startsWith("FREEROUTING__")) continue;
            String propertyName = entry.getKey().substring("FREEROUTING__".length()).toLowerCase().replace("__", ".");
            this.setValue(propertyName, entry.getValue());
        }
    }

    public Boolean setValue(String propertyName, String newValue) {
        try {
            ReflectionUtil.setFieldValue(this, propertyName, newValue);
            return true;
        }
        catch (Exception e) {
            FRLogger.error("Failed to set property value for: " + propertyName, e);
            return false;
        }
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public void applyCommandLineArguments(String[] p_args) {
        for (int i = 0; i < p_args.length; ++i) {
            try {
                String op;
                if (p_args[i].startsWith("--")) {
                    String[] parts = p_args[i].substring(2).split("=");
                    if (parts.length != 2 || Objects.equals(parts[0], "user_data_path")) continue;
                    this.setValue(parts[0], parts[1]);
                    continue;
                }
                if (p_args[i].startsWith("-de")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.design_input_filename = p_args[i + 1];
                    continue;
                }
                if (p_args[i].startsWith("-di")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.guiSettings.inputDirectory = p_args[i + 1];
                    continue;
                }
                if (p_args[i].startsWith("-do")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.design_output_filename = p_args[i + 1];
                    continue;
                }
                if (p_args[i].startsWith("-drc")) {
                    this.routerSettings.enabled = false;
                    this.drcSettings.enabled = true;
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.drc_report_file = new BoardFileDetails();
                    this.drc_report_file.format = FileFormat.DRC_JSON;
                    this.drc_report_file.setFilename(p_args[i + 1]);
                    continue;
                }
                if (p_args[i].startsWith("-dr")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.design_rules_filename = p_args[i + 1];
                    continue;
                }
                if (p_args[i].startsWith("-mp")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.routerSettings.maxPasses = Integer.decode(p_args[i + 1]);
                    if (this.routerSettings.maxPasses < 1) {
                        this.routerSettings.maxPasses = 1;
                    }
                    if (this.routerSettings.maxPasses <= 99998) continue;
                    this.routerSettings.maxPasses = 99998;
                    continue;
                }
                if (p_args[i].startsWith("-mt")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.routerSettings.optimizer.maxThreads = Integer.decode(p_args[i + 1]);
                    if (this.routerSettings.optimizer.maxThreads <= 0) {
                        this.routerSettings.optimizer.maxThreads = 0;
                    }
                    if (this.routerSettings.optimizer.maxThreads <= 1024) continue;
                    this.routerSettings.optimizer.maxThreads = 1024;
                    continue;
                }
                if (p_args[i].startsWith("-oit")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.routerSettings.optimizer.optimizationImprovementThreshold = Float.parseFloat(p_args[i + 1]) / 100.0f;
                    if (!(this.routerSettings.optimizer.optimizationImprovementThreshold <= 0.0f)) continue;
                    this.routerSettings.optimizer.optimizationImprovementThreshold = 0.0f;
                    continue;
                }
                if (p_args[i].startsWith("-us")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    op = p_args[i + 1].toLowerCase().trim();
                    this.routerSettings.optimizer.boardUpdateStrategy = "global".equals(op) ? BoardUpdateStrategy.GLOBAL_OPTIMAL : ("hybrid".equals(op) ? BoardUpdateStrategy.HYBRID : BoardUpdateStrategy.GREEDY);
                    continue;
                }
                if (p_args[i].startsWith("-is")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    op = p_args[i + 1].toLowerCase().trim();
                    this.routerSettings.optimizer.itemSelectionStrategy = op.indexOf("seq") == 0 ? ItemSelectionStrategy.SEQUENTIAL : (op.indexOf("rand") == 0 ? ItemSelectionStrategy.RANDOM : ItemSelectionStrategy.PRIORITIZED);
                    continue;
                }
                if (p_args[i].startsWith("-hr")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.routerSettings.optimizer.hybridRatio = p_args[i + 1].trim();
                    continue;
                }
                if ("-l".equals(p_args[i])) {
                    String localeString = "";
                    if (p_args.length > i + 1) {
                        localeString = p_args[i + 1].toLowerCase().replace("-", "_");
                    }
                    if (localeString.startsWith("en")) {
                        this.currentLocale = Locale.ENGLISH;
                        continue;
                    }
                    if (localeString.startsWith("de")) {
                        this.currentLocale = Locale.GERMAN;
                        continue;
                    }
                    if (localeString.startsWith("zh_tw")) {
                        this.currentLocale = Locale.TRADITIONAL_CHINESE;
                        continue;
                    }
                    if (localeString.startsWith("zh")) {
                        this.currentLocale = Locale.SIMPLIFIED_CHINESE;
                        continue;
                    }
                    if (localeString.startsWith("hi")) {
                        this.currentLocale = Locale.forLanguageTag("hi-IN");
                        continue;
                    }
                    if (localeString.startsWith("es")) {
                        this.currentLocale = Locale.forLanguageTag("es-ES");
                        continue;
                    }
                    if (localeString.startsWith("it")) {
                        this.currentLocale = Locale.forLanguageTag("it-IT");
                        continue;
                    }
                    if (localeString.startsWith("fr")) {
                        this.currentLocale = Locale.FRENCH;
                        continue;
                    }
                    if (localeString.startsWith("ar")) {
                        this.currentLocale = Locale.forLanguageTag("ar-EG");
                        continue;
                    }
                    if (localeString.startsWith("bn")) {
                        this.currentLocale = Locale.forLanguageTag("bn-BD");
                        continue;
                    }
                    if (localeString.startsWith("ru")) {
                        this.currentLocale = Locale.forLanguageTag("ru-RU");
                        continue;
                    }
                    if (localeString.startsWith("pt")) {
                        this.currentLocale = Locale.forLanguageTag("pt-PT");
                        continue;
                    }
                    if (localeString.startsWith("ja")) {
                        this.currentLocale = Locale.JAPANESE;
                        continue;
                    }
                    if (!localeString.startsWith("ko")) continue;
                    this.currentLocale = Locale.KOREAN;
                    continue;
                }
                if (p_args[i].startsWith("-im")) {
                    this.featureFlags.snapshots = true;
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.featureFlags.snapshots = !Objects.equals(p_args[i + 1], "0");
                    continue;
                }
                if (p_args[i].startsWith("-dl")) {
                    this.featureFlags.logging = false;
                    continue;
                }
                if (p_args[i].startsWith("-da")) {
                    this.usageAndDiagnosticData.disableAnalytics = true;
                    continue;
                }
                if (p_args[i].startsWith("-host")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.environmentSettings.host = p_args[i + 1].trim();
                    continue;
                }
                if (p_args[i].startsWith("-help")) {
                    this.show_help_option = true;
                    continue;
                }
                if (p_args[i].startsWith("-inc")) {
                    this.routerSettings.ignoreNetClasses = p_args[i + 1].split(",");
                    continue;
                }
                if (p_args[i].startsWith("-dct")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.guiSettings.dialogConfirmationTimeout = Integer.parseInt(p_args[i + 1]);
                    if (this.guiSettings.dialogConfirmationTimeout > 0) continue;
                    this.guiSettings.dialogConfirmationTimeout = 0;
                    continue;
                }
                if (!p_args[i].startsWith("-random_seed") || p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                this.routerSettings.random_seed = TextManager.hexadecimalStringToLong(p_args[i + 1]);
                ++i;
                continue;
            }
            catch (Exception e) {
                FRLogger.error("There was a problem parsing the '" + p_args[i] + "' parameter", e);
            }
        }
    }

    public String getDesignDir() {
        return this.guiSettings.inputDirectory;
    }

    public int getMaxPasses() {
        return this.routerSettings.maxPasses;
    }

    public int getNumThreads() {
        return this.routerSettings.optimizer.maxThreads;
    }

    public String getHybridRatio() {
        return this.routerSettings.optimizer.hybridRatio;
    }

    public BoardUpdateStrategy getBoardUpdateStrategy() {
        return this.routerSettings.optimizer.boardUpdateStrategy;
    }

    public ItemSelectionStrategy getItemSelectionStrategy() {
        return this.routerSettings.optimizer.itemSelectionStrategy;
    }
}

