/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.rules;

import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.management.TextManager;
import app.freerouting.rules.ViaInfo;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class ViaInfos
implements Serializable,
ObjectInfoPanel.Printable {
    private final List<ViaInfo> list = new LinkedList<ViaInfo>();

    public boolean add(ViaInfo p_via_info) {
        if (this.name_exists(p_via_info.get_name())) {
            return false;
        }
        this.list.add(p_via_info);
        return true;
    }

    public int count() {
        return this.list.size();
    }

    public ViaInfo get(int p_no) {
        assert (p_no >= 0 && p_no < this.list.size());
        return this.list.get(p_no);
    }

    public ViaInfo get(String p_name) {
        for (ViaInfo curr_via : this.list) {
            if (!curr_via.get_name().equals(p_name)) continue;
            return curr_via;
        }
        return null;
    }

    public boolean name_exists(String p_name) {
        for (ViaInfo curr_via : this.list) {
            if (!curr_via.get_name().equals(p_name)) continue;
            return true;
        }
        return false;
    }

    public boolean remove(ViaInfo p_via_info) {
        return this.list.remove(p_via_info);
    }

    @Override
    public void print_info(ObjectInfoPanel p_window, Locale p_locale) {
        TextManager tm = new TextManager(this.getClass(), p_locale);
        p_window.append_bold(tm.getText("vias", new String[0]) + ": ");
        int counter = 0;
        boolean first_time = true;
        int max_vias_per_row = 5;
        for (ViaInfo curr_via : this.list) {
            if (first_time) {
                first_time = false;
            } else {
                p_window.append(", ");
            }
            if (counter == 0) {
                p_window.newline();
                p_window.indent();
            }
            p_window.append(curr_via.get_name(), tm.getText("via_info", new String[0]), curr_via);
            counter = (counter + 1) % 5;
        }
    }
}

