/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.rules;

import app.freerouting.board.LayerStructure;
import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.TextManager;
import app.freerouting.rules.ClearanceMatrix;
import app.freerouting.rules.DefaultItemClearanceClasses;
import app.freerouting.rules.ViaRule;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;

public class NetClass
implements Serializable,
ObjectInfoPanel.Printable {
    private final ClearanceMatrix clearance_matrix;
    private final LayerStructure board_layer_structure;
    private final int[] trace_half_width_arr;
    private final boolean[] active_routing_layer_arr;
    public DefaultItemClearanceClasses default_item_clearance_classes = new DefaultItemClearanceClasses();
    public boolean is_ignored_by_autorouter;
    private String name;
    private ViaRule via_rule;
    private int trace_clearance_class;
    private boolean shove_fixed;
    private boolean pull_tight = true;
    private boolean ignore_cycles_with_areas;
    private double minimum_trace_length = 0.0;
    private double maximum_trace_length = 0.0;

    public NetClass(String p_name, LayerStructure p_layer_structure, ClearanceMatrix p_clearance_matrix, boolean p_is_ignored_by_autorouter) {
        this.name = p_name;
        this.board_layer_structure = p_layer_structure;
        this.clearance_matrix = p_clearance_matrix;
        this.trace_half_width_arr = new int[p_layer_structure.arr.length];
        this.active_routing_layer_arr = new boolean[p_layer_structure.arr.length];
        for (int i = 0; i < p_layer_structure.arr.length; ++i) {
            this.active_routing_layer_arr[i] = p_layer_structure.arr[i].is_signal;
        }
        this.is_ignored_by_autorouter = p_is_ignored_by_autorouter;
    }

    public String toString() {
        return this.name;
    }

    public String get_name() {
        return this.name;
    }

    public void set_name(String p_name) {
        this.name = p_name;
    }

    public void set_trace_half_width(int p_value) {
        Arrays.fill(this.trace_half_width_arr, p_value);
    }

    public void set_trace_half_width_on_inner(int p_value) {
        for (int i = 1; i < this.trace_half_width_arr.length - 1; ++i) {
            this.trace_half_width_arr[i] = p_value;
        }
    }

    public void set_trace_half_width(int p_layer, int p_value) {
        this.trace_half_width_arr[p_layer] = p_value;
    }

    public int layer_count() {
        return this.trace_half_width_arr.length;
    }

    public int get_trace_half_width(int p_layer) {
        if (p_layer < 0 || p_layer >= this.trace_half_width_arr.length) {
            FRLogger.warn(" NetClass.get_trace_half_width: p_layer out of range");
            return 0;
        }
        return this.trace_half_width_arr[p_layer];
    }

    public int get_trace_clearance_class() {
        return this.trace_clearance_class;
    }

    public void set_trace_clearance_class(int p_clearance_class_no) {
        this.trace_clearance_class = p_clearance_class_no;
    }

    public ViaRule get_via_rule() {
        return this.via_rule;
    }

    public void set_via_rule(ViaRule p_via_rule) {
        this.via_rule = p_via_rule;
    }

    public boolean is_shove_fixed() {
        return this.shove_fixed;
    }

    public void set_shove_fixed(boolean p_value) {
        this.shove_fixed = p_value;
    }

    public boolean get_pull_tight() {
        return this.pull_tight;
    }

    public void set_pull_tight(boolean p_value) {
        this.pull_tight = p_value;
    }

    public boolean get_ignore_cycles_with_areas() {
        return this.ignore_cycles_with_areas;
    }

    public void set_ignore_cycles_with_areas(boolean p_value) {
        this.ignore_cycles_with_areas = p_value;
    }

    public double get_minimum_trace_length() {
        return this.minimum_trace_length;
    }

    public void set_minimum_trace_length(double p_value) {
        this.minimum_trace_length = p_value;
    }

    public double get_maximum_trace_length() {
        return this.maximum_trace_length;
    }

    public void set_maximum_trace_length(double p_value) {
        this.maximum_trace_length = p_value;
    }

    public boolean is_active_routing_layer(int p_layer_no) {
        if (p_layer_no < 0 || p_layer_no >= this.active_routing_layer_arr.length) {
            return false;
        }
        return this.active_routing_layer_arr[p_layer_no];
    }

    public void set_active_routing_layer(int p_layer_no, boolean p_active) {
        if (p_layer_no < 0 || p_layer_no >= this.active_routing_layer_arr.length) {
            return;
        }
        this.active_routing_layer_arr[p_layer_no] = p_active;
    }

    public void set_all_layers_active(boolean p_value) {
        Arrays.fill(this.active_routing_layer_arr, p_value);
    }

    public void set_all_inner_layers_active(boolean p_value) {
        for (int i = 1; i < this.trace_half_width_arr.length - 1; ++i) {
            this.active_routing_layer_arr[i] = p_value;
        }
    }

    @Override
    public void print_info(ObjectInfoPanel p_window, Locale p_locale) {
        TextManager tm = new TextManager(this.getClass(), p_locale);
        p_window.append_bold(tm.getText("net_class_2", new String[0]) + " ");
        p_window.append_bold(this.name);
        p_window.append_bold(":");
        p_window.append(" " + tm.getText("trace_clearance_class", new String[0]) + " ");
        String cl_name = this.clearance_matrix.get_name(this.trace_clearance_class);
        p_window.append(cl_name, tm.getText("trace_clearance_class_2", new String[0]), this.clearance_matrix.get_row(this.trace_clearance_class));
        if (this.shove_fixed) {
            p_window.append(", " + tm.getText("shove_fixed", new String[0]));
        }
        p_window.append(", " + tm.getText("via_rule", new String[0]) + " ");
        p_window.append(this.via_rule.name, tm.getText("via_rule_2", new String[0]), this.via_rule);
        if (this.trace_width_is_layer_dependent()) {
            for (int i = 0; i < this.trace_half_width_arr.length; ++i) {
                p_window.newline();
                p_window.indent();
                p_window.append(tm.getText("trace_width", new String[0]) + " ");
                p_window.append(2 * this.trace_half_width_arr[i]);
                p_window.append(" " + tm.getText("on_layer", new String[0]) + " ");
                p_window.append(this.board_layer_structure.arr[i].name);
            }
        } else {
            p_window.append(", " + tm.getText("trace_width", new String[0]) + " ");
            p_window.append(2 * this.trace_half_width_arr[0]);
        }
        p_window.newline();
    }

    public boolean trace_width_is_layer_dependent() {
        int compare_value = this.trace_half_width_arr[0];
        for (int i = 1; i < this.trace_half_width_arr.length; ++i) {
            if (!this.board_layer_structure.arr[i].is_signal || this.trace_half_width_arr[i] == compare_value) continue;
            return true;
        }
        return false;
    }

    public boolean trace_width_is_inner_layer_dependent() {
        if (this.trace_half_width_arr.length <= 3) {
            return false;
        }
        int first_inner_layer_no = 1;
        while (!this.board_layer_structure.arr[first_inner_layer_no].is_signal) {
            ++first_inner_layer_no;
        }
        if (first_inner_layer_no >= this.trace_half_width_arr.length - 1) {
            return false;
        }
        int compare_width = this.trace_half_width_arr[first_inner_layer_no];
        for (int i = first_inner_layer_no + 1; i < this.trace_half_width_arr.length - 1; ++i) {
            if (!this.board_layer_structure.arr[i].is_signal || this.trace_half_width_arr[i] == compare_width) continue;
            return true;
        }
        return false;
    }
}

