/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.rules;

import app.freerouting.board.AngleRestriction;
import app.freerouting.board.Item;
import app.freerouting.board.LayerStructure;
import app.freerouting.core.Padstack;
import app.freerouting.geometry.planar.ConvexShape;
import app.freerouting.logger.FRLogger;
import app.freerouting.rules.ClearanceMatrix;
import app.freerouting.rules.DefaultItemClearanceClasses;
import app.freerouting.rules.Net;
import app.freerouting.rules.NetClass;
import app.freerouting.rules.NetClasses;
import app.freerouting.rules.Nets;
import app.freerouting.rules.ViaInfo;
import app.freerouting.rules.ViaInfos;
import app.freerouting.rules.ViaRule;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Vector;

public class BoardRules
implements Serializable {
    public final ClearanceMatrix clearance_matrix;
    public final Nets nets;
    public final ViaInfos via_infos = new ViaInfos();
    public final Vector<ViaRule> via_rules = new Vector();
    public final NetClasses net_classes = new NetClasses();
    private final LayerStructure layer_structure;
    private transient AngleRestriction trace_angle_restriction;
    private boolean ignore_conduction = true;
    private int min_trace_half_width;
    private int max_trace_half_width;
    private double pin_edge_to_turn_dist;
    private boolean use_slow_autoroute_algorithm;

    public BoardRules(LayerStructure p_layer_structure, ClearanceMatrix p_clearance_matrix) {
        this.layer_structure = p_layer_structure;
        this.clearance_matrix = p_clearance_matrix;
        this.nets = new Nets();
        this.trace_angle_restriction = AngleRestriction.FORTYFIVE_DEGREE;
        this.min_trace_half_width = 100000;
        this.max_trace_half_width = 100;
    }

    public static int default_clearance_class() {
        return 1;
    }

    public static int clearance_class_none() {
        return 0;
    }

    public int get_trace_half_width(int p_net_no, int p_layer) {
        Net curr_net = this.nets.get(p_net_no);
        return curr_net.get_class().get_trace_half_width(p_layer);
    }

    public boolean trace_widths_are_layer_dependent(int p_net_no) {
        int compare_width = this.get_trace_half_width(p_net_no, 0);
        for (int i = 1; i < this.layer_structure.arr.length; ++i) {
            if (this.get_trace_half_width(p_net_no, i) == compare_width) continue;
            return true;
        }
        return false;
    }

    public int get_min_trace_half_width() {
        return this.min_trace_half_width;
    }

    public int get_max_trace_half_width() {
        return this.max_trace_half_width;
    }

    public void set_default_trace_half_width(int p_layer, int p_value) {
        this.get_default_net_class().set_trace_half_width(p_layer, p_value);
        this.min_trace_half_width = Math.min(this.min_trace_half_width, p_value);
        this.max_trace_half_width = Math.max(this.max_trace_half_width, p_value);
    }

    public int get_default_trace_half_width(int p_layer) {
        return this.get_default_net_class().get_trace_half_width(p_layer);
    }

    public void set_default_trace_half_widths(int p_value) {
        if (p_value <= 0) {
            FRLogger.warn("BoardRules.set_trace_half_widths: p_value out of range");
            return;
        }
        this.get_default_net_class().set_trace_half_width(p_value);
        this.min_trace_half_width = Math.min(this.min_trace_half_width, p_value);
        this.max_trace_half_width = Math.max(this.max_trace_half_width, p_value);
    }

    public NetClass get_default_net_class() {
        if (this.net_classes.count() <= 0) {
            this.create_default_net_class();
        }
        return this.net_classes.get(0);
    }

    public NetClass get_new_net_class(Locale p_locale) {
        NetClass result = this.net_classes.append(this.layer_structure, this.clearance_matrix, p_locale);
        result.set_trace_clearance_class(this.get_default_net_class().get_trace_clearance_class());
        result.set_via_rule(this.get_default_via_rule());
        result.set_trace_half_width(this.get_default_net_class().get_trace_half_width(0));
        return result;
    }

    public NetClass get_new_net_class(String p_name) {
        NetClass result = this.net_classes.append(p_name, this.layer_structure, this.clearance_matrix, false);
        result.set_trace_clearance_class(this.get_default_net_class().get_trace_clearance_class());
        result.set_via_rule(this.get_default_via_rule());
        result.set_trace_half_width(this.get_default_net_class().get_trace_half_width(0));
        return result;
    }

    public void create_default_via_rule(NetClass p_net_class, String p_name) {
        if (this.via_infos.count() == 0) {
            return;
        }
        ViaRule default_rule = new ViaRule(p_name);
        int default_via_cl_class = p_net_class.default_item_clearance_classes.get(DefaultItemClearanceClasses.ItemClass.VIA);
        for (int i = 0; i < this.via_infos.count(); ++i) {
            int curr_to_layer;
            ViaInfo curr_via_info = this.via_infos.get(i);
            if (curr_via_info.get_clearance_class() != default_via_cl_class) continue;
            Padstack curr_padstack = curr_via_info.get_padstack();
            int curr_from_layer = curr_padstack.from_layer();
            ViaInfo existing_via = default_rule.get_layer_range(curr_from_layer, curr_to_layer = curr_padstack.to_layer());
            if (existing_via != null) {
                ConvexShape new_shape = curr_padstack.get_shape(curr_from_layer);
                ConvexShape existing_shape = existing_via.get_padstack().get_shape(curr_from_layer);
                if (!(new_shape.max_width() < existing_shape.max_width())) continue;
                default_rule.remove_via(existing_via);
                default_rule.append_via(curr_via_info);
                continue;
            }
            default_rule.append_via(curr_via_info);
        }
        this.via_rules.add(default_rule);
        p_net_class.set_via_rule(default_rule);
    }

    public void create_default_net_class() {
        NetClass default_net_class = this.net_classes.append("default", this.layer_structure, this.clearance_matrix, false);
        int default_trace_half_width = 1500;
        default_net_class.set_trace_half_width(default_trace_half_width);
        default_net_class.set_trace_clearance_class(1);
    }

    public NetClass append_net_class(Locale p_locale) {
        NetClass new_class = this.net_classes.append(this.layer_structure, this.clearance_matrix, p_locale);
        NetClass default_class = this.net_classes.get(0);
        new_class.set_via_rule(default_class.get_via_rule());
        new_class.set_trace_half_width(default_class.get_trace_half_width(0));
        new_class.set_trace_clearance_class(default_class.get_trace_clearance_class());
        return new_class;
    }

    public NetClass append_net_class(String p_name) {
        NetClass found_class = this.net_classes.get(p_name);
        if (found_class != null) {
            return found_class;
        }
        NetClass new_class = this.net_classes.append(p_name, this.layer_structure, this.clearance_matrix, false);
        NetClass default_class = this.net_classes.get(0);
        new_class.default_item_clearance_classes = new DefaultItemClearanceClasses(default_class.default_item_clearance_classes);
        new_class.set_via_rule(default_class.get_via_rule());
        new_class.set_trace_half_width(default_class.get_trace_half_width(0));
        new_class.set_trace_clearance_class(default_class.get_trace_clearance_class());
        return new_class;
    }

    public ViaRule get_default_via_rule() {
        if (this.via_rules.isEmpty()) {
            return null;
        }
        return (ViaRule)this.via_rules.getFirst();
    }

    public ViaRule get_via_rule(String p_name) {
        for (ViaRule curr_rule : this.via_rules) {
            if (!curr_rule.name.equals(p_name)) continue;
            return curr_rule;
        }
        return null;
    }

    public void change_clearance_class_no(int p_from_no, int p_to_no, Collection<Item> p_board_items) {
        int i;
        for (Item curr_item : p_board_items) {
            if (curr_item.clearance_class_no() != p_from_no) continue;
            curr_item.set_clearance_class_no(p_to_no);
        }
        for (i = 0; i < this.net_classes.count(); ++i) {
            NetClass curr_net_class = this.net_classes.get(i);
            if (curr_net_class.get_trace_clearance_class() == p_from_no) {
                curr_net_class.set_trace_clearance_class(p_to_no);
            }
            for (DefaultItemClearanceClasses.ItemClass curr_item_class : DefaultItemClearanceClasses.ItemClass.values()) {
                if (curr_net_class.default_item_clearance_classes.get(curr_item_class) != p_from_no) continue;
                curr_net_class.default_item_clearance_classes.set(curr_item_class, p_to_no);
            }
        }
        for (i = 0; i < this.via_infos.count(); ++i) {
            ViaInfo curr_via = this.via_infos.get(i);
            if (curr_via.get_clearance_class() != p_from_no) continue;
            curr_via.set_clearance_class(p_to_no);
        }
    }

    public boolean remove_clearance_class(int p_index, Collection<Item> p_board_items) {
        int i;
        ViaInfo curr_via;
        NetClass curr_net_class;
        int i2;
        for (Item curr_item : p_board_items) {
            if (curr_item.clearance_class_no() != p_index) continue;
            return false;
        }
        for (i2 = 0; i2 < this.net_classes.count(); ++i2) {
            curr_net_class = this.net_classes.get(i2);
            if (curr_net_class.get_trace_clearance_class() == p_index) {
                return false;
            }
            for (DefaultItemClearanceClasses.ItemClass curr_item_class : DefaultItemClearanceClasses.ItemClass.values()) {
                if (curr_net_class.default_item_clearance_classes.get(curr_item_class) != p_index) continue;
                return false;
            }
        }
        for (i2 = 0; i2 < this.via_infos.count(); ++i2) {
            curr_via = this.via_infos.get(i2);
            if (curr_via.get_clearance_class() != p_index) continue;
            return false;
        }
        for (Item curr_item : p_board_items) {
            if (curr_item.clearance_class_no() <= p_index) continue;
            curr_item.set_clearance_class_no(curr_item.clearance_class_no() - 1);
        }
        for (i = 0; i < this.net_classes.count(); ++i) {
            curr_net_class = this.net_classes.get(i);
            if (curr_net_class.get_trace_clearance_class() > p_index) {
                curr_net_class.set_trace_clearance_class(curr_net_class.get_trace_clearance_class() - 1);
            }
            for (DefaultItemClearanceClasses.ItemClass curr_item_class : DefaultItemClearanceClasses.ItemClass.values()) {
                int curr_class_no = curr_net_class.default_item_clearance_classes.get(curr_item_class);
                if (curr_class_no <= p_index) continue;
                curr_net_class.default_item_clearance_classes.set(curr_item_class, curr_class_no - 1);
            }
        }
        for (i = 0; i < this.via_infos.count(); ++i) {
            curr_via = this.via_infos.get(i);
            if (curr_via.get_clearance_class() <= p_index) continue;
            curr_via.set_clearance_class(curr_via.get_clearance_class() - 1);
        }
        this.clearance_matrix.remove_class(p_index);
        return true;
    }

    public double get_pin_edge_to_turn_dist() {
        return this.pin_edge_to_turn_dist;
    }

    public void set_pin_edge_to_turn_dist(double p_value) {
        this.pin_edge_to_turn_dist = p_value;
    }

    public boolean get_ignore_conduction() {
        return this.ignore_conduction;
    }

    public void set_ignore_conduction(boolean p_value) {
        this.ignore_conduction = p_value;
    }

    public AngleRestriction get_trace_angle_restriction() {
        return this.trace_angle_restriction;
    }

    public void set_trace_angle_restriction(AngleRestriction p_angle_restriction) {
        this.trace_angle_restriction = p_angle_restriction;
    }

    public boolean get_use_slow_autoroute_algorithm() {
        return this.use_slow_autoroute_algorithm;
    }

    public void set_use_slow_autoroute_algorithm(boolean p_value) {
        this.use_slow_autoroute_algorithm = p_value;
    }

    public double get_default_via_diameter() {
        ViaRule default_via_rule = this.get_default_via_rule();
        if (default_via_rule == null) {
            return 0.0;
        }
        if (default_via_rule.via_count() <= 0) {
            return 0.0;
        }
        Padstack via_padstack = default_via_rule.get_via(0).get_padstack();
        ConvexShape curr_shape = via_padstack.get_shape(via_padstack.from_layer());
        double result = curr_shape.max_width();
        curr_shape = via_padstack.get_shape(via_padstack.to_layer());
        result = Math.max(result, curr_shape.max_width());
        return result;
    }

    private void writeObject(ObjectOutputStream p_stream) throws IOException {
        p_stream.defaultWriteObject();
        p_stream.writeInt(this.trace_angle_restriction.getValue());
    }

    private void readObject(ObjectInputStream p_stream) throws IOException, ClassNotFoundException {
        p_stream.defaultReadObject();
        int snap_angle_no = p_stream.readInt();
        this.trace_angle_restriction = AngleRestriction.valueOf(snap_angle_no);
    }
}

