/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.management.analytics;

import app.freerouting.Freerouting;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.analytics.AnalyticsClient;
import app.freerouting.management.analytics.FreeroutingAnalyticsClient;
import app.freerouting.management.analytics.dto.Properties;
import app.freerouting.management.analytics.dto.Traits;
import app.freerouting.management.gson.GsonProvider;
import java.time.Instant;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class FRAnalytics {
    private static final HashMap<String, String> appLocationTable = new HashMap<String, String>(){
        {
            this.put("app.freerouting.gui.BoardFrame", "app.freerouting.gui/Board");
            this.put("app.freerouting.gui.WindowObjectVisibility", "app.freerouting.gui/Appearance/ObjectTransparency");
            this.put("app.freerouting.gui.WindowLayerVisibility", "app.freerouting.gui/Appearance/LayerTransparency");
            this.put("app.freerouting.gui.ColorManager", "app.freerouting.gui/Appearance/Colors");
            this.put("app.freerouting.gui.WindowDisplayMisc", "app.freerouting.gui/Appearance/Misc");
            this.put("app.freerouting.gui.WindowSelectParameter", "app.freerouting.gui/Settings/Selection");
            this.put("app.freerouting.gui.WindowRouteParameter", "app.freerouting.gui/Settings/Routing");
            this.put("app.freerouting.gui.WindowAutorouteParameter", "app.freerouting.gui/Settings/Auto-router");
            this.put("app.freerouting.gui.WindowAutorouteDetailParameter", "app.freerouting.gui/Settings/Auto-router/Details");
            this.put("app.freerouting.gui.WindowMoveParameter", "app.freerouting.gui/Settings/Controls");
            this.put("app.freerouting.gui.WindowClearanceMatrix", "app.freerouting.gui/Rules/ClearanceMatrix");
            this.put("app.freerouting.gui.WindowVia", "app.freerouting.gui/Rules/Vias");
            this.put("app.freerouting.gui.WindowNets", "app.freerouting.gui/Rules/Nets");
            this.put("app.freerouting.gui.WindowNetClasses", "app.freerouting.gui/Rules/NetClasses");
            this.put("app.freerouting.gui.WindowPackages", "app.freerouting.gui/Information/LibraryPackages");
            this.put("app.freerouting.gui.WindowPadstacks", "app.freerouting.gui/Information/LibraryPadstacks");
            this.put("app.freerouting.gui.WindowComponents", "app.freerouting.gui/Information/PlacedComponents");
            this.put("app.freerouting.gui.WindowIncompletes", "app.freerouting.gui/Information/Incompletes");
            this.put("app.freerouting.gui.WindowLengthViolations", "app.freerouting.gui/Information/LengthViolations");
            this.put("app.freerouting.gui.WindowClearanceViolations", "app.freerouting.gui/Information/ClearanceViolations");
            this.put("app.freerouting.gui.WindowUnconnectedRoute", "app.freerouting.gui/Information/UnconnectedRoutes");
            this.put("app.freerouting.gui.WindowRouteStubs", "app.freerouting.gui/Information/RouteStubs");
            this.put("app.freerouting.gui.WindowSnapshot", "app.freerouting.gui/Other/Snapshots");
            this.put("app.freerouting.gui.WindowSnapshotSettings", "app.freerouting.gui/Other/Snapshots/Settings");
            this.put("app.freerouting.gui.WindowAbout", "app.freerouting.gui/Help/About");
            this.put("select_button", "app.freerouting.gui/Board/Toolbar/Select");
            this.put("route_button", "app.freerouting.gui/Board/Toolbar/Route");
            this.put("drag_button", "app.freerouting.gui/Board/Toolbar/Drag");
            this.put("autoroute_button", "app.freerouting.gui/Board/Toolbar/Autorouter");
            this.put("undo_button", "app.freerouting.gui/Board/Toolbar/Undo");
            this.put("redo_button", "app.freerouting.gui/Board/Toolbar/Redo");
            this.put("incompletes_button", "app.freerouting.gui/Board/Toolbar/Incompletes");
            this.put("violation_button", "app.freerouting.gui/Board/Toolbar/Violations");
            this.put("display_all_button", "app.freerouting.gui/Board/Toolbar/ZoomAll");
            this.put("display_region_button", "app.freerouting.gui/Board/Toolbar/ZoomRegion");
            this.put("file_save_menuitem", "app.freerouting.gui/Board/Menu/File/Save");
            this.put("file_save_and_exit_menuitem", "app.freerouting.gui/Board/Menu/File/SaveAndExit");
            this.put("file_cancel_and_exit_menuitem", "app.freerouting.gui/Board/Menu/File/CancelAndExit");
            this.put("file_save_as_menuitem", "app.freerouting.gui/Board/Menu/File/SaveAs");
            this.put("file_write_logfile_menuitem", "app.freerouting.gui/Board/Menu/File/MacroRecording");
            this.put("file_replay_logfile_menuitem", "app.freerouting.gui/Board/Menu/File/MacroPlayback");
            this.put("file_save_settings_menuitem", "app.freerouting.gui/Board/Menu/File/SaveGUISettings");
            this.put("file_write_session_file_menuitem", "app.freerouting.gui/Board/Menu/File/ExportAsSpecctra");
            this.put("file_write_eagle_session_script_menuitem", "app.freerouting.gui/Board/Menu/File/ExportAsEagleScript");
            this.put("display_object_visibility_menuitem", "app.freerouting.gui/Board/Menu/Appearance/ObjectVisibility");
            this.put("display_layer_visibility_menuitem", "app.freerouting.gui/Board/Menu/Appearance/LayerVisibility");
            this.put("display_colors_menuitem", "app.freerouting.gui/Board/Menu/Appearance/Colors");
            this.put("display_miscellaneous_menuitem", "app.freerouting.gui/Board/Menu/Appearance/Miscellaneous");
            this.put("settings_selection_menuitem", "app.freerouting.gui/Board/Menu/Settings/Selection");
            this.put("settings_routing_menuitem", "app.freerouting.gui/Board/Menu/Settings/Routing");
            this.put("settings_autorouter_menuitem", "app.freerouting.gui/Board/Menu/Settings/AutoRouter");
            this.put("settings_controls_menuitem", "app.freerouting.gui/Board/Menu/Settings/Controls");
            this.put("rules_clearance_menuitem", "app.freerouting.gui/Board/Menu/Rules/ClearanceMatrix");
            this.put("rules_vias_menuitem", "app.freerouting.gui/Board/Menu/Rules/Vias");
            this.put("rules_nets_menuitem", "app.freerouting.gui/Board/Menu/Rules/Nets");
            this.put("rules_net_class_menuitem", "app.freerouting.gui/Board/Menu/Rules/NetClasses");
            this.put("info_packages_menuitem", "app.freerouting.gui/Board/Menu/Info/Packages");
            this.put("info_padstacks_menuitem", "app.freerouting.gui/Board/Menu/Info/Padstacks");
            this.put("info_components_menuitem", "app.freerouting.gui/Board/Menu/Info/Components");
            this.put("info_incompletes_menuitem", "app.freerouting.gui/Board/Menu/Info/IncompleteRoutes");
            this.put("info_length_violations_menuitem", "app.freerouting.gui/Board/Menu/Info/LengthViolations");
            this.put("info_clearance_violations_menuitem", "app.freerouting.gui/Board/Menu/Info/ClearanceViolations");
            this.put("info_unconnected_routes_menuitem", "app.freerouting.gui/Board/Menu/Info/UnconnectedRoutes");
            this.put("info_route_stubs_menuitem", "app.freerouting.gui/Board/Menu/Info/RoutedStubs");
            this.put("other_snapshots_menuitem", "app.freerouting.gui/Board/Menu/Other/Snapshots");
            this.put("other_delete_all_tracks_menuitem", "app.freerouting.gui/Board/Menu/Other/DeleteAllTracksAndVias");
            this.put("help_about_menuitem", "app.freerouting.gui/Board/Menu/Help/About");
        }
    };
    private static AnalyticsClient analytics;
    private static String permanent_user_id;
    private static String permanent_user_email;
    private static String appPreviousLocation;
    private static String appCurrentLocation;
    private static String appWindowTitle;
    private static long appStartedAt;
    private static int sessionCount;
    private static long totalAutorouterRuntime;
    private static long totalRouteOptimizerRuntime;
    private static long autorouterStartedAt;
    private static long routeOptimizerStartedAt;

    private FRAnalytics() {
    }

    public static void setAccessKey(String libraryVersion, String key) {
        analytics = new FreeroutingAnalyticsClient(libraryVersion, key);
    }

    public static void setUserId(String userId, String userEmail) {
        permanent_user_id = userId;
        permanent_user_email = userEmail;
    }

    private static void identifyUser(String userId, Map<String, String> traits) {
        if (analytics == null) {
            return;
        }
        try {
            Traits t2 = new Traits();
            t2.putAll(traits);
            analytics.identify(userId, null, t2);
        }
        catch (Exception e) {
            FRLogger.error("Exception in FRAnalytics.identifyUser: " + e.getMessage(), e);
        }
    }

    private static void identifyAnonymous(String anonymousId, Map<String, String> traits) {
        if (analytics == null) {
            return;
        }
        try {
            Traits t2 = new Traits();
            t2.putAll(traits);
            analytics.identify(null, anonymousId, t2);
        }
        catch (Exception e) {
            FRLogger.error("Exception in FRAnalytics.identifyAnonymous: " + e.getMessage(), e);
        }
    }

    private static void trackAnonymousAction(String anonymousId, String action, Map<String, String> properties) {
        if (analytics == null) {
            return;
        }
        try {
            Properties p = new Properties();
            p.put("current_time_utc", Instant.now().toString());
            p.put("user_id", permanent_user_id);
            p.put("user_email", permanent_user_email);
            p.put("app_current_location", appCurrentLocation);
            p.put("app_previous_location", appPreviousLocation);
            p.put("app_window_title", appWindowTitle);
            if (properties != null) {
                p.putAll(properties);
            }
            analytics.track(null, anonymousId, action, p);
        }
        catch (Exception e) {
            FRLogger.error("Exception in FRAnalytics.trackAnonymousAction: " + e.getMessage(), e);
        }
    }

    public static void identify() {
        HashMap<String, String> traits = new HashMap<String, String>();
        traits.put("anonymous", "true");
        traits.put("user_id", permanent_user_id);
        traits.put("user_email", permanent_user_email);
        FRAnalytics.identifyAnonymous(permanent_user_id, traits);
    }

    public static void setAppLocation(String windowClassName, String windowTitle) {
        if (Objects.equals(appPreviousLocation, windowClassName = FRAnalytics.translateClassNameToUrl(windowClassName))) {
            return;
        }
        appPreviousLocation = appCurrentLocation;
        appCurrentLocation = windowClassName;
        appWindowTitle = windowTitle;
        Properties p = new Properties();
        FRAnalytics.trackAnonymousAction(permanent_user_id, "Window Changed", p);
    }

    public static void buttonClicked(String buttonClassName, String buttonText) {
        buttonClassName = FRAnalytics.translateClassNameToUrl(buttonClassName);
        Properties p = new Properties();
        p.put("button_name", buttonClassName);
        p.put("button_text", buttonText);
        FRAnalytics.trackAnonymousAction(permanent_user_id, "Button Clicked", p);
    }

    private static String translateClassNameToUrl(String appLocation) {
        if (appLocationTable.containsKey(appLocation)) {
            return appLocationTable.get(appLocation);
        }
        return appLocation.replace("app.freerouting.gui.", "app.freerouting.gui/");
    }

    public static void setEnabled(boolean enabled) {
        if (analytics == null) {
            return;
        }
        analytics.setEnabled(enabled);
    }

    public static void appStarted(String freeroutingVersion, String freeroutingBuildDate, String commandLineArguments, String osName, String osArchitecture, String osVersion, String javaVersion, String javaVendor, Locale systemLanguage, Locale guiLanguage, int cpuCoreCount, long ramAmount, String host, int width, int height, int dpi) {
        appStartedAt = Instant.now().getEpochSecond();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("build_version", freeroutingVersion);
        properties.put("build_date", freeroutingBuildDate);
        properties.put("command_line_arguments", commandLineArguments);
        properties.put("os_name", osName);
        properties.put("os_architecture", osArchitecture);
        properties.put("os_version", osVersion);
        properties.put("java_version", javaVersion);
        properties.put("java_vendor", javaVendor);
        properties.put("system_language", systemLanguage.toString());
        properties.put("gui_language", guiLanguage.toString());
        properties.put("cpu_core_count", Integer.toString(cpuCoreCount));
        properties.put("ram_amount", Long.toString(ramAmount));
        properties.put("host", host);
        properties.put("screen_width", Integer.toString(width));
        properties.put("screen_height", Integer.toString(height));
        properties.put("screen_dpi", Integer.toString(dpi));
        FRAnalytics.trackAnonymousAction(permanent_user_id, "Application Started", properties);
    }

    public static void appClosed() {
        long appClosedAt = Instant.now().getEpochSecond();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("session_count", String.valueOf(sessionCount));
        properties.put("total_autorouter_runtime", String.valueOf(totalAutorouterRuntime));
        properties.put("total_route_optimizer_runtime", String.valueOf(totalRouteOptimizerRuntime));
        properties.put("application_runtime", String.valueOf(appClosedAt - appStartedAt));
        properties.put("statistics_start_time", String.valueOf(Freerouting.globalSettings.statistics.startTime));
        properties.put("statistics_end_time", String.valueOf(Freerouting.globalSettings.statistics.endTime));
        properties.put("statistics_sessions_total", String.valueOf(Freerouting.globalSettings.statistics.sessionsTotal));
        properties.put("statistics_jobs_started", String.valueOf(Freerouting.globalSettings.statistics.jobsStarted));
        properties.put("statistics_jobs_completed", String.valueOf(Freerouting.globalSettings.statistics.jobsCompleted));
        FRAnalytics.trackAnonymousAction(permanent_user_id, "Application Closed", properties);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void autorouterStarted() {
        autorouterStartedAt = Instant.now().getEpochSecond();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("settings", GsonProvider.GSON.toJson(Freerouting.globalSettings));
        properties.put("session_count", String.valueOf(++sessionCount));
        FRAnalytics.trackAnonymousAction(permanent_user_id, "Auto-router Started", properties);
    }

    public static void autorouterFinished() {
        long autorouterFinishedAt = Instant.now().getEpochSecond();
        long autorouterRuntime = autorouterFinishedAt - autorouterStartedAt;
        totalAutorouterRuntime += autorouterRuntime;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("settings", GsonProvider.GSON.toJson(Freerouting.globalSettings));
        properties.put("session_count", String.valueOf(sessionCount));
        properties.put("autorouter_runtime", String.valueOf(autorouterRuntime));
        FRAnalytics.trackAnonymousAction(permanent_user_id, "Auto-router Finished", properties);
    }

    public static void routeOptimizerStarted() {
        routeOptimizerStartedAt = Instant.now().getEpochSecond();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("settings", GsonProvider.GSON.toJson(Freerouting.globalSettings));
        properties.put("session_count", String.valueOf(sessionCount));
        FRAnalytics.trackAnonymousAction(permanent_user_id, "Route Optimizer Started", properties);
    }

    public static void routeOptimizerFinished() {
        long routeOptimizerFinishedAt = Instant.now().getEpochSecond();
        long routeOptimizerRuntime = routeOptimizerFinishedAt - routeOptimizerStartedAt;
        totalRouteOptimizerRuntime += routeOptimizerRuntime;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("settings", GsonProvider.GSON.toJson(Freerouting.globalSettings));
        properties.put("session_count", String.valueOf(sessionCount));
        properties.put("route_optimizer_runtime", String.valueOf(routeOptimizerRuntime));
        FRAnalytics.trackAnonymousAction(permanent_user_id, "Route Optimizer Finished", properties);
    }

    public static void fileLoaded(String fileFormat, String fileDetails) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("file_format", fileFormat);
        properties.put("file_details", fileDetails);
        FRAnalytics.trackAnonymousAction(permanent_user_id, "File Loaded", properties);
    }

    public static void boardLoaded(String hostName, String hostVersion, int layerCount, int componentCount, int netCount) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("host_name", hostName);
        properties.put("host_version", hostVersion);
        properties.put("layer_count", Integer.toString(layerCount));
        properties.put("component_count", Integer.toString(componentCount));
        properties.put("net_count", Integer.toString(netCount));
        FRAnalytics.trackAnonymousAction(permanent_user_id, "Board Loaded", properties);
    }

    public static void fileSaved(String fileFormat, String fileDetails) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("file_format", fileFormat);
        properties.put("file_details", fileDetails);
        FRAnalytics.trackAnonymousAction(permanent_user_id, "File Saved", properties);
    }

    public static void exceptionThrown(String localizedMessage, Throwable e) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement ste : e.getStackTrace()) {
            sb.append(ste.toString());
            sb.append("\n");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("exception_message", localizedMessage);
        properties.put("exception_details", e.toString());
        properties.put("exception_stacktrace", sb.toString());
        FRAnalytics.trackAnonymousAction(permanent_user_id, "Exception Thrown", properties);
    }

    public static void apiEndpointCalled(String apiMethod, String requestBody, String responseBody) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("api_method", apiMethod);
        properties.put("api_request", requestBody);
        properties.put("api_response", responseBody);
        FRAnalytics.trackAnonymousAction(permanent_user_id, "API Endpoint Called", properties);
    }

    static {
        appPreviousLocation = "";
        appCurrentLocation = "";
        appWindowTitle = "";
    }
}

