/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.management;

import app.freerouting.logger.FRLogger;
import app.freerouting.settings.GlobalSettings;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;

public class TextManager {
    private final Map<String, Integer> iconMap = new HashMap<String, Integer>(this){
        final /* synthetic */ TextManager this$0;
        {
            TextManager textManager = this$0;
            Objects.requireNonNull(textManager);
            this.this$0 = textManager;
            this.put("cog", 984211);
            this.put("auto-fix", 983144);
            this.put("cancel", 984890);
            this.put("delete-sweep", 984553);
            this.put("undo", 984396);
            this.put("redo", 984142);
            this.put("spider-web", 986058);
            this.put("order-bool-ascending-variant", 985487);
            this.put("magnify-plus-cursor", 985699);
            this.put("magnify-minus", 983882);
            this.put("alert", 983078);
            this.put("close-octagon", 983388);
        }
    };
    private Locale currentLocale;
    private String currentBaseName;
    private ResourceBundle defaultMessages;
    private ResourceBundle classMessages;
    private ResourceBundle englishClassMessages;
    private Font materialDesignIcons;

    public TextManager(Class baseClass, Locale locale) {
        this.currentLocale = locale;
        this.loadResourceBundle(baseClass.getName());
        try {
            this.materialDesignIcons = Font.createFont(0, GlobalSettings.class.getResourceAsStream("/materialdesignicons-webfont.ttf"));
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(this.materialDesignIcons);
        }
        catch (FontFormatException | IOException e) {
            FRLogger.error("There was a problem loading the Material Design Icons font", e);
        }
    }

    public static String convertInstantToString(Instant instant) {
        return TextManager.convertInstantToString(instant, "yyyyMMdd_HHmmss");
    }

    public static String convertInstantToString(Instant instant, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return localDateTime.format(formatter);
    }

    public static String generateRandomAlphanumericString(int length) {
        String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder randomString = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = (int)((double)characters.length() * ThreadLocalRandom.current().nextDouble());
            randomString.append(characters.charAt(index));
        }
        return randomString.toString();
    }

    public static Long parseTimespanString(String timespanString) {
        try {
            String durationString = TextManager.convertFromTimespanToDurationFormat(timespanString);
            Duration duration = Duration.parse(durationString);
            return duration.getSeconds();
        }
        catch (DateTimeParseException dateTimeParseException) {
            return null;
        }
    }

    public static String convertFromTimespanToDurationFormat(String timespanString) {
        String[] parts = timespanString.split(":");
        StringBuilder durationString = new StringBuilder("PT");
        if (parts.length == 3) {
            durationString.append(parts[0]).append("H").append(parts[1]).append("M").append(parts[2]).append("S");
        } else if (parts.length == 2) {
            durationString.append(parts[0]).append("M").append(parts[1]).append("S");
        } else if (parts.length == 1) {
            durationString.append(parts[0]).append("S");
        }
        return durationString.toString();
    }

    public static String shortenString(String text, int peakCharacterCount) {
        Object shortenedText = text;
        if (text.length() > peakCharacterCount * 2) {
            shortenedText = ((String)shortenedText).substring(0, peakCharacterCount) + "..." + text.substring(text.length() - peakCharacterCount);
        }
        return shortenedText;
    }

    public static String removeQuotes(String text) {
        if (text == null || text.length() < 2) {
            return text;
        }
        if (text.startsWith("\"") && text.endsWith("\"")) {
            text = text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static byte[] decryptAes256Cbc(byte[] encodedText, String passphrase) {
        try {
            IvParameterSpec iv = new IvParameterSpec("freeroutingivpar".getBytes(StandardCharsets.UTF_8));
            SecretKeySpec skeySpec = new SecretKeySpec(passphrase.getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(2, (Key)skeySpec, iv);
            byte[] original = cipher.doFinal(encodedText);
            return original;
        }
        catch (Exception ex) {
            FRLogger.error("There was a problem decrypting the text", ex);
            return null;
        }
    }

    public static String unescapeUnicode(String text) {
        Pattern pattern = Pattern.compile("\\\\u(\\p{XDigit}{4})");
        Matcher matcher = pattern.matcher(text);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String hexCode = matcher.group(1);
            char unicode = (char)Integer.parseInt(hexCode, 16);
            matcher.appendReplacement(result, String.valueOf(unicode));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String longToHexadecimalString(Long longValue) {
        return "0x%016X".formatted(longValue);
    }

    public static Long hexadecimalStringToLong(String hexString) {
        if (hexString.startsWith("0x") || hexString.startsWith("0X")) {
            hexString = hexString.substring(2);
            return Long.parseUnsignedLong(hexString, 16);
        }
        return Long.parseUnsignedLong(hexString, 10);
    }

    private void loadResourceBundle(String baseName) {
        this.currentBaseName = baseName;
        try {
            this.defaultMessages = ResourceBundle.getBundle("app.freerouting.Common", this.currentLocale);
        }
        catch (Exception exception) {
            FRLogger.warn("There was a problem loading the resource bundle 'app.freerouting.Common' of locale '" + String.valueOf(this.currentLocale) + "'");
            try {
                this.defaultMessages = ResourceBundle.getBundle("app.freerouting.Common", Locale.forLanguageTag("en-US"));
            }
            catch (Exception exception2) {
                this.defaultMessages = null;
                FRLogger.error("There was a problem loading the resource bundle 'app.freerouting.Common' of locale 'en-US'", null);
            }
        }
        try {
            this.classMessages = ResourceBundle.getBundle(this.currentBaseName, this.currentLocale);
        }
        catch (Exception exception) {
            try {
                this.classMessages = ResourceBundle.getBundle(this.currentBaseName, Locale.forLanguageTag("en-US"));
            }
            catch (Exception exception3) {
                this.classMessages = null;
            }
        }
        try {
            this.englishClassMessages = ResourceBundle.getBundle(this.currentBaseName, Locale.forLanguageTag("en"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getText(String key, String ... args) {
        String text;
        if (this.classMessages != null && this.classMessages.containsKey(key)) {
            text = this.classMessages.getString(key);
        } else if (this.defaultMessages != null && this.defaultMessages.containsKey(key)) {
            text = this.defaultMessages.getString(key);
        } else if (this.englishClassMessages != null && this.englishClassMessages.containsKey(key)) {
            text = this.englishClassMessages.getString(key);
        } else {
            return key;
        }
        Pattern pattern = Pattern.compile("\\{\\{(.+?)\\}\\}");
        Matcher matcher = pattern.matcher(text);
        int argIndex = 0;
        while (matcher.find()) {
            String placeholder = matcher.group(0);
            if (placeholder.startsWith("{{icon:") || argIndex >= args.length) continue;
            text = text.replace(placeholder, args[argIndex]);
            ++argIndex;
        }
        return text;
    }

    private String insertIcons(JComponent component, String text) {
        Pattern pattern = Pattern.compile("\\{\\{icon:(.+?)\\}\\}");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String placeholder = matcher.group(0);
            String iconName = matcher.group(1);
            try {
                int codePoint = this.iconMap.get(iconName);
                text = text.replace(placeholder, new String(Character.toChars(codePoint)));
                Font originalFont = component.getFont();
                component.setFont(this.materialDesignIcons.deriveFont(0, (float)originalFont.getSize() * 1.5f));
            }
            catch (Exception e) {
                FRLogger.error("There was a problem setting the icon for the component", e);
            }
        }
        return text;
    }

    public void setText(JComponent component, String key, String ... args) {
        String text = this.getText(key, args);
        String tooltip = this.getText(key + "_tooltip", args);
        if (tooltip == null || tooltip.isEmpty() || tooltip.equals(key + "_tooltip")) {
            tooltip = null;
        }
        text = this.insertIcons(component, text);
        if (component instanceof JButton) {
            JButton button1 = (JButton)component;
            button1.setText(text);
            if (tooltip != null && !tooltip.isEmpty()) {
                component.setToolTipText(tooltip);
            }
        } else if (component instanceof JToggleButton) {
            JToggleButton button = (JToggleButton)component;
            button.setText(text);
            if (tooltip != null && !tooltip.isEmpty()) {
                component.setToolTipText(tooltip);
            }
        } else if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            label.setText(text);
            if (tooltip != null && !tooltip.isEmpty()) {
                component.setToolTipText(tooltip);
            }
        } else {
            String componentType = component.getClass().getName();
            FRLogger.warn("The component type '" + componentType + "' is not supported");
        }
    }

    public Locale getLocale() {
        return this.currentLocale;
    }

    public void setLocale(Locale locale) {
        this.currentLocale = locale;
        this.loadResourceBundle(this.currentBaseName);
    }
}

