/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.management;

import app.freerouting.logger.FRLogger;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static void setFieldValue(Object obj, String propertyName, Object newValue) throws NoSuchFieldException, IllegalAccessException {
        String[] propertyPath = propertyName.split("[.:\\-]");
        Object currentObject = obj;
        Field field = null;
        for (int i = 0; i < propertyPath.length - 1; ++i) {
            field = ReflectionUtil.getFieldByNameOrSerializedName(currentObject.getClass(), propertyPath[i]);
            field.setAccessible(true);
            currentObject = field.get(currentObject);
        }
        field = ReflectionUtil.getFieldByNameOrSerializedName(currentObject.getClass(), propertyPath[propertyPath.length - 1]);
        field.setAccessible(true);
        Object convertedValue = ReflectionUtil.convertValue(field.getType(), newValue);
        field.set(currentObject, convertedValue);
    }

    private static Field getFieldByNameOrSerializedName(Class<?> clazz, String name) throws NoSuchFieldException {
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getName().equals(name)) {
                return field;
            }
            SerializedName annotation = field.getAnnotation(SerializedName.class);
            if (annotation == null || !annotation.value().equals(name)) continue;
            return field;
        }
        throw new NoSuchFieldException("No field found with name or SerializedName: " + name);
    }

    private static Object convertValue(Class<?> targetType, Object value) {
        if (targetType.isInstance(value)) {
            return value;
        }
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return Integer.parseInt(value.toString());
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            return Long.parseLong(value.toString());
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            return Double.parseDouble(value.toString());
        }
        if (targetType == Boolean.TYPE || targetType == Boolean.class) {
            if ("0".equals(value.toString())) {
                value = "false";
            } else if ("1".equals(value.toString())) {
                value = "true";
            }
            return Boolean.parseBoolean(value.toString());
        }
        return value;
    }

    public static int copyFields(Object source, Object target) {
        int numberOfFieldsChanged = 0;
        for (Field field : source.getClass().getDeclaredFields()) {
            try {
                Object targetValue;
                if (Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
                field.setAccessible(true);
                Object sourceValue = field.get(source);
                if (sourceValue == null || sourceValue.equals(ReflectionUtil.getDefaultValue(field))) continue;
                if (field.getType().isPrimitive() || field.getType() == String.class) {
                    targetValue = field.get(target);
                    if (targetValue == sourceValue) continue;
                    field.set(target, sourceValue);
                    ++numberOfFieldsChanged;
                    continue;
                }
                if (field.getType().isEnum()) {
                    Class<?> enumType = field.getType();
                    Object enumValue = Enum.valueOf(enumType, sourceValue.toString());
                    field.set(target, enumValue);
                    ++numberOfFieldsChanged;
                    continue;
                }
                if (field.getType().isArray()) {
                    if (field.getType().getComponentType().isPrimitive() || field.getType().getComponentType() == String.class) {
                        targetValue = field.get(target);
                        int targetArrayLength = 0;
                        if (targetValue != null && targetValue.getClass().isArray()) {
                            targetArrayLength = Array.getLength(targetValue);
                        }
                        int sourceArrayLength = 0;
                        if (sourceValue != null && sourceValue.getClass().isArray()) {
                            sourceArrayLength = Array.getLength(sourceValue);
                        }
                        if (targetValue != null && (targetArrayLength != 0 || sourceArrayLength <= 0)) continue;
                        field.set(target, sourceValue);
                        ++numberOfFieldsChanged;
                        continue;
                    }
                    Object[] sourceArray = (Object[])sourceValue;
                    Object[] targetArray = (Object[])field.get(target);
                    if (targetArray == null) {
                        targetArray = new Object[sourceArray.length];
                        field.set(target, targetArray);
                    }
                    System.arraycopy(sourceArray, 0, targetArray, 0, sourceArray.length);
                    numberOfFieldsChanged += sourceArray.length;
                    continue;
                }
                Object targetField = field.get(target);
                if (targetField == null) {
                    targetField = field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    field.set(target, targetField);
                }
                numberOfFieldsChanged += ReflectionUtil.copyFields(sourceValue, targetField);
            }
            catch (Exception e) {
                FRLogger.error("Error copying fields", e);
            }
        }
        return numberOfFieldsChanged;
    }

    private static Object getDefaultValue(Field field) {
        Object result = null;
        try {
            result = field.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                result = 0;
            } else if (field.getType() == Long.TYPE || field.getType() == Long.class) {
                result = 0L;
            } else if (field.getType() == Float.TYPE || field.getType() == Float.class) {
                result = Float.valueOf(0.0f);
            } else if (field.getType() == Double.TYPE || field.getType() == Double.class) {
                result = 0.0;
            } else if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                result = false;
            } else if (field.getType().isArray()) {
                result = Array.newInstance(field.getType().getComponentType(), 0);
            } else if (field.getType().isEnum()) {
                result = field.getType().getEnumConstants()[0];
            } else {
                FRLogger.warn("No default constructor found for field: " + field.getName());
            }
        }
        catch (Exception e) {
            FRLogger.error("Error getting default value for field: " + field.getName(), e);
        }
        return result;
    }
}

