/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.logger;

import app.freerouting.logger.LogEntry;
import app.freerouting.logger.LogEntryType;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class LogEntries {
    private final List<LogEntry> entries = new ArrayList<LogEntry>();
    private final List<LogEntryAddedListener> listeners = new ArrayList<LogEntryAddedListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWarningCount() {
        List<LogEntry> list = this.entries;
        synchronized (list) {
            return (int)this.entries.stream().filter(e -> e.type == LogEntryType.Warning).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrorCount() {
        List<LogEntry> list = this.entries;
        synchronized (list) {
            return (int)this.entries.stream().filter(e -> e.type == LogEntryType.Error).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<LogEntry> list = this.entries;
        synchronized (list) {
            this.entries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAsString() {
        List<LogEntry> list = this.entries;
        synchronized (list) {
            return this.entries.stream().map(LogEntry::toString).collect(Collectors.joining("\n", "", "\n"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] get() {
        List<LogEntry> list = this.entries;
        synchronized (list) {
            return (String[])this.entries.stream().map(LogEntry::toString).toArray(String[]::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogEntry[] getEntries(Instant entriesSince, UUID topic) {
        List<LogEntry> list = this.entries;
        synchronized (list) {
            return (LogEntry[])this.entries.stream().filter(e -> (entriesSince == null || e.timestamp.isAfter(entriesSince)) && (topic == null || e.topic != null && e.topic.equals(topic))).toArray(LogEntry[]::new);
        }
    }

    public LogEntry add(LogEntryType type, String message, UUID topic) {
        LogEntry logEntry = this.add(type, message, topic, null);
        return logEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogEntry add(LogEntryType type, String message, UUID topic, Throwable exception) {
        LogEntry logEntry = new LogEntry(type, message, exception, topic);
        List<LogEntry> list = this.entries;
        synchronized (list) {
            this.entries.add(logEntry);
        }
        for (LogEntryAddedListener listener : this.listeners) {
            listener.logEntryAdded(logEntry);
        }
        return logEntry;
    }

    public void addLogEntryAddedListener(LogEntryAddedListener listener) {
        this.listeners.add(listener);
    }

    public void removeLogEntryAddedListener(LogEntryAddedListener listener) {
        this.listeners.remove(listener);
    }

    public static interface LogEntryAddedListener {
        public void logEntryAdded(LogEntry var1);
    }
}

