/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.SelectRegionState;
import java.awt.geom.Point2D;

public class ZoomRegionState
extends SelectRegionState {
    public ZoomRegionState(InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        super(p_parent_state, p_board_handling, p_activityReplayFile);
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.ZOOM_FRAME);
        }
    }

    public static ZoomRegionState get_instance(InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        return ZoomRegionState.get_instance(null, p_parent_state, p_board_handling, p_activityReplayFile);
    }

    public static ZoomRegionState get_instance(FloatPoint p_location, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        ZoomRegionState new_instance = new ZoomRegionState(p_parent_state, p_board_handling, p_activityReplayFile);
        new_instance.corner1 = p_location;
        new_instance.hdlg.screen_messages.set_status_message(new_instance.tm.getText("drag_left_mouse_button_to_create_region_to_display", new String[0]));
        return new_instance;
    }

    @Override
    public InteractiveState complete() {
        this.corner2 = this.hdlg.get_current_mouse_position();
        this.zoom_region();
        if (this.activityReplayFile != null) {
            this.activityReplayFile.add_corner(this.corner2);
        }
        return this.return_state;
    }

    private void zoom_region() {
        if (this.corner1 == null || this.corner2 == null) {
            return;
        }
        Point2D sc_corner1 = this.hdlg.graphics_context.coordinate_transform.board_to_screen(this.corner1);
        Point2D sc_corner2 = this.hdlg.graphics_context.coordinate_transform.board_to_screen(this.corner2);
        this.hdlg.get_panel().zoom_frame(sc_corner1, sc_corner2);
    }
}

