/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.ItemSelectionFilter;
import app.freerouting.board.RoutingBoard;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.SnapShot;
import app.freerouting.logger.FRLogger;
import app.freerouting.settings.RouterSettings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;

public class Settings
implements Serializable {
    final int[] manual_trace_half_width_arr;
    public RouterSettings autoroute_settings;
    int layer;
    boolean push_enabled;
    boolean drag_components_enabled;
    boolean select_on_all_visible_layers;
    boolean is_stitch_route;
    int trace_pull_tight_region_width;
    boolean via_snap_to_smd_center;
    int horizontal_component_grid;
    int vertical_component_grid;
    boolean manual_rule_selection;
    boolean hilight_routing_obstacle;
    int manual_trace_clearance_class;
    int manual_via_rule_index;
    boolean zoom_with_wheel;
    ItemSelectionFilter item_selection_filter;
    SnapShot.Attributes snapshot_attributes;
    private transient boolean read_only;
    private transient ActivityReplayFile activityReplayFile;

    public Settings(RoutingBoard p_board, ActivityReplayFile p_activityReplayFile) {
        this.activityReplayFile = p_activityReplayFile;
        this.layer = 0;
        this.push_enabled = true;
        this.drag_components_enabled = true;
        this.select_on_all_visible_layers = true;
        this.is_stitch_route = false;
        this.trace_pull_tight_region_width = Integer.MAX_VALUE;
        this.via_snap_to_smd_center = true;
        this.horizontal_component_grid = 0;
        this.vertical_component_grid = 0;
        this.manual_rule_selection = false;
        this.hilight_routing_obstacle = false;
        this.manual_trace_clearance_class = 1;
        this.manual_via_rule_index = 0;
        this.zoom_with_wheel = true;
        this.manual_trace_half_width_arr = new int[p_board.get_layer_count()];
        Arrays.fill(this.manual_trace_half_width_arr, 1000);
        this.autoroute_settings = new RouterSettings(p_board);
        this.item_selection_filter = new ItemSelectionFilter();
        this.snapshot_attributes = new SnapShot.Attributes();
    }

    public Settings(Settings p_settings) {
        this.activityReplayFile = p_settings.activityReplayFile;
        this.read_only = p_settings.read_only;
        this.layer = p_settings.layer;
        this.push_enabled = p_settings.push_enabled;
        this.drag_components_enabled = p_settings.drag_components_enabled;
        this.select_on_all_visible_layers = p_settings.select_on_all_visible_layers;
        this.is_stitch_route = p_settings.is_stitch_route;
        this.trace_pull_tight_region_width = p_settings.trace_pull_tight_region_width;
        this.via_snap_to_smd_center = p_settings.via_snap_to_smd_center;
        this.horizontal_component_grid = p_settings.horizontal_component_grid;
        this.vertical_component_grid = p_settings.vertical_component_grid;
        this.manual_rule_selection = p_settings.manual_rule_selection;
        this.hilight_routing_obstacle = p_settings.hilight_routing_obstacle;
        this.zoom_with_wheel = p_settings.zoom_with_wheel;
        this.manual_trace_clearance_class = p_settings.manual_trace_clearance_class;
        this.manual_via_rule_index = p_settings.manual_via_rule_index;
        this.manual_trace_half_width_arr = new int[p_settings.manual_trace_half_width_arr.length];
        System.arraycopy(p_settings.manual_trace_half_width_arr, 0, this.manual_trace_half_width_arr, 0, this.manual_trace_half_width_arr.length);
        this.autoroute_settings = p_settings.autoroute_settings.clone();
        this.item_selection_filter = new ItemSelectionFilter(p_settings.item_selection_filter);
        this.snapshot_attributes = new SnapShot.Attributes(p_settings.snapshot_attributes);
    }

    public int get_layer() {
        return this.layer;
    }

    public boolean get_push_enabled() {
        return this.push_enabled;
    }

    public void set_push_enabled(boolean p_value) {
        if (this.read_only) {
            return;
        }
        this.push_enabled = p_value;
        this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_PUSH_ENABLED, p_value);
    }

    public boolean get_is_stitch_route() {
        return this.is_stitch_route;
    }

    public boolean get_drag_components_enabled() {
        return this.drag_components_enabled;
    }

    public void set_drag_components_enabled(boolean p_value) {
        if (this.read_only) {
            return;
        }
        this.drag_components_enabled = p_value;
        this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_DRAG_COMPONENTS_ENABLED, p_value);
    }

    public boolean get_select_on_all_visible_layers() {
        return this.select_on_all_visible_layers;
    }

    public void set_select_on_all_visible_layers(boolean p_value) {
        if (this.read_only) {
            return;
        }
        this.select_on_all_visible_layers = p_value;
        this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_SELECT_ON_ALL_LAYER, p_value);
    }

    public boolean get_manual_rule_selection() {
        return this.manual_rule_selection;
    }

    public boolean get_via_snap_to_smd_center() {
        return this.via_snap_to_smd_center;
    }

    public void set_via_snap_to_smd_center(boolean p_value) {
        if (this.read_only) {
            return;
        }
        this.via_snap_to_smd_center = p_value;
    }

    public boolean get_hilight_routing_obstacle() {
        return this.hilight_routing_obstacle;
    }

    public void set_hilight_routing_obstacle(boolean p_value) {
        if (this.read_only) {
            return;
        }
        this.hilight_routing_obstacle = p_value;
    }

    public boolean get_zoom_with_wheel() {
        return this.zoom_with_wheel;
    }

    public void set_zoom_with_wheel(boolean p_value) {
        if (this.read_only) {
            return;
        }
        if (this.zoom_with_wheel != p_value) {
            this.zoom_with_wheel = p_value;
            if (this.activityReplayFile != null) {
                this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_ZOOM_WITH_WHEEL, p_value);
            }
        }
    }

    public ItemSelectionFilter get_item_selection_filter() {
        return this.item_selection_filter;
    }

    public void set_item_selection_filter(ItemSelectionFilter p_value) {
        if (this.read_only) {
            return;
        }
        this.item_selection_filter = p_value;
    }

    public int get_trace_pull_tight_region_width() {
        return this.trace_pull_tight_region_width;
    }

    public int get_horizontal_component_grid() {
        return this.horizontal_component_grid;
    }

    public void set_horizontal_component_grid(int p_value) {
        if (this.read_only) {
            return;
        }
        this.horizontal_component_grid = p_value;
    }

    public int get_vertical_component_grid() {
        return this.vertical_component_grid;
    }

    public void set_vertical_component_grid(int p_value) {
        if (this.read_only) {
            return;
        }
        this.vertical_component_grid = p_value;
    }

    public int get_manual_trace_clearance_class() {
        return this.manual_trace_clearance_class;
    }

    public void set_manual_trace_clearance_class(int p_index) {
        if (this.read_only) {
            return;
        }
        this.manual_trace_clearance_class = p_index;
        this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_MANUAL_TRACE_CLEARANCE_CLASS, p_index);
    }

    public int get_manual_via_rule_index() {
        return this.manual_via_rule_index;
    }

    public void set_manual_via_rule_index(int p_value) {
        if (this.read_only) {
            return;
        }
        this.manual_via_rule_index = p_value;
    }

    public SnapShot.Attributes get_snapshot_attributes() {
        return this.snapshot_attributes;
    }

    public int get_manual_trace_half_width(int p_layer_no) {
        if (p_layer_no < 0 || p_layer_no >= this.manual_trace_half_width_arr.length) {
            FRLogger.warn("Settings.get_manual_trace_half_width p_layer_no out of range");
            return 0;
        }
        return this.manual_trace_half_width_arr[p_layer_no];
    }

    public void set_stitch_route(boolean p_value) {
        if (this.read_only) {
            return;
        }
        this.is_stitch_route = p_value;
        this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_STITCH_ROUTE, p_value);
    }

    public void set_current_pull_tight_region_width(int p_value) {
        if (this.read_only) {
            return;
        }
        this.trace_pull_tight_region_width = p_value;
        this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_PULL_TIGHT_REGION_WIDTH, p_value);
    }

    public void set_manual_tracewidth_selection(boolean p_value) {
        if (this.read_only) {
            return;
        }
        this.manual_rule_selection = p_value;
        this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_MANUAL_TRACEWIDTH_SELECTION, p_value);
    }

    public void set_manual_trace_half_width(int p_layer_no, int p_value) {
        if (this.read_only) {
            return;
        }
        this.manual_trace_half_width_arr[p_layer_no] = p_value;
        this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_MANUAL_TRACE_HALF_WIDTH, p_layer_no);
        this.activityReplayFile.add_int(p_value);
    }

    public void set_selectable(ItemSelectionFilter.SelectableChoices p_item_type, boolean p_value) {
        if (this.read_only) {
            return;
        }
        this.item_selection_filter.set_selected(p_item_type, p_value);
        this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_SELECTABLE, p_item_type.ordinal());
        int logged_value = p_value ? 1 : 0;
        this.activityReplayFile.add_int(logged_value);
    }

    public void set_read_only(Boolean p_value) {
        this.read_only = p_value;
    }

    void set_logfile(ActivityReplayFile p_activityReplayFile) {
        this.activityReplayFile = p_activityReplayFile;
    }

    private void readObject(ObjectInputStream p_stream) throws IOException, ClassNotFoundException {
        p_stream.defaultReadObject();
        if (this.item_selection_filter == null) {
            FRLogger.warn("Settings.readObject: item_selection_filter is null");
            this.item_selection_filter = new ItemSelectionFilter();
        }
        if (this.snapshot_attributes == null) {
            FRLogger.warn("Settings.readObject: snapshot_attributes is null");
            this.snapshot_attributes = new SnapShot.Attributes();
        }
        this.read_only = false;
    }
}

