/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.Item;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.SelectRegionState;
import app.freerouting.interactive.SelectedItemState;
import java.util.Set;
import java.util.TreeSet;

public class SelectItemsInRegionState
extends SelectRegionState {
    private SelectItemsInRegionState(InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        super(p_parent_state, p_board_handling, p_activityReplayFile);
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.SELECT_REGION);
        }
    }

    public static SelectItemsInRegionState get_instance(InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        return SelectItemsInRegionState.get_instance(null, p_parent_state, p_board_handling, p_activityReplayFile);
    }

    public static SelectItemsInRegionState get_instance(FloatPoint p_location, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        p_board_handling.display_layer_message();
        SelectItemsInRegionState new_instance = new SelectItemsInRegionState(p_parent_state, p_board_handling, p_activityReplayFile);
        new_instance.corner1 = p_location;
        if (new_instance.activityReplayFile != null) {
            new_instance.activityReplayFile.add_corner(p_location);
        }
        new_instance.hdlg.screen_messages.set_status_message(new_instance.tm.getText("drag_left_mouse_button_to_selects_items_in_region", new String[0]));
        return new_instance;
    }

    @Override
    public InteractiveState complete() {
        if (!this.hdlg.is_board_read_only()) {
            this.hdlg.screen_messages.set_status_message("");
            this.corner2 = this.hdlg.get_current_mouse_position();
            if (this.activityReplayFile != null) {
                this.activityReplayFile.add_corner(this.corner2);
            }
            this.select_all_in_region();
        }
        return this.return_state;
    }

    private void select_all_in_region() {
        boolean something_found;
        IntPoint p1 = this.corner1.round();
        IntPoint p2 = this.corner2.round();
        IntBox b = new IntBox(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.max(p1.x, p2.x), Math.max(p1.y, p2.y));
        int select_layer = this.hdlg.settings.select_on_all_visible_layers ? -1 : this.hdlg.settings.layer;
        Set<Item> found_items = this.hdlg.settings.item_selection_filter.filter(this.hdlg.get_routing_board().overlapping_items(b, select_layer));
        if (this.hdlg.settings.select_on_all_visible_layers) {
            TreeSet<Item> visible_items = new TreeSet<Item>();
            block0: for (Item curr_item : found_items) {
                for (int i = curr_item.first_layer(); i <= curr_item.last_layer(); ++i) {
                    if (!(this.hdlg.graphics_context.get_layer_visibility(i) > 0.0)) continue;
                    visible_items.add(curr_item);
                    continue block0;
                }
            }
            found_items = visible_items;
        }
        boolean bl = something_found = !found_items.isEmpty();
        if (something_found) {
            InteractiveState interactiveState = this.return_state;
            if (interactiveState instanceof SelectedItemState) {
                SelectedItemState state = (SelectedItemState)interactiveState;
                state.get_item_list().addAll(found_items);
            } else {
                this.return_state = SelectedItemState.get_instance(found_items, this.return_state, this.hdlg, this.activityReplayFile);
            }
        } else {
            this.hdlg.screen_messages.set_status_message(this.tm.getText("nothing_selected", new String[0]));
        }
    }
}

