/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.ConductionArea;
import app.freerouting.board.DrillItem;
import app.freerouting.board.Item;
import app.freerouting.board.ItemSelectionFilter;
import app.freerouting.board.Layer;
import app.freerouting.board.LayerStructure;
import app.freerouting.board.Pin;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.Trace;
import app.freerouting.board.Via;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.DynamicRouteState;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.MenuState;
import app.freerouting.interactive.Route;
import app.freerouting.interactive.StitchRouteState;
import app.freerouting.logger.FRLogger;
import app.freerouting.rules.Net;
import java.awt.Graphics;
import java.util.Set;
import java.util.TreeSet;

public class RouteState
extends InteractiveState {
    protected Route route;
    protected boolean observers_activated;
    private Set<Item> routing_target_set;

    protected RouteState(InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        super(p_parent_state, p_board_handling, p_activityReplayFile);
    }

    /*
     * Unable to fully structure code
     */
    public static RouteState get_instance(FloatPoint p_location, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        block20: {
            block19: {
                if (!(p_parent_state instanceof MenuState)) {
                    FRLogger.warn("RouteState.get_instance: unexpected parent state");
                }
                p_board_handling.display_layer_message();
                location = p_location.round();
                picked_item = RouteState.start_ok(location, p_board_handling);
                if (picked_item == null) {
                    return null;
                }
                net_count = picked_item.net_count();
                if (net_count <= 0) {
                    return null;
                }
                if (!(picked_item instanceof Pin)) ** GOTO lbl-1000
                pin = (Pin)picked_item;
                if (net_count > 1) {
                    route_net_no_arr = RouteState.get_route_net_numbers_at_tie_pin(pin, p_board_handling.settings.layer);
                } else lbl-1000:
                // 2 sources

                {
                    route_net_no_arr = new int[net_count];
                    for (i = 0; i < net_count; ++i) {
                        route_net_no_arr[i] = picked_item.get_net_no(i);
                    }
                }
                if (route_net_no_arr.length == 0) {
                    return null;
                }
                routing_board = p_board_handling.get_routing_board();
                trace_half_widths = new int[routing_board.get_layer_count()];
                layer_active_arr = new boolean[trace_half_widths.length];
                for (i = 0; i < trace_half_widths.length; ++i) {
                    trace_half_widths[i] = p_board_handling.get_trace_halfwidth(route_net_no_arr[0], i);
                    layer_active_arr[i] = false;
                    for (j = 0; j < route_net_no_arr.length; ++j) {
                        if (!p_board_handling.is_active_routing_layer(route_net_no_arr[j], i)) continue;
                        layer_active_arr[i] = true;
                    }
                }
                trace_clearance_class = p_board_handling.get_trace_clearance_class(route_net_no_arr[0]);
                start_ok = true;
                if (!(picked_item instanceof Trace)) break block19;
                picked_trace = (Trace)picked_item;
                picked_corner = picked_trace.nearest_end_point(location);
                if (!(picked_corner instanceof IntPoint)) ** GOTO lbl-1000
                point = (IntPoint)picked_corner;
                if (p_location.distance(picked_corner.to_float()) < (double)(5 * picked_trace.get_half_width())) {
                    location = point;
                } else lbl-1000:
                // 2 sources

                {
                    if (picked_trace instanceof PolylineTrace) {
                        trace = (PolylineTrace)picked_trace;
                        nearest_point = trace.polyline().nearest_point_approx(p_location);
                        location = nearest_point.round();
                    }
                    if (!routing_board.connect_to_trace(location, picked_trace, picked_trace.get_half_width(), picked_trace.clearance_class_no())) {
                        start_ok = false;
                    }
                }
                if (start_ok && !p_board_handling.settings.manual_rule_selection) {
                    new_trace_half_widths = new int[trace_half_widths.length];
                    System.arraycopy(trace_half_widths, 0, new_trace_half_widths, 0, trace_half_widths.length);
                    new_trace_half_widths[picked_trace.get_layer()] = picked_trace.get_half_width();
                    trace_half_widths = new_trace_half_widths;
                    trace_clearance_class = picked_trace.clearance_class_no();
                }
                break block20;
            }
            if (picked_item instanceof DrillItem && (center = (drill_item = (DrillItem)picked_item).get_center()) instanceof IntPoint) {
                location = point = (IntPoint)center;
            }
        }
        if (!start_ok) {
            return null;
        }
        curr_net = routing_board.rules.nets.get(route_net_no_arr[0]);
        if (curr_net == null) {
            return null;
        }
        is_stitch_route = p_board_handling.settings.is_stitch_route != false || curr_net.get_class().is_shove_fixed() != false || curr_net.get_class().get_pull_tight() == false;
        routing_board.generate_snapshot();
        new_instance = is_stitch_route != false ? new StitchRouteState(p_parent_state, p_board_handling, p_activityReplayFile) : new DynamicRouteState(p_parent_state, p_board_handling, p_activityReplayFile);
        new_instance.routing_target_set = picked_item.get_unconnected_set(-1);
        new_instance.route = new Route(location, p_board_handling.settings.layer, trace_half_widths, layer_active_arr, route_net_no_arr, trace_clearance_class, p_board_handling.get_via_rule(route_net_no_arr[0]), p_board_handling.settings.push_enabled, p_board_handling.settings.trace_pull_tight_region_width, p_board_handling.settings.autoroute_settings.trace_pull_tight_accuracy, picked_item, new_instance.routing_target_set, routing_board, is_stitch_route, p_board_handling.settings.autoroute_settings.get_automatic_neckdown(), p_board_handling.settings.via_snap_to_smd_center, p_board_handling.settings.hilight_routing_obstacle);
        v0 = new_instance.observers_activated = routing_board.observers_active() == false;
        if (new_instance.observers_activated) {
            routing_board.start_notify_observers();
        }
        p_board_handling.repaint();
        if (new_instance.activityReplayFile != null) {
            new_instance.activityReplayFile.start_scope(ActivityReplayFileScope.CREATING_TRACE, p_location);
            p_board_handling.hide_ratsnest();
        }
        new_instance.display_default_message();
        return new_instance;
    }

    protected static Item start_ok(IntPoint p_location, GuiBoardManager p_hdlg) {
        RoutingBoard routing_board = p_hdlg.get_routing_board();
        Item picked_item = routing_board.pick_nearest_routing_item(p_location, p_hdlg.settings.layer, null);
        int layer_count = routing_board.get_layer_count();
        if (picked_item == null && p_hdlg.settings.select_on_all_visible_layers) {
            int i;
            picked_item = RouteState.pick_routing_item(p_location, 0, p_hdlg);
            if (picked_item == null) {
                picked_item = RouteState.pick_routing_item(p_location, layer_count - 1, p_hdlg);
            }
            if (picked_item == null) {
                for (i = 1; !(i >= layer_count - 1 || routing_board.layer_structure.arr[i].is_signal && (picked_item = RouteState.pick_routing_item(p_location, i, p_hdlg)) != null); ++i) {
                }
            }
            if (picked_item == null) {
                for (i = 1; i < layer_count - 1 && (routing_board.layer_structure.arr[i].is_signal || (picked_item = RouteState.pick_routing_item(p_location, i, p_hdlg)) == null); ++i) {
                }
            }
        }
        return picked_item;
    }

    private static Item pick_routing_item(IntPoint p_location, int p_layer_no, GuiBoardManager p_hdlg) {
        if (p_layer_no == p_hdlg.settings.layer || p_hdlg.graphics_context.get_layer_visibility(p_layer_no) <= 0.0) {
            return null;
        }
        Item picked_item = p_hdlg.get_routing_board().pick_nearest_routing_item(p_location, p_layer_no, null);
        if (picked_item != null) {
            p_hdlg.set_layer(picked_item.first_layer());
        }
        return picked_item;
    }

    static int[] get_route_net_numbers_at_tie_pin(Pin p_pin, int p_layer) {
        TreeSet<Integer> net_number_list = new TreeSet<Integer>();
        for (int i = 0; i < p_pin.net_count(); ++i) {
            net_number_list.add(p_pin.get_net_no(i));
        }
        Set<Item> contacts = p_pin.get_normal_contacts();
        for (Item curr_contact : contacts) {
            if (curr_contact.first_layer() > p_layer || curr_contact.last_layer() < p_layer) continue;
            for (int i = 0; i < curr_contact.net_count(); ++i) {
                net_number_list.remove(curr_contact.get_net_no(i));
            }
        }
        int[] result = new int[net_number_list.size()];
        int curr_ind = 0;
        for (Integer curr_net_number : net_number_list) {
            result[curr_ind] = curr_net_number;
            ++curr_ind;
        }
        return result;
    }

    @Override
    public InteractiveState process_logfile_point(FloatPoint p_point) {
        return this.add_corner(p_point);
    }

    @Override
    public InteractiveState key_typed(char p_key_char) {
        InteractiveState curr_return_state = this;
        if (Character.isDigit(p_key_char)) {
            LayerStructure layer_structure = this.hdlg.get_routing_board().layer_structure;
            int d = Character.digit(p_key_char, 10);
            d = Math.min(d, layer_structure.signal_layer_count());
            d = Math.max(d - 1, 0);
            Layer new_layer = layer_structure.get_signal_layer(d);
            if ((d = layer_structure.get_no(new_layer)) >= 0) {
                this.change_layer_action(d);
            }
        } else if (p_key_char == '+') {
            LayerStructure layer_structure = this.hdlg.get_routing_board().layer_structure;
            int current_layer_no = this.hdlg.settings.layer;
            while (++current_layer_no < layer_structure.arr.length && !layer_structure.arr[current_layer_no].is_signal) {
            }
            if (current_layer_no < layer_structure.arr.length) {
                this.change_layer_action(current_layer_no);
            }
        } else if (p_key_char == '-') {
            LayerStructure layer_structure = this.hdlg.get_routing_board().layer_structure;
            int current_layer_no = this.hdlg.settings.layer;
            while (--current_layer_no >= 0 && !layer_structure.arr[current_layer_no].is_signal) {
            }
            if (current_layer_no >= 0) {
                this.change_layer_action(current_layer_no);
            }
        } else {
            curr_return_state = super.key_typed(p_key_char);
        }
        return curr_return_state;
    }

    public InteractiveState add_corner(FloatPoint p_location) {
        InteractiveState result;
        boolean route_completed = this.route.next_corner(p_location);
        String layer_string = this.hdlg.get_routing_board().layer_structure.arr[this.route.nearest_target_layer()].name;
        this.hdlg.screen_messages.set_target_layer(layer_string);
        if (this.activityReplayFile != null) {
            this.activityReplayFile.add_corner(p_location);
        }
        if (route_completed && this.observers_activated) {
            this.hdlg.get_routing_board().end_notify_observers();
            this.observers_activated = false;
        }
        if (route_completed) {
            result = this.return_state;
            this.hdlg.screen_messages.clear();
            for (int curr_net_no : this.route.net_no_arr) {
                this.hdlg.update_ratsnest(curr_net_no);
            }
        } else {
            result = this;
        }
        this.hdlg.recalculate_length_violations();
        this.hdlg.repaint(this.hdlg.get_graphics_update_rectangle());
        return result;
    }

    @Override
    public InteractiveState cancel() {
        Trace tail = this.hdlg.get_routing_board().get_trace_tail(this.route.get_last_corner(), this.hdlg.settings.layer, this.route.net_no_arr);
        if (tail != null) {
            Set<Item> remove_items = tail.get_connection_items(Item.StopConnectionOption.VIA);
            if (this.hdlg.settings.push_enabled) {
                this.hdlg.get_routing_board().remove_items_and_pull_tight(remove_items, this.hdlg.settings.trace_pull_tight_region_width, this.hdlg.settings.autoroute_settings.trace_pull_tight_accuracy);
            } else {
                this.hdlg.get_routing_board().remove_items(remove_items);
            }
        }
        if (this.observers_activated) {
            this.hdlg.get_routing_board().end_notify_observers();
            this.observers_activated = false;
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.CANCEL_SCOPE);
        }
        this.hdlg.screen_messages.clear();
        for (int curr_net_no : this.route.net_no_arr) {
            this.hdlg.update_ratsnest(curr_net_no);
        }
        return this.return_state;
    }

    @Override
    public boolean change_layer_action(int p_new_layer) {
        boolean result = true;
        if (p_new_layer >= 0 && p_new_layer < this.hdlg.get_routing_board().get_layer_count()) {
            boolean change_layer_succeeded;
            if (this.route != null && !this.route.is_layer_active(p_new_layer)) {
                String layer_name = this.hdlg.get_routing_board().layer_structure.arr[p_new_layer].name;
                this.hdlg.screen_messages.set_status_message(this.tm.getText("layer_not_changed_because_layer", new String[0]) + " " + layer_name + " " + this.tm.getText("is_not_active_for_the_current_net", new String[0]));
            }
            if (change_layer_succeeded = this.route.change_layer(p_new_layer)) {
                boolean connected_to_plane = false;
                int old_layer = this.hdlg.settings.get_layer();
                ItemSelectionFilter selection_filter = new ItemSelectionFilter(ItemSelectionFilter.SelectableChoices.VIAS);
                Set<Item> picked_items = this.hdlg.get_routing_board().pick_items(this.route.get_last_corner(), old_layer, selection_filter);
                Via new_via = null;
                for (Item curr_via : picked_items) {
                    if (!curr_via.shares_net_no(this.route.net_no_arr)) continue;
                    new_via = (Via)curr_via;
                    break;
                }
                if (new_via != null) {
                    int to_layer;
                    int from_layer;
                    if (old_layer < p_new_layer) {
                        from_layer = old_layer + 1;
                        to_layer = p_new_layer;
                    } else {
                        from_layer = p_new_layer;
                        to_layer = old_layer - 1;
                    }
                    Set<Item> contacts = new_via.get_normal_contacts();
                    for (Item curr_item : contacts) {
                        ConductionArea curr_area;
                        if (!(curr_item instanceof ConductionArea) || (curr_area = (ConductionArea)curr_item).get_layer() < from_layer || curr_area.get_layer() > to_layer) continue;
                        connected_to_plane = true;
                        break;
                    }
                }
                if (connected_to_plane) {
                    this.hdlg.set_interactive_state(this.return_state);
                    for (int curr_net_no : this.route.net_no_arr) {
                        this.hdlg.update_ratsnest(curr_net_no);
                    }
                } else {
                    this.hdlg.set_layer(p_new_layer);
                    String layer_name = this.hdlg.get_routing_board().layer_structure.arr[p_new_layer].name;
                    this.hdlg.screen_messages.set_status_message(this.tm.getText("layer_changed_to", new String[0]) + " " + layer_name);
                    this.hdlg.get_routing_board().generate_snapshot();
                }
                if (this.activityReplayFile != null) {
                    this.activityReplayFile.start_scope(ActivityReplayFileScope.CHANGE_LAYER, p_new_layer);
                }
            } else {
                int shove_failing_layer = this.hdlg.get_routing_board().get_shove_failing_layer();
                if (shove_failing_layer >= 0) {
                    String layer_name = this.hdlg.get_routing_board().layer_structure.arr[this.hdlg.get_routing_board().get_shove_failing_layer()].name;
                    this.hdlg.screen_messages.set_status_message(this.tm.getText("layer_not_changed_because_of_obstacle_on_layer", new String[0]) + " " + layer_name);
                } else {
                    FRLogger.warn("RouteState.change_layer_action: shove_failing_layer not set");
                }
                result = false;
            }
            this.hdlg.repaint();
        }
        return result;
    }

    @Override
    public void draw(Graphics p_graphics) {
        if (this.route != null) {
            this.route.draw(p_graphics, this.hdlg.graphics_context);
        }
    }

    @Override
    public void display_default_message() {
        if (this.route != null) {
            Net curr_net = this.hdlg.get_routing_board().rules.nets.get(this.route.net_no_arr[0]);
            this.hdlg.screen_messages.set_status_message(this.tm.getText("routing_net", new String[0]) + " " + curr_net.name);
        }
    }
}

