/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.AngleRestriction;
import app.freerouting.board.ConductionArea;
import app.freerouting.board.DrillItem;
import app.freerouting.board.Item;
import app.freerouting.board.ItemSelectionFilter;
import app.freerouting.board.Pin;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.Trace;
import app.freerouting.board.Unit;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.core.Padstack;
import app.freerouting.datastructures.TimeLimit;
import app.freerouting.geometry.planar.Area;
import app.freerouting.geometry.planar.Ellipse;
import app.freerouting.geometry.planar.FloatLine;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.interactive.NetIncompletes;
import app.freerouting.logger.FRLogger;
import app.freerouting.rules.Net;
import app.freerouting.rules.ViaInfo;
import app.freerouting.rules.ViaRule;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class Route {
    private static final int CHECK_FORCED_TRACE_TIME_LIMIT = 3000;
    private static final int PULL_TIGHT_TIME_LIMIT = 2000;
    final int[] net_no_arr;
    private final Item start_item;
    private final Set<Item> target_set;
    private final Set<SwapPinInfo> swap_pin_infos;
    private final int[] pen_half_width_arr;
    private final boolean[] layer_active;
    private final int clearance_class;
    private final ViaRule via_rule;
    private final int max_shove_trace_recursion_depth;
    private final int max_shove_via_recursion_depth;
    private final int max_spring_over_recursion_depth;
    private final int trace_tidy_width;
    private final int pull_tight_accuracy;
    private final RoutingBoard board;
    private final boolean is_stitch_mode;
    private final boolean with_neckdown;
    private final boolean via_snap_to_smd_center;
    private final boolean hilight_shove_failing_obstacle;
    private final int pull_tight_time_limit;
    private Point prev_corner;
    private int layer;
    private Collection<TargetPoint> target_points;
    private Collection<Item> target_traces_and_areas;
    private FloatPoint nearest_target_point;
    private Item nearest_target_item;
    private Item shove_failing_obstacle;

    public Route(Point p_start_corner, int p_layer, int[] p_pen_half_width_arr, boolean[] p_layer_active_arr, int[] p_net_no_arr, int p_clearance_class, ViaRule p_via_rule, boolean p_push_enabled, int p_trace_tidy_width, int p_pull_tight_accuracy, Item p_start_item, Set<Item> p_target_set, RoutingBoard p_board, boolean p_is_stitch_mode, boolean p_with_neckdown, boolean p_via_snap_to_smd_center, boolean p_hilight_shove_failing_obstacle) {
        this.board = p_board;
        this.layer = p_layer;
        if (p_push_enabled) {
            this.max_shove_trace_recursion_depth = 20;
            this.max_shove_via_recursion_depth = 8;
            this.max_spring_over_recursion_depth = 5;
        } else {
            this.max_shove_trace_recursion_depth = 0;
            this.max_shove_via_recursion_depth = 0;
            this.max_spring_over_recursion_depth = 0;
        }
        this.trace_tidy_width = p_trace_tidy_width;
        this.pull_tight_accuracy = p_pull_tight_accuracy;
        this.prev_corner = p_start_corner;
        this.net_no_arr = p_net_no_arr;
        this.pen_half_width_arr = p_pen_half_width_arr;
        this.layer_active = p_layer_active_arr;
        this.clearance_class = p_clearance_class;
        this.via_rule = p_via_rule;
        this.start_item = p_start_item;
        this.target_set = p_target_set;
        this.is_stitch_mode = p_is_stitch_mode;
        this.with_neckdown = p_with_neckdown;
        this.via_snap_to_smd_center = p_via_snap_to_smd_center;
        this.hilight_shove_failing_obstacle = p_hilight_shove_failing_obstacle;
        this.pull_tight_time_limit = 2000;
        this.calculate_target_points_and_areas();
        this.swap_pin_infos = this.calculate_swap_pin_infos();
    }

    public boolean next_corner(FloatPoint p_corner) {
        DrillItem target;
        if (!this.layer_active[this.layer]) {
            return false;
        }
        IntPoint curr_corner = p_corner.round();
        if (!(this.board.contains(this.prev_corner) && this.board.contains(curr_corner) && this.board.layer_structure.arr[this.layer].is_signal)) {
            return false;
        }
        if (curr_corner.equals(this.prev_corner)) {
            return false;
        }
        Item item = this.nearest_target_item;
        if (item instanceof DrillItem && this.prev_corner.equals((target = (DrillItem)item).get_center())) {
            return true;
        }
        this.shove_failing_obstacle = null;
        AngleRestriction angle_restriction = this.board.rules.get_trace_angle_restriction();
        if (angle_restriction != AngleRestriction.NONE && !(this.prev_corner instanceof IntPoint)) {
            return false;
        }
        if (angle_restriction == AngleRestriction.NINETY_DEGREE) {
            curr_corner = curr_corner.orthogonal_projection((IntPoint)this.prev_corner);
        } else if (angle_restriction == AngleRestriction.FORTYFIVE_DEGREE) {
            curr_corner = curr_corner.fortyfive_degree_projection((IntPoint)this.prev_corner);
        }
        Item end_routing_item = this.board.pick_nearest_routing_item(this.prev_corner, this.layer, null);
        this.nearest_target_item = this.board.pick_nearest_routing_item(curr_corner, this.layer, end_routing_item);
        TimeLimit check_forced_trace_time_limit = this.is_stitch_mode ? null : new TimeLimit(3000);
        Point ok_point = this.board.insert_forced_trace_segment(this.prev_corner, curr_corner, this.pen_half_width_arr[this.layer], this.layer, this.net_no_arr, this.clearance_class, this.max_shove_trace_recursion_depth, this.max_shove_via_recursion_depth, this.max_spring_over_recursion_depth, this.trace_tidy_width, this.pull_tight_accuracy, !this.is_stitch_mode, check_forced_trace_time_limit);
        if (ok_point == this.prev_corner && this.with_neckdown) {
            ok_point = this.try_neckdown_at_start(curr_corner);
        }
        if (ok_point == this.prev_corner && this.with_neckdown) {
            ok_point = this.try_neckdown_at_end(this.prev_corner, curr_corner);
        }
        if (ok_point == null) {
            this.board.undo(null);
            return !this.is_stitch_mode;
        }
        if (ok_point == this.prev_corner) {
            this.set_shove_failing_obstacle(this.board.get_shove_failing_obstacle());
            return false;
        }
        this.prev_corner = ok_point;
        boolean route_completed = false;
        if (ok_point == curr_corner) {
            route_completed = this.connect_to_target(curr_corner);
        }
        IntOctagon tidy_clip_shape = this.trace_tidy_width == Integer.MAX_VALUE ? null : (this.trace_tidy_width == 0 ? IntOctagon.EMPTY : ok_point.surrounding_octagon().enlarge(this.trace_tidy_width));
        int[] opt_net_no_arr = this.max_shove_trace_recursion_depth <= 0 ? this.net_no_arr : new int[]{};
        if (route_completed) {
            this.board.reduce_nets_of_route_items();
            for (int curr_net_no : this.net_no_arr) {
                this.board.combine_traces(curr_net_no);
            }
        } else {
            this.calc_nearest_target_point(this.prev_corner.to_float());
        }
        this.board.opt_changed_area(opt_net_no_arr, tidy_clip_shape, this.pull_tight_accuracy, null, null, this.pull_tight_time_limit, ok_point, this.layer);
        return route_completed;
    }

    public boolean change_layer(int p_to_layer) {
        boolean snapped_to_smd_center;
        if (this.layer == p_to_layer) {
            return true;
        }
        if (p_to_layer < 0 || p_to_layer >= this.layer_active.length) {
            FRLogger.warn("Route.change_layer: p_to_layer out of range");
            return false;
        }
        if (!this.layer_active[p_to_layer]) {
            return false;
        }
        if (this.via_rule == null) {
            return false;
        }
        this.shove_failing_obstacle = null;
        if (this.via_snap_to_smd_center && !(snapped_to_smd_center = this.snap_to_smd_center(p_to_layer))) {
            this.snap_to_smd_center(this.layer);
        }
        boolean result = true;
        int min_layer = Math.min(this.layer, p_to_layer);
        int max_layer = Math.max(this.layer, p_to_layer);
        boolean via_found = false;
        for (int i = 0; i < this.via_rule.via_count(); ++i) {
            ViaInfo curr_via_info = this.via_rule.get_via(i);
            Padstack curr_via_padstack = curr_via_info.get_padstack();
            if (min_layer < curr_via_padstack.from_layer() || max_layer > curr_via_padstack.to_layer()) continue;
            this.board.generate_snapshot();
            result = this.board.forced_via(curr_via_info, this.prev_corner, this.net_no_arr, this.clearance_class, this.pen_half_width_arr, this.max_shove_trace_recursion_depth, 0, this.trace_tidy_width, this.pull_tight_accuracy, this.pull_tight_time_limit);
            if (result) {
                via_found = true;
                break;
            }
            this.set_shove_failing_obstacle(this.board.get_shove_failing_obstacle());
            this.board.undo(null);
        }
        if (via_found) {
            this.layer = p_to_layer;
        }
        return result;
    }

    private boolean snap_to_smd_center(int p_layer) {
        ItemSelectionFilter selection_filter = new ItemSelectionFilter(ItemSelectionFilter.SelectableChoices.PINS);
        Set<Item> picked_items = this.board.pick_items(this.prev_corner, p_layer, selection_filter);
        Pin found_smd_pin = null;
        for (Item curr_item : picked_items) {
            if (!(curr_item instanceof Pin)) continue;
            Pin curr_pin = (Pin)curr_item;
            if (!curr_item.shares_net_no(this.net_no_arr) || curr_pin.first_layer() != p_layer || curr_pin.last_layer() != p_layer) continue;
            found_smd_pin = curr_pin;
            break;
        }
        if (found_smd_pin == null) {
            return false;
        }
        Point pin_center = found_smd_pin.get_center();
        if (!(pin_center instanceof IntPoint)) {
            return false;
        }
        IntPoint to_corner = (IntPoint)pin_center;
        if (this.connect(this.prev_corner, to_corner)) {
            this.prev_corner = to_corner;
        }
        return true;
    }

    private boolean connect_to_target(IntPoint p_from_point) {
        if (this.nearest_target_item != null && this.target_set != null && !this.target_set.contains(this.nearest_target_item)) {
            this.nearest_target_item = null;
        }
        if (this.nearest_target_item == null || !this.nearest_target_item.shares_net_no(this.net_no_arr)) {
            return false;
        }
        boolean route_completed = false;
        Point connection_point = null;
        Item item = this.nearest_target_item;
        if (item instanceof DrillItem) {
            DrillItem target = (DrillItem)item;
            connection_point = target.get_center();
        } else {
            item = this.nearest_target_item;
            if (item instanceof PolylineTrace) {
                PolylineTrace trace = (PolylineTrace)item;
                return this.board.connect_to_trace(p_from_point, trace, this.pen_half_width_arr[this.layer], this.clearance_class);
            }
            if (this.nearest_target_item instanceof ConductionArea) {
                connection_point = p_from_point;
            }
        }
        if (connection_point instanceof IntPoint) {
            IntPoint point = (IntPoint)connection_point;
            route_completed = this.connect(p_from_point, point);
        }
        return route_completed;
    }

    private boolean connect(Point p_from_point, IntPoint p_to_point) {
        Point[] corners = this.angled_connection(p_from_point, p_to_point);
        boolean connection_succeeded = true;
        block0: for (int i = 1; i < corners.length; ++i) {
            Point from_corner = corners[i - 1];
            Point to_corner = corners[i];
            TimeLimit time_limit = new TimeLimit(3000);
            while (!from_corner.equals(to_corner)) {
                Point curr_ok_point = this.board.insert_forced_trace_segment(from_corner, to_corner, this.pen_half_width_arr[this.layer], this.layer, this.net_no_arr, this.clearance_class, this.max_shove_trace_recursion_depth, this.max_shove_via_recursion_depth, this.max_spring_over_recursion_depth, this.trace_tidy_width, this.pull_tight_accuracy, !this.is_stitch_mode, time_limit);
                if (curr_ok_point == null) {
                    this.board.undo(null);
                    return true;
                }
                if (curr_ok_point.equals(from_corner) && this.with_neckdown) {
                    curr_ok_point = this.try_neckdown_at_end(from_corner, to_corner);
                }
                if (curr_ok_point.equals(from_corner)) {
                    this.prev_corner = from_corner;
                    connection_succeeded = false;
                    continue block0;
                }
                from_corner = curr_ok_point;
            }
        }
        return connection_succeeded;
    }

    public int nearest_target_layer() {
        if (this.nearest_target_item == null) {
            return this.layer;
        }
        int first_layer = this.nearest_target_item.first_layer();
        int last_layer = this.nearest_target_item.last_layer();
        int result = this.layer < first_layer ? first_layer : Math.min(this.layer, last_layer);
        return result;
    }

    private Set<SwapPinInfo> calculate_swap_pin_infos() {
        TreeSet<SwapPinInfo> result = new TreeSet<SwapPinInfo>();
        if (this.target_set == null) {
            return result;
        }
        for (Item curr_item : this.target_set) {
            if (!(curr_item instanceof Pin)) continue;
            Pin pin = (Pin)curr_item;
            Set<Pin> curr_swappable_pins = pin.get_swappable_pins();
            for (Pin curr_swappable_pin : curr_swappable_pins) {
                result.add(new SwapPinInfo(this, curr_swappable_pin));
            }
        }
        ItemSelectionFilter selection_filter = new ItemSelectionFilter(ItemSelectionFilter.SelectableChoices.PINS);
        Set<Item> picked_items = this.board.pick_items(this.prev_corner, this.layer, selection_filter);
        for (Item curr_item : picked_items) {
            if (!(curr_item instanceof Pin)) continue;
            Pin pin = (Pin)curr_item;
            Set<Pin> curr_swappable_pins = pin.get_swappable_pins();
            for (Pin curr_swappable_pin : curr_swappable_pins) {
                result.add(new SwapPinInfo(this, curr_swappable_pin));
            }
        }
        return result;
    }

    public void draw(Graphics p_graphics, GraphicsContext p_graphics_context) {
        if (this.hilight_shove_failing_obstacle && this.shove_failing_obstacle != null) {
            this.shove_failing_obstacle.draw(p_graphics, p_graphics_context, p_graphics_context.get_violations_color(), 1.0);
        }
        if (this.target_set == null || this.net_no_arr.length < 1) {
            return;
        }
        Net curr_net = this.board.rules.nets.get(this.net_no_arr[0]);
        if (curr_net == null) {
            return;
        }
        Color highlight_color = p_graphics_context.get_hilight_color();
        double highligt_color_intensity = p_graphics_context.get_hilight_color_intensity();
        for (SwapPinInfo curr_info : this.swap_pin_infos) {
            curr_info.pin.draw(p_graphics, p_graphics_context, highlight_color, 0.3 * highligt_color_intensity);
            if (curr_info.incomplete == null) continue;
            FloatPoint[] draw_points = new FloatPoint[]{curr_info.incomplete.a, curr_info.incomplete.b};
            Color draw_color = p_graphics_context.get_incomplete_color();
            p_graphics_context.draw(draw_points, 1.0, draw_color, p_graphics, highligt_color_intensity);
        }
        for (Item curr_item : this.target_set) {
            if (curr_item instanceof ConductionArea) continue;
            curr_item.draw(p_graphics, p_graphics_context, highlight_color, highligt_color_intensity);
        }
        FloatPoint from_corner = this.prev_corner.to_float();
        if (this.nearest_target_point != null && this.prev_corner != null) {
            boolean curr_length_matching_ok = true;
            double max_trace_length = curr_net.get_class().get_maximum_trace_length();
            double min_trace_length = curr_net.get_class().get_minimum_trace_length();
            double length_matching_color_intensity = p_graphics_context.get_length_matching_area_color_intensity();
            if (max_trace_length > 0.0 || min_trace_length > 0.0 && length_matching_color_intensity > 0.0) {
                double trace_length_add = from_corner.distance(this.prev_corner.to_float());
                if (max_trace_length <= 0.0) {
                    max_trace_length = 1.00663296E7;
                }
                double curr_max_trace_length = max_trace_length - (curr_net.get_trace_length() + trace_length_add);
                double curr_min_trace_length = min_trace_length - (curr_net.get_trace_length() + trace_length_add);
                double incomplete_length = this.nearest_target_point.distance(from_corner);
                if (incomplete_length < curr_max_trace_length && min_trace_length <= max_trace_length) {
                    Vector delta = this.nearest_target_point.round().difference_by(this.prev_corner);
                    double rotation = delta.angle_approx();
                    FloatPoint center = from_corner.middle_point(this.nearest_target_point);
                    double bigger_radius = 0.5 * curr_max_trace_length;
                    double smaller_radius = 0.5 * Math.sqrt(curr_max_trace_length * curr_max_trace_length - incomplete_length * incomplete_length);
                    int ellipse_count = min_trace_length <= 0.0 || incomplete_length >= curr_min_trace_length ? 1 : 2;
                    Ellipse[] ellipse_arr = new Ellipse[ellipse_count];
                    ellipse_arr[0] = new Ellipse(center, rotation, bigger_radius, smaller_radius);
                    IntBox bounding_box = new IntBox(this.prev_corner.to_float().round(), this.nearest_target_point.round());
                    bounding_box = bounding_box.offset(curr_max_trace_length - incomplete_length);
                    this.board.join_graphics_update_box(bounding_box);
                    if (ellipse_count == 2) {
                        bigger_radius = 0.5 * curr_min_trace_length;
                        smaller_radius = 0.5 * Math.sqrt(curr_min_trace_length * curr_min_trace_length - incomplete_length * incomplete_length);
                        ellipse_arr[1] = new Ellipse(center, rotation, bigger_radius, smaller_radius);
                    }
                    p_graphics_context.fill_ellipse_arr(ellipse_arr, p_graphics, p_graphics_context.get_length_matching_area_color(), length_matching_color_intensity);
                } else {
                    curr_length_matching_ok = false;
                }
            }
            FloatPoint[] draw_points = new FloatPoint[]{from_corner, this.nearest_target_point};
            Color draw_color = p_graphics_context.get_incomplete_color();
            double draw_width = Math.min(this.board.communication.get_resolution(Unit.MIL), 100.0);
            if (!curr_length_matching_ok) {
                draw_color = p_graphics_context.get_violations_color();
                draw_width *= 3.0;
            }
            p_graphics_context.draw(draw_points, draw_width, draw_color, p_graphics, highligt_color_intensity);
            if (this.nearest_target_item != null && !this.nearest_target_item.is_on_layer(this.layer)) {
                NetIncompletes.draw_layer_change_marker(draw_points[0], 4 * this.pen_half_width_arr[0], p_graphics, p_graphics_context);
            }
        }
    }

    private Point[] angled_connection(Point p_from_point, Point p_to_point) {
        IntPoint add_corner = null;
        if (p_from_point instanceof IntPoint) {
            IntPoint point = (IntPoint)p_from_point;
            if (p_to_point instanceof IntPoint) {
                IntPoint point1 = (IntPoint)p_to_point;
                AngleRestriction angle_restriction = this.board.rules.get_trace_angle_restriction();
                if (angle_restriction == AngleRestriction.NINETY_DEGREE) {
                    add_corner = point.ninety_degree_corner(point1, true);
                } else if (angle_restriction == AngleRestriction.FORTYFIVE_DEGREE) {
                    add_corner = point.fortyfive_degree_corner(point1, true);
                }
            }
        }
        int new_corner_count = 2;
        if (add_corner != null) {
            ++new_corner_count;
        }
        Point[] result = new Point[new_corner_count];
        result[0] = p_from_point;
        if (add_corner != null) {
            result[1] = add_corner;
        }
        result[result.length - 1] = p_to_point;
        return result;
    }

    private void calculate_target_points_and_areas() {
        this.target_points = new LinkedList<TargetPoint>();
        this.target_traces_and_areas = new LinkedList<Item>();
        if (this.target_set == null) {
            return;
        }
        for (Item curr_ob : this.target_set) {
            if (curr_ob instanceof DrillItem) {
                DrillItem item = (DrillItem)curr_ob;
                Point curr_point = item.get_center();
                this.target_points.add(new TargetPoint(curr_point.to_float(), curr_ob));
                continue;
            }
            if (!(curr_ob instanceof Trace) && !(curr_ob instanceof ConductionArea)) continue;
            this.target_traces_and_areas.add(curr_ob);
        }
    }

    public Point get_last_corner() {
        return this.prev_corner;
    }

    public boolean is_layer_active(int p_layer) {
        if (p_layer < 0 || p_layer >= this.layer_active.length) {
            return false;
        }
        return this.layer_active[p_layer];
    }

    void calc_nearest_target_point(FloatPoint p_from_point) {
        double min_dist = Double.MAX_VALUE;
        FloatPoint nearest_point = null;
        Item nearest_item = null;
        for (TargetPoint curr_target_point : this.target_points) {
            double curr_dist = p_from_point.distance(curr_target_point.location);
            if (!(curr_dist < min_dist)) continue;
            min_dist = curr_dist;
            nearest_point = curr_target_point.location;
            nearest_item = curr_target_point.item;
        }
        for (Item curr_item : this.target_traces_and_areas) {
            Area curr_area;
            FloatPoint curr_nearest_point;
            double curr_dist;
            if (curr_item instanceof PolylineTrace) {
                PolylineTrace curr_trace = (PolylineTrace)curr_item;
                Polyline curr_polyline = curr_trace.polyline();
                if (!(curr_polyline.bounding_box().distance(p_from_point) < min_dist) || !((curr_dist = p_from_point.distance(curr_nearest_point = curr_polyline.nearest_point_approx(p_from_point))) < min_dist)) continue;
                min_dist = curr_dist;
                nearest_point = curr_nearest_point;
                nearest_item = curr_trace;
                continue;
            }
            if (!(curr_item instanceof ConductionArea)) continue;
            ConductionArea curr_conduction_area = (ConductionArea)curr_item;
            if (curr_item.tile_shape_count() <= 0 || !((curr_area = curr_conduction_area.get_area()).bounding_box().distance(p_from_point) < min_dist) || !((curr_dist = p_from_point.distance(curr_nearest_point = curr_area.nearest_point_approx(p_from_point))) < min_dist)) continue;
            min_dist = curr_dist;
            nearest_point = curr_nearest_point;
            nearest_item = curr_conduction_area;
        }
        if (nearest_point == null) {
            return;
        }
        this.nearest_target_point = nearest_point;
        this.nearest_target_item = nearest_item;
        this.board.join_graphics_update_box(nearest_item.bounding_box());
    }

    private void set_shove_failing_obstacle(Item p_item) {
        this.shove_failing_obstacle = p_item;
        if (p_item != null) {
            this.board.join_graphics_update_box(p_item.bounding_box());
        }
    }

    private Point try_neckdown_at_start(IntPoint p_to_corner) {
        Trace trace;
        Item picked_item;
        Item item = this.start_item;
        if (!(item instanceof Pin)) {
            return this.prev_corner;
        }
        Pin start_pin = (Pin)item;
        if (!start_pin.is_on_layer(this.layer)) {
            return this.prev_corner;
        }
        FloatPoint pin_center = start_pin.get_center().to_float();
        double curr_clearance = this.board.rules.clearance_matrix.get_value(this.clearance_class, start_pin.clearance_class_no(), this.layer, true);
        double pin_neck_down_distance = 2.0 * (0.5 * start_pin.get_max_width(this.layer) + curr_clearance);
        if (pin_center.distance(this.prev_corner.to_float()) >= pin_neck_down_distance) {
            return this.prev_corner;
        }
        int neck_down_halfwidth = start_pin.get_trace_neckdown_halfwidth(this.layer);
        if (neck_down_halfwidth >= this.pen_half_width_arr[this.layer]) {
            return this.prev_corner;
        }
        if (!this.prev_corner.equals(start_pin.get_center()) && (picked_item = this.board.pick_nearest_routing_item(this.prev_corner, this.layer, null)) instanceof Trace && (trace = (Trace)picked_item).get_half_width() > neck_down_halfwidth) {
            return this.prev_corner;
        }
        TimeLimit time_limit = new TimeLimit(3000);
        Point ok_point = this.board.insert_forced_trace_segment(this.prev_corner, p_to_corner, neck_down_halfwidth, this.layer, this.net_no_arr, this.clearance_class, this.max_shove_trace_recursion_depth, this.max_shove_via_recursion_depth, this.max_spring_over_recursion_depth, this.trace_tidy_width, this.pull_tight_accuracy, !this.is_stitch_mode, time_limit);
        return ok_point;
    }

    private Point try_neckdown_at_end(Point p_from_corner, Point p_to_corner) {
        Item item = this.nearest_target_item;
        if (!(item instanceof Pin)) {
            return p_from_corner;
        }
        Pin target_pin = (Pin)item;
        if (!target_pin.is_on_layer(this.layer)) {
            return p_from_corner;
        }
        FloatPoint pin_center = target_pin.get_center().to_float();
        double curr_clearance = this.board.rules.clearance_matrix.get_value(this.clearance_class, target_pin.clearance_class_no(), this.layer, true);
        double pin_neck_down_distance = 2.0 * (0.5 * target_pin.get_max_width(this.layer) + curr_clearance);
        if (pin_center.distance(p_from_corner.to_float()) >= pin_neck_down_distance) {
            return p_from_corner;
        }
        int neck_down_halfwidth = target_pin.get_trace_neckdown_halfwidth(this.layer);
        if (neck_down_halfwidth >= this.pen_half_width_arr[this.layer]) {
            return p_from_corner;
        }
        TimeLimit time_limit = new TimeLimit(3000);
        Point ok_point = this.board.insert_forced_trace_segment(p_from_corner, p_to_corner, neck_down_halfwidth, this.layer, this.net_no_arr, this.clearance_class, this.max_shove_trace_recursion_depth, this.max_shove_via_recursion_depth, this.max_spring_over_recursion_depth, this.trace_tidy_width, this.pull_tight_accuracy, !this.is_stitch_mode, time_limit);
        return ok_point;
    }

    private class SwapPinInfo
    implements Comparable<SwapPinInfo> {
        final Pin pin;
        FloatLine incomplete;

        SwapPinInfo(Route route, Pin p_pin) {
            Objects.requireNonNull(route);
            this.pin = p_pin;
            this.incomplete = null;
            if (p_pin.is_connected() || p_pin.net_count() != 1) {
                return;
            }
            FloatPoint pin_center = p_pin.get_center().to_float();
            double min_dist = Double.MAX_VALUE;
            FloatPoint nearest_point = null;
            Collection<Item> net_items = route.board.get_connectable_items(p_pin.get_net_no(0));
            for (Item curr_item : net_items) {
                FloatPoint curr_point;
                double curr_dist;
                if (curr_item == this.pin || !(curr_item instanceof DrillItem) || !((curr_dist = pin_center.distance_square(curr_point = ((DrillItem)curr_item).get_center().to_float())) < min_dist)) continue;
                min_dist = curr_dist;
                nearest_point = curr_point;
            }
            if (nearest_point != null) {
                this.incomplete = new FloatLine(pin_center, nearest_point);
            }
        }

        @Override
        public int compareTo(SwapPinInfo p_other) {
            return this.pin.compareTo(p_other.pin);
        }
    }

    private static class TargetPoint {
        final FloatPoint location;
        final Item item;

        TargetPoint(FloatPoint p_location, Item p_item) {
            this.location = p_location;
            this.item = p_item;
        }
    }
}

