/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.FixedState;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.PolygonShape;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.CornerItemConstructionState;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.rules.BoardRules;
import java.util.Iterator;

public class PolygonShapeConstructionState
extends CornerItemConstructionState {
    private PolygonShapeConstructionState(FloatPoint p_location, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        super(p_parent_state, p_board_handling, p_activityReplayFile);
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.CREATING_POLYGONSHAPE);
        }
        this.add_corner(p_location);
    }

    public static PolygonShapeConstructionState get_instance(FloatPoint p_location, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        return new PolygonShapeConstructionState(p_location, p_parent_state, p_board_handling, p_activityReplayFile);
    }

    @Override
    public InteractiveState complete() {
        boolean construction_succeeded;
        this.add_corner_for_snap_angle();
        int corner_count = this.corner_list.size();
        boolean bl = construction_succeeded = corner_count > 2;
        if (construction_succeeded) {
            Point[] corner_arr = new IntPoint[corner_count];
            Iterator it = this.corner_list.iterator();
            for (int i = 0; i < corner_count; ++i) {
                corner_arr[i] = (IntPoint)it.next();
            }
            PolygonShape obstacle_shape = new PolygonShape(corner_arr);
            int cl_class = BoardRules.clearance_class_none();
            construction_succeeded = obstacle_shape.split_to_convex() == null ? false : this.hdlg.get_routing_board().check_shape(obstacle_shape, this.hdlg.settings.layer, new int[0], cl_class);
            if (construction_succeeded) {
                boolean bl2 = this.observers_activated = !this.hdlg.get_routing_board().observers_active();
                if (this.observers_activated) {
                    this.hdlg.get_routing_board().start_notify_observers();
                }
                this.hdlg.get_routing_board().generate_snapshot();
                this.hdlg.get_routing_board().insert_obstacle(obstacle_shape, this.hdlg.settings.layer, cl_class, FixedState.NOT_FIXED);
                this.hdlg.get_routing_board().end_notify_observers();
                if (this.observers_activated) {
                    this.hdlg.get_routing_board().end_notify_observers();
                    this.observers_activated = false;
                }
            }
        }
        if (construction_succeeded) {
            this.hdlg.screen_messages.set_status_message(this.tm.getText("keepout_successful_completed", new String[0]));
        } else {
            this.hdlg.screen_messages.set_status_message(this.tm.getText("keepout_cancelled_because_of_overlaps", new String[0]));
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.COMPLETE_SCOPE);
        }
        return this.return_state;
    }

    @Override
    public void display_default_message() {
        this.hdlg.screen_messages.set_status_message(this.tm.getText("creating_polygonshape", new String[0]));
    }
}

