/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.Component;
import app.freerouting.board.Components;
import app.freerouting.board.ConductionArea;
import app.freerouting.board.Item;
import app.freerouting.board.LayerStructure;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.Via;
import app.freerouting.core.BoardLibrary;
import app.freerouting.drc.ClearanceViolation;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.SelectedItemState;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.TextManager;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JPopupMenu;

public class MoveItemState
extends InteractiveState {
    private final Set<Item> item_list;
    private final Set<Component> component_list;
    private final Component grid_snap_component;
    private final Collection<NetItems> net_items_list;
    private final boolean observers_activated;
    private IntPoint current_position;
    private IntPoint previous_position;
    private Collection<ClearanceViolation> clearance_violations;

    private MoveItemState(FloatPoint p_location, Set<Item> p_item_list, Set<Component> p_component_list, Component p_first_component, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        super(p_parent_state, p_board_handling, p_activityReplayFile);
        this.component_list = p_component_list;
        this.grid_snap_component = p_first_component;
        this.previous_position = this.current_position = p_location.round();
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.MOVE_ITEMS, p_location);
        }
        RoutingBoard routing_board = this.hdlg.get_routing_board();
        boolean bl = this.observers_activated = !this.hdlg.get_routing_board().observers_active();
        if (this.observers_activated) {
            this.hdlg.get_routing_board().start_notify_observers();
        }
        routing_board.generate_snapshot();
        for (Item curr_item : p_item_list) {
            routing_board.remove_item(curr_item);
        }
        this.net_items_list = new LinkedList<NetItems>();
        this.item_list = new TreeSet<Item>();
        for (Item curr_item : p_item_list) {
            Item copied_item = curr_item.copy(0);
            for (int i = 0; i < curr_item.net_count(); ++i) {
                this.add_to_net_items_list(copied_item, curr_item.get_net_no(i));
            }
            this.item_list.add(copied_item);
        }
    }

    public static MoveItemState get_instance(FloatPoint p_location, Collection<Item> p_item_list, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        TextManager tm = new TextManager(InteractiveState.class, p_board_handling.get_locale());
        if (p_item_list.isEmpty()) {
            p_board_handling.screen_messages.set_status_message(tm.getText("move_component_failed_because_no_item_selected", new String[0]));
            return null;
        }
        TreeSet<Item> item_list = new TreeSet<Item>();
        TreeSet<Component> component_list = new TreeSet<Component>();
        RoutingBoard routing_board = p_board_handling.get_routing_board();
        Component grid_snap_component = null;
        for (Item curr_item : p_item_list) {
            if (curr_item.get_component_no() > 0) {
                Component curr_component = routing_board.components.get(curr_item.get_component_no());
                if (curr_component == null) {
                    FRLogger.warn("MoveComponentState.get_instance inconsistent component number");
                    return null;
                }
                if (grid_snap_component == null && (p_board_handling.settings.horizontal_component_grid > 0 || p_board_handling.settings.horizontal_component_grid > 0)) {
                    grid_snap_component = curr_component;
                }
                if (component_list.contains(curr_component)) continue;
                Collection<Item> component_items = routing_board.get_component_items(curr_component.no);
                for (Item curr_component_item : component_items) {
                    component_list.add(curr_component);
                    item_list.add(curr_component_item);
                }
                continue;
            }
            item_list.add(curr_item);
        }
        TreeSet<Item> fixed_items = new TreeSet<Item>();
        TreeSet<Item> obstacle_items = new TreeSet<Item>();
        TreeSet<Item> add_items = new TreeSet<Item>();
        boolean move_ok = true;
        for (Item curr_item : item_list) {
            if (curr_item.is_user_fixed()) {
                p_board_handling.screen_messages.set_status_message(tm.getText("some_items_cannot_be_moved_because_they_are_fixed", new String[0]));
                move_ok = false;
                obstacle_items.add(curr_item);
                fixed_items.add(curr_item);
                continue;
            }
            if (!curr_item.is_connected()) continue;
            boolean item_movable = true;
            Set<Item> contacts = curr_item.get_connected_set(-1, true);
            for (Item curr_contact : contacts) {
                Component curr_component;
                if (curr_contact instanceof ConductionArea) continue;
                if (curr_contact.is_user_fixed()) {
                    item_movable = false;
                    fixed_items.add(curr_contact);
                } else if (curr_contact.get_component_no() != 0 && !component_list.contains(curr_component = routing_board.components.get(curr_contact.get_component_no()))) {
                    item_movable = false;
                }
                if (item_movable) {
                    add_items.add(curr_contact);
                    continue;
                }
                obstacle_items.add(curr_contact);
            }
            if (item_movable) continue;
            move_ok = false;
        }
        if (!move_ok) {
            if (p_parent_state instanceof SelectedItemState) {
                SelectedItemState state = (SelectedItemState)p_parent_state;
                if (!fixed_items.isEmpty()) {
                    state.get_item_list().addAll(fixed_items);
                    p_board_handling.screen_messages.set_status_message(tm.getText("please_unfix_selected_items_before_moving", new String[0]));
                } else {
                    state.get_item_list().addAll(obstacle_items);
                    p_board_handling.screen_messages.set_status_message(tm.getText("please_unroute_or_extend_selection_before_moving", new String[0]));
                }
            }
            return null;
        }
        item_list.addAll(add_items);
        return new MoveItemState(p_location, item_list, component_list, grid_snap_component, p_parent_state.return_state, p_board_handling, p_activityReplayFile);
    }

    private void add_to_net_items_list(Item p_item, int p_net_no) {
        for (NetItems curr_items : this.net_items_list) {
            if (curr_items.net_no != p_net_no) continue;
            curr_items.items.add(p_item);
            return;
        }
        Collection<Item> new_item_list = this.hdlg.get_routing_board().get_connectable_items(p_net_no);
        new_item_list.add(p_item);
        NetItems new_net_items = new NetItems(p_net_no, new_item_list);
        this.net_items_list.add(new_net_items);
    }

    @Override
    public InteractiveState mouse_moved() {
        super.mouse_moved();
        this.move(this.hdlg.get_current_mouse_position());
        if (this.activityReplayFile != null) {
            this.activityReplayFile.add_corner(this.current_position.to_float());
        }
        return this;
    }

    @Override
    public InteractiveState process_logfile_point(FloatPoint p_point) {
        this.move(p_point);
        return this;
    }

    @Override
    public InteractiveState left_button_clicked(FloatPoint p_location) {
        return this.complete();
    }

    @Override
    public InteractiveState complete() {
        for (Item curr_item : this.item_list) {
            if (curr_item.clearance_violation_count() <= 0) continue;
            this.hdlg.screen_messages.set_status_message(this.tm.getText("insertion_failed_because_of_obstacles", new String[0]));
            return this;
        }
        RoutingBoard routing_board = this.hdlg.get_routing_board();
        for (Item curr_item : this.item_list) {
            routing_board.insert_item(curr_item);
        }
        for (Component curr_component : this.component_list) {
            routing_board.communication.observers.notify_moved(curr_component);
        }
        for (NetItems curr_net_items : this.net_items_list) {
            this.hdlg.update_ratsnest(curr_net_items.net_no);
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.COMPLETE_SCOPE);
        }
        this.hdlg.screen_messages.set_status_message(this.tm.getText("move_completed", new String[0]));
        this.hdlg.repaint();
        return this.return_state;
    }

    @Override
    public InteractiveState cancel() {
        this.hdlg.get_routing_board().undo(null);
        for (NetItems curr_net_items : this.net_items_list) {
            this.hdlg.update_ratsnest(curr_net_items.net_no);
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.CANCEL_SCOPE);
        }
        return this.return_state;
    }

    @Override
    public InteractiveState mouse_wheel_moved(int p_rotation) {
        if (this.hdlg.settings.zoom_with_wheel) {
            super.mouse_wheel_moved(p_rotation);
        } else {
            this.rotate(-p_rotation);
        }
        return this;
    }

    private void move(FloatPoint p_new_position) {
        this.current_position = p_new_position.round();
        if (!this.current_position.equals(this.previous_position)) {
            Vector translate_vector = this.current_position.difference_by((Point)this.previous_position);
            if (this.grid_snap_component != null) {
                translate_vector = this.adjust_to_placement_grid(translate_vector);
            }
            Components components = this.hdlg.get_routing_board().components;
            for (Component curr_component : this.component_list) {
                components.move(curr_component.no, translate_vector);
            }
            this.clearance_violations = new LinkedList<ClearanceViolation>();
            for (Item curr_item : this.item_list) {
                curr_item.translate_by(translate_vector);
                this.clearance_violations.addAll(curr_item.clearance_violations());
            }
            this.previous_position = this.current_position;
            for (NetItems curr_net_items : this.net_items_list) {
                this.hdlg.update_ratsnest(curr_net_items.net_no, curr_net_items.items);
            }
            this.hdlg.repaint();
        }
    }

    private Vector adjust_to_placement_grid(Vector p_vector) {
        Point new_component_location = this.grid_snap_component.get_location().translate_by(p_vector);
        IntPoint rounded_component_location = new_component_location.to_float().round_to_grid(this.hdlg.settings.horizontal_component_grid, this.hdlg.settings.vertical_component_grid);
        Vector adjustment = rounded_component_location.difference_by(new_component_location);
        Vector result = p_vector.add(adjustment);
        this.current_position = this.previous_position.translate_by(result).to_float().round();
        return p_vector.add(adjustment);
    }

    public void turn_90_degree(int p_factor) {
        if (p_factor == 0) {
            return;
        }
        Components components = this.hdlg.get_routing_board().components;
        for (Component curr_component : this.component_list) {
            components.turn_90_degree(curr_component.no, p_factor, this.current_position);
        }
        this.clearance_violations = new LinkedList<ClearanceViolation>();
        for (Item curr_item : this.item_list) {
            curr_item.turn_90_degree(p_factor, this.current_position);
            this.clearance_violations.addAll(curr_item.clearance_violations());
        }
        for (NetItems curr_net_items : this.net_items_list) {
            this.hdlg.update_ratsnest(curr_net_items.net_no, curr_net_items.items);
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.TURN_90_DEGREE, p_factor);
        }
        this.hdlg.repaint();
    }

    public void rotate(double p_angle_in_degree) {
        if (p_angle_in_degree == 0.0) {
            return;
        }
        Components components = this.hdlg.get_routing_board().components;
        for (Component curr_component : this.component_list) {
            components.rotate(curr_component.no, p_angle_in_degree, this.current_position);
        }
        this.clearance_violations = new LinkedList<ClearanceViolation>();
        FloatPoint float_position = this.current_position.to_float();
        for (Item curr_item : this.item_list) {
            curr_item.rotate_approx(p_angle_in_degree, float_position);
            this.clearance_violations.addAll(curr_item.clearance_violations());
        }
        for (NetItems curr_net_items : this.net_items_list) {
            this.hdlg.update_ratsnest(curr_net_items.net_no, curr_net_items.items);
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.ROTATE, (int)p_angle_in_degree);
        }
        this.hdlg.repaint();
    }

    public void turn_45_degree(int p_factor) {
        if (p_factor % 2 == 0) {
            this.turn_90_degree(p_factor / 2);
        } else {
            this.rotate(p_factor * 45);
        }
    }

    public void change_placement_side() {
        LayerStructure layer_structure = this.hdlg.get_routing_board().layer_structure;
        BoardLibrary board_library = this.hdlg.get_routing_board().library;
        boolean placement_side_changable = true;
        for (Item curr_item : this.item_list) {
            if (curr_item instanceof Via) {
                Via via = (Via)curr_item;
                if (board_library.get_mirrored_via_padstack(via.get_padstack()) != null) continue;
                placement_side_changable = false;
                break;
            }
            if (curr_item.first_layer() != curr_item.last_layer()) continue;
            int new_layer_no = this.hdlg.get_layer_count() - curr_item.first_layer() - 1;
            if (layer_structure.arr[new_layer_no].is_signal) continue;
            placement_side_changable = false;
            break;
        }
        if (!placement_side_changable) {
            this.hdlg.screen_messages.set_status_message(this.tm.getText("cannot_change_placement_side", new String[0]));
            return;
        }
        Components components = this.hdlg.get_routing_board().components;
        for (Component curr_component : this.component_list) {
            components.change_side(curr_component.no, this.current_position);
        }
        this.clearance_violations = new LinkedList<ClearanceViolation>();
        for (Item curr_item : this.item_list) {
            curr_item.change_placement_side(this.current_position);
            this.clearance_violations.addAll(curr_item.clearance_violations());
        }
        for (NetItems curr_net_items : this.net_items_list) {
            this.hdlg.update_ratsnest(curr_net_items.net_no, curr_net_items.items);
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.CHANGE_PLACEMENT_SIDE);
        }
        this.hdlg.repaint();
    }

    public void reset_rotation() {
        Component component_to_reset = null;
        for (Component curr_component : this.component_list) {
            if (component_to_reset == null) {
                component_to_reset = curr_component;
                continue;
            }
            if (component_to_reset.get_rotation_in_degree() == curr_component.get_rotation_in_degree()) continue;
            this.hdlg.screen_messages.set_status_message(this.tm.getText("unable_to_reset_components_with_different_rotations", new String[0]));
            return;
        }
        if (component_to_reset == null) {
            return;
        }
        double rotation = component_to_reset.get_rotation_in_degree();
        if (!this.hdlg.get_routing_board().components.get_flip_style_rotate_first() || component_to_reset.placed_on_front()) {
            rotation = 360.0 - rotation;
        }
        this.rotate(rotation);
    }

    @Override
    public InteractiveState key_typed(char p_key_char) {
        InteractiveState curr_return_state = this;
        switch (p_key_char) {
            case '+': {
                this.turn_90_degree(1);
                break;
            }
            case '*': {
                this.turn_90_degree(2);
                break;
            }
            case '-': {
                this.turn_90_degree(3);
                break;
            }
            case '/': {
                this.change_placement_side();
                break;
            }
            case 'r': {
                this.hdlg.settings.set_zoom_with_wheel(false);
                break;
            }
            case 'z': {
                this.hdlg.settings.set_zoom_with_wheel(true);
                break;
            }
            default: {
                curr_return_state = super.key_typed(p_key_char);
            }
        }
        return curr_return_state;
    }

    @Override
    public JPopupMenu get_popup_menu() {
        return this.hdlg.get_panel().popup_menu_move;
    }

    @Override
    public String get_help_id() {
        return "MoveItemState";
    }

    @Override
    public void draw(Graphics p_graphics) {
        if (this.item_list == null) {
            return;
        }
        for (Item curr_item : this.item_list) {
            curr_item.draw(p_graphics, this.hdlg.graphics_context);
        }
        if (this.clearance_violations != null) {
            Color draw_color = this.hdlg.graphics_context.get_violations_color();
            for (ClearanceViolation curr_violation : this.clearance_violations) {
                this.hdlg.graphics_context.fill_area(curr_violation.shape, p_graphics, draw_color, 1.0);
            }
        }
    }

    private static class NetItems {
        final int net_no;
        final Collection<Item> items;

        NetItems(int p_net_no, Collection<Item> p_items) {
            this.net_no = p_net_no;
            this.items = p_items;
        }
    }
}

