/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.Freerouting;
import app.freerouting.core.RoutingJob;
import app.freerouting.core.StoppableThread;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.AutorouterAndRouteOptimizerThread;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.SelectedItemState;
import app.freerouting.interactive.ThreadActionListener;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.TextManager;
import app.freerouting.settings.GlobalSettings;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class InteractiveActionThread
extends StoppableThread {
    public final GuiBoardManager boardManager;
    protected final RoutingJob routingJob;
    protected List<ThreadActionListener> listeners = new ArrayList<ThreadActionListener>();

    protected InteractiveActionThread(GuiBoardManager boardManager, RoutingJob job) {
        this.boardManager = boardManager;
        this.routingJob = job;
    }

    public static InteractiveActionThread get_autoroute_instance(GuiBoardManager boardManager, RoutingJob job) {
        return new AutorouteThread(boardManager, job);
    }

    public static InteractiveActionThread get_autorouter_and_route_optimizer_instance(final GuiBoardManager boardManager, RoutingJob job) {
        Long randomSeed = job.routerSettings.random_seed;
        job.routerSettings = boardManager.settings.autoroute_settings.clone();
        job.routerSettings.random_seed = randomSeed;
        AutorouterAndRouteOptimizerThread routerThread = new AutorouterAndRouteOptimizerThread(boardManager, job);
        routerThread.addListener(new ThreadActionListener(){

            @Override
            public void autorouterStarted() {
            }

            @Override
            public void autorouterAborted() {
            }

            @Override
            public void autorouterFinished() {
                try {
                    GlobalSettings.saveAsJson(Freerouting.globalSettings);
                }
                catch (IOException iOException) {
                    FRLogger.warn("InteractiveActionThread: unable to save global settings");
                }
                if (Freerouting.globalSettings.statistics.jobsCompleted >= 5 && Freerouting.globalSettings.userProfileSettings.userEmail.isEmpty()) {
                    boardManager.get_panel().board_frame.menubar.showProfileDialog();
                }
            }
        });
        return routerThread;
    }

    public static InteractiveActionThread get_fanout_instance(GuiBoardManager boardManager, RoutingJob job) {
        return new FanoutThread(boardManager, job);
    }

    public static InteractiveActionThread get_pull_tight_instance(GuiBoardManager boardManager, RoutingJob job) {
        return new PullTightThread(boardManager, job);
    }

    public static InteractiveActionThread get_read_logfile_instance(GuiBoardManager boardManager, RoutingJob job, InputStream p_input_stream) {
        return new ReadLogfileThread(boardManager, job, p_input_stream);
    }

    public void addListener(ThreadActionListener toAdd) {
        this.listeners.add(toAdd);
    }

    @Override
    public void run() {
        this.thread_action();
        this.boardManager.repaint();
    }

    public synchronized void draw(Graphics p_graphics) {
    }

    private static class AutorouteThread
    extends InteractiveActionThread {
        private AutorouteThread(GuiBoardManager p_board_handling, RoutingJob job) {
            super(p_board_handling, job);
        }

        @Override
        protected void thread_action() {
            if (!(this.boardManager.interactive_state instanceof SelectedItemState)) {
                return;
            }
            InteractiveState return_state = ((SelectedItemState)this.boardManager.interactive_state).autoroute(this);
            this.boardManager.set_interactive_state(return_state);
        }
    }

    private static class FanoutThread
    extends InteractiveActionThread {
        private FanoutThread(GuiBoardManager p_board_handling, RoutingJob job) {
            super(p_board_handling, job);
        }

        @Override
        protected void thread_action() {
            if (!(this.boardManager.interactive_state instanceof SelectedItemState)) {
                return;
            }
            InteractiveState return_state = ((SelectedItemState)this.boardManager.interactive_state).fanout(this);
            this.boardManager.set_interactive_state(return_state);
        }
    }

    private static class PullTightThread
    extends InteractiveActionThread {
        private PullTightThread(GuiBoardManager p_board_handling, RoutingJob job) {
            super(p_board_handling, job);
        }

        @Override
        protected void thread_action() {
            if (!(this.boardManager.interactive_state instanceof SelectedItemState)) {
                return;
            }
            InteractiveState return_state = ((SelectedItemState)this.boardManager.interactive_state).pull_tight(this);
            this.boardManager.set_interactive_state(return_state);
        }
    }

    private static class ReadLogfileThread
    extends InteractiveActionThread {
        private final InputStream input_stream;

        private ReadLogfileThread(GuiBoardManager p_board_handling, RoutingJob job, InputStream p_input_stream) {
            super(p_board_handling, job);
            this.input_stream = p_input_stream;
        }

        @Override
        protected void thread_action() {
            TextManager tm = new TextManager(InteractiveState.class, this.boardManager.get_locale());
            boolean saved_board_read_only = this.boardManager.is_board_read_only();
            this.boardManager.set_board_read_only(true);
            String start_message = tm.getText("logfile", new String[0]) + " " + tm.getText("stop_message", new String[0]);
            this.boardManager.screen_messages.set_status_message(start_message);
            this.boardManager.screen_messages.set_write_protected(true);
            boolean done = false;
            InteractiveState previous_state = this.boardManager.interactive_state;
            if (!this.boardManager.activityReplayFile.start_read(this.input_stream)) {
                done = true;
            }
            boolean interrupted = false;
            int debug_counter = 0;
            this.boardManager.get_panel().board_frame.refresh_windows();
            this.boardManager.paint_immediately = true;
            while (!done) {
                if (this.isStopRequested()) {
                    interrupted = true;
                    done = true;
                }
                ++debug_counter;
                ActivityReplayFileScope logfile_scope = this.boardManager.activityReplayFile.start_read_scope();
                if (logfile_scope == null) {
                    done = true;
                }
                if (done) continue;
                try {
                    InteractiveState new_state = logfile_scope.read_scope(this.boardManager.activityReplayFile, this.boardManager.interactive_state, this.boardManager);
                    if (new_state == null) {
                        FRLogger.warn("BoardHandling:read_logfile: inconsistent logfile scope");
                        new_state = previous_state;
                    }
                    this.boardManager.repaint();
                    this.boardManager.set_interactive_state(new_state);
                }
                catch (Exception new_state) {
                    done = true;
                }
            }
            this.boardManager.paint_immediately = false;
            try {
                this.input_stream.close();
            }
            catch (IOException e) {
                FRLogger.error("ReadLogfileThread: unable to close input stream", e);
            }
            this.boardManager.get_panel().board_frame.refresh_windows();
            this.boardManager.screen_messages.set_write_protected(false);
            String curr_message = interrupted ? tm.getText("interrupted", new String[0]) : tm.getText("completed", new String[0]);
            String end_message = tm.getText("logfile", new String[0]) + " " + curr_message;
            this.boardManager.screen_messages.set_status_message(end_message);
            this.boardManager.set_board_read_only(saved_board_read_only);
            this.boardManager.get_panel().board_frame.repaint_all();
        }
    }
}

