/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.autoroute.BoardUpdateStrategy;
import app.freerouting.autoroute.ItemSelectionStrategy;
import app.freerouting.board.AngleRestriction;
import app.freerouting.board.BoardObservers;
import app.freerouting.board.Communication;
import app.freerouting.board.CoordinateTransform;
import app.freerouting.board.FixedState;
import app.freerouting.board.Item;
import app.freerouting.board.ItemSelectionFilter;
import app.freerouting.board.Layer;
import app.freerouting.board.LayerStructure;
import app.freerouting.board.Pin;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.Unit;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.core.RoutingJob;
import app.freerouting.datastructures.IdentificationNumberGenerator;
import app.freerouting.designforms.specctra.DsnFile;
import app.freerouting.designforms.specctra.SessionToEagle;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.PolylineShape;
import app.freerouting.gui.BoardPanel;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.CircleConstructionState;
import app.freerouting.interactive.ClearanceViolations;
import app.freerouting.interactive.CopyItemState;
import app.freerouting.interactive.DragMenuState;
import app.freerouting.interactive.HeadlessBoardManager;
import app.freerouting.interactive.HoleConstructionState;
import app.freerouting.interactive.InteractiveActionThread;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.MenuState;
import app.freerouting.interactive.MoveItemState;
import app.freerouting.interactive.PolygonShapeConstructionState;
import app.freerouting.interactive.RatsNest;
import app.freerouting.interactive.RouteMenuState;
import app.freerouting.interactive.RouteState;
import app.freerouting.interactive.ScreenMessages;
import app.freerouting.interactive.SelectItemsInRegionState;
import app.freerouting.interactive.SelectMenuState;
import app.freerouting.interactive.SelectedItemState;
import app.freerouting.interactive.Settings;
import app.freerouting.interactive.TileConstructionState;
import app.freerouting.interactive.ZoomRegionState;
import app.freerouting.logger.FRLogger;
import app.freerouting.logger.LogEntries;
import app.freerouting.logger.LogEntry;
import app.freerouting.logger.LogEntryType;
import app.freerouting.management.TextManager;
import app.freerouting.rules.BoardRules;
import app.freerouting.rules.Net;
import app.freerouting.rules.NetClass;
import app.freerouting.rules.ViaRule;
import app.freerouting.settings.GlobalSettings;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.swing.JPopupMenu;

public class GuiBoardManager
extends HeadlessBoardManager {
    private static final long repaint_interval = 1000L;
    private static long last_repainted_time;
    public final ScreenMessages screen_messages;
    private final BoardPanel panel;
    private final TextManager tm;
    private final List<Consumer<Boolean>> readOnlyEventListeners = new ArrayList<Consumer<Boolean>>();
    private final GlobalSettings globalSettings;
    public GraphicsContext graphics_context;
    public CoordinateTransform coordinate_transform;
    InteractiveState interactive_state;
    boolean paint_immediately;
    private int num_threads;
    private BoardUpdateStrategy board_update_strategy;
    private String hybrid_ratio;
    private ItemSelectionStrategy item_selection_strategy;
    private InteractiveActionThread interactive_action_thread;
    private RatsNest ratsnest;
    private ClearanceViolations clearance_violations;
    private boolean board_is_read_only;
    private FloatPoint current_mouse_position;

    public GuiBoardManager(BoardPanel p_panel, GlobalSettings globalSettings, RoutingJob routingJob) {
        super(globalSettings.currentLocale, routingJob);
        this.globalSettings = globalSettings;
        this.panel = p_panel;
        this.screen_messages = p_panel.screen_messages;
        this.set_interactive_state(RouteMenuState.get_instance(this, this.activityReplayFile));
        this.tm = new TextManager(this.getClass(), globalSettings.currentLocale);
        LogEntries.LogEntryAddedListener listener = this::logEntryAdded;
        FRLogger.getLogEntries().addLogEntryAddedListener(listener);
    }

    private void logEntryAdded(LogEntry logEntry) {
        if (logEntry.getType() == LogEntryType.Error || logEntry.getType() == LogEntryType.Warning) {
            LogEntries entries = FRLogger.getLogEntries();
            this.screen_messages.set_error_and_warning_count(entries.getErrorCount(), entries.getWarningCount());
        }
    }

    public boolean is_board_read_only() {
        return this.board_is_read_only;
    }

    public void set_board_read_only(boolean p_value) {
        this.board_is_read_only = p_value;
        this.settings.set_read_only(p_value);
        this.readOnlyEventListeners.forEach(listener -> listener.accept(p_value));
    }

    @Override
    public Locale get_locale() {
        return this.locale;
    }

    public int get_layer_count() {
        if (this.board == null) {
            return 0;
        }
        return this.board.get_layer_count();
    }

    public FloatPoint get_current_mouse_position() {
        return this.current_mouse_position;
    }

    void set_current_mouse_position(FloatPoint p_point) {
        this.current_mouse_position = p_point;
    }

    public void set_ignore_conduction(boolean p_value) {
        if (this.board_is_read_only) {
            return;
        }
        this.board.change_conduction_is_obstacle(!p_value);
        this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_IGNORE_CONDUCTION, p_value);
    }

    public void set_pin_edge_to_turn_dist(double p_value) {
        if (this.board_is_read_only) {
            return;
        }
        double edge_to_turn_dist = this.coordinate_transform.user_to_board(p_value);
        if (edge_to_turn_dist != this.board.rules.get_pin_edge_to_turn_dist()) {
            Collection<Pin> pin_list = this.board.get_pins();
            for (Pin curr_pin : pin_list) {
                if (!curr_pin.has_trace_exit_restrictions()) continue;
                Set<Item> contact_list = curr_pin.get_normal_contacts();
                for (Item curr_contact : contact_list) {
                    if (!(curr_contact instanceof PolylineTrace)) continue;
                    PolylineTrace trace = (PolylineTrace)curr_contact;
                    if (curr_contact.get_fixed_state() != FixedState.SHOVE_FIXED || trace.corner_count() != 2) continue;
                    curr_contact.set_fixed_state(FixedState.NOT_FIXED);
                }
            }
        }
        this.board.rules.set_pin_edge_to_turn_dist(edge_to_turn_dist);
    }

    public void set_layer_visibility(int p_layer, double p_value) {
        if (p_layer >= 0 && p_layer < this.graphics_context.layer_count()) {
            this.graphics_context.set_layer_visibility(p_layer, p_value);
            if (p_value == 0.0 && this.settings.layer == p_layer) {
                double best_visibility = 0.0;
                int best_visible_layer = 0;
                for (int i = 0; i < this.graphics_context.layer_count(); ++i) {
                    if (!(this.graphics_context.get_layer_visibility(i) > best_visibility)) continue;
                    best_visibility = this.graphics_context.get_layer_visibility(i);
                    best_visible_layer = i;
                }
                this.settings.layer = best_visible_layer;
            }
        }
    }

    public int get_trace_halfwidth(int p_net_no, int p_layer) {
        int result = this.settings.manual_rule_selection ? this.settings.manual_trace_half_width_arr[p_layer] : this.board.rules.get_trace_half_width(p_net_no, p_layer);
        return result;
    }

    public boolean is_active_routing_layer(int p_net_no, int p_layer) {
        if (this.settings.manual_rule_selection) {
            return true;
        }
        Net curr_net = this.board.rules.nets.get(p_net_no);
        if (curr_net == null) {
            return true;
        }
        NetClass curr_net_class = curr_net.get_class();
        if (curr_net_class == null) {
            return true;
        }
        return curr_net_class.is_active_routing_layer(p_layer);
    }

    public int get_trace_clearance_class(int p_net_no) {
        int result = this.settings.manual_rule_selection ? this.settings.manual_trace_clearance_class : this.board.rules.nets.get(p_net_no).get_class().get_trace_clearance_class();
        return result;
    }

    public ViaRule get_via_rule(int p_net_no) {
        ViaRule result = null;
        if (this.settings.manual_rule_selection) {
            result = this.board.rules.via_rules.get(this.settings.manual_via_rule_index);
        }
        if (result == null) {
            result = this.board.rules.nets.get(p_net_no).get_class().get_via_rule();
        }
        return result;
    }

    public void set_default_trace_halfwidth(int p_layer, int p_value) {
        if (this.board_is_read_only) {
            return;
        }
        if (p_layer >= 0 && p_layer <= this.board.get_layer_count()) {
            this.board.rules.set_default_trace_half_width(p_layer, p_value);
            this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_TRACE_HALF_WIDTH, p_layer);
            this.activityReplayFile.add_int(p_value);
        }
    }

    public void set_clearance_compensation(boolean p_value) {
        if (this.board_is_read_only) {
            return;
        }
        this.board.search_tree_manager.set_clearance_compensation_used(p_value);
        this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_CLEARANCE_COMPENSATION, p_value);
    }

    public void set_current_snap_angle(AngleRestriction p_snap_angle) {
        if (this.board_is_read_only) {
            return;
        }
        this.board.rules.set_trace_angle_restriction(p_snap_angle);
        this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_SNAP_ANGLE, p_snap_angle.getValue());
    }

    public void set_current_layer(int p_layer) {
        if (this.board_is_read_only) {
            return;
        }
        int layer = Math.max(p_layer, 0);
        layer = Math.min(layer, this.board.get_layer_count() - 1);
        this.set_layer(layer);
        this.activityReplayFile.start_scope(ActivityReplayFileScope.SET_LAYER, p_layer);
    }

    void set_layer(int p_layer_no) {
        Layer curr_layer = this.board.layer_structure.arr[p_layer_no];
        this.screen_messages.set_layer(curr_layer.name);
        this.settings.layer = p_layer_no;
        if (!this.board_is_read_only && curr_layer.is_signal) {
            this.panel.set_selected_signal_layer(p_layer_no);
        }
        if (this.graphics_context.get_layer_visibility(p_layer_no) == 0.0) {
            this.graphics_context.set_layer_visibility(p_layer_no, 1.0);
            this.panel.board_frame.refresh_windows();
        }
        this.graphics_context.set_fully_visible_layer(p_layer_no);
        this.repaint();
    }

    public void display_layer_message() {
        this.screen_messages.clear_add_field();
        Layer curr_layer = this.board.layer_structure.arr[this.settings.layer];
        this.screen_messages.set_layer(curr_layer.name);
    }

    public void set_manual_trace_half_width(int p_layer_no, int p_value) {
        if (p_layer_no == -1) {
            for (int i = 0; i < this.settings.manual_trace_half_width_arr.length; ++i) {
                this.settings.set_manual_trace_half_width(i, p_value);
            }
        } else if (p_layer_no == -2) {
            for (int i = 1; i < this.settings.manual_trace_half_width_arr.length - 1; ++i) {
                this.settings.set_manual_trace_half_width(i, p_value);
            }
        } else {
            this.settings.set_manual_trace_half_width(p_layer_no, p_value);
        }
    }

    public void set_selectable(ItemSelectionFilter.SelectableChoices p_item_type, boolean p_value) {
        this.settings.set_selectable(p_item_type, p_value);
        if (!p_value && this.interactive_state instanceof SelectedItemState) {
            this.set_interactive_state(((SelectedItemState)this.interactive_state).filter());
        }
    }

    public void toggle_ratsnest() {
        if (this.ratsnest == null || this.ratsnest.is_hidden()) {
            this.create_ratsnest();
        } else {
            this.ratsnest = null;
        }
        this.repaint();
    }

    public void toggle_clearance_violations() {
        if (this.clearance_violations == null) {
            this.clearance_violations = new ClearanceViolations(this.board.get_items());
            Integer violation_count = (this.clearance_violations.list.size() + 1) / 2;
            String curr_message = violation_count + " " + this.tm.getText("clearance_violations_found", new String[0]);
            this.screen_messages.set_status_message(curr_message);
        } else {
            this.clearance_violations = null;
            this.screen_messages.set_status_message("");
        }
        this.repaint();
    }

    public void create_ratsnest() {
        this.ratsnest = new RatsNest(this.board);
        Integer incomplete_count = this.ratsnest.incomplete_count();
        int length_violation_count = this.ratsnest.length_violation_count();
        String curr_message = length_violation_count == 0 ? incomplete_count + " " + this.tm.getText("incomplete_connections_to_route", new String[0]) : incomplete_count + " " + this.tm.getText("incompletes", new String[0]) + " " + length_violation_count + " " + this.tm.getText("length_violations", new String[0]);
        this.screen_messages.set_status_message(curr_message);
    }

    void update_ratsnest(int p_net_no) {
        if (this.ratsnest != null && p_net_no > 0) {
            this.ratsnest.recalculate(p_net_no, this.board);
            this.ratsnest.show();
        }
    }

    void update_ratsnest(int p_net_no, Collection<Item> p_item_list) {
        if (this.ratsnest != null && p_net_no > 0) {
            this.ratsnest.recalculate(p_net_no, p_item_list, this.board);
            this.ratsnest.show();
        }
    }

    void update_ratsnest() {
        if (this.ratsnest != null) {
            this.ratsnest = new RatsNest(this.board);
        }
    }

    public void hide_ratsnest() {
        if (this.ratsnest != null) {
            this.ratsnest.hide();
        }
    }

    public void show_ratsnest() {
        if (this.ratsnest != null) {
            this.ratsnest.show();
        }
    }

    public void remove_ratsnest() {
        this.ratsnest = null;
    }

    public RatsNest get_ratsnest() {
        if (this.ratsnest == null) {
            this.ratsnest = new RatsNest(this.board);
        }
        return this.ratsnest;
    }

    public void recalculate_length_violations() {
        if (this.ratsnest != null && this.ratsnest.recalculate_length_violations() && !this.ratsnest.is_hidden()) {
            this.repaint();
        }
    }

    public void set_incompletes_filter(int p_net_no, boolean p_value) {
        if (this.ratsnest != null) {
            this.ratsnest.set_filter(p_net_no, p_value);
        }
    }

    @Override
    public void create_board(IntBox p_bounding_box, LayerStructure p_layer_structure, PolylineShape[] p_outline_shapes, String p_outline_clearance_class_name, BoardRules p_rules, Communication p_board_communication) {
        super.create_board(p_bounding_box, p_layer_structure, p_outline_shapes, p_outline_clearance_class_name, p_rules, p_board_communication);
        double unit_factor = p_board_communication.coordinate_transform.board_to_dsn(1.0);
        this.coordinate_transform = new CoordinateTransform(1.0, p_board_communication.unit, unit_factor, p_board_communication.unit);
        Dimension panel_size = this.panel.getPreferredSize();
        this.graphics_context = new GraphicsContext(p_bounding_box, panel_size, p_layer_structure, this.locale);
    }

    public void change_user_unit(Unit p_unit) {
        this.screen_messages.set_unit_label(p_unit.toString());
        CoordinateTransform old_transform = this.coordinate_transform;
        this.coordinate_transform = new CoordinateTransform(old_transform.user_unit_factor, p_unit, old_transform.board_unit_factor, old_transform.board_unit);
    }

    public void start_logfile(File p_filename) {
        if (this.board_is_read_only) {
            return;
        }
        this.activityReplayFile.start_write(p_filename);
    }

    public void repaint() {
        if (this.paint_immediately) {
            Rectangle MAX_RECTAMGLE = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.panel.paintImmediately(MAX_RECTAMGLE);
        } else if (last_repainted_time < System.currentTimeMillis() - 1000L) {
            last_repainted_time = System.currentTimeMillis();
            this.panel.repaint();
        }
    }

    public void repaint(Rectangle p_rect) {
        if (this.paint_immediately) {
            this.panel.paintImmediately(p_rect);
        } else {
            this.panel.repaint(p_rect);
        }
    }

    public BoardPanel get_panel() {
        return this.panel;
    }

    public JPopupMenu get_current_popup_menu() {
        JPopupMenu result = this.interactive_state != null ? this.interactive_state.get_popup_menu() : null;
        return result;
    }

    public void draw(Graphics p_graphics) {
        if (this.board == null) {
            return;
        }
        this.board.draw(p_graphics, this.graphics_context);
        if (this.ratsnest != null) {
            this.ratsnest.draw(p_graphics, this.graphics_context);
        }
        if (this.clearance_violations != null) {
            this.clearance_violations.draw(p_graphics, this.graphics_context);
        }
        if (this.interactive_state != null) {
            this.interactive_state.draw(p_graphics);
        }
        if (this.interactive_action_thread != null) {
            this.interactive_action_thread.draw(p_graphics);
        }
    }

    public void generate_snapshot() {
        if (this.board_is_read_only) {
            return;
        }
        this.board.generate_snapshot();
        this.activityReplayFile.start_scope(ActivityReplayFileScope.GENERATE_SNAPSHOT);
    }

    public void undo() {
        if (this.board_is_read_only || !(this.interactive_state instanceof MenuState)) {
            return;
        }
        TreeSet<Integer> changed_nets = new TreeSet<Integer>();
        if (this.board.undo(changed_nets)) {
            for (Integer changed_net : changed_nets) {
                this.update_ratsnest(changed_net);
            }
            if (!changed_nets.isEmpty()) {
                this.settings.autoroute_settings.set_start_pass_no(1);
            }
            this.screen_messages.set_status_message(this.tm.getText("undo", new String[0]));
        } else {
            this.screen_messages.set_status_message(this.tm.getText("no_more_undo_possible", new String[0]));
        }
        this.activityReplayFile.start_scope(ActivityReplayFileScope.UNDO);
        this.repaint();
    }

    public void redo() {
        if (this.board_is_read_only || !(this.interactive_state instanceof MenuState)) {
            return;
        }
        TreeSet<Integer> changed_nets = new TreeSet<Integer>();
        if (this.board.redo(changed_nets)) {
            for (Integer changed_net : changed_nets) {
                this.update_ratsnest(changed_net);
            }
            this.screen_messages.set_status_message(this.tm.getText("redo", new String[0]));
        } else {
            this.screen_messages.set_status_message(this.tm.getText("no_more_redo_possible", new String[0]));
        }
        this.activityReplayFile.start_scope(ActivityReplayFileScope.REDO);
        this.repaint();
    }

    public void left_button_clicked(Point2D p_point) {
        FloatPoint location;
        InteractiveState return_state;
        if (this.board_is_read_only) {
            this.stop_autorouter_and_route_optimizer();
            return;
        }
        if (this.interactive_state != null && this.graphics_context != null && (return_state = this.interactive_state.left_button_clicked(location = this.graphics_context.coordinate_transform.screen_to_board(p_point))) != this.interactive_state && return_state != null) {
            this.set_interactive_state(return_state);
            this.repaint();
        }
    }

    public void mouse_moved(Point2D p_point) {
        if (this.board_is_read_only) {
            return;
        }
        if (this.interactive_state != null && this.graphics_context != null) {
            this.current_mouse_position = this.graphics_context.coordinate_transform.screen_to_board(p_point);
            InteractiveState return_state = this.interactive_state.mouse_moved();
            Set<Item> hover_item = this.pick_items(this.current_mouse_position);
            if (hover_item.size() == 1) {
                String hover_info = hover_item.iterator().next().get_hover_info(this.locale);
                this.panel.setToolTipText(hover_info);
            } else {
                this.panel.setToolTipText(null);
            }
            if (return_state != this.interactive_state) {
                this.set_interactive_state(return_state);
                this.repaint();
            }
        }
    }

    public void mouse_pressed(Point2D p_point) {
        if (this.interactive_state != null && this.graphics_context != null) {
            this.current_mouse_position = this.graphics_context.coordinate_transform.screen_to_board(p_point);
            this.set_interactive_state(this.interactive_state.mouse_pressed(this.current_mouse_position));
        }
    }

    public void mouse_dragged(Point2D p_point) {
        if (this.interactive_state != null && this.graphics_context != null) {
            this.current_mouse_position = this.graphics_context.coordinate_transform.screen_to_board(p_point);
            InteractiveState return_state = this.interactive_state.mouse_dragged(this.current_mouse_position);
            if (return_state != this.interactive_state) {
                this.set_interactive_state(return_state);
                this.repaint();
            }
        }
    }

    public void button_released() {
        InteractiveState return_state;
        if (this.interactive_state != null && (return_state = this.interactive_state.button_released()) != this.interactive_state) {
            this.set_interactive_state(return_state);
            this.repaint();
        }
    }

    public void mouse_wheel_moved(int p_rotation) {
        InteractiveState return_state;
        if (this.interactive_state != null && (return_state = this.interactive_state.mouse_wheel_moved(p_rotation)) != this.interactive_state) {
            this.set_interactive_state(return_state);
            this.repaint();
        }
    }

    public void key_typed_action(char p_key_char) {
        if (this.board_is_read_only) {
            return;
        }
        InteractiveState return_state = this.interactive_state.key_typed(p_key_char);
        if (return_state != null && return_state != this.interactive_state) {
            this.set_interactive_state(return_state);
            this.panel.board_frame.setToolbarModeSelectionPanelValue(this.get_interactive_state());
            this.repaint();
        }
    }

    public void return_from_state() {
        if (this.board_is_read_only) {
            return;
        }
        InteractiveState new_state = this.interactive_state.complete();
        if (new_state != this.interactive_state) {
            this.set_interactive_state(new_state);
            this.repaint();
        }
    }

    public void cancel_state() {
        if (this.board_is_read_only) {
            return;
        }
        InteractiveState new_state = this.interactive_state.cancel();
        if (new_state != this.interactive_state) {
            this.set_interactive_state(new_state);
            this.repaint();
        }
    }

    public boolean change_layer_action(int p_new_layer) {
        boolean result = true;
        if (this.interactive_state != null && !this.board_is_read_only) {
            result = this.interactive_state.change_layer_action(p_new_layer);
        }
        return result;
    }

    public void set_select_menu_state() {
        this.interactive_state = SelectMenuState.get_instance(this, this.activityReplayFile);
        this.screen_messages.set_status_message(this.tm.getText("select_menu", new String[0]));
    }

    public void set_route_menu_state() {
        this.interactive_state = RouteMenuState.get_instance(this, this.activityReplayFile);
        this.screen_messages.set_status_message(this.tm.getText("route_menu", new String[0]));
    }

    public void set_drag_menu_state() {
        this.interactive_state = DragMenuState.get_instance(this, this.activityReplayFile);
        this.screen_messages.set_status_message(this.tm.getText("drag_menu", new String[0]));
    }

    public boolean isBoardChanged() {
        return this.calculateCrc32() != this.originalBoardChecksum;
    }

    public boolean loadFromBinary(ObjectInputStream p_design) {
        try {
            this.board = (RoutingBoard)p_design.readObject();
            this.settings = (Settings)p_design.readObject();
            this.settings.set_logfile(this.activityReplayFile);
            this.coordinate_transform = (CoordinateTransform)p_design.readObject();
            this.graphics_context = (GraphicsContext)p_design.readObject();
            this.originalBoardChecksum = this.calculateCrc32();
        }
        catch (Exception e) {
            this.routingJob.logError("Couldn't read design file", e);
            return false;
        }
        this.screen_messages.set_layer(this.board.layer_structure.arr[this.settings.layer].name);
        return true;
    }

    public boolean saveAsSpecctraDesignDsn(OutputStream p_output_stream, String p_design_name, boolean p_compat_mode) {
        if (this.board_is_read_only || p_output_stream == null) {
            return false;
        }
        boolean wasSaveSuccessful = DsnFile.write(this, p_output_stream, p_design_name, p_compat_mode);
        if (wasSaveSuccessful) {
            this.originalBoardChecksum = this.calculateCrc32();
        }
        return wasSaveSuccessful;
    }

    @Override
    public boolean saveAsSpecctraSessionSes(OutputStream outputStream, String designName) {
        if (this.board_is_read_only) {
            return false;
        }
        return super.saveAsSpecctraSessionSes(outputStream, designName);
    }

    public boolean saveSpecctraSessionSesAsEagleScriptScr(InputStream p_input_stream, OutputStream p_output_stream) {
        if (this.board_is_read_only) {
            return false;
        }
        return SessionToEagle.get_instance(p_input_stream, p_output_stream, this.board);
    }

    @Override
    public DsnFile.ReadResult loadFromSpecctraDsn(InputStream inputStream, BoardObservers boardObservers, IdentificationNumberGenerator identificationNumberGenerator) {
        DsnFile.ReadResult result = super.loadFromSpecctraDsn(inputStream, boardObservers, identificationNumberGenerator);
        this.set_layer(0);
        return result;
    }

    public boolean saveAsBinary(ObjectOutputStream p_object_stream) {
        boolean result = true;
        try {
            p_object_stream.writeObject(this.board);
            p_object_stream.writeObject(this.settings);
            p_object_stream.writeObject(this.coordinate_transform);
            p_object_stream.writeObject(this.graphics_context);
            this.originalBoardChecksum = this.calculateCrc32();
        }
        catch (Exception exception) {
            this.screen_messages.set_status_message(this.tm.getText("save_error", new String[0]));
            result = false;
        }
        return result;
    }

    public void read_logfile(InputStream p_input_stream) {
        if (this.board_is_read_only || !(this.interactive_state instanceof MenuState)) {
            return;
        }
        this.interactive_action_thread = InteractiveActionThread.get_read_logfile_instance(this, this.routingJob, p_input_stream);
        this.interactive_action_thread.start();
    }

    public void close_files() {
        this.activityReplayFile.close_output();
    }

    public void start_route(Point2D p_point) {
        if (this.board_is_read_only) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_point);
        RouteState new_state = RouteState.get_instance(location, this.interactive_state, this, this.activityReplayFile);
        this.set_interactive_state(new_state);
    }

    public void select_items(Point2D p_point) {
        if (this.board_is_read_only || !(this.interactive_state instanceof MenuState)) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_point);
        InteractiveState return_state = ((MenuState)this.interactive_state).select_items(location);
        this.set_interactive_state(return_state);
    }

    public void select_items_in_region() {
        if (this.board_is_read_only || !(this.interactive_state instanceof MenuState)) {
            return;
        }
        this.set_interactive_state(SelectItemsInRegionState.get_instance(this.interactive_state, this, this.activityReplayFile));
    }

    public void select_items(Set<Item> p_items) {
        if (this.board_is_read_only) {
            return;
        }
        this.display_layer_message();
        if (this.interactive_state instanceof MenuState) {
            this.set_interactive_state(SelectedItemState.get_instance(p_items, this.interactive_state, this, this.activityReplayFile));
        } else {
            InteractiveState interactiveState = this.interactive_state;
            if (interactiveState instanceof SelectedItemState) {
                SelectedItemState state = (SelectedItemState)interactiveState;
                state.get_item_list().addAll(p_items);
                this.repaint();
            }
        }
    }

    public void swap_pin(Point2D p_location) {
        if (this.board_is_read_only || !(this.interactive_state instanceof MenuState)) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_location);
        InteractiveState return_state = ((MenuState)this.interactive_state).swap_pin(location);
        this.set_interactive_state(return_state);
    }

    public void zoom_selection() {
        if (!(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        IntBox bounding_box = this.board.get_bounding_box(((SelectedItemState)this.interactive_state).get_item_list());
        bounding_box = bounding_box.offset(this.board.rules.get_max_trace_half_width());
        Point2D lower_left = this.graphics_context.coordinate_transform.board_to_screen(bounding_box.ll.to_float());
        Point2D upper_right = this.graphics_context.coordinate_transform.board_to_screen(bounding_box.ur.to_float());
        this.panel.zoom_frame(lower_left, upper_right);
    }

    public void toggle_select_action(Point2D p_point) {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_point);
        InteractiveState return_state = ((SelectedItemState)this.interactive_state).toggle_select(location);
        if (return_state != this.interactive_state) {
            this.set_interactive_state(return_state);
            this.repaint();
        }
    }

    public void fix_selected_items() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        ((SelectedItemState)this.interactive_state).fix_items();
    }

    public void unfix_selected_items() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        ((SelectedItemState)this.interactive_state).unfix_items();
    }

    public void display_selected_item_info() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        ((SelectedItemState)this.interactive_state).info();
    }

    public void assign_selected_to_new_net() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        InteractiveState new_state = ((SelectedItemState)this.interactive_state).assign_items_to_new_net();
        this.set_interactive_state(new_state);
    }

    public void assign_selected_to_new_group() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        InteractiveState new_state = ((SelectedItemState)this.interactive_state).assign_items_to_new_group();
        this.set_interactive_state(new_state);
    }

    public void delete_selected_items() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        InteractiveState new_state = ((SelectedItemState)this.interactive_state).delete_items();
        this.set_interactive_state(new_state);
    }

    public void cutout_selected_items() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        InteractiveState new_state = ((SelectedItemState)this.interactive_state).cutout_items();
        this.set_interactive_state(new_state);
    }

    public void assign_clearance_classs_to_selected_items(int p_cl_class_index) {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        InteractiveState new_state = ((SelectedItemState)this.interactive_state).assign_clearance_class(p_cl_class_index);
        this.set_interactive_state(new_state);
    }

    public void move_selected_items(Point2D p_from_location) {
        InteractiveState interactiveState;
        if (this.board_is_read_only || !((interactiveState = this.interactive_state) instanceof SelectedItemState)) {
            return;
        }
        SelectedItemState curr_state = (SelectedItemState)interactiveState;
        Collection<Item> item_list = curr_state.get_item_list();
        FloatPoint from_location = this.graphics_context.coordinate_transform.screen_to_board(p_from_location);
        MoveItemState new_state = MoveItemState.get_instance(from_location, item_list, this.interactive_state, this, this.activityReplayFile);
        this.set_interactive_state(new_state);
        this.repaint();
    }

    public void copy_selected_items(Point2D p_from_location) {
        InteractiveState interactiveState;
        if (this.board_is_read_only || !((interactiveState = this.interactive_state) instanceof SelectedItemState)) {
            return;
        }
        SelectedItemState curr_state = (SelectedItemState)interactiveState;
        curr_state.extent_to_whole_components();
        Collection<Item> item_list = curr_state.get_item_list();
        FloatPoint from_location = this.graphics_context.coordinate_transform.screen_to_board(p_from_location);
        CopyItemState new_state = CopyItemState.get_instance(from_location, item_list, this.interactive_state.return_state, this, this.activityReplayFile);
        this.set_interactive_state(new_state);
    }

    public void optimize_selected_items() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        this.board.generate_snapshot();
        this.interactive_action_thread = InteractiveActionThread.get_pull_tight_instance(this, this.routingJob);
        this.interactive_action_thread.start();
    }

    public void autoroute_selected_items() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        this.board.generate_snapshot();
        this.interactive_action_thread = InteractiveActionThread.get_autoroute_instance(this, this.routingJob);
        this.interactive_action_thread.start();
    }

    public void fanout_selected_items() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        this.board.generate_snapshot();
        this.interactive_action_thread = InteractiveActionThread.get_fanout_instance(this, this.routingJob);
        this.interactive_action_thread.start();
    }

    public InteractiveActionThread start_autorouter_and_route_optimizer(RoutingJob job) {
        if (this.board_is_read_only) {
            return null;
        }
        this.board.generate_snapshot();
        this.interactive_action_thread = InteractiveActionThread.get_autorouter_and_route_optimizer_instance(this, job);
        this.interactive_action_thread.start();
        return this.interactive_action_thread;
    }

    public void stop_autorouter_and_route_optimizer() {
        if (this.interactive_action_thread != null) {
            this.interactive_action_thread.requestStop();
        }
        this.set_board_read_only(false);
    }

    public void extend_selection_to_whole_nets() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        this.set_interactive_state(((SelectedItemState)this.interactive_state).extent_to_whole_nets());
    }

    public void extend_selection_to_whole_components() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        this.set_interactive_state(((SelectedItemState)this.interactive_state).extent_to_whole_components());
    }

    public void extend_selection_to_whole_connected_sets() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        this.set_interactive_state(((SelectedItemState)this.interactive_state).extent_to_whole_connected_sets());
    }

    public void extend_selection_to_whole_connections() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        this.set_interactive_state(((SelectedItemState)this.interactive_state).extent_to_whole_connections());
    }

    public void toggle_selected_item_violations() {
        if (this.board_is_read_only || !(this.interactive_state instanceof SelectedItemState)) {
            return;
        }
        ((SelectedItemState)this.interactive_state).toggle_clearance_violations();
    }

    public void turn_45_degree(int p_factor) {
        if (this.board_is_read_only || !(this.interactive_state instanceof MoveItemState)) {
            return;
        }
        ((MoveItemState)this.interactive_state).turn_45_degree(p_factor);
    }

    public void change_placement_side() {
        if (this.board_is_read_only || !(this.interactive_state instanceof MoveItemState)) {
            return;
        }
        ((MoveItemState)this.interactive_state).change_placement_side();
    }

    public void zoom_region() {
        this.interactive_state = ZoomRegionState.get_instance(this.interactive_state, this, this.activityReplayFile);
    }

    public void start_circle(Point2D p_point) {
        if (this.board_is_read_only) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_point);
        this.set_interactive_state(CircleConstructionState.get_instance(location, this.interactive_state, this, this.activityReplayFile));
    }

    public void start_tile(Point2D p_point) {
        if (this.board_is_read_only) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_point);
        this.set_interactive_state(TileConstructionState.get_instance(location, this.interactive_state, this, this.activityReplayFile));
    }

    public void start_polygonshape_item(Point2D p_point) {
        if (this.board_is_read_only) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_point);
        this.set_interactive_state(PolygonShapeConstructionState.get_instance(location, this.interactive_state, this, this.activityReplayFile));
    }

    public void start_adding_hole(Point2D p_point) {
        if (this.board_is_read_only) {
            return;
        }
        FloatPoint location = this.graphics_context.coordinate_transform.screen_to_board(p_point);
        HoleConstructionState new_state = HoleConstructionState.get_instance(location, this.interactive_state, this, this.activityReplayFile);
        this.set_interactive_state(new_state);
    }

    Rectangle get_graphics_update_rectangle() {
        Rectangle result;
        IntBox update_box = this.board.get_graphics_update_box();
        if (update_box == null || update_box.is_empty()) {
            result = new Rectangle(0, 0, 0, 0);
        } else {
            IntBox offset_box = update_box.offset(this.board.get_max_trace_half_width());
            result = this.graphics_context.coordinate_transform.board_to_screen(offset_box);
        }
        return result;
    }

    Set<Item> pick_items(FloatPoint p_location) {
        return this.pick_items(p_location, this.settings.item_selection_filter);
    }

    Set<Item> pick_items(FloatPoint p_location, ItemSelectionFilter p_item_filter) {
        IntPoint location = p_location.round();
        Set<Item> result = this.board.pick_items(location, this.settings.layer, p_item_filter);
        if (result.isEmpty() && this.settings.select_on_all_visible_layers) {
            for (int i = 0; i < this.graphics_context.layer_count(); ++i) {
                if (i == this.settings.layer || this.graphics_context.get_layer_visibility(i) <= 0.0) continue;
                result.addAll(this.board.pick_items(location, i, p_item_filter));
            }
        }
        return result;
    }

    void move_mouse(FloatPoint p_to_location) {
        if (!this.board_is_read_only) {
            this.panel.move_mouse(this.graphics_context.coordinate_transform.board_to_screen(p_to_location));
        }
    }

    public InteractiveState get_interactive_state() {
        return this.interactive_state;
    }

    public void set_interactive_state(InteractiveState p_state) {
        if (p_state != null && p_state != this.interactive_state) {
            this.interactive_state = p_state;
            if (!this.board_is_read_only) {
                p_state.set_toolbar();
            }
        }
    }

    public void adjust_design_bounds() {
        IntBox new_bounding_box = this.board.get_bounding_box();
        Collection<Item> board_items = this.board.get_items();
        for (Item curr_item : board_items) {
            IntBox curr_bounding_box = curr_item.bounding_box();
            if (curr_bounding_box.ur.x >= Integer.MAX_VALUE) continue;
            new_bounding_box = new_bounding_box.union(curr_bounding_box);
        }
        this.graphics_context.change_design_bounds(new_bounding_box);
    }

    public void dispose() {
        this.close_files();
        this.graphics_context = null;
        this.coordinate_transform = null;
        this.settings = null;
        this.interactive_state = null;
        this.ratsnest = null;
        this.clearance_violations = null;
        this.board = null;
    }

    public BoardUpdateStrategy get_board_update_strategy() {
        return this.board_update_strategy;
    }

    public void set_board_update_strategy(BoardUpdateStrategy p_board_update_strategy) {
        this.board_update_strategy = p_board_update_strategy;
    }

    public String get_hybrid_ratio() {
        return this.hybrid_ratio;
    }

    public void set_hybrid_ratio(String p_hybrid_ratio) {
        this.hybrid_ratio = p_hybrid_ratio;
    }

    public ItemSelectionStrategy get_item_selection_strategy() {
        return this.item_selection_strategy;
    }

    public void set_item_selection_strategy(ItemSelectionStrategy p_item_selection_strategy) {
        this.item_selection_strategy = p_item_selection_strategy;
    }

    public int get_num_threads() {
        if (this.num_threads > 1 && !this.globalSettings.featureFlags.multiThreading) {
            this.routingJob.logInfo("Multi-threading is disabled in the settings. Using single thread.");
            this.num_threads = 1;
        }
        return this.num_threads;
    }

    public void set_num_threads(int p_value) {
        this.num_threads = p_value;
    }

    public void addReadOnlyEventListener(Consumer<Boolean> listener) {
        this.readOnlyEventListeners.add(listener);
    }
}

