/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.DrillItem;
import app.freerouting.board.Item;
import app.freerouting.board.Trace;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.DragItemState;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.MakeSpaceState;
import java.util.Set;
import java.util.TreeSet;

public abstract class DragState
extends InteractiveState {
    protected FloatPoint previous_location;
    protected boolean something_dragged;
    protected boolean observers_activated;

    protected DragState(FloatPoint p_location, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        super(p_parent_state, p_board_handling, p_activityReplayFile);
        this.previous_location = p_location;
    }

    public static DragState get_instance(FloatPoint p_location, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        DragState result;
        int curr_layer;
        p_board_handling.display_layer_message();
        Item item_to_move = null;
        int try_count = 1;
        if (p_board_handling.settings.select_on_all_visible_layers) {
            try_count += p_board_handling.get_layer_count();
        }
        int pick_layer = curr_layer = p_board_handling.settings.layer;
        boolean item_found = false;
        int i = 0;
        while (i < try_count) {
            if (i == 0 || pick_layer != curr_layer && p_board_handling.graphics_context.get_layer_visibility(pick_layer) > 0.0) {
                Set<Item> found_items = p_board_handling.get_routing_board().pick_items(p_location.round(), pick_layer, p_board_handling.settings.item_selection_filter);
                for (Item curr_item : found_items) {
                    item_found = true;
                    if (curr_item instanceof Trace || !p_board_handling.settings.drag_components_enabled && curr_item.get_component_no() != 0) continue;
                    item_to_move = curr_item;
                    if (!(curr_item instanceof DrillItem)) continue;
                    break;
                }
                if (item_to_move != null) break;
            }
            pick_layer = i++;
        }
        if ((result = item_to_move != null ? new DragItemState(item_to_move, p_location, p_parent_state, p_board_handling, p_activityReplayFile) : (!item_found ? new MakeSpaceState(p_location, p_parent_state, p_board_handling, p_activityReplayFile) : null)) != null) {
            p_board_handling.hide_ratsnest();
        }
        return result;
    }

    public abstract InteractiveState move_to(FloatPoint var1);

    @Override
    public InteractiveState mouse_dragged(FloatPoint p_point) {
        InteractiveState result = this.move_to(p_point);
        if (result != this) {
            TreeSet<Integer> changed_nets = new TreeSet<Integer>();
            this.hdlg.get_routing_board().undo(changed_nets);
            for (Integer changed_net : changed_nets) {
                this.hdlg.update_ratsnest(changed_net);
            }
        }
        if (this.something_dragged && this.activityReplayFile != null) {
            this.activityReplayFile.add_corner(p_point);
        }
        return result;
    }

    @Override
    public InteractiveState complete() {
        return this.button_released();
    }

    @Override
    public InteractiveState process_logfile_point(FloatPoint p_point) {
        return this.move_to(p_point);
    }
}

