/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.AngleRestriction;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPopupMenu;

public class CornerItemConstructionState
extends InteractiveState {
    protected LinkedList<IntPoint> corner_list = new LinkedList();
    protected FloatPoint snapped_mouse_position;
    protected boolean observers_activated;

    protected CornerItemConstructionState(InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        super(p_parent_state, p_board_handling, p_activityReplayFile);
        p_board_handling.remove_ratsnest();
    }

    @Override
    public InteractiveState left_button_clicked(FloatPoint p_location) {
        return this.add_corner(p_location);
    }

    public InteractiveState add_corner(FloatPoint p_location) {
        IntPoint location = this.snap(p_location.round());
        this.corner_list.add(location);
        this.hdlg.repaint();
        if (this.activityReplayFile != null) {
            this.activityReplayFile.add_corner(p_location);
        }
        return this;
    }

    @Override
    public InteractiveState process_logfile_point(FloatPoint p_point) {
        return this.add_corner(p_point);
    }

    @Override
    public InteractiveState mouse_moved() {
        super.mouse_moved();
        IntPoint curr_mouse_pos = this.hdlg.get_current_mouse_position().round();
        this.snapped_mouse_position = this.snap(curr_mouse_pos).to_float();
        this.hdlg.repaint();
        return this;
    }

    @Override
    public JPopupMenu get_popup_menu() {
        return this.hdlg.get_panel().popup_menu_corneritem_construction;
    }

    @Override
    public void draw(Graphics p_graphics) {
        int corner_count = this.corner_list.size();
        if (this.snapped_mouse_position != null) {
            ++corner_count;
        }
        FloatPoint[] corners = new FloatPoint[corner_count];
        Iterator it = this.corner_list.iterator();
        for (int i = 0; i < corners.length - 1; ++i) {
            corners[i] = ((IntPoint)it.next()).to_float();
        }
        corners[corners.length - 1] = this.snapped_mouse_position == null ? ((IntPoint)it.next()).to_float() : this.snapped_mouse_position;
        this.hdlg.graphics_context.draw(corners, 300.0, Color.white, p_graphics, 0.5);
    }

    protected void add_corner_for_snap_angle() {
        if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.NONE) {
            return;
        }
        IntPoint first_corner = this.corner_list.getFirst();
        IntPoint last_corner = this.corner_list.getLast();
        IntPoint add_corner = null;
        if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE) {
            add_corner = last_corner.ninety_degree_corner(first_corner, true);
        } else if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.FORTYFIVE_DEGREE) {
            add_corner = last_corner.fortyfive_degree_corner(first_corner, true);
        }
        if (add_corner != null) {
            this.corner_list.add(add_corner);
        }
    }

    private IntPoint snap(IntPoint p_point) {
        IntPoint result;
        boolean list_empty = this.corner_list.isEmpty();
        if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE && !list_empty) {
            IntPoint last_corner = this.corner_list.getLast();
            result = p_point.orthogonal_projection(last_corner);
        } else if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.FORTYFIVE_DEGREE && !list_empty) {
            IntPoint last_corner = this.corner_list.getLast();
            result = p_point.fortyfive_degree_projection(last_corner);
        } else {
            result = p_point;
        }
        return result;
    }
}

