/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.AngleRestriction;
import app.freerouting.board.FixedState;
import app.freerouting.board.RoutingBoard;
import app.freerouting.geometry.planar.Area;
import app.freerouting.geometry.planar.Circle;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.rules.BoardRules;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JPopupMenu;

public class CircleConstructionState
extends InteractiveState {
    private final FloatPoint circle_center;
    private double circle_radius = 0.0;
    private boolean observers_activated;

    private CircleConstructionState(FloatPoint p_location, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        super(p_parent_state, p_board_handling, p_activityReplayFile);
        this.circle_center = p_location;
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.CREATING_CIRCLE, p_location);
        }
    }

    public static CircleConstructionState get_instance(FloatPoint p_location, InteractiveState p_parent_state, GuiBoardManager p_board_handling, ActivityReplayFile p_activityReplayFile) {
        p_board_handling.remove_ratsnest();
        return new CircleConstructionState(p_location, p_parent_state, p_board_handling, p_activityReplayFile);
    }

    @Override
    public InteractiveState left_button_clicked(FloatPoint p_location) {
        if (this.activityReplayFile != null) {
            this.activityReplayFile.add_corner(p_location);
        }
        return this.complete();
    }

    @Override
    public InteractiveState mouse_moved() {
        super.mouse_moved();
        this.hdlg.repaint();
        return this;
    }

    @Override
    public InteractiveState complete() {
        IntPoint center = this.circle_center.round();
        int radius = (int)Math.round(this.circle_radius);
        int layer = this.hdlg.settings.layer;
        RoutingBoard board = this.hdlg.get_routing_board();
        int cl_class = BoardRules.clearance_class_none();
        boolean construction_succeeded = this.circle_radius > 0.0;
        Serializable obstacle_shape = null;
        if (construction_succeeded) {
            obstacle_shape = new Circle(center, radius);
            if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE) {
                obstacle_shape = obstacle_shape.bounding_box();
            } else if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.FORTYFIVE_DEGREE) {
                obstacle_shape = obstacle_shape.bounding_octagon();
            }
            construction_succeeded = board.check_shape((Area)((Object)obstacle_shape), layer, new int[0], cl_class);
        }
        if (construction_succeeded) {
            this.hdlg.screen_messages.set_status_message(this.tm.getText("keepout_successful_completed", new String[0]));
            boolean bl = this.observers_activated = !this.hdlg.get_routing_board().observers_active();
            if (this.observers_activated) {
                this.hdlg.get_routing_board().start_notify_observers();
            }
            board.generate_snapshot();
            board.insert_obstacle((Area)((Object)obstacle_shape), layer, cl_class, FixedState.NOT_FIXED);
            if (this.observers_activated) {
                this.hdlg.get_routing_board().end_notify_observers();
                this.observers_activated = false;
            }
        } else {
            this.hdlg.screen_messages.set_status_message(this.tm.getText("keepout_cancelled_because_of_overlaps", new String[0]));
        }
        if (this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.COMPLETE_SCOPE);
        }
        this.hdlg.repaint();
        return this.return_state;
    }

    @Override
    public InteractiveState process_logfile_point(FloatPoint p_point) {
        this.circle_radius = this.circle_center.distance(p_point);
        return this;
    }

    @Override
    public void draw(Graphics p_graphics) {
        FloatPoint current_mouse_position = this.hdlg.get_current_mouse_position();
        if (current_mouse_position == null) {
            return;
        }
        this.circle_radius = this.circle_center.distance(current_mouse_position);
        this.hdlg.graphics_context.draw_circle(this.circle_center, this.circle_radius, 300.0, Color.white, p_graphics, 1.0);
    }

    @Override
    public JPopupMenu get_popup_menu() {
        return this.hdlg.get_panel().popup_menu_insert_cancel;
    }

    @Override
    public void display_default_message() {
        this.hdlg.screen_messages.set_status_message(this.tm.getText("creating_circle", new String[0]));
    }
}

