/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.Freerouting;
import app.freerouting.autoroute.BatchAutorouter;
import app.freerouting.autoroute.BatchFanout;
import app.freerouting.autoroute.BatchOptimizer;
import app.freerouting.autoroute.BatchOptimizerMultiThreaded;
import app.freerouting.autoroute.TaskState;
import app.freerouting.autoroute.events.BoardSnapshotEvent;
import app.freerouting.autoroute.events.BoardSnapshotEventListener;
import app.freerouting.autoroute.events.BoardUpdatedEvent;
import app.freerouting.autoroute.events.BoardUpdatedEventListener;
import app.freerouting.autoroute.events.TaskStateChangedEvent;
import app.freerouting.autoroute.events.TaskStateChangedEventListener;
import app.freerouting.board.AngleRestriction;
import app.freerouting.board.Unit;
import app.freerouting.core.RoutingJob;
import app.freerouting.core.RoutingJobState;
import app.freerouting.core.scoring.BoardStatistics;
import app.freerouting.designforms.specctra.SpecctraSesFileWriter;
import app.freerouting.geometry.planar.FloatLine;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.gui.FileFormat;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.interactive.InteractiveActionThread;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.ThreadActionListener;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.TextManager;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.tests.BoardValidator;
import java.awt.Color;
import java.awt.Graphics;
import java.io.ByteArrayOutputStream;
import java.time.Instant;
import java.util.Objects;

public class AutorouterAndRouteOptimizerThread
extends InteractiveActionThread {
    private final BatchAutorouter batchAutorouter;
    private BatchOptimizer batchOptimizer;

    protected AutorouterAndRouteOptimizerThread(GuiBoardManager p_board_handling, final RoutingJob routingJob) {
        super(p_board_handling, routingJob);
        routingJob.thread = this;
        routingJob.board = p_board_handling.get_routing_board();
        this.batchAutorouter = new BatchAutorouter(routingJob);
        if (!Objects.equals(routingJob.routerSettings.algorithm, this.batchAutorouter.getId())) {
            routingJob.logWarning("The algorithm '" + routingJob.routerSettings.algorithm + "' is not supported by the batch autorouter. The default algorithm '" + this.batchAutorouter.getId() + "' will be used instead.");
            routingJob.routerSettings.algorithm = this.batchAutorouter.getId();
        }
        this.batchAutorouter.addBoardUpdatedEventListener(new BoardUpdatedEventListener(){
            final /* synthetic */ AutorouterAndRouteOptimizerThread this$0;
            {
                AutorouterAndRouteOptimizerThread autorouterAndRouteOptimizerThread = this$0;
                Objects.requireNonNull(autorouterAndRouteOptimizerThread);
                this.this$0 = autorouterAndRouteOptimizerThread;
            }

            @Override
            public void onBoardUpdatedEvent(BoardUpdatedEvent event) {
                float boardScore = event.getBoardStatistics().getNormalizedScore(routingJob.routerSettings.scoring);
                this.this$0.boardManager.screen_messages.set_batch_autoroute_info(event.getRouterCounters());
                this.this$0.boardManager.screen_messages.set_board_score(boardScore, event.getBoardStatistics().connections.incompleteCount, event.getBoardStatistics().clearanceViolations.totalCount);
                this.this$0.boardManager.repaint();
            }
        });
        this.batchAutorouter.addBoardUpdatedEventListener(new BoardUpdatedEventListener(){
            final /* synthetic */ AutorouterAndRouteOptimizerThread this$0;
            {
                AutorouterAndRouteOptimizerThread autorouterAndRouteOptimizerThread = this$0;
                Objects.requireNonNull(autorouterAndRouteOptimizerThread);
                this.this$0 = autorouterAndRouteOptimizerThread;
            }

            @Override
            public void onBoardUpdatedEvent(BoardUpdatedEvent event) {
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    boolean wasSaveSuccessful = SpecctraSesFileWriter.write(this.this$0.boardManager.get_routing_board(), outputStream, routingJob.name);
                    if (wasSaveSuccessful) {
                        byte[] sesOutputData = outputStream.toByteArray();
                        routingJob.output.setData(sesOutputData);
                    }
                }
                catch (Exception e) {
                    routingJob.logError("Couldn't save the SES output into the job object.", e);
                }
            }
        });
        this.batchAutorouter.addTaskStateChangedEventListener(new TaskStateChangedEventListener(this){
            final /* synthetic */ AutorouterAndRouteOptimizerThread this$0;
            {
                AutorouterAndRouteOptimizerThread autorouterAndRouteOptimizerThread = this$0;
                Objects.requireNonNull(autorouterAndRouteOptimizerThread);
                this.this$0 = autorouterAndRouteOptimizerThread;
            }

            @Override
            public void onTaskStateChangedEvent(TaskStateChangedEvent event) {
                TaskState taskState = event.getTaskState();
                if (taskState == TaskState.RUNNING) {
                    TextManager tm = new TextManager(InteractiveState.class, this.this$0.boardManager.get_locale());
                    String start_message = tm.getText("autorouter_started", Integer.toString(event.getPassNumber()));
                    this.this$0.boardManager.screen_messages.set_status_message(start_message);
                }
            }
        });
        this.batchAutorouter.addBoardSnapshotEventListener(new BoardSnapshotEventListener(this){
            final /* synthetic */ AutorouterAndRouteOptimizerThread this$0;
            {
                AutorouterAndRouteOptimizerThread autorouterAndRouteOptimizerThread = this$0;
                Objects.requireNonNull(autorouterAndRouteOptimizerThread);
                this.this$0 = autorouterAndRouteOptimizerThread;
            }

            @Override
            public void onBoardSnapshotEvent(BoardSnapshotEvent event) {
                this.this$0.boardManager.get_panel().board_frame.save_intermediate_stage_file();
            }
        });
        this.batchOptimizer = null;
        if (routingJob.routerSettings.optimizer.enabled) {
            if (!Freerouting.globalSettings.featureFlags.multiThreading || routingJob.routerSettings.optimizer.maxThreads == 1) {
                this.batchOptimizer = new BatchOptimizer(routingJob);
                if (!Objects.equals(routingJob.routerSettings.optimizer.algorithm, this.batchOptimizer.getId())) {
                    routingJob.logWarning("The algorithm '" + routingJob.routerSettings.optimizer.algorithm + "' is not supported by the batch autorouter. The default algorithm '" + this.batchOptimizer.getId() + "' will be used instead.");
                    routingJob.routerSettings.optimizer.algorithm = this.batchOptimizer.getId();
                }
                this.batchOptimizer.addBoardUpdatedEventListener(new BoardUpdatedEventListener(){
                    final /* synthetic */ AutorouterAndRouteOptimizerThread this$0;
                    {
                        AutorouterAndRouteOptimizerThread autorouterAndRouteOptimizerThread = this$0;
                        Objects.requireNonNull(autorouterAndRouteOptimizerThread);
                        this.this$0 = autorouterAndRouteOptimizerThread;
                    }

                    @Override
                    public void onBoardUpdatedEvent(BoardUpdatedEvent event) {
                        BoardStatistics boardStatistics = event.getBoardStatistics();
                        this.this$0.boardManager.screen_messages.set_post_route_info(boardStatistics.items.viaCount, boardStatistics.traces.totalLength.floatValue(), this.this$0.boardManager.coordinate_transform.user_unit);
                        this.this$0.boardManager.screen_messages.set_board_score(boardStatistics.getNormalizedScore(routingJob.routerSettings.scoring), boardStatistics.connections.incompleteCount, boardStatistics.clearanceViolations.totalCount);
                        this.this$0.boardManager.repaint();
                    }
                });
                this.batchOptimizer.addTaskStateChangedEventListener(new TaskStateChangedEventListener(this){
                    final /* synthetic */ AutorouterAndRouteOptimizerThread this$0;
                    {
                        AutorouterAndRouteOptimizerThread autorouterAndRouteOptimizerThread = this$0;
                        Objects.requireNonNull(autorouterAndRouteOptimizerThread);
                        this.this$0 = autorouterAndRouteOptimizerThread;
                    }

                    @Override
                    public void onTaskStateChangedEvent(TaskStateChangedEvent event) {
                        TaskState taskState = event.getTaskState();
                        if (taskState == TaskState.RUNNING) {
                            TextManager tm = new TextManager(InteractiveState.class, this.this$0.boardManager.get_locale());
                            String start_message = tm.getText("optimizer_started", Integer.toString(event.getPassNumber()));
                            this.this$0.boardManager.screen_messages.set_status_message(start_message);
                        }
                    }
                });
            }
            if (Freerouting.globalSettings.featureFlags.multiThreading && routingJob.routerSettings.optimizer.maxThreads > 1) {
                this.batchOptimizer = new BatchOptimizerMultiThreaded(routingJob);
                if (!Objects.equals(routingJob.routerSettings.optimizer.algorithm, this.batchOptimizer.getId())) {
                    routingJob.logWarning("The algorithm '" + routingJob.routerSettings.optimizer.algorithm + "' is not supported by the batch autorouter. The default algorithm '" + this.batchOptimizer.getId() + "' will be used instead.");
                    routingJob.routerSettings.optimizer.algorithm = this.batchOptimizer.getId();
                }
                this.batchOptimizer.addBoardUpdatedEventListener(new BoardUpdatedEventListener(this){
                    final /* synthetic */ AutorouterAndRouteOptimizerThread this$0;
                    {
                        AutorouterAndRouteOptimizerThread autorouterAndRouteOptimizerThread = this$0;
                        Objects.requireNonNull(autorouterAndRouteOptimizerThread);
                        this.this$0 = autorouterAndRouteOptimizerThread;
                    }

                    @Override
                    public void onBoardUpdatedEvent(BoardUpdatedEvent event) {
                        BoardStatistics boardStatistics = event.getBoardStatistics();
                        this.this$0.boardManager.replaceRoutingBoard(event.getBoard());
                        this.this$0.boardManager.screen_messages.set_post_route_info(boardStatistics.items.viaCount, boardStatistics.traces.totalLength.floatValue(), this.this$0.boardManager.coordinate_transform.user_unit);
                    }
                });
                this.batchOptimizer.addTaskStateChangedEventListener(new TaskStateChangedEventListener(this){
                    final /* synthetic */ AutorouterAndRouteOptimizerThread this$0;
                    {
                        AutorouterAndRouteOptimizerThread autorouterAndRouteOptimizerThread = this$0;
                        Objects.requireNonNull(autorouterAndRouteOptimizerThread);
                        this.this$0 = autorouterAndRouteOptimizerThread;
                    }

                    @Override
                    public void onTaskStateChangedEvent(TaskStateChangedEvent event) {
                        TaskState taskState = event.getTaskState();
                        if (taskState == TaskState.RUNNING) {
                            TextManager tm = new TextManager(InteractiveState.class, this.this$0.boardManager.get_locale());
                            String start_message = tm.getText("optimizer_started", Integer.toString(event.getPassNumber()));
                            this.this$0.boardManager.screen_messages.set_status_message(start_message);
                        }
                    }
                });
            }
        }
    }

    @Override
    protected void thread_action() {
        this.routingJob.startedAt = Instant.now();
        this.routingJob.state = RoutingJobState.RUNNING;
        this.boardManager.set_num_threads(this.routingJob.routerSettings.optimizer.maxThreads);
        for (ThreadActionListener hl : this.listeners) {
            hl.autorouterStarted();
        }
        FRLogger.traceEntry("BatchAutorouterThread.thread_action()");
        try {
            String end_message;
            boolean fanout_first;
            TextManager tm = new TextManager(InteractiveState.class, this.boardManager.get_locale());
            boolean saved_board_read_only = this.boardManager.is_board_read_only();
            this.boardManager.set_board_read_only(true);
            boolean ratsnest_hidden_before = this.boardManager.get_ratsnest().is_hidden();
            if (!ratsnest_hidden_before) {
                this.boardManager.get_ratsnest().hide();
            }
            int threadCount = this.routingJob.routerSettings.maxThreads;
            this.routingJob.logInfo("Starting routing of '" + this.routingJob.name + "' on " + (String)(threadCount == 1 ? "1 thread" : threadCount + " threads") + "...");
            FRLogger.traceEntry("BatchAutorouterThread.thread_action()-autorouting");
            Freerouting.globalSettings.statistics.incrementJobsCompleted();
            FRAnalytics.autorouterStarted();
            String start_message = tm.getText("batch_autorouter", new String[0]) + " " + tm.getText("stop_message", new String[0]);
            this.boardManager.screen_messages.set_status_message(start_message);
            boolean bl = fanout_first = this.boardManager.get_settings().autoroute_settings.getRunFanout() && this.boardManager.get_settings().autoroute_settings.get_start_pass_no() <= 1;
            if (fanout_first) {
                BatchFanout fanout = new BatchFanout(this.routingJob);
                fanout.addTaskStateChangedEventListener(new TaskStateChangedEventListener(this){
                    final /* synthetic */ AutorouterAndRouteOptimizerThread this$0;
                    {
                        AutorouterAndRouteOptimizerThread autorouterAndRouteOptimizerThread = this$0;
                        Objects.requireNonNull(autorouterAndRouteOptimizerThread);
                        this.this$0 = autorouterAndRouteOptimizerThread;
                    }

                    @Override
                    public void onTaskStateChangedEvent(TaskStateChangedEvent event) {
                        this.this$0.boardManager.screen_messages.set_batch_fanout_info(event.getPassNumber(), 0);
                    }
                });
                fanout.addBoardUpdatedEventListener(new BoardUpdatedEventListener(this){
                    final /* synthetic */ AutorouterAndRouteOptimizerThread this$0;
                    {
                        AutorouterAndRouteOptimizerThread autorouterAndRouteOptimizerThread = this$0;
                        Objects.requireNonNull(autorouterAndRouteOptimizerThread);
                        this.this$0 = autorouterAndRouteOptimizerThread;
                    }

                    @Override
                    public void onBoardUpdatedEvent(BoardUpdatedEvent event) {
                        this.this$0.boardManager.repaint();
                    }
                });
                fanout.runBatchLoop();
            }
            if (this.boardManager.get_settings().autoroute_settings.getRunRouter() && !this.is_stop_auto_router_requested()) {
                this.batchAutorouter.runBatchLoop();
            }
            this.boardManager.replaceRoutingBoard(this.routingJob.board);
            this.boardManager.get_routing_board().finish_autoroute();
            BoardStatistics bs = new BoardStatistics(this.boardManager.get_routing_board());
            float scoreBeforeOptimization = bs.getNormalizedScore(this.routingJob.routerSettings.scoring);
            double autoroutingSecondsToComplete = FRLogger.traceExit("BatchAutorouterThread.thread_action()-autorouting");
            this.routingJob.logInfo("Auto-routing was completed in " + FRLogger.formatDuration(autoroutingSecondsToComplete) + " with the score of " + FRLogger.formatScore(scoreBeforeOptimization, bs.connections.incompleteCount, bs.clearanceViolations.totalCount) + ".");
            FRAnalytics.autorouterFinished();
            Thread.sleep(100L);
            int num_threads = this.boardManager.get_num_threads();
            if (num_threads > 0 && this.routingJob.routerSettings.optimizer.enabled) {
                this.routingJob.logInfo("Starting optimization on " + (String)(num_threads == 1 ? "1 thread" : num_threads + " threads") + "...");
                if (num_threads > 1) {
                    this.routingJob.logWarning("Multi-threaded route optimization is broken and it is known to generate clearance violations. It is highly recommended to use the single-threaded route optimization instead by setting the number of threads to 1 with the '-mt 1' command line argument.");
                }
                FRLogger.traceEntry("BatchAutorouterThread.thread_action()-routeoptimization");
                FRAnalytics.routeOptimizerStarted();
                if (this.boardManager.get_settings().autoroute_settings.getRunOptimizer() && !this.isStopRequested()) {
                    String opt_message = tm.getText("batch_optimizer", new String[0]) + " " + tm.getText("stop_message", new String[0]);
                    this.boardManager.screen_messages.set_status_message(opt_message);
                    this.batchOptimizer.runBatchLoop();
                    String curr_message = this.isStopRequested() ? tm.getText("interrupted", new String[0]) : tm.getText("completed", new String[0]);
                    end_message = tm.getText("postroute", new String[0]) + " " + curr_message;
                    this.boardManager.screen_messages.set_status_message(end_message);
                }
                bs = new BoardStatistics(this.boardManager.get_routing_board());
                float scoreAfterOptimization = bs.getNormalizedScore(this.routingJob.routerSettings.scoring);
                double percentage_improvement = (double)(scoreAfterOptimization / scoreBeforeOptimization) * 100.0 - 100.0;
                double routeOptimizationSecondsToComplete = FRLogger.traceExit("BatchAutorouterThread.thread_action()-routeoptimization");
                this.routingJob.logInfo("Optimization was completed in " + FRLogger.formatDuration(routeOptimizationSecondsToComplete) + " with the score of " + FRLogger.formatScore(scoreBeforeOptimization, bs.connections.incompleteCount, bs.clearanceViolations.totalCount) + (String)(percentage_improvement > 0.0 ? " and an improvement of " + FRLogger.defaultSignedFloatFormat.format(percentage_improvement) + "%." : "."));
                FRAnalytics.routeOptimizerFinished();
                if (!this.isStopRequested()) {
                    this.boardManager.get_panel().board_frame.delete_intermediate_stage_file();
                }
            }
            this.boardManager.set_board_read_only(saved_board_read_only);
            if (this.routingJob.output.format == FileFormat.SES) {
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    if (this.boardManager.saveAsSpecctraSessionSes(baos, this.routingJob.name)) {
                        this.routingJob.output.setData(baos.toByteArray());
                    }
                }
                catch (Exception e) {
                    this.routingJob.logError("Couldn't save the output into the job object.", e);
                }
            }
            this.boardManager.update_ratsnest();
            if (!ratsnest_hidden_before) {
                this.boardManager.get_ratsnest().show();
            }
            this.boardManager.screen_messages.clear();
            String curr_message = this.isStopRequested() ? tm.getText("interrupted", new String[0]) : tm.getText("completed", new String[0]);
            int incomplete_count = this.boardManager.get_ratsnest().incomplete_count();
            end_message = tm.getText("autoroute", new String[0]) + " " + curr_message + ", " + incomplete_count + " " + tm.getText("connections_not_found", new String[0]);
            this.boardManager.screen_messages.set_status_message(end_message);
            this.boardManager.get_panel().board_frame.refresh_windows();
            if (this.boardManager.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.FORTYFIVE_DEGREE) {
                BoardValidator.doAllTracesHaveAnglesThatAreMultiplesOfFortyFiveDegrees("after autoroute: ", this.boardManager.get_routing_board());
            }
        }
        catch (Exception e) {
            this.routingJob.logError(e.getLocalizedMessage(), e);
        }
        if (this.isStopRequested()) {
            this.routingJob.finishedAt = Instant.now();
            this.routingJob.state = RoutingJobState.CANCELLED;
        } else {
            this.routingJob.finishedAt = Instant.now();
            this.routingJob.state = RoutingJobState.COMPLETED;
            Freerouting.globalSettings.statistics.incrementJobsCompleted();
        }
        for (ThreadActionListener hl : this.listeners) {
            if (this.isStopRequested()) {
                hl.autorouterAborted();
                continue;
            }
            hl.autorouterFinished();
        }
        FRLogger.traceExit("BatchAutorouterThread.thread_action()");
    }

    @Override
    public void draw(Graphics p_graphics) {
        FloatLine curr_air_line = this.batchAutorouter.get_air_line();
        if (curr_air_line != null) {
            FloatPoint[] draw_line = new FloatPoint[]{curr_air_line.a, curr_air_line.b};
            Color draw_color = this.boardManager.graphics_context.get_incomplete_color();
            double draw_width = Math.min(this.boardManager.get_routing_board().communication.get_resolution(Unit.MIL) * 3.0, 300.0);
            this.boardManager.graphics_context.draw(draw_line, draw_width, draw_color, p_graphics, 1.0);
        }
        if (this.batchOptimizer != null) {
            FloatPoint current_opt_position = this.batchOptimizer.get_current_position();
            int radius = 10 * this.boardManager.get_routing_board().rules.get_default_trace_half_width(0);
            if (current_opt_position != null) {
                boolean draw_width = true;
                Color draw_color = this.boardManager.graphics_context.get_incomplete_color();
                FloatPoint[] draw_points = new FloatPoint[]{new FloatPoint(current_opt_position.x - (double)radius, current_opt_position.y - (double)radius), new FloatPoint(current_opt_position.x + (double)radius, current_opt_position.y + (double)radius)};
                this.boardManager.graphics_context.draw(draw_points, 1.0, draw_color, p_graphics, 1.0);
                draw_points[0] = new FloatPoint(current_opt_position.x + (double)radius, current_opt_position.y - (double)radius);
                draw_points[1] = new FloatPoint(current_opt_position.x - (double)radius, current_opt_position.y + (double)radius);
                this.boardManager.graphics_context.draw(draw_points, 1.0, draw_color, p_graphics, 1.0);
                this.boardManager.graphics_context.draw_circle(current_opt_position, radius, 1.0, draw_color, p_graphics, 1.0);
            }
        }
    }
}

