/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.WindowBase;
import app.freerouting.gui.WindowMessage;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.rules.ViaInfo;
import app.freerouting.rules.ViaInfos;
import app.freerouting.rules.ViaRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class WindowViaRule
extends WindowBase {
    private final ViaRule via_rule;
    private final ViaInfos via_list;
    private final JPanel main_panel;
    private final JList<ViaInfo> rule_list;
    private final DefaultListModel<ViaInfo> rule_list_model;

    public WindowViaRule(ViaRule p_via_rule, ViaInfos p_via_list, BoardFrame p_board_frame) {
        super(300, 150);
        this.via_rule = p_via_rule;
        this.via_list = p_via_list;
        this.setLanguage(p_board_frame.get_locale());
        this.setTitle(this.tm.getText("title", new String[0]) + " " + p_via_rule.name);
        this.main_panel = new JPanel();
        this.main_panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.main_panel.setLayout(new BorderLayout());
        this.rule_list_model = new DefaultListModel();
        this.rule_list = new JList<ViaInfo>(this.rule_list_model);
        this.rule_list.setSelectionMode(0);
        this.rule_list.setVisibleRowCount(10);
        JScrollPane list_scroll_pane = new JScrollPane(this.rule_list);
        list_scroll_pane.setPreferredSize(new Dimension(200, 100));
        this.main_panel.add((Component)list_scroll_pane, "Center");
        for (int i = 0; i < p_via_rule.via_count(); ++i) {
            this.rule_list_model.addElement(p_via_rule.get_via(i));
        }
        JPanel button_panel = new JPanel();
        this.main_panel.add((Component)button_panel, "South");
        GridBagLayout gridbag = new GridBagLayout();
        button_panel.setLayout(gridbag);
        GridBagConstraints gridbag_constraints = new GridBagConstraints();
        JButton rules_vias_rules_edit_append_button = new JButton(this.tm.getText("append", new String[0]));
        gridbag_constraints.gridwidth = -1;
        gridbag.setConstraints(rules_vias_rules_edit_append_button, gridbag_constraints);
        rules_vias_rules_edit_append_button.setToolTipText(this.tm.getText("append_tooltip", new String[0]));
        rules_vias_rules_edit_append_button.addActionListener(new AppendListener(this));
        rules_vias_rules_edit_append_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("rules_vias_rules_edit_append_button", rules_vias_rules_edit_append_button.getText()));
        button_panel.add(rules_vias_rules_edit_append_button);
        JButton rules_vias_rules_edit_remove_button = new JButton(this.tm.getText("remove", new String[0]));
        gridbag_constraints.gridwidth = 0;
        gridbag.setConstraints(rules_vias_rules_edit_remove_button, gridbag_constraints);
        rules_vias_rules_edit_remove_button.setToolTipText(this.tm.getText("remove_tooltip", new String[0]));
        rules_vias_rules_edit_remove_button.addActionListener(new DeleteListener(this));
        rules_vias_rules_edit_remove_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("rules_vias_rules_edit_remove_button", rules_vias_rules_edit_remove_button.getText()));
        button_panel.add(rules_vias_rules_edit_remove_button);
        JButton rules_vias_rules_edit_move_up_button = new JButton(this.tm.getText("move_up", new String[0]));
        gridbag_constraints.gridwidth = -1;
        gridbag.setConstraints(rules_vias_rules_edit_move_up_button, gridbag_constraints);
        rules_vias_rules_edit_move_up_button.setToolTipText(this.tm.getText("move_up_tooltip", new String[0]));
        rules_vias_rules_edit_move_up_button.addActionListener(new MoveUpListener(this));
        rules_vias_rules_edit_move_up_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("rules_vias_rules_edit_move_up_button", rules_vias_rules_edit_move_up_button.getText()));
        button_panel.add(rules_vias_rules_edit_move_up_button);
        JButton rules_vias_rules_edit_move_down_button = new JButton(this.tm.getText("move_down", new String[0]));
        gridbag_constraints.gridwidth = 0;
        gridbag.setConstraints(rules_vias_rules_edit_move_down_button, gridbag_constraints);
        rules_vias_rules_edit_move_down_button.setToolTipText(this.tm.getText("move_down_tooltip", new String[0]));
        rules_vias_rules_edit_move_down_button.addActionListener(new MoveDownListener(this));
        rules_vias_rules_edit_move_down_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("rules_vias_rules_edit_move_down_button", rules_vias_rules_edit_move_down_button.getText()));
        button_panel.add(rules_vias_rules_edit_move_down_button);
        this.add(this.main_panel);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private void swap_position(int p_1, int p_2) {
        ViaInfo via_1 = this.rule_list_model.get(p_1);
        ViaInfo via_2 = this.rule_list_model.get(p_2);
        if (via_1 == null || via_2 == null) {
            return;
        }
        this.rule_list_model.set(p_1, via_2);
        this.rule_list_model.set(p_2, via_1);
        this.via_rule.swap(via_1, via_2);
    }

    private class AppendListener
    implements ActionListener {
        final /* synthetic */ WindowViaRule this$0;

        private AppendListener(WindowViaRule windowViaRule) {
            WindowViaRule windowViaRule2 = windowViaRule;
            Objects.requireNonNull(windowViaRule2);
            this.this$0 = windowViaRule2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            Object[] possible_values = new Object[this.this$0.via_list.count() - this.this$0.via_rule.via_count()];
            if (possible_values.length == 0) {
                return;
            }
            int curr_index = 0;
            for (int i = 0; i < this.this$0.via_list.count(); ++i) {
                ViaInfo curr_via = this.this$0.via_list.get(i);
                if (this.this$0.via_rule.contains(curr_via)) continue;
                if (curr_index >= possible_values.length) {
                    FRLogger.warn("ViaRuleWindow.AppendListener.actionPerformed: index inconsistent");
                    break;
                }
                possible_values[curr_index] = curr_via;
                ++curr_index;
            }
            assert (curr_index == possible_values.length);
            Object selected_value = JOptionPane.showInputDialog(null, this.this$0.tm.getText("choose_via_to_append", new String[0]), this.this$0.tm.getText("append_via_to_rule", new String[0]), 1, null, possible_values, possible_values[0]);
            if (selected_value != null) {
                ViaInfo selected_via = (ViaInfo)selected_value;
                this.this$0.via_rule.append_via(selected_via);
                this.this$0.rule_list_model.addElement(selected_via);
            }
        }
    }

    private class DeleteListener
    implements ActionListener {
        final /* synthetic */ WindowViaRule this$0;

        private DeleteListener(WindowViaRule windowViaRule) {
            WindowViaRule windowViaRule2 = windowViaRule;
            Objects.requireNonNull(windowViaRule2);
            this.this$0 = windowViaRule2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            String message;
            ViaInfo selected_via = this.this$0.rule_list.getSelectedValue();
            if (selected_via != null && WindowMessage.confirm(message = this.this$0.tm.getText("remove_2", new String[0]) + " " + selected_via.get_name() + " " + this.this$0.tm.getText("from_the_rule", new String[0]) + " " + this.this$0.via_rule.name + "?")) {
                this.this$0.rule_list_model.removeElement(selected_via);
                this.this$0.via_rule.remove_via(selected_via);
            }
        }
    }

    private class MoveUpListener
    implements ActionListener {
        final /* synthetic */ WindowViaRule this$0;

        private MoveUpListener(WindowViaRule windowViaRule) {
            WindowViaRule windowViaRule2 = windowViaRule;
            Objects.requireNonNull(windowViaRule2);
            this.this$0 = windowViaRule2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            int selected_index = this.this$0.rule_list.getSelectedIndex();
            if (selected_index <= 0) {
                return;
            }
            this.this$0.swap_position(selected_index - 1, selected_index);
            this.this$0.rule_list.setSelectedIndex(selected_index - 1);
        }
    }

    private class MoveDownListener
    implements ActionListener {
        final /* synthetic */ WindowViaRule this$0;

        private MoveDownListener(WindowViaRule windowViaRule) {
            WindowViaRule windowViaRule2 = windowViaRule;
            Objects.requireNonNull(windowViaRule2);
            this.this$0 = windowViaRule2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            int selected_index = this.this$0.rule_list.getSelectedIndex();
            if (selected_index < 0 || selected_index >= this.this$0.rule_list_model.getSize() - 1) {
                return;
            }
            this.this$0.swap_position(selected_index, selected_index + 1);
            this.this$0.rule_list.setSelectedIndex(selected_index + 1);
        }
    }
}

