/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.Freerouting;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.PlaceholderTextField;
import app.freerouting.gui.WindowBase;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.management.gson.GsonProvider;
import app.freerouting.settings.GlobalSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class WindowUserSettings
extends WindowBase {
    private WindowUserSettings(BoardFrame p_board_frame) {
        super(480, 355);
        this.setLanguage(p_board_frame.get_locale());
        final JDialog profileDialog = new JDialog((Frame)null, "User Settings", true);
        profileDialog.setTitle(this.tm.getText("title", new String[0]));
        profileDialog.setSize(480, 500);
        profileDialog.setMinimumSize(new Dimension(480, 500));
        profileDialog.setMaximumSize(new Dimension(480, 500));
        profileDialog.setResizable(false);
        profileDialog.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 15, 5, 15);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        int ipadx = 30;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.ipadx = ipadx;
        JLabel userIdLabel = new JLabel(this.tm.getText("user_id", new String[0]));
        profileDialog.add((Component)userIdLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.ipadx = 0;
        JTextField userIdField = new JTextField(Freerouting.globalSettings.userProfileSettings.userId);
        userIdField.setEditable(false);
        profileDialog.add((Component)userIdField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.ipadx = ipadx;
        JLabel emailLabel = new JLabel(this.tm.getText("email", new String[0]));
        profileDialog.add((Component)emailLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.ipadx = 0;
        final PlaceholderTextField emailField = new PlaceholderTextField(this.tm.getText("email_placeholder", new String[0]));
        emailField.setText(Freerouting.globalSettings.userProfileSettings.userEmail);
        profileDialog.add((Component)emailField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        JCheckBox telemetryCheckbox = new JCheckBox(this.tm.getText("allow_telemetry", new String[0]));
        telemetryCheckbox.setSelected(Freerouting.globalSettings.userProfileSettings.isTelemetryAllowed);
        telemetryCheckbox.addItemListener(itemEvent -> {
            Freerouting.globalSettings.userProfileSettings.isTelemetryAllowed = telemetryCheckbox.isSelected();
        });
        profileDialog.add((Component)telemetryCheckbox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        JCheckBox allowContactCheckbox = new JCheckBox(this.tm.getText("allow_contact", new String[0]));
        allowContactCheckbox.setSelected(Freerouting.globalSettings.userProfileSettings.isContactAllowed);
        allowContactCheckbox.addItemListener(itemEvent -> {
            Freerouting.globalSettings.userProfileSettings.isContactAllowed = allowContactCheckbox.isSelected();
        });
        profileDialog.add((Component)allowContactCheckbox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        final JButton updateButton = new JButton(this.tm.getText("save_settings_button", new String[0]));
        Dimension buttonSize = new Dimension(100, updateButton.getPreferredSize().height);
        updateButton.setPreferredSize(buttonSize);
        updateButton.setMaximumSize(buttonSize);
        updateButton.setEnabled(false);
        updateButton.addActionListener(new ActionListener(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Freerouting.globalSettings.userProfileSettings.userEmail = emailField.getText();
                try {
                    GlobalSettings.saveAsJson(Freerouting.globalSettings);
                }
                catch (IOException ex) {
                    FRLogger.error("Failed to save user profile settings", ex);
                }
                profileDialog.dispose();
            }
        });
        updateButton.addActionListener(actionEvent -> FRAnalytics.buttonClicked("update_button", GsonProvider.GSON.toJson(Freerouting.globalSettings)));
        profileDialog.add((Component)updateButton, gbc);
        DocumentListener documentListener = new DocumentListener(){
            final /* synthetic */ WindowUserSettings this$0;
            {
                WindowUserSettings windowUserSettings = this$0;
                Objects.requireNonNull(windowUserSettings);
                this.this$0 = windowUserSettings;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.this$0.validateEmail(emailField, updateButton);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.this$0.validateEmail(emailField, updateButton);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.this$0.validateEmail(emailField, updateButton);
            }
        };
        emailField.getDocument().addDocumentListener(documentListener);
        ItemListener itemListener = itemEvent -> this.validateEmail(emailField, updateButton);
        telemetryCheckbox.addItemListener(itemListener);
        allowContactCheckbox.addItemListener(itemListener);
        this.validateEmail(emailField, updateButton);
        if (Freerouting.globalSettings.userProfileSettings.userEmail.isEmpty()) {
            emailField.requestFocus();
            emailField.setBorder(BorderFactory.createLineBorder(Color.RED));
        } else {
            updateButton.requestFocus();
        }
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        JSeparator separator = new JSeparator();
        profileDialog.add((Component)separator, gbc);
        gbc.fill = 2;
        gbc.gridwidth = 2;
        gbc.gridy = 6;
        gbc.weightx = 0.0;
        gbc.ipadx = ipadx;
        JLabel statisticsHeader = new JLabel(this.tm.getText("statistics_header", Freerouting.globalSettings.statistics.startTime.substring(0, 10)));
        profileDialog.add((Component)statisticsHeader, gbc);
        gbc.gridwidth = 1;
        gbc.gridy = 7;
        gbc.weightx = 0.0;
        gbc.ipadx = ipadx;
        JLabel sessionsLabel = new JLabel(this.tm.getText("sessions_total", new String[0]));
        profileDialog.add((Component)sessionsLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.ipadx = 0;
        JLabel sessionsValue = new JLabel(Freerouting.globalSettings.statistics.sessionsTotal.toString());
        profileDialog.add((Component)sessionsValue, gbc);
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.weightx = 0.0;
        gbc.ipadx = ipadx;
        JLabel startedJobsLabel = new JLabel(this.tm.getText("jobs_started", new String[0]));
        profileDialog.add((Component)startedJobsLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.ipadx = 0;
        JLabel startedJobsValue = new JLabel(Freerouting.globalSettings.statistics.jobsStarted.toString());
        profileDialog.add((Component)startedJobsValue, gbc);
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.weightx = 0.0;
        gbc.ipadx = ipadx;
        JLabel completedJobsLabel = new JLabel(this.tm.getText("jobs_completed", new String[0]));
        profileDialog.add((Component)completedJobsLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.ipadx = 0;
        JLabel completedJobsValue = new JLabel(Freerouting.globalSettings.statistics.jobsCompleted.toString());
        profileDialog.add((Component)completedJobsValue, gbc);
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        JSeparator separator2 = new JSeparator();
        profileDialog.add((Component)separator2, gbc);
        gbc.gridx = 0;
        gbc.gridy = 11;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        JLabel sponsorMessage = new JLabel(this.tm.getText("sponsor_message", new String[0]));
        profileDialog.add((Component)sponsorMessage, gbc);
        gbc.gridy = 12;
        gbc.anchor = 10;
        JButton sponsorButton = new JButton(this.tm.getText("sponsor_button", new String[0]));
        sponsorButton.setPreferredSize(new Dimension(150, sponsorButton.getPreferredSize().height));
        sponsorButton.setMaximumSize(new Dimension(150, sponsorButton.getPreferredSize().height));
        sponsorButton.addActionListener(actionEvent -> {
            try {
                Desktop.getDesktop().browse(new URI("https://github.com/sponsors/andrasfuchs"));
            }
            catch (Exception ex) {
                FRLogger.error("Failed to open sponsor link", ex);
            }
        });
        profileDialog.add((Component)sponsorButton, gbc);
        profileDialog.setLocationRelativeTo(null);
        profileDialog.setVisible(true);
    }

    public static WindowUserSettings show(BoardFrame p_board_frame) {
        return new WindowUserSettings(p_board_frame);
    }

    private void validateEmail(JTextField emailField, JButton updateButton) {
        String email = emailField.getText();
        boolean isValid = email.isEmpty() || email.matches("^[A-Za-z0-9+_.-]+@[A-Za-z0-9.-]+$");
        emailField.setBorder(isValid ? BorderFactory.createLineBorder(Color.GRAY) : BorderFactory.createLineBorder(Color.RED));
        updateButton.setEnabled(isValid);
    }
}

