/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.Item;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.Trace;
import app.freerouting.board.Via;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.CleanupWindows;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.TextManager;
import app.freerouting.rules.Net;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class WindowUnconnectedRoute
extends CleanupWindows {
    private int max_unconnected_route_info_id_no;

    public WindowUnconnectedRoute(BoardFrame p_board_frame) {
        super(p_board_frame);
        this.setLanguage(p_board_frame.get_locale());
        this.tm = new TextManager(CleanupWindows.class, p_board_frame.get_locale());
        this.setTitle(this.tm.getText("unconnected_route", new String[0]));
        this.list_empty_message.setText(this.tm.getText("no_unconnected_route_found", new String[0]));
    }

    @Override
    protected void fill_list() {
        RoutingBoard routing_board = this.board_frame.board_panel.board_handling.get_routing_board();
        TreeSet<Item> handled_items = new TreeSet<Item>();
        TreeSet<UnconnectedRouteInfo> unconnected_route_info_set = new TreeSet<UnconnectedRouteInfo>();
        Collection<Item> board_items = routing_board.get_items();
        for (Item curr_item : board_items) {
            if (!(curr_item instanceof Trace) && !(curr_item instanceof Via) || handled_items.contains(curr_item)) continue;
            Set<Item> curr_connected_set = curr_item.get_connected_set(-1);
            boolean terminal_item_found = false;
            for (Item curr_connnected_item : curr_connected_set) {
                handled_items.add(curr_connnected_item);
                if (curr_connnected_item instanceof Trace || curr_connnected_item instanceof Via) continue;
                terminal_item_found = true;
            }
            if (terminal_item_found) continue;
            if (curr_item.net_count() == 1) {
                Net curr_net = routing_board.rules.nets.get(curr_item.get_net_no(0));
                if (curr_net == null) continue;
                UnconnectedRouteInfo curr_unconnected_route_info = new UnconnectedRouteInfo(this, curr_net, curr_connected_set);
                unconnected_route_info_set.add(curr_unconnected_route_info);
                continue;
            }
            FRLogger.warn("WindowUnconnectedRoute.fill_list: net_count 1 expected");
        }
        for (UnconnectedRouteInfo curr_info : unconnected_route_info_set) {
            this.add_to_list(curr_info);
        }
        this.list.setVisibleRowCount(Math.min(unconnected_route_info_set.size(), 20));
    }

    @Override
    protected void select_instances() {
        List selected_list_values = this.list.getSelectedValuesList();
        if (selected_list_values.isEmpty()) {
            return;
        }
        TreeSet<Item> selected_items = new TreeSet<Item>();
        for (int i = 0; i < selected_list_values.size(); ++i) {
            selected_items.addAll(((UnconnectedRouteInfo)selected_list_values.get((int)i)).item_list);
        }
        GuiBoardManager board_handling = this.board_frame.board_panel.board_handling;
        board_handling.select_items(selected_items);
        board_handling.zoom_selection();
    }

    private class UnconnectedRouteInfo
    implements Comparable<UnconnectedRouteInfo> {
        private final Net net;
        private final Collection<Item> item_list;
        private final int id_no;
        private final Integer trace_count;
        private final Integer via_count;
        final /* synthetic */ WindowUnconnectedRoute this$0;

        public UnconnectedRouteInfo(WindowUnconnectedRoute windowUnconnectedRoute, Net p_net, Collection<Item> p_item_list) {
            WindowUnconnectedRoute windowUnconnectedRoute2 = windowUnconnectedRoute;
            Objects.requireNonNull(windowUnconnectedRoute2);
            this.this$0 = windowUnconnectedRoute2;
            this.net = p_net;
            this.item_list = p_item_list;
            ++windowUnconnectedRoute.max_unconnected_route_info_id_no;
            this.id_no = windowUnconnectedRoute.max_unconnected_route_info_id_no;
            int curr_trace_count = 0;
            int curr_via_count = 0;
            for (Item curr_item : p_item_list) {
                if (curr_item instanceof Trace) {
                    ++curr_trace_count;
                    continue;
                }
                if (!(curr_item instanceof Via)) continue;
                ++curr_via_count;
            }
            this.trace_count = curr_trace_count;
            this.via_count = curr_via_count;
        }

        public String toString() {
            return this.this$0.tm.getText("net", new String[0]) + " " + this.net.name + ": " + this.this$0.tm.getText("trace_count", new String[0]) + " " + this.trace_count + ", " + this.this$0.tm.getText("via_count", new String[0]) + " " + this.via_count;
        }

        @Override
        public int compareTo(UnconnectedRouteInfo p_other) {
            int result = this.net.name.compareTo(p_other.net.name);
            if (result == 0) {
                result = this.id_no - p_other.id_no;
            }
            return result;
        }
    }
}

