/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.Component;
import app.freerouting.board.Item;
import app.freerouting.board.RoutingBoard;
import app.freerouting.core.Package;
import app.freerouting.core.Packages;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.WindowObjectListWithFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class WindowPackages
extends WindowObjectListWithFilter {
    public WindowPackages(BoardFrame p_board_frame) {
        super(p_board_frame);
        this.setLanguage(p_board_frame.get_locale());
        this.setTitle(this.tm.getText("packages", new String[0]));
    }

    @Override
    protected void fill_list() {
        int i;
        Packages packages = this.board_frame.board_panel.board_handling.get_routing_board().library.packages;
        Object[] sorted_arr = new Package[packages.count()];
        for (i = 0; i < sorted_arr.length; ++i) {
            sorted_arr[i] = packages.get(i + 1);
        }
        Arrays.sort(sorted_arr);
        for (i = 0; i < sorted_arr.length; ++i) {
            this.add_to_list(sorted_arr[i]);
        }
        this.list.setVisibleRowCount(Math.min(packages.count(), 20));
    }

    @Override
    protected void select_instances() {
        List selected_packages = this.list.getSelectedValuesList();
        if (selected_packages.isEmpty()) {
            return;
        }
        RoutingBoard routing_board = this.board_frame.board_panel.board_handling.get_routing_board();
        TreeSet<Item> board_instances = new TreeSet<Item>();
        Collection<Item> board_items = routing_board.get_items();
        for (Item curr_item : board_items) {
            if (curr_item.get_component_no() <= 0) continue;
            Component curr_component = routing_board.components.get(curr_item.get_component_no());
            Package curr_package = curr_component.get_package();
            boolean package_matches = false;
            for (int i = 0; i < selected_packages.size(); ++i) {
                if (curr_package != selected_packages.get(i)) continue;
                package_matches = true;
                break;
            }
            if (!package_matches) continue;
            board_instances.add(curr_item);
        }
        this.board_frame.board_panel.board_handling.select_items(board_instances);
        this.board_frame.board_panel.board_handling.zoom_selection();
    }
}

