/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.CoordinateTransform;
import app.freerouting.board.Item;
import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.board.Pin;
import app.freerouting.board.PrintableShape;
import app.freerouting.board.Trace;
import app.freerouting.board.Via;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.Shape;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardTemporarySubWindow;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.analytics.FRAnalytics;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class WindowObjectInfo
extends BoardTemporarySubWindow
implements ObjectInfoPanel {
    private static final int MAX_WINDOW_HEIGHT = 500;
    private static final int SCROLLBAR_ADD = 30;
    private final JTextPane text_pane;
    private final CoordinateTransform coordinate_transform;
    private final NumberFormat number_format;
    private final Collection<WindowObjectInfo> subwindows = new LinkedList<WindowObjectInfo>();

    private WindowObjectInfo(BoardFrame p_board_frame, CoordinateTransform p_coordinate_transform) {
        super(p_board_frame);
        this.setLanguage(p_board_frame.get_locale());
        this.coordinate_transform = p_coordinate_transform;
        this.text_pane = new JTextPane();
        this.text_pane.setEditable(false);
        this.number_format = NumberFormat.getInstance(p_board_frame.get_locale());
        this.number_format.setMaximumFractionDigits(4);
        StyledDocument document = this.text_pane.getStyledDocument();
        Style default_style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style bold_style = document.addStyle("bold", default_style);
        StyleConstants.setBold(bold_style, true);
        JScrollPane scroll_pane = new JScrollPane(this.text_pane);
        this.add(scroll_pane);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ WindowObjectInfo this$0;
            {
                WindowObjectInfo windowObjectInfo = this$0;
                Objects.requireNonNull(windowObjectInfo);
                this.this$0 = windowObjectInfo;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.dispose();
            }
        });
    }

    public static void display(Collection<Item> p_item_list, BoardFrame p_board_frame, CoordinateTransform p_coordinate_transform, Point p_location) {
        WindowObjectInfo new_instance = new WindowObjectInfo(p_board_frame, p_coordinate_transform);
        new_instance.setTitle(new_instance.tm.getText("title", new String[0]));
        Integer pin_count = 0;
        Integer via_count = 0;
        Integer trace_count = 0;
        double cumulative_trace_length = 0.0;
        for (ObjectInfoPanel.Printable printable : p_item_list) {
            printable.print_info(new_instance, p_board_frame.get_locale());
            if (printable instanceof Pin) {
                pin_count = pin_count + 1;
                continue;
            }
            if (printable instanceof Via) {
                via_count = via_count + 1;
                continue;
            }
            if (!(printable instanceof Trace)) continue;
            Trace trace = (Trace)printable;
            trace_count = trace_count + 1;
            cumulative_trace_length += trace.get_length();
        }
        new_instance.append_bold(new_instance.tm.getText("summary", new String[0]) + " ");
        NumberFormat number_format = NumberFormat.getInstance(p_board_frame.get_locale());
        if (pin_count > 0) {
            new_instance.append(number_format.format(pin_count));
            if (pin_count == 1) {
                new_instance.append(" " + new_instance.tm.getText("pin", new String[0]));
            } else {
                new_instance.append(" " + new_instance.tm.getText("pins", new String[0]));
            }
            if (via_count + trace_count > 0) {
                new_instance.append(", ");
            }
        }
        if (via_count > 0) {
            new_instance.append(number_format.format(via_count));
            if (via_count == 1) {
                new_instance.append(" " + new_instance.tm.getText("via", new String[0]));
            } else {
                new_instance.append(" " + new_instance.tm.getText("vias", new String[0]));
            }
            if (trace_count > 0) {
                new_instance.append(", ");
            }
        }
        if (trace_count > 0) {
            new_instance.append(number_format.format(trace_count));
            if (trace_count == 1) {
                new_instance.append(" " + new_instance.tm.getText("trace", new String[0]) + " ");
            } else {
                new_instance.append(" " + new_instance.tm.getText("traces", new String[0]) + " ");
            }
            new_instance.append(cumulative_trace_length);
        }
        new_instance.pack();
        Dimension dimension = new_instance.getSize();
        if (dimension.getHeight() > 500.0) {
            new_instance.setPreferredSize(new Dimension((int)dimension.getWidth() + 30, 500));
            new_instance.pack();
        }
        new_instance.setLocation(p_location);
        new_instance.setVisible(true);
    }

    public static WindowObjectInfo display(String p_title, Collection<ObjectInfoPanel.Printable> p_object_list, BoardFrame p_board_frame, CoordinateTransform p_coordinate_transform) {
        WindowObjectInfo new_window = new WindowObjectInfo(p_board_frame, p_coordinate_transform);
        new_window.setTitle(p_title);
        if (p_object_list.isEmpty()) {
            new_window.append(new_window.tm.getText("list_empty", new String[0]));
        }
        for (ObjectInfoPanel.Printable curr_object : p_object_list) {
            curr_object.print_info(new_window, p_board_frame.get_locale());
        }
        new_window.pack();
        Dimension size = new_window.getSize();
        if (size.getHeight() > 500.0) {
            new_window.setPreferredSize(new Dimension((int)size.getWidth() + 30, 500));
            new_window.pack();
        }
        new_window.setVisible(true);
        return new_window;
    }

    private boolean append(String p_string, String p_style) {
        StyledDocument document = this.text_pane.getStyledDocument();
        try {
            document.insertString(document.getLength(), p_string, document.getStyle(p_style));
        }
        catch (BadLocationException badLocationException) {
            FRLogger.warn("ObjectInfoWindow.append: unable to insert text into text pane.");
            return false;
        }
        return true;
    }

    @Override
    public boolean append(String p_string) {
        return this.append(p_string, "normal");
    }

    @Override
    public boolean append_bold(String p_string) {
        return this.append(p_string, "bold");
    }

    @Override
    public boolean append(double p_value) {
        Float value = Float.valueOf((float)this.coordinate_transform.board_to_user(p_value));
        return this.append(this.number_format.format(value));
    }

    @Override
    public boolean append_without_transforming(double p_value) {
        Float value = Float.valueOf((float)p_value);
        return this.append(this.number_format.format(value));
    }

    @Override
    public boolean append(FloatPoint p_point) {
        FloatPoint transformed_point = this.coordinate_transform.board_to_user(p_point);
        return this.append(transformed_point.to_string(this.board_frame.get_locale()));
    }

    @Override
    public boolean append(Shape p_shape, Locale p_locale) {
        PrintableShape transformed_shape = this.coordinate_transform.board_to_user(p_shape, p_locale);
        if (transformed_shape == null) {
            return false;
        }
        return this.append(transformed_shape.toString());
    }

    @Override
    public boolean newline() {
        return this.append("\n");
    }

    @Override
    public boolean indent() {
        return this.append("       ");
    }

    @Override
    public boolean append(String p_button_name, String p_window_title, ObjectInfoPanel.Printable p_object) {
        LinkedList<ObjectInfoPanel.Printable> object_list = new LinkedList<ObjectInfoPanel.Printable>();
        object_list.add(p_object);
        return this.append_objects(p_button_name, p_window_title, object_list);
    }

    @Override
    public boolean append_items(String p_button_name, String p_window_title, Collection<Item> p_items) {
        LinkedList<ObjectInfoPanel.Printable> object_list = new LinkedList<ObjectInfoPanel.Printable>(p_items);
        return this.append_objects(p_button_name, p_window_title, object_list);
    }

    @Override
    public boolean append_objects(String p_button_name, String p_window_title, Collection<ObjectInfoPanel.Printable> p_objects) {
        JButton object_info_button = new JButton();
        object_info_button.setText(p_button_name);
        object_info_button.setBorderPainted(false);
        object_info_button.setContentAreaFilled(false);
        object_info_button.setMargin(new Insets(0, 0, 0, 0));
        object_info_button.setAlignmentY(0.75f);
        object_info_button.setForeground(Color.blue);
        object_info_button.addActionListener(new InfoButtonListener(this, p_window_title, p_objects));
        object_info_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("object_info_button", object_info_button.getText()));
        StyledDocument document = this.text_pane.getStyledDocument();
        Style default_style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style button_style = document.addStyle(p_button_name, default_style);
        StyleConstants.setAlignment(button_style, 1);
        StyleConstants.setComponent(button_style, object_info_button);
        try {
            document.insertString(document.getLength(), p_button_name, button_style);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("ObjectInfoWindow.append: unable to insert text into text pane.");
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        for (WindowObjectInfo curr_subwindow : this.subwindows) {
            if (curr_subwindow == null) continue;
            curr_subwindow.dispose();
        }
        super.dispose();
    }

    private class InfoButtonListener
    implements ActionListener {
        private static final int WINDOW_OFFSET = 30;
        private final String title;
        private final Collection<ObjectInfoPanel.Printable> objects;
        final /* synthetic */ WindowObjectInfo this$0;

        public InfoButtonListener(WindowObjectInfo windowObjectInfo, String p_title, Collection<ObjectInfoPanel.Printable> p_objects) {
            WindowObjectInfo windowObjectInfo2 = windowObjectInfo;
            Objects.requireNonNull(windowObjectInfo2);
            this.this$0 = windowObjectInfo2;
            this.title = p_title;
            this.objects = p_objects;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowObjectInfo new_window = WindowObjectInfo.display(this.title, this.objects, this.this$0.board_frame, this.this$0.coordinate_transform);
            Point loc = this.this$0.getLocation();
            Point new_window_location = new Point((int)(loc.getX() + 30.0), (int)(loc.getY() + 30.0));
            new_window.setLocation(new_window_location);
            this.this$0.subwindows.add(new_window);
        }
    }
}

