/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.boardgraphics.CoordinateTransform;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardPanel;
import app.freerouting.gui.BoardSavableSubWindow;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.analytics.FRAnalytics;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WindowDisplayMisc
extends BoardSavableSubWindow {
    private static final int MAX_SLIDER_VALUE = 100;
    private final BoardPanel panel;
    private final JRadioButton appearance_misc_small_cursor_checkbox;
    private final JRadioButton appearance_misc_big_cursor_checkbox;
    private final JRadioButton appearance_misc_rotation_none_checkbox;
    private final JRadioButton appearance_misc_rotation_90_degree_checkbox;
    private final JRadioButton appearance_misc_rotation_180_degree_checkbox;
    private final JRadioButton appearance_misc_rotation_270_degree_checkbox;
    private final JRadioButton appearance_misc_mirror_none_checkbox;
    private final JRadioButton appearance_misc_vertical_mirror_checkbox;
    private final JRadioButton appearance_misc_horizontal_mirror_checkbox;
    private final JSlider auto_layer_dim_slider;

    public WindowDisplayMisc(BoardFrame p_board_frame) {
        this.setLanguage(p_board_frame.get_locale());
        this.panel = p_board_frame.board_panel;
        this.setTitle(this.tm.getText("title", new String[0]));
        JPanel main_panel = new JPanel();
        this.getContentPane().add(main_panel);
        GridBagLayout gridbag = new GridBagLayout();
        main_panel.setLayout(gridbag);
        GridBagConstraints gridbag_constraints = new GridBagConstraints();
        gridbag_constraints.anchor = 17;
        gridbag_constraints.gridwidth = -1;
        JLabel cursor_label = new JLabel("   " + this.tm.getText("cross_hair_cursor", new String[0]));
        gridbag_constraints.gridwidth = -1;
        gridbag_constraints.gridheight = 2;
        gridbag.setConstraints(cursor_label, gridbag_constraints);
        main_panel.add((Component)cursor_label, gridbag_constraints);
        gridbag_constraints.gridwidth = 0;
        gridbag_constraints.gridheight = 1;
        this.appearance_misc_small_cursor_checkbox = new JRadioButton(this.tm.getText("small", new String[0]));
        this.appearance_misc_small_cursor_checkbox.setToolTipText(this.tm.getText("cursor_checkbox_tooltip", new String[0]));
        this.appearance_misc_small_cursor_checkbox.addActionListener(new SmallCursorListener(this));
        this.appearance_misc_small_cursor_checkbox.addActionListener(actionEvent -> FRAnalytics.buttonClicked("appearance_misc_small_cursor_checkbox", this.appearance_misc_small_cursor_checkbox.getText()));
        gridbag.setConstraints(this.appearance_misc_small_cursor_checkbox, gridbag_constraints);
        main_panel.add((Component)this.appearance_misc_small_cursor_checkbox, gridbag_constraints);
        this.appearance_misc_big_cursor_checkbox = new JRadioButton(this.tm.getText("big", new String[0]));
        this.appearance_misc_big_cursor_checkbox.addActionListener(new BigCursorListener(this));
        this.appearance_misc_big_cursor_checkbox.addActionListener(actionEvent -> FRAnalytics.buttonClicked("appearance_misc_big_cursor_checkbox", this.appearance_misc_big_cursor_checkbox.getText()));
        this.appearance_misc_big_cursor_checkbox.setToolTipText(this.tm.getText("cursor_checkbox_tooltip", new String[0]));
        gridbag.setConstraints(this.appearance_misc_big_cursor_checkbox, gridbag_constraints);
        main_panel.add((Component)this.appearance_misc_big_cursor_checkbox, gridbag_constraints);
        ButtonGroup cursor_button_group = new ButtonGroup();
        cursor_button_group.add(this.appearance_misc_small_cursor_checkbox);
        cursor_button_group.add(this.appearance_misc_big_cursor_checkbox);
        JLabel separator = new JLabel("  \u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        JLabel rotation_label = new JLabel("   " + this.tm.getText("rotation", new String[0]));
        gridbag_constraints.gridwidth = -1;
        gridbag_constraints.gridheight = 4;
        gridbag.setConstraints(rotation_label, gridbag_constraints);
        main_panel.add((Component)rotation_label, gridbag_constraints);
        gridbag_constraints.gridwidth = 0;
        gridbag_constraints.gridheight = 1;
        this.appearance_misc_rotation_none_checkbox = new JRadioButton(this.tm.getText("none", new String[0]));
        gridbag.setConstraints(this.appearance_misc_rotation_none_checkbox, gridbag_constraints);
        main_panel.add((Component)this.appearance_misc_rotation_none_checkbox, gridbag_constraints);
        this.appearance_misc_rotation_90_degree_checkbox = new JRadioButton(this.tm.getText("90_degree", new String[0]));
        gridbag.setConstraints(this.appearance_misc_rotation_90_degree_checkbox, gridbag_constraints);
        main_panel.add((Component)this.appearance_misc_rotation_90_degree_checkbox, gridbag_constraints);
        this.appearance_misc_rotation_180_degree_checkbox = new JRadioButton(this.tm.getText("180_degree", new String[0]));
        gridbag.setConstraints(this.appearance_misc_rotation_180_degree_checkbox, gridbag_constraints);
        main_panel.add((Component)this.appearance_misc_rotation_180_degree_checkbox, gridbag_constraints);
        this.appearance_misc_rotation_270_degree_checkbox = new JRadioButton(this.tm.getText("-90_degree", new String[0]));
        gridbag.setConstraints(this.appearance_misc_rotation_270_degree_checkbox, gridbag_constraints);
        main_panel.add((Component)this.appearance_misc_rotation_270_degree_checkbox, gridbag_constraints);
        ButtonGroup rotation_button_group = new ButtonGroup();
        rotation_button_group.add(this.appearance_misc_rotation_none_checkbox);
        rotation_button_group.add(this.appearance_misc_rotation_90_degree_checkbox);
        rotation_button_group.add(this.appearance_misc_rotation_180_degree_checkbox);
        rotation_button_group.add(this.appearance_misc_rotation_270_degree_checkbox);
        this.appearance_misc_rotation_none_checkbox.addActionListener(new RotationNoneListener(this));
        this.appearance_misc_rotation_none_checkbox.addActionListener(actionEvent -> FRAnalytics.buttonClicked("appearance_misc_rotation_none_checkbox", this.appearance_misc_rotation_none_checkbox.getText()));
        this.appearance_misc_rotation_90_degree_checkbox.addActionListener(new Rotation90Listener(this));
        this.appearance_misc_rotation_90_degree_checkbox.addActionListener(actionEvent -> FRAnalytics.buttonClicked("appearance_misc_rotation_90_degree_checkbox", this.appearance_misc_rotation_90_degree_checkbox.getText()));
        this.appearance_misc_rotation_180_degree_checkbox.addActionListener(new Rotation180Listener(this));
        this.appearance_misc_rotation_180_degree_checkbox.addActionListener(actionEvent -> FRAnalytics.buttonClicked("appearance_misc_rotation_180_degree_checkbox", this.appearance_misc_rotation_180_degree_checkbox.getText()));
        this.appearance_misc_rotation_270_degree_checkbox.addActionListener(new Rotation270Listener(this));
        this.appearance_misc_rotation_270_degree_checkbox.addActionListener(actionEvent -> FRAnalytics.buttonClicked("appearance_misc_rotation_270_degree_checkbox", this.appearance_misc_rotation_270_degree_checkbox.getText()));
        separator = new JLabel("  \u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        JLabel mirroring_label = new JLabel("   " + this.tm.getText("board_mirroring", new String[0]));
        gridbag_constraints.gridwidth = -1;
        gridbag_constraints.gridheight = 3;
        gridbag.setConstraints(mirroring_label, gridbag_constraints);
        main_panel.add((Component)mirroring_label, gridbag_constraints);
        gridbag_constraints.gridwidth = 0;
        gridbag_constraints.gridheight = 1;
        this.appearance_misc_mirror_none_checkbox = new JRadioButton(this.tm.getText("none", new String[0]));
        this.appearance_misc_mirror_none_checkbox.addActionListener(new MirrorNoneListener(this));
        this.appearance_misc_mirror_none_checkbox.addActionListener(actionEvent -> FRAnalytics.buttonClicked("appearance_misc_mirror_none_checkbox", this.appearance_misc_mirror_none_checkbox.getText()));
        gridbag.setConstraints(this.appearance_misc_mirror_none_checkbox, gridbag_constraints);
        main_panel.add((Component)this.appearance_misc_mirror_none_checkbox, gridbag_constraints);
        this.appearance_misc_vertical_mirror_checkbox = new JRadioButton(this.tm.getText("left_right", new String[0]));
        this.appearance_misc_vertical_mirror_checkbox.addActionListener(new VerticalMirrorListener(this));
        this.appearance_misc_vertical_mirror_checkbox.addActionListener(actionEvent -> FRAnalytics.buttonClicked("appearance_misc_vertical_mirror_checkbox", this.appearance_misc_vertical_mirror_checkbox.getText()));
        gridbag.setConstraints(this.appearance_misc_vertical_mirror_checkbox, gridbag_constraints);
        main_panel.add((Component)this.appearance_misc_vertical_mirror_checkbox, gridbag_constraints);
        this.appearance_misc_horizontal_mirror_checkbox = new JRadioButton(this.tm.getText("top_bottom", new String[0]));
        this.appearance_misc_horizontal_mirror_checkbox.addActionListener(new HorizontalMirrorListener(this));
        this.appearance_misc_horizontal_mirror_checkbox.addActionListener(actionEvent -> FRAnalytics.buttonClicked("appearance_misc_horizontal_mirror_checkbox", this.appearance_misc_horizontal_mirror_checkbox.getText()));
        gridbag.setConstraints(this.appearance_misc_horizontal_mirror_checkbox, gridbag_constraints);
        main_panel.add((Component)this.appearance_misc_horizontal_mirror_checkbox, gridbag_constraints);
        ButtonGroup mirroring_button_group = new ButtonGroup();
        mirroring_button_group.add(this.appearance_misc_mirror_none_checkbox);
        mirroring_button_group.add(this.appearance_misc_vertical_mirror_checkbox);
        mirroring_button_group.add(this.appearance_misc_horizontal_mirror_checkbox);
        separator = new JLabel("  \u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        gridbag_constraints.insets = new Insets(5, 10, 5, 10);
        JLabel auto_layer_dim_label = new JLabel(this.tm.getText("layer_dimming", new String[0]));
        auto_layer_dim_label.setToolTipText(this.tm.getText("layer_dimming_tooltip", new String[0]));
        gridbag.setConstraints(auto_layer_dim_label, gridbag_constraints);
        main_panel.add(auto_layer_dim_label);
        this.auto_layer_dim_slider = new JSlider(0, 100);
        gridbag.setConstraints(this.auto_layer_dim_slider, gridbag_constraints);
        main_panel.add(this.auto_layer_dim_slider);
        this.auto_layer_dim_slider.addChangeListener(new SliderChangeListener(this));
        this.refresh();
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void refresh() {
        this.appearance_misc_small_cursor_checkbox.setSelected(!this.panel.is_custom_cross_hair_cursor());
        this.appearance_misc_big_cursor_checkbox.setSelected(this.panel.is_custom_cross_hair_cursor());
        int ninety_degree_rotation = this.panel.board_handling.graphics_context.coordinate_transform.get_90_degree_rotation();
        switch (ninety_degree_rotation) {
            case 0: {
                this.appearance_misc_rotation_none_checkbox.setSelected(true);
                break;
            }
            case 1: {
                this.appearance_misc_rotation_90_degree_checkbox.setSelected(true);
                break;
            }
            case 2: {
                this.appearance_misc_rotation_180_degree_checkbox.setSelected(true);
                break;
            }
            case 3: {
                this.appearance_misc_rotation_270_degree_checkbox.setSelected(true);
                break;
            }
            default: {
                FRLogger.warn("DisplayMiscWindow: unexpected ninety_degree_rotation");
                this.appearance_misc_rotation_none_checkbox.setSelected(true);
            }
        }
        boolean is_mirror_left_right = this.panel.board_handling.graphics_context.coordinate_transform.is_mirror_left_right();
        boolean is_mirror_top_button = this.panel.board_handling.graphics_context.coordinate_transform.is_mirror_top_bottom();
        this.appearance_misc_mirror_none_checkbox.setSelected(!is_mirror_left_right && !is_mirror_top_button);
        this.appearance_misc_vertical_mirror_checkbox.setSelected(this.panel.board_handling.graphics_context.coordinate_transform.is_mirror_left_right());
        this.appearance_misc_horizontal_mirror_checkbox.setSelected(this.panel.board_handling.graphics_context.coordinate_transform.is_mirror_top_bottom());
        int curr_slider_value = (int)Math.round(100.0 * (1.0 - this.panel.board_handling.graphics_context.get_auto_layer_dim_factor()));
        this.auto_layer_dim_slider.setValue(curr_slider_value);
    }

    private class SmallCursorListener
    implements ActionListener {
        final /* synthetic */ WindowDisplayMisc this$0;

        private SmallCursorListener(WindowDisplayMisc windowDisplayMisc) {
            WindowDisplayMisc windowDisplayMisc2 = windowDisplayMisc;
            Objects.requireNonNull(windowDisplayMisc2);
            this.this$0 = windowDisplayMisc2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            this.this$0.panel.set_custom_crosshair_cursor(false);
        }
    }

    private class BigCursorListener
    implements ActionListener {
        final /* synthetic */ WindowDisplayMisc this$0;

        private BigCursorListener(WindowDisplayMisc windowDisplayMisc) {
            WindowDisplayMisc windowDisplayMisc2 = windowDisplayMisc;
            Objects.requireNonNull(windowDisplayMisc2);
            this.this$0 = windowDisplayMisc2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            this.this$0.panel.set_custom_crosshair_cursor(true);
        }
    }

    private class RotationNoneListener
    implements ActionListener {
        final /* synthetic */ WindowDisplayMisc this$0;

        private RotationNoneListener(WindowDisplayMisc windowDisplayMisc) {
            WindowDisplayMisc windowDisplayMisc2 = windowDisplayMisc;
            Objects.requireNonNull(windowDisplayMisc2);
            this.this$0 = windowDisplayMisc2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            CoordinateTransform coordinate_transform = this.this$0.panel.board_handling.graphics_context.coordinate_transform;
            coordinate_transform.set_rotation(0.0);
            this.this$0.panel.repaint();
        }
    }

    private class Rotation90Listener
    implements ActionListener {
        final /* synthetic */ WindowDisplayMisc this$0;

        private Rotation90Listener(WindowDisplayMisc windowDisplayMisc) {
            WindowDisplayMisc windowDisplayMisc2 = windowDisplayMisc;
            Objects.requireNonNull(windowDisplayMisc2);
            this.this$0 = windowDisplayMisc2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            CoordinateTransform coordinate_transform = this.this$0.panel.board_handling.graphics_context.coordinate_transform;
            coordinate_transform.set_rotation(1.5707963267948966);
            this.this$0.panel.repaint();
        }
    }

    private class Rotation180Listener
    implements ActionListener {
        final /* synthetic */ WindowDisplayMisc this$0;

        private Rotation180Listener(WindowDisplayMisc windowDisplayMisc) {
            WindowDisplayMisc windowDisplayMisc2 = windowDisplayMisc;
            Objects.requireNonNull(windowDisplayMisc2);
            this.this$0 = windowDisplayMisc2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            CoordinateTransform coordinate_transform = this.this$0.panel.board_handling.graphics_context.coordinate_transform;
            coordinate_transform.set_rotation(Math.PI);
            this.this$0.panel.repaint();
        }
    }

    private class Rotation270Listener
    implements ActionListener {
        final /* synthetic */ WindowDisplayMisc this$0;

        private Rotation270Listener(WindowDisplayMisc windowDisplayMisc) {
            WindowDisplayMisc windowDisplayMisc2 = windowDisplayMisc;
            Objects.requireNonNull(windowDisplayMisc2);
            this.this$0 = windowDisplayMisc2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            CoordinateTransform coordinate_transform = this.this$0.panel.board_handling.graphics_context.coordinate_transform;
            coordinate_transform.set_rotation(4.71238898038469);
            this.this$0.panel.repaint();
        }
    }

    private class MirrorNoneListener
    implements ActionListener {
        final /* synthetic */ WindowDisplayMisc this$0;

        private MirrorNoneListener(WindowDisplayMisc windowDisplayMisc) {
            WindowDisplayMisc windowDisplayMisc2 = windowDisplayMisc;
            Objects.requireNonNull(windowDisplayMisc2);
            this.this$0 = windowDisplayMisc2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            CoordinateTransform coordinate_transform = this.this$0.panel.board_handling.graphics_context.coordinate_transform;
            if (!coordinate_transform.is_mirror_left_right() && !coordinate_transform.is_mirror_top_bottom()) {
                return;
            }
            FloatPoint old_viewport_center = coordinate_transform.screen_to_board(this.this$0.panel.get_viewport_center());
            coordinate_transform.set_mirror_left_right(false);
            coordinate_transform.set_mirror_top_bottom(false);
            this.this$0.panel.set_viewport_center(coordinate_transform.board_to_screen(old_viewport_center));
            this.this$0.panel.repaint();
        }
    }

    private class VerticalMirrorListener
    implements ActionListener {
        final /* synthetic */ WindowDisplayMisc this$0;

        private VerticalMirrorListener(WindowDisplayMisc windowDisplayMisc) {
            WindowDisplayMisc windowDisplayMisc2 = windowDisplayMisc;
            Objects.requireNonNull(windowDisplayMisc2);
            this.this$0 = windowDisplayMisc2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            CoordinateTransform coordinate_transform = this.this$0.panel.board_handling.graphics_context.coordinate_transform;
            if (coordinate_transform.is_mirror_left_right()) {
                return;
            }
            FloatPoint old_viewport_center = coordinate_transform.screen_to_board(this.this$0.panel.get_viewport_center());
            coordinate_transform.set_mirror_left_right(true);
            coordinate_transform.set_mirror_top_bottom(false);
            this.this$0.panel.set_viewport_center(coordinate_transform.board_to_screen(old_viewport_center));
            this.this$0.panel.repaint();
        }
    }

    private class HorizontalMirrorListener
    implements ActionListener {
        final /* synthetic */ WindowDisplayMisc this$0;

        private HorizontalMirrorListener(WindowDisplayMisc windowDisplayMisc) {
            WindowDisplayMisc windowDisplayMisc2 = windowDisplayMisc;
            Objects.requireNonNull(windowDisplayMisc2);
            this.this$0 = windowDisplayMisc2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            CoordinateTransform coordinate_transform = this.this$0.panel.board_handling.graphics_context.coordinate_transform;
            if (coordinate_transform.is_mirror_top_bottom()) {
                return;
            }
            FloatPoint old_viewport_center = coordinate_transform.screen_to_board(this.this$0.panel.get_viewport_center());
            coordinate_transform.set_mirror_top_bottom(true);
            coordinate_transform.set_mirror_left_right(false);
            this.this$0.panel.set_viewport_center(coordinate_transform.board_to_screen(old_viewport_center));
            this.this$0.panel.repaint();
        }
    }

    private class SliderChangeListener
    implements ChangeListener {
        final /* synthetic */ WindowDisplayMisc this$0;

        private SliderChangeListener(WindowDisplayMisc windowDisplayMisc) {
            WindowDisplayMisc windowDisplayMisc2 = windowDisplayMisc;
            Objects.requireNonNull(windowDisplayMisc2);
            this.this$0 = windowDisplayMisc2;
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            double new_value = 1.0 - (double)this.this$0.auto_layer_dim_slider.getValue() / 100.0;
            this.this$0.panel.board_handling.graphics_context.set_auto_layer_dim_factor(new_value);
            this.this$0.panel.repaint();
        }
    }
}

