/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.Item;
import app.freerouting.board.RoutingBoard;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardSavableSubWindow;
import app.freerouting.gui.ComboBoxLayer;
import app.freerouting.interactive.GuiBoardManager;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.analytics.FRAnalytics;
import app.freerouting.rules.ClearanceMatrix;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class WindowClearanceMatrix
extends BoardSavableSubWindow {
    private static final String[] reserved_name_chars = new String[]{"(", ")", " ", "_"};
    private final BoardFrame board_frame;
    private final JPanel main_panel;
    private final ComboBoxLayer rules_clearance_layer_combo_box;
    private JPanel center_panel;
    private JTable clearance_table;
    private ClearanceTableModel clearance_table_model;

    public WindowClearanceMatrix(BoardFrame p_board_frame) {
        this.board_frame = p_board_frame;
        this.setLanguage(p_board_frame.get_locale());
        this.setTitle(this.tm.getText("title", new String[0]));
        this.main_panel = new JPanel();
        this.main_panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.main_panel.setLayout(new BorderLayout());
        JPanel north_panel = new JPanel();
        north_panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
        JLabel layer_label = new JLabel(this.tm.getText("layer", new String[0]) + " ");
        layer_label.setToolTipText(this.tm.getText("layer_tooltip", new String[0]));
        north_panel.add(layer_label);
        GuiBoardManager board_handling = this.board_frame.board_panel.board_handling;
        this.rules_clearance_layer_combo_box = new ComboBoxLayer(board_handling.get_routing_board().layer_structure, p_board_frame.get_locale());
        north_panel.add(this.rules_clearance_layer_combo_box);
        this.rules_clearance_layer_combo_box.addActionListener(new ComboBoxListener(this));
        this.rules_clearance_layer_combo_box.addActionListener(actionEvent -> FRAnalytics.buttonClicked("rules_clearance_layer_combo_box", this.rules_clearance_layer_combo_box.getSelectedItem().toString()));
        this.main_panel.add((Component)north_panel, "North");
        this.center_panel = this.add_clearance_table(p_board_frame);
        this.main_panel.add((Component)this.center_panel, "Center");
        JPanel south_panel = new JPanel();
        south_panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        south_panel.setLayout(new BorderLayout());
        this.add(south_panel);
        JButton rules_clearance_add_class_button = new JButton(this.tm.getText("add_class", new String[0]));
        rules_clearance_add_class_button.setToolTipText(this.tm.getText("add_class_tooltip", new String[0]));
        rules_clearance_add_class_button.addActionListener(new AddClassListener(this));
        rules_clearance_add_class_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("rules_clearance_add_class_button", rules_clearance_add_class_button.getText()));
        south_panel.add((Component)rules_clearance_add_class_button, "West");
        JButton rules_clearance_prune_button = new JButton(this.tm.getText("prune", new String[0]));
        rules_clearance_prune_button.setToolTipText(this.tm.getText("prune_tooltip", new String[0]));
        rules_clearance_prune_button.addActionListener(new PruneListener(this));
        rules_clearance_prune_button.addActionListener(actionEvent -> FRAnalytics.buttonClicked("rules_clearance_prune_button", rules_clearance_prune_button.getText()));
        south_panel.add((Component)rules_clearance_prune_button, "East");
        this.main_panel.add((Component)south_panel, "South");
        this.add(this.main_panel);
        this.pack();
    }

    @Override
    public void refresh() {
        RoutingBoard routing_board = this.board_frame.board_panel.board_handling.get_routing_board();
        if (this.clearance_table_model.getRowCount() != routing_board.rules.clearance_matrix.get_class_count()) {
            this.adjust_clearance_table();
        }
        this.clearance_table_model.set_values(this.rules_clearance_layer_combo_box.get_selected_layer().index);
        this.repaint();
    }

    private JPanel add_clearance_table(BoardFrame p_board_frame) {
        this.clearance_table_model = new ClearanceTableModel(this, p_board_frame.board_panel.board_handling);
        this.clearance_table = new JTable(this.clearance_table_model);
        int textfield_height = 16;
        int textfield_width = Math.max(6 * this.max_name_length(), 100);
        int table_height = 16 * this.clearance_table_model.getRowCount();
        int table_width = textfield_width * this.clearance_table_model.getColumnCount();
        this.clearance_table.setPreferredSize(new Dimension(table_width, table_height));
        this.clearance_table.setAutoResizeMode(0);
        JPanel scroll_panel = new JPanel();
        scroll_panel.setLayout(new BorderLayout());
        scroll_panel.add((Component)this.clearance_table.getTableHeader(), "North");
        scroll_panel.add((Component)this.clearance_table, "Center");
        JScrollPane scroll_pane = new JScrollPane(scroll_panel, 20, 30);
        int scroll_bar_width = 20;
        int scroll_pane_height = 16 * this.clearance_table_model.getRowCount() + 20;
        int scroll_pane_width = Math.min(table_width + 20, 1200);
        scroll_pane.setPreferredSize(new Dimension(scroll_pane_width, scroll_pane_height));
        Color header_background_color = new Color(220, 220, 255);
        JTableHeader table_header = this.clearance_table.getTableHeader();
        table_header.setBackground(header_background_color);
        TableColumn first_column = this.clearance_table.getColumnModel().getColumn(0);
        DefaultTableCellRenderer first_column_renderer = new DefaultTableCellRenderer();
        first_column_renderer.setBackground(header_background_color);
        first_column.setCellRenderer(first_column_renderer);
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        result.add((Component)scroll_pane, "Center");
        if ("de".equalsIgnoreCase(p_board_frame.get_locale().getLanguage())) {
            JLabel bug_label = new JLabel("Wegen eines Java-System-Bugs muss das Dezimalkomma in dieser Tabelle als Punkt eingegeben werden!");
            result.add((Component)bug_label, "South");
        }
        return result;
    }

    private void add_class() {
        String new_name;
        do {
            if ((new_name = JOptionPane.showInputDialog(this.tm.getText("new_name", new String[0]))) != null) continue;
            return;
        } while (!this.is_legal_class_name(new_name = new_name.trim()));
        RoutingBoard routing_board = this.board_frame.board_panel.board_handling.get_routing_board();
        ClearanceMatrix clearance_matrix = routing_board.rules.clearance_matrix;
        boolean name_exists = false;
        for (int i = 0; i < clearance_matrix.get_class_count(); ++i) {
            if (!new_name.equals(clearance_matrix.get_name(i))) continue;
            name_exists = true;
            break;
        }
        if (name_exists) {
            return;
        }
        clearance_matrix.append_class(new_name);
        routing_board.search_tree_manager.set_clearance_compensation_used(false);
        this.adjust_clearance_table();
    }

    private void prune_clearance_matrix() {
        RoutingBoard routing_board = this.board_frame.board_panel.board_handling.get_routing_board();
        ClearanceMatrix clearance_matrix = routing_board.rules.clearance_matrix;
        block0: for (int i = clearance_matrix.get_class_count() - 1; i >= 2; --i) {
            for (int j = clearance_matrix.get_class_count() - 1; j >= 0; --j) {
                if (i == j || !clearance_matrix.is_equal(i, j)) continue;
                String message = this.tm.getText("confirm_remove", new String[0]) + " " + clearance_matrix.get_name(i);
                int remove_clearance_class_dialog = JOptionPane.showConfirmDialog(this, message, null, 0);
                if (remove_clearance_class_dialog != 0) continue block0;
                Collection<Item> board_items = routing_board.get_items();
                routing_board.rules.change_clearance_class_no(i, j, board_items);
                if (!routing_board.rules.remove_clearance_class(i, board_items)) {
                    FRLogger.warn("WindowClearanceMatrix.prune_clearance_matrix error removing clearance class");
                    return;
                }
                routing_board.search_tree_manager.clearance_class_removed(i);
                this.adjust_clearance_table();
                continue block0;
            }
        }
    }

    private void adjust_clearance_table() {
        this.clearance_table_model = new ClearanceTableModel(this, this.board_frame.board_panel.board_handling);
        this.clearance_table = new JTable(this.clearance_table_model);
        this.main_panel.remove(this.center_panel);
        this.center_panel = this.add_clearance_table(this.board_frame);
        this.main_panel.add((Component)this.center_panel, "Center");
        this.pack();
        this.board_frame.refresh_windows();
    }

    private boolean is_legal_class_name(String p_string) {
        if (p_string.isEmpty()) {
            return false;
        }
        for (int i = 0; i < reserved_name_chars.length; ++i) {
            if (!p_string.contains(reserved_name_chars[i])) continue;
            return false;
        }
        return true;
    }

    private int max_name_length() {
        int result = 1;
        ClearanceMatrix clearance_matrix = this.board_frame.board_panel.board_handling.get_routing_board().rules.clearance_matrix;
        for (int i = 0; i < clearance_matrix.get_class_count(); ++i) {
            result = Math.max(result, clearance_matrix.get_name(i).length());
        }
        return result;
    }

    private class ComboBoxListener
    implements ActionListener {
        final /* synthetic */ WindowClearanceMatrix this$0;

        private ComboBoxListener(WindowClearanceMatrix windowClearanceMatrix) {
            WindowClearanceMatrix windowClearanceMatrix2 = windowClearanceMatrix;
            Objects.requireNonNull(windowClearanceMatrix2);
            this.this$0 = windowClearanceMatrix2;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.this$0.refresh();
        }
    }

    private class AddClassListener
    implements ActionListener {
        final /* synthetic */ WindowClearanceMatrix this$0;

        private AddClassListener(WindowClearanceMatrix windowClearanceMatrix) {
            WindowClearanceMatrix windowClearanceMatrix2 = windowClearanceMatrix;
            Objects.requireNonNull(windowClearanceMatrix2);
            this.this$0 = windowClearanceMatrix2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            this.this$0.add_class();
        }
    }

    private class PruneListener
    implements ActionListener {
        final /* synthetic */ WindowClearanceMatrix this$0;

        private PruneListener(WindowClearanceMatrix windowClearanceMatrix) {
            WindowClearanceMatrix windowClearanceMatrix2 = windowClearanceMatrix;
            Objects.requireNonNull(windowClearanceMatrix2);
            this.this$0 = windowClearanceMatrix2;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            this.this$0.prune_clearance_matrix();
        }
    }

    private class ClearanceTableModel
    extends AbstractTableModel
    implements Serializable {
        private final Object[][] data;
        private final String[] column_names;
        final /* synthetic */ WindowClearanceMatrix this$0;

        public ClearanceTableModel(WindowClearanceMatrix windowClearanceMatrix, GuiBoardManager p_board_handling) {
            WindowClearanceMatrix windowClearanceMatrix2 = windowClearanceMatrix;
            Objects.requireNonNull(windowClearanceMatrix2);
            this.this$0 = windowClearanceMatrix2;
            ClearanceMatrix clearance_matrix = p_board_handling.get_routing_board().rules.clearance_matrix;
            this.column_names = new String[clearance_matrix.get_class_count() + 1];
            this.column_names[0] = windowClearanceMatrix.tm.getText("class", new String[0]);
            this.data = new Object[clearance_matrix.get_class_count()][];
            for (int i = 0; i < clearance_matrix.get_class_count(); ++i) {
                this.column_names[i + 1] = clearance_matrix.get_name(i);
                this.data[i] = new Object[clearance_matrix.get_class_count() + 1];
                this.data[i][0] = clearance_matrix.get_name(i);
            }
            this.set_values(0);
        }

        @Override
        public String getColumnName(int p_col) {
            return this.column_names[p_col];
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.column_names.length;
        }

        @Override
        public Object getValueAt(int p_row, int p_col) {
            return this.data[p_row][p_col];
        }

        @Override
        public void setValueAt(Object p_value, int p_row, int p_col) {
            boolean items_already_assigned;
            Item curr_item;
            Number number_value;
            if (p_value instanceof Number) {
                Number number;
                number_value = number = (Number)p_value;
            } else {
                if (!(p_value instanceof String)) {
                    return;
                }
                try {
                    number_value = Float.valueOf(Float.parseFloat((String)p_value));
                }
                catch (Exception exception) {
                    return;
                }
            }
            int curr_row = p_row;
            int curr_column = p_col - 1;
            GuiBoardManager board_handling = this.this$0.board_frame.board_panel.board_handling;
            UndoableObjects item_list = board_handling.get_routing_board().item_list;
            boolean items_already_assigned_row = false;
            boolean items_already_assigned_column = false;
            Iterator<UndoableObjects.UndoableObjectNode> it = item_list.start_read_object();
            while ((curr_item = (Item)item_list.read_object(it)) != null) {
                int curr_item_class_no = curr_item.clearance_class_no();
                if (curr_item_class_no == curr_row) {
                    items_already_assigned_row = true;
                }
                if (curr_item_class_no != curr_column) continue;
                items_already_assigned_column = true;
            }
            ClearanceMatrix clearance_matrix = board_handling.get_routing_board().rules.clearance_matrix;
            boolean bl = items_already_assigned = items_already_assigned_row && items_already_assigned_column;
            if (items_already_assigned) {
                String message = this.this$0.tm.getText("already_assigned", new String[0]) + " ";
                message = curr_row == curr_column ? message + this.this$0.tm.getText("the_class", new String[0]) + " " + clearance_matrix.get_name(curr_row) : message + this.this$0.tm.getText("the_classes", new String[0]) + " " + clearance_matrix.get_name(curr_row) + " " + this.this$0.tm.getText("and", new String[0]) + " " + clearance_matrix.get_name(curr_column);
                int clearance_class_already_assigned_dialog = JOptionPane.showConfirmDialog(this.this$0.board_frame.clearance_matrix_window, message = message + this.this$0.tm.getText("change_anyway", new String[0]), null, 0);
                if (clearance_class_already_assigned_dialog != 0) {
                    return;
                }
            }
            this.data[p_row][p_col] = number_value;
            this.data[p_col - 1][p_row + 1] = number_value;
            this.fireTableCellUpdated(p_row, p_col);
            this.fireTableCellUpdated(p_col - 1, p_row + 1);
            int board_value = (int)Math.round(board_handling.coordinate_transform.user_to_board(number_value.doubleValue()));
            int layer_no = this.this$0.rules_clearance_layer_combo_box.get_selected_layer().index;
            if (layer_no == -1) {
                clearance_matrix.set_value(curr_row, curr_column, board_value);
                clearance_matrix.set_value(curr_column, curr_row, board_value);
            } else if (layer_no == -2) {
                clearance_matrix.set_inner_value(curr_row, curr_column, board_value);
                clearance_matrix.set_inner_value(curr_column, curr_row, board_value);
            } else {
                clearance_matrix.set_value(curr_row, curr_column, layer_no, board_value);
                clearance_matrix.set_value(curr_column, curr_row, layer_no, board_value);
            }
            if (items_already_assigned) {
                board_handling.get_routing_board().search_tree_manager.clearance_value_changed();
            }
        }

        @Override
        public boolean isCellEditable(int p_row, int p_col) {
            return p_row > 0 && p_col > 1;
        }

        @Override
        public Class<?> getColumnClass(int p_col) {
            if (p_col == 0) {
                return String.class;
            }
            return Float.class;
        }

        private void set_values(int p_layer) {
            GuiBoardManager board_handling = this.this$0.board_frame.board_panel.board_handling;
            ClearanceMatrix clearance_matrix = board_handling.get_routing_board().rules.clearance_matrix;
            for (int i = 0; i < clearance_matrix.get_class_count(); ++i) {
                for (int j = 0; j < clearance_matrix.get_class_count(); ++j) {
                    float curr_table_value;
                    if (p_layer == -1) {
                        if (clearance_matrix.is_layer_dependent(i, j)) {
                            this.data[i][j + 1] = -1;
                            continue;
                        }
                        curr_table_value = (float)board_handling.coordinate_transform.board_to_user(clearance_matrix.get_value(i, j, 0, false));
                        this.data[i][j + 1] = Float.valueOf(curr_table_value);
                        continue;
                    }
                    if (p_layer == -2) {
                        if (clearance_matrix.is_inner_layer_dependent(i, j)) {
                            this.data[i][j + 1] = -1;
                            continue;
                        }
                        curr_table_value = (float)board_handling.coordinate_transform.board_to_user(clearance_matrix.get_value(i, j, 1, false));
                        this.data[i][j + 1] = Float.valueOf(curr_table_value);
                        continue;
                    }
                    curr_table_value = (float)board_handling.coordinate_transform.board_to_user(clearance_matrix.get_value(i, j, p_layer, false));
                    this.data[i][j + 1] = Float.valueOf(curr_table_value);
                }
            }
        }
    }
}

