/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.management.TextManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class SegmentedButtons
extends JPanel {
    private final ButtonGroup buttonGroup;
    private final Map<JToggleButton, String> buttonValues;
    private final Color textColor = new Color(0, 0, 0);
    private final Color selectedTextColor = new Color(225, 225, 225);
    private final Color selectedColor = new Color(30, 30, 30);
    private final Color hoverColor = new Color(220, 220, 220);
    private final Color selectedAndHoverColor = new Color(50, 50, 50);
    private final Color borderColor = new Color(121, 116, 126);
    private final int borderWidth = 1;
    private final List<Consumer<String>> valueChangedEventListeners = new ArrayList<Consumer<String>>();
    private String selectedValue;

    public SegmentedButtons(TextManager tm, String heading, String ... values) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JLabel headingLabel = new JLabel(heading, 0);
        headingLabel.setFont(new Font("Dialog", 0, 12));
        headingLabel.setForeground(this.textColor);
        this.add((Component)headingLabel, "North");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createLineBorder(this.borderColor, 1));
        buttonPanel.setLayout(new GridBagLayout());
        this.add((Component)buttonPanel, "Center");
        this.buttonGroup = new ButtonGroup();
        this.buttonValues = new LinkedHashMap<JToggleButton, String>();
        LinkedHashMap<String, String> valueTextMap = new LinkedHashMap<String, String>();
        for (String value : values) {
            valueTextMap.put(value, tm.getText(value, new String[0]));
        }
        int maximumWidth = 0;
        for (Map.Entry entry : valueTextMap.entrySet()) {
            JToggleButton button = this.createSegmentButton((String)entry.getValue(), (String)entry.getKey());
            String tooltip = tm.getText((String)entry.getKey() + "_tooltip", new String[0]);
            button.setToolTipText(tooltip != null && !tooltip.isEmpty() ? tooltip : (String)entry.getValue());
            buttonPanel.add(button);
            this.buttonGroup.add(button);
            this.buttonValues.put(button, (String)entry.getKey());
            int buttonWidth = button.getPreferredSize().width;
            if (buttonWidth <= maximumWidth) continue;
            maximumWidth = buttonWidth;
        }
        this.add(buttonPanel);
        int buttonCount = this.buttonGroup.getButtonCount();
        int buttonIndex = 0;
        for (JToggleButton button : this.buttonValues.keySet()) {
            boolean isFirst = buttonIndex == 0;
            boolean isLast = buttonIndex == buttonCount - 1;
            button.setPreferredSize(new Dimension((int)((double)maximumWidth * 1.1), button.getPreferredSize().height));
            if (isFirst) {
                this.setSelectedValue(this.buttonValues.get(button));
            }
            ++buttonIndex;
        }
    }

    private JToggleButton createSegmentButton(String text, String value) {
        final JToggleButton button = new JToggleButton(this, text){
            final /* synthetic */ SegmentedButtons this$0;
            {
                SegmentedButtons segmentedButtons = this$0;
                Objects.requireNonNull(segmentedButtons);
                this.this$0 = segmentedButtons;
                super(arg0);
            }

            @Override
            public void setSelected(boolean selected) {
                super.setSelected(selected);
                if (selected) {
                    this.setFont(new Font("Dialog", 1, 12));
                    this.setForeground(this.this$0.selectedTextColor);
                    this.setBackground(this.this$0.selectedColor);
                    this.setOpaque(true);
                } else {
                    this.setFont(new Font("Dialog", 0, 12));
                    this.setForeground(this.this$0.textColor);
                    this.setOpaque(false);
                }
            }
        };
        button.setFocusPainted(false);
        button.setContentAreaFilled(true);
        button.setOpaque(false);
        button.setFont(new Font("Dialog", 0, 12));
        button.setMargin(new Insets(0, 10, 0, 10));
        button.setBorderPainted(false);
        button.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ SegmentedButtons this$0;
            {
                SegmentedButtons segmentedButtons = this$0;
                Objects.requireNonNull(segmentedButtons);
                this.this$0 = segmentedButtons;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setCursor(new Cursor(12));
                if (button.isSelected()) {
                    button.setForeground(this.this$0.selectedTextColor);
                    button.setBackground(this.this$0.selectedAndHoverColor);
                    button.setOpaque(true);
                } else {
                    button.setForeground(this.this$0.textColor);
                    button.setBackground(this.this$0.hoverColor);
                    button.setOpaque(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setCursor(new Cursor(0));
                if (button.isSelected()) {
                    button.setForeground(this.this$0.selectedTextColor);
                    button.setBackground(this.this$0.selectedColor);
                    button.setOpaque(true);
                } else {
                    button.setForeground(this.this$0.textColor);
                    button.setOpaque(false);
                }
            }
        });
        button.addActionListener(actionEvent -> {
            for (Map.Entry<JToggleButton, String> entry : this.buttonValues.entrySet()) {
                JToggleButton btn = entry.getKey();
                btn.setFont(new Font("Dialog", 0, 12));
                btn.setForeground(this.textColor);
                btn.setOpaque(false);
            }
            this.selectedValue = this.buttonValues.get(button);
            button.setFont(new Font("Dialog", 1, 12));
            button.setForeground(this.selectedTextColor);
            button.setBackground(this.selectedColor);
            button.setOpaque(true);
            this.valueChangedEventListeners.forEach(listener -> listener.accept(this.selectedValue));
        });
        return button;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (JToggleButton button : this.buttonValues.keySet()) {
            button.setEnabled(enabled);
        }
    }

    public void addValueChangedEventListener(Consumer<String> listener) {
        this.valueChangedEventListeners.add(listener);
    }

    public String getSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(String value) {
        for (Map.Entry<JToggleButton, String> entry : this.buttonValues.entrySet()) {
            JToggleButton button = entry.getKey();
            button.setSelected(entry.getValue().equals(value));
        }
        if (this.valueChangedEventListeners != null) {
            this.valueChangedEventListeners.forEach(listener -> listener.accept(value));
        }
    }
}

