/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.Layer;
import app.freerouting.board.LayerStructure;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.PopupMenuChangeLayer;
import app.freerouting.gui.PopupMenuDisplay;
import app.freerouting.management.TextManager;
import app.freerouting.management.analytics.FRAnalytics;
import java.awt.Component;
import javax.swing.JMenuItem;

public class PopupMenuStitchRoute
extends PopupMenuDisplay {
    private final PopupMenuChangeLayer change_layer_menu;

    public PopupMenuStitchRoute(BoardFrame p_board_frame) {
        super(p_board_frame);
        LayerStructure layer_structure = this.board_panel.board_handling.get_routing_board().layer_structure;
        if (layer_structure.arr.length > 0) {
            this.change_layer_menu = new PopupMenuChangeLayer(p_board_frame);
            this.add((Component)this.change_layer_menu, 0);
        } else {
            this.change_layer_menu = null;
        }
        TextManager tm = new TextManager(this.getClass(), p_board_frame.get_locale());
        JMenuItem popup_insert_menuitem = new JMenuItem();
        popup_insert_menuitem.setText(tm.getText("insert", new String[0]));
        popup_insert_menuitem.addActionListener(actionEvent -> this.board_panel.board_handling.left_button_clicked(this.board_panel.right_button_click_location));
        popup_insert_menuitem.addActionListener(actionEvent -> FRAnalytics.buttonClicked("popup_insert_menuitem", popup_insert_menuitem.getText()));
        this.add((Component)popup_insert_menuitem, 0);
        JMenuItem popup_done_menuitem = new JMenuItem();
        popup_done_menuitem.setText(tm.getText("done", new String[0]));
        popup_done_menuitem.addActionListener(actionEvent -> this.board_panel.board_handling.return_from_state());
        popup_done_menuitem.addActionListener(actionEvent -> FRAnalytics.buttonClicked("popup_done_menuitem", popup_done_menuitem.getText()));
        this.add((Component)popup_done_menuitem, 1);
        JMenuItem popup_cancel_menuitem = new JMenuItem();
        popup_cancel_menuitem.setText(tm.getText("cancel", new String[0]));
        popup_cancel_menuitem.addActionListener(actionEvent -> this.board_panel.board_handling.cancel_state());
        popup_cancel_menuitem.addActionListener(actionEvent -> FRAnalytics.buttonClicked("popup_cancel_menuitem", popup_cancel_menuitem.getText()));
        this.add((Component)popup_cancel_menuitem, 2);
        Layer curr_layer = layer_structure.arr[this.board_panel.board_handling.settings.get_layer()];
        this.disable_layer_item(layer_structure.get_signal_layer_no(curr_layer));
    }

    void disable_layer_item(int p_no) {
        if (this.change_layer_menu != null) {
            this.change_layer_menu.disable_item(p_no);
        }
    }
}

