/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Objects;
import javax.swing.JTextField;

public class PlaceholderTextField
extends JTextField {
    private final String placeholder;

    public PlaceholderTextField(final String placeholder) {
        this.placeholder = placeholder;
        this.setForeground(Color.GRAY);
        this.setText(placeholder);
        this.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ PlaceholderTextField this$0;
            {
                PlaceholderTextField placeholderTextField = this$0;
                Objects.requireNonNull(placeholderTextField);
                this.this$0 = placeholderTextField;
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (this.this$0.getText().equals(placeholder) || this.this$0.getText().isEmpty()) {
                    this.this$0.setForeground(Color.BLACK);
                    this.this$0.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (this.this$0.getText().isEmpty() || this.this$0.getText().equals(placeholder)) {
                    this.this$0.setForeground(Color.GRAY);
                    this.this$0.setText(placeholder);
                }
            }
        });
    }

    @Override
    public String getText() {
        String text = super.getText();
        return text.equals(this.placeholder) ? "" : text;
    }

    @Override
    public void setText(String text) {
        super.setText(text.isEmpty() ? this.placeholder : text);
        this.setForeground(text.isEmpty() ? Color.GRAY : Color.BLACK);
    }
}

