/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.rules.ClearanceMatrix;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class ComboBoxClearance
extends JComboBox<ClearanceClass> {
    private ClearanceClass[] class_arr;

    public ComboBoxClearance(ClearanceMatrix p_clearance_matrix) {
        this.class_arr = new ClearanceClass[p_clearance_matrix.get_class_count()];
        for (int i = 0; i < this.class_arr.length; ++i) {
            this.class_arr[i] = new ClearanceClass(p_clearance_matrix.get_name(i), i);
        }
        this.setModel(new DefaultComboBoxModel<ClearanceClass>(this.class_arr));
        this.setSelectedIndex(1);
    }

    public void adjust(ClearanceMatrix p_new_clearance_matrix) {
        int old_index = this.get_selected_class_index();
        this.class_arr = new ClearanceClass[p_new_clearance_matrix.get_class_count()];
        for (int i = 0; i < this.class_arr.length; ++i) {
            this.class_arr[i] = new ClearanceClass(p_new_clearance_matrix.get_name(i), i);
        }
        this.setModel(new DefaultComboBoxModel<ClearanceClass>(this.class_arr));
        this.setSelectedIndex(Math.min(old_index, this.class_arr.length - 1));
    }

    public int get_selected_class_index() {
        return ((ClearanceClass)this.getSelectedItem()).index;
    }

    public int get_class_count() {
        return this.class_arr.length;
    }

    protected static class ClearanceClass {
        public final String name;
        public final int index;

        public ClearanceClass(String p_name, int p_index) {
            this.name = p_name;
            this.index = p_index;
        }

        public String toString() {
            return this.name;
        }
    }
}

